/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.nio.ByteBuffer;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;

public class Latin1Prober
extends CharsetProber {
    public static final byte UDF = 0;
    public static final byte OTH = 1;
    public static final byte ASC = 2;
    public static final byte ASS = 3;
    public static final byte ACV = 4;
    public static final byte ACO = 5;
    public static final byte ASV = 6;
    public static final byte ASO = 7;
    public static final int CLASS_NUM = 8;
    public static final int FREQ_CAT_NUM = 4;
    private static final byte[] latin1CharToClass;
    private static final byte[] latin1ClassModel;
    private CharsetProber.ProbingState state;
    private byte lastCharClass;
    private int[] freqCounter = new int[4];

    static {
        byte[] byArray = new byte[256];
        byArray[0] = 1;
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        byArray[7] = 1;
        byArray[8] = 1;
        byArray[9] = 1;
        byArray[10] = 1;
        byArray[11] = 1;
        byArray[12] = 1;
        byArray[13] = 1;
        byArray[14] = 1;
        byArray[15] = 1;
        byArray[16] = 1;
        byArray[17] = 1;
        byArray[18] = 1;
        byArray[19] = 1;
        byArray[20] = 1;
        byArray[21] = 1;
        byArray[22] = 1;
        byArray[23] = 1;
        byArray[24] = 1;
        byArray[25] = 1;
        byArray[26] = 1;
        byArray[27] = 1;
        byArray[28] = 1;
        byArray[29] = 1;
        byArray[30] = 1;
        byArray[31] = 1;
        byArray[32] = 1;
        byArray[33] = 1;
        byArray[34] = 1;
        byArray[35] = 1;
        byArray[36] = 1;
        byArray[37] = 1;
        byArray[38] = 1;
        byArray[39] = 1;
        byArray[40] = 1;
        byArray[41] = 1;
        byArray[42] = 1;
        byArray[43] = 1;
        byArray[44] = 1;
        byArray[45] = 1;
        byArray[46] = 1;
        byArray[47] = 1;
        byArray[48] = 1;
        byArray[49] = 1;
        byArray[50] = 1;
        byArray[51] = 1;
        byArray[52] = 1;
        byArray[53] = 1;
        byArray[54] = 1;
        byArray[55] = 1;
        byArray[56] = 1;
        byArray[57] = 1;
        byArray[58] = 1;
        byArray[59] = 1;
        byArray[60] = 1;
        byArray[61] = 1;
        byArray[62] = 1;
        byArray[63] = 1;
        byArray[64] = 1;
        byArray[65] = 2;
        byArray[66] = 2;
        byArray[67] = 2;
        byArray[68] = 2;
        byArray[69] = 2;
        byArray[70] = 2;
        byArray[71] = 2;
        byArray[72] = 2;
        byArray[73] = 2;
        byArray[74] = 2;
        byArray[75] = 2;
        byArray[76] = 2;
        byArray[77] = 2;
        byArray[78] = 2;
        byArray[79] = 2;
        byArray[80] = 2;
        byArray[81] = 2;
        byArray[82] = 2;
        byArray[83] = 2;
        byArray[84] = 2;
        byArray[85] = 2;
        byArray[86] = 2;
        byArray[87] = 2;
        byArray[88] = 2;
        byArray[89] = 2;
        byArray[90] = 2;
        byArray[91] = 1;
        byArray[92] = 1;
        byArray[93] = 1;
        byArray[94] = 1;
        byArray[95] = 1;
        byArray[96] = 1;
        byArray[97] = 3;
        byArray[98] = 3;
        byArray[99] = 3;
        byArray[100] = 3;
        byArray[101] = 3;
        byArray[102] = 3;
        byArray[103] = 3;
        byArray[104] = 3;
        byArray[105] = 3;
        byArray[106] = 3;
        byArray[107] = 3;
        byArray[108] = 3;
        byArray[109] = 3;
        byArray[110] = 3;
        byArray[111] = 3;
        byArray[112] = 3;
        byArray[113] = 3;
        byArray[114] = 3;
        byArray[115] = 3;
        byArray[116] = 3;
        byArray[117] = 3;
        byArray[118] = 3;
        byArray[119] = 3;
        byArray[120] = 3;
        byArray[121] = 3;
        byArray[122] = 3;
        byArray[123] = 1;
        byArray[124] = 1;
        byArray[125] = 1;
        byArray[126] = 1;
        byArray[127] = 1;
        byArray[128] = 1;
        byArray[130] = 1;
        byArray[131] = 7;
        byArray[132] = 1;
        byArray[133] = 1;
        byArray[134] = 1;
        byArray[135] = 1;
        byArray[136] = 1;
        byArray[137] = 1;
        byArray[138] = 5;
        byArray[139] = 1;
        byArray[140] = 5;
        byArray[142] = 5;
        byArray[145] = 1;
        byArray[146] = 1;
        byArray[147] = 1;
        byArray[148] = 1;
        byArray[149] = 1;
        byArray[150] = 1;
        byArray[151] = 1;
        byArray[152] = 1;
        byArray[153] = 1;
        byArray[154] = 7;
        byArray[155] = 1;
        byArray[156] = 7;
        byArray[158] = 7;
        byArray[159] = 5;
        byArray[160] = 1;
        byArray[161] = 1;
        byArray[162] = 1;
        byArray[163] = 1;
        byArray[164] = 1;
        byArray[165] = 1;
        byArray[166] = 1;
        byArray[167] = 1;
        byArray[168] = 1;
        byArray[169] = 1;
        byArray[170] = 1;
        byArray[171] = 1;
        byArray[172] = 1;
        byArray[173] = 1;
        byArray[174] = 1;
        byArray[175] = 1;
        byArray[176] = 1;
        byArray[177] = 1;
        byArray[178] = 1;
        byArray[179] = 1;
        byArray[180] = 1;
        byArray[181] = 1;
        byArray[182] = 1;
        byArray[183] = 1;
        byArray[184] = 1;
        byArray[185] = 1;
        byArray[186] = 1;
        byArray[187] = 1;
        byArray[188] = 1;
        byArray[189] = 1;
        byArray[190] = 1;
        byArray[191] = 1;
        byArray[192] = 4;
        byArray[193] = 4;
        byArray[194] = 4;
        byArray[195] = 4;
        byArray[196] = 4;
        byArray[197] = 4;
        byArray[198] = 5;
        byArray[199] = 5;
        byArray[200] = 4;
        byArray[201] = 4;
        byArray[202] = 4;
        byArray[203] = 4;
        byArray[204] = 4;
        byArray[205] = 4;
        byArray[206] = 4;
        byArray[207] = 4;
        byArray[208] = 5;
        byArray[209] = 5;
        byArray[210] = 4;
        byArray[211] = 4;
        byArray[212] = 4;
        byArray[213] = 4;
        byArray[214] = 4;
        byArray[215] = 1;
        byArray[216] = 4;
        byArray[217] = 4;
        byArray[218] = 4;
        byArray[219] = 4;
        byArray[220] = 4;
        byArray[221] = 5;
        byArray[222] = 5;
        byArray[223] = 5;
        byArray[224] = 6;
        byArray[225] = 6;
        byArray[226] = 6;
        byArray[227] = 6;
        byArray[228] = 6;
        byArray[229] = 6;
        byArray[230] = 7;
        byArray[231] = 7;
        byArray[232] = 6;
        byArray[233] = 6;
        byArray[234] = 6;
        byArray[235] = 6;
        byArray[236] = 6;
        byArray[237] = 6;
        byArray[238] = 6;
        byArray[239] = 6;
        byArray[240] = 7;
        byArray[241] = 7;
        byArray[242] = 6;
        byArray[243] = 6;
        byArray[244] = 6;
        byArray[245] = 6;
        byArray[246] = 6;
        byArray[247] = 1;
        byArray[248] = 6;
        byArray[249] = 6;
        byArray[250] = 6;
        byArray[251] = 6;
        byArray[252] = 6;
        byArray[253] = 7;
        byArray[254] = 7;
        byArray[255] = 7;
        latin1CharToClass = byArray;
        byte[] byArray2 = new byte[64];
        byArray2[9] = 3;
        byArray2[10] = 3;
        byArray2[11] = 3;
        byArray2[12] = 3;
        byArray2[13] = 3;
        byArray2[14] = 3;
        byArray2[15] = 3;
        byArray2[17] = 3;
        byArray2[18] = 3;
        byArray2[19] = 3;
        byArray2[20] = 3;
        byArray2[21] = 3;
        byArray2[22] = 3;
        byArray2[23] = 3;
        byArray2[25] = 3;
        byArray2[26] = 3;
        byArray2[27] = 3;
        byArray2[28] = 1;
        byArray2[29] = 1;
        byArray2[30] = 3;
        byArray2[31] = 3;
        byArray2[33] = 3;
        byArray2[34] = 3;
        byArray2[35] = 3;
        byArray2[36] = 1;
        byArray2[37] = 2;
        byArray2[38] = 1;
        byArray2[39] = 2;
        byArray2[41] = 3;
        byArray2[42] = 3;
        byArray2[43] = 3;
        byArray2[44] = 3;
        byArray2[45] = 3;
        byArray2[46] = 3;
        byArray2[47] = 3;
        byArray2[49] = 3;
        byArray2[50] = 1;
        byArray2[51] = 3;
        byArray2[52] = 1;
        byArray2[53] = 1;
        byArray2[54] = 1;
        byArray2[55] = 3;
        byArray2[57] = 3;
        byArray2[58] = 1;
        byArray2[59] = 3;
        byArray2[60] = 1;
        byArray2[61] = 1;
        byArray2[62] = 3;
        byArray2[63] = 3;
        latin1ClassModel = byArray2;
    }

    public Latin1Prober() {
        this.reset();
    }

    @Override
    public String getCharSetName() {
        return Constants.CHARSET_WINDOWS_1252;
    }

    @Override
    public float getConfidence() {
        float confidence;
        if (this.state == CharsetProber.ProbingState.NOT_ME) {
            return 0.01f;
        }
        int total = 0;
        int i = 0;
        while (i < this.freqCounter.length) {
            total += this.freqCounter[i];
            ++i;
        }
        if (total <= 0) {
            confidence = 0.0f;
        } else {
            confidence = (float)this.freqCounter[3] * 1.0f / (float)total;
            confidence -= (float)this.freqCounter[1] * 20.0f / (float)total;
        }
        if (confidence < 0.0f) {
            confidence = 0.0f;
        }
        return confidence *= 0.5f;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] buf, int offset, int length) {
        ByteBuffer newBufTmp = this.filterWithEnglishLetters(buf, offset, length);
        byte[] newBuf = newBufTmp.array();
        int newBufLen = newBufTmp.position();
        int i = 0;
        while (i < newBufLen) {
            int c = newBuf[i] & 0xFF;
            byte charClass = latin1CharToClass[c];
            byte freq = latin1ClassModel[this.lastCharClass * 8 + charClass];
            if (freq == 0) {
                this.state = CharsetProber.ProbingState.NOT_ME;
                break;
            }
            byte by = freq;
            this.freqCounter[by] = this.freqCounter[by] + 1;
            this.lastCharClass = charClass;
            ++i;
        }
        return this.state;
    }

    @Override
    public void reset() {
        this.state = CharsetProber.ProbingState.DETECTING;
        this.lastCharClass = 1;
        int i = 0;
        while (i < this.freqCounter.length) {
            this.freqCounter[i] = 0;
            ++i;
        }
    }

    @Override
    public void setOption() {
    }
}

