/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.knn.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.control.TableColumn;

public class PersistentSettings {
    private static final String lineSeparator = "\n";
    private String zielgroesse;
    private int k;
    private List<String> selectedColumns;
    private Map<String, Double> schaetzereignis;
    private int sortedColumnNr;
    private TableColumn.SortType sortOrder;

    public String getZielgroesse() {
        return this.zielgroesse;
    }

    public void setZielgroesse(String zielgroesse) {
        this.zielgroesse = zielgroesse;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public List<String> getSelectedColumns() {
        return this.selectedColumns;
    }

    public void setSelectedColumns(List<String> selectedColumns) {
        this.selectedColumns = selectedColumns;
    }

    public Map<String, Double> getSchaetzereignis() {
        return this.schaetzereignis;
    }

    public void setSchaetzereignis(Map<String, Double> schaetzereignis) {
        this.schaetzereignis = schaetzereignis;
    }

    public int getSortedColumnNr() {
        return this.sortedColumnNr;
    }

    public void setSortedColumnNr(int sortedColumnNr) {
        this.sortedColumnNr = sortedColumnNr;
    }

    public TableColumn.SortType getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(TableColumn.SortType sortOrder) {
        this.sortOrder = sortOrder;
    }

    public void write(Writer writer) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.zielgroesse);
        sb.append(lineSeparator);
        sb.append(this.k);
        sb.append(lineSeparator);
        sb.append(this.selectedColumns.size());
        sb.append(lineSeparator);
        for (String title : this.selectedColumns) {
            sb.append(title);
            sb.append(lineSeparator);
        }
        for (String key : this.schaetzereignis.keySet()) {
            sb.append(key);
            sb.append(lineSeparator);
            sb.append(this.schaetzereignis.get(key));
            sb.append(lineSeparator);
        }
        sb.append(this.sortedColumnNr);
        sb.append(lineSeparator);
        sb.append(this.sortOrder);
        sb.append(lineSeparator);
        writer.write(sb.toString());
        writer.close();
    }

    public static PersistentSettings read(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader buffReader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF8")));){
            String line;
            while ((line = buffReader.readLine()) != null) {
                sb.append(String.valueOf(line) + lineSeparator);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String settingsString = sb.toString();
        return PersistentSettings.read(settingsString);
    }

    private static PersistentSettings read(String settingsString) {
        PersistentSettings result = new PersistentSettings();
        int currentLineNr = 0;
        String[] lines = settingsString.split(lineSeparator);
        if (lines[currentLineNr].equals("null")) {
            result.setZielgroesse(null);
        } else {
            result.setZielgroesse(lines[currentLineNr]);
        }
        result.setK(Integer.valueOf(lines[++currentLineNr]));
        int nrOfCols = Integer.valueOf(lines[++currentLineNr]);
        ArrayList<String> selectedColumns = new ArrayList<String>(nrOfCols);
        int i = 0;
        while (i < nrOfCols) {
            String selectedCol = lines[++currentLineNr].trim();
            selectedColumns.add(selectedCol);
            ++i;
        }
        result.setSelectedColumns(selectedColumns);
        HashMap<String, Double> schaetzereignis = new HashMap<String, Double>();
        int i2 = 0;
        while (i2 < nrOfCols) {
            String value;
            String key = lines[++currentLineNr].trim();
            if ("null".equals(value = lines[++currentLineNr].trim())) {
                schaetzereignis.put(key, null);
            } else {
                schaetzereignis.put(key, Double.valueOf(value));
            }
            ++i2;
        }
        result.setSchaetzereignis(schaetzereignis);
        result.setSortedColumnNr(Integer.valueOf(lines[++currentLineNr]));
        String sortOrder = lines[++currentLineNr];
        if (!sortOrder.equals("null")) {
            result.setSortOrder(TableColumn.SortType.valueOf((String)sortOrder));
        }
        return result;
    }
}

