/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.knn.model;

import ch.wsl.fps.knn.model.DataCell;
import ch.wsl.fps.knn.model.DataColumn;
import ch.wsl.fps.knn.model.DataRow;
import ch.wsl.fps.knn.model.InvalidInputFormatException;
import ch.wsl.fps.knn.model.TargetDataColumn;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class KnnInputData {
    private static final String REPLACEMENT_FOR_NEWLINE_CHAR = ", ";
    private final List<String> titles = new ArrayList<String>();
    private final List<DataRow> dataRows = new ArrayList<DataRow>();
    private final List<DataColumn> dataColumns = new ArrayList<DataColumn>();
    private TargetDataColumn targetColumn = null;

    private KnnInputData() {
    }

    public static KnnInputData parseCsvFromReaderToKnnInputData(Reader in, char delimiter) throws IOException, InvalidInputFormatException {
        KnnInputData result = new KnnInputData();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (CSVParser parser = new CSVParser(in, CSVFormat.DEFAULT.withDelimiter(delimiter).withFirstRecordAsHeader());){
                String[] headers = new String[parser.getHeaderMap().size()];
                for (Map.Entry entry : parser.getHeaderMap().entrySet()) {
                    headers[((Integer)entry.getValue()).intValue()] = ((String)entry.getKey()).replaceAll("\n", REPLACEMENT_FOR_NEWLINE_CHAR);
                }
                result.titles.addAll(Arrays.asList(headers));
                for (CSVRecord record : parser.getRecords()) {
                    result.dataRows.add(KnnInputData.getFromCsvRecord(record, result));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IllegalArgumentException e) {
            String prefix = "The header contains a duplicate name: \"";
            if (e.getMessage().startsWith("The header contains a duplicate name: \"")) {
                String msg = e.getMessage().substring("The header contains a duplicate name: \"".length());
                msg = msg.substring(0, msg.indexOf("\""));
                msg = "Die Kopfzeile enth\u00e4lt den folgenden Titel mehrmals:\n \"" + msg + "\".\n\nJeder Titel in der Kopfzeile der CSV-Datei darf nur einmal vorkommen.";
                throw new InvalidInputFormatException(msg);
            }
            throw e;
        }
        return result;
    }

    private static DataRow getFromCsvRecord(CSVRecord csvRecord, KnnInputData alreadyParsed) throws InvalidInputFormatException {
        if (!csvRecord.isConsistent()) {
            long recordNumber = csvRecord.getRecordNumber();
            String msg = "Eintrag Nr. " + recordNumber + " in CSV-Datei hat nicht die selbe Anzahl Felder wie die Kopfzeile!";
            throw new InvalidInputFormatException(msg);
        }
        HashMap<DataColumn, DataCell> cellValues = new HashMap<DataColumn, DataCell>();
        DataRow row = new DataRow(cellValues);
        int i = 0;
        while (i < alreadyParsed.getNrOfCols()) {
            DataCell cell;
            String content = csvRecord.get(i);
            String title = alreadyParsed.titles.get(i);
            if (KnnInputData.isInteger(content)) {
                if (alreadyParsed.dataColumns.size() <= i) {
                    alreadyParsed.dataColumns.add(new DataColumn(title, DataType.INTEGER, new ArrayList<DataCell>()));
                }
                cell = new DataCell(Integer.valueOf(content), alreadyParsed.dataColumns.get(i), false);
                alreadyParsed.dataColumns.get(i).getCells().add(cell);
                cellValues.put(alreadyParsed.dataColumns.get(i), cell);
            } else if (KnnInputData.isDouble(content)) {
                if (alreadyParsed.dataColumns.size() <= i) {
                    alreadyParsed.dataColumns.add(new DataColumn(title, DataType.DOUBLE, new ArrayList<DataCell>()));
                }
                cell = new DataCell(Double.valueOf(content), alreadyParsed.dataColumns.get(i), false);
                alreadyParsed.dataColumns.get(i).getCells().add(cell);
                cellValues.put(alreadyParsed.dataColumns.get(i), cell);
            } else {
                if (alreadyParsed.dataColumns.size() <= i) {
                    alreadyParsed.dataColumns.add(new DataColumn(title, DataType.TEXT, new ArrayList<DataCell>()));
                }
                content = content.replaceAll("\n", REPLACEMENT_FOR_NEWLINE_CHAR);
                cell = new DataCell(content, alreadyParsed.dataColumns.get(i), false);
                alreadyParsed.dataColumns.get(i).getCells().add(cell);
                cellValues.put(alreadyParsed.dataColumns.get(i), cell);
            }
            ++i;
        }
        return row;
    }

    private static boolean isInteger(String str) {
        try {
            Integer.valueOf(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isDouble(String str) {
        try {
            Double.valueOf(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public List<DataRow> getDataRows() {
        return this.dataRows;
    }

    public int getNrOfCols() {
        return this.titles.size();
    }

    public long getNrOfColsSelected() {
        return this.dataColumns.stream().filter(col -> col.isSelected()).count();
    }

    public boolean isEmpty() {
        return this.titles.isEmpty() && this.dataRows.isEmpty();
    }

    public List<String> getTitles() {
        return Collections.unmodifiableList(this.titles);
    }

    public List<DataType> getDataTypes() {
        ArrayList<DataType> result = new ArrayList<DataType>();
        for (DataColumn dataCol : this.dataColumns) {
            result.add(dataCol.getDataType());
        }
        return result;
    }

    public List<DataColumn> getDataColumns() {
        return Collections.unmodifiableList(this.dataColumns);
    }

    public DataColumn getDataColumn(String title) {
        return this.getDataColumns().stream().filter(e -> e.getTitle().equals(title)).findAny().orElse(null);
    }

    public TargetDataColumn getTargetColumn() {
        return this.targetColumn;
    }

    public void setTargetColumn(TargetDataColumn targetCol) {
        this.targetColumn = targetCol;
    }

    public static enum DataType {
        INTEGER,
        DOUBLE,
        TEXT;


        public boolean isAvailableForCalculation() {
            return this == INTEGER || this == DOUBLE;
        }

        public Class<?> getAssociatedClass() {
            if (this == INTEGER) {
                return Integer.class;
            }
            if (this == DOUBLE) {
                return Double.class;
            }
            if (this == TEXT) {
                return String.class;
            }
            throw new RuntimeException("Invalid DataType: " + this.name());
        }
    }
}

