/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.knn.model;

import ch.wsl.fps.knn.model.DataColumn;
import ch.wsl.fps.knn.model.KnnInputData;

public class DataCell {
    private Object originalValue;
    private Double calcValue;
    private final DataColumn dataColumn;
    private final boolean isTargetRowCell;

    public DataCell(Object originalValue, DataColumn dataColumn, boolean isTargetRowCell) {
        this.dataColumn = dataColumn;
        this.isTargetRowCell = isTargetRowCell;
        this.setOriginalValue(originalValue);
    }

    public void setOriginalValue(Object originalValue) {
        this.originalValue = originalValue;
        if (originalValue instanceof Integer) {
            this.calcValue = ((Integer)originalValue).doubleValue();
            this.updateDataType(KnnInputData.DataType.INTEGER);
        } else if (originalValue instanceof Double) {
            this.calcValue = (double)((Double)originalValue);
            this.updateDataType(KnnInputData.DataType.DOUBLE);
        } else {
            this.calcValue = null;
            this.updateDataType(KnnInputData.DataType.TEXT);
        }
    }

    public Object getOriginalValue() {
        return this.originalValue;
    }

    public double getCalcValue() {
        return this.calcValue;
    }

    public KnnInputData.DataType getDataType() {
        return this.dataColumn.getDataType();
    }

    public boolean containsValidCalcValue() {
        return this.calcValue != null;
    }

    private void updateDataType(KnnInputData.DataType newDataType) {
        if (this.isTargetRowCell) {
            return;
        }
        KnnInputData.DataType oldDataType = this.dataColumn.getDataType();
        if (newDataType == KnnInputData.DataType.DOUBLE && oldDataType == KnnInputData.DataType.INTEGER) {
            this.dataColumn.setDataType(newDataType);
            System.out.println("Column '" + this.dataColumn.getTitle() + "': Set dataType from " + (Object)((Object)oldDataType) + " to " + (Object)((Object)newDataType) + " because of value '" + this.originalValue + "'");
        } else if (newDataType == KnnInputData.DataType.TEXT && oldDataType != KnnInputData.DataType.TEXT) {
            this.dataColumn.setDataType(newDataType);
            System.out.println("Column '" + this.dataColumn.getTitle() + "': Set dataType from " + (Object)((Object)oldDataType) + " to " + (Object)((Object)newDataType) + " because of value '" + this.originalValue + "'");
        }
    }
}

