/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.knn.gui.table;

import ch.wsl.fps.knn.gui.MainWindow;
import ch.wsl.fps.knn.gui.table.KnnTableRow;
import ch.wsl.fps.knn.model.DataColumn;
import ch.wsl.fps.knn.model.KnnInputData;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.StackPane;

public class MainTableColumn
extends TableColumn<KnnTableRow, Object> {
    private final String title;
    private final CheckBox chkHeader;
    private final DataColumn dataColumn;

    public MainTableColumn(DataColumn dataColumn, ObjectProperty<String> zielgroesse, ObservableValue<Integer> k) {
        boolean isTextCol;
        this.dataColumn = dataColumn;
        this.title = dataColumn.getTitle();
        this.chkHeader = new CheckBox(this.title);
        StackPane stackPane = new StackPane(new Node[]{this.chkHeader});
        this.setGraphic((Node)stackPane);
        boolean bl = isTextCol = !this.getDataType().isAvailableForCalculation();
        if (isTextCol) {
            this.chkHeader.setDisable(true);
            String msg = "Diese Spalte enth\u00e4lt eine oder mehrere Zellen, die nicht-numerische Werte enthalten. Diese Spalte kann deshalb nicht f\u00fcr die Berechnung verwendet werden.";
            Tooltip t = new Tooltip(msg);
            t.setWrapText(true);
            t.setPrefWidth(300.0);
            MainTableColumn.setupTooltip((Node)stackPane, t);
        }
        this.chkHeader.selectedProperty().addListener((obs, oldVal, newVal) -> this.setSelected((boolean)newVal));
        this.initMainTableColumnCellFactory(zielgroesse, k);
        this.setCellValueFactory(element -> ((KnnTableRow)element.getValue()).getCellValueForColumn(this.title));
    }

    private void initMainTableColumnCellFactory(final ObjectProperty<String> zielgroesse, final ObservableValue<Integer> k) {
        this.setCellFactory(e -> new TableCell<KnnTableRow, Object>(){
            private BooleanExpression highlightTargetCell;
            private BooleanExpression highlightReferenceCell;
            {
                this.tableRowProperty().addListener((obs, oldVal, newVal) -> {
                    if (oldVal == null && newVal != null) {
                        BooleanBinding isTargetColumnProperty = objectProperty.isEqualTo((Object)MainTableColumn.this.getTitle());
                        BooleanProperty headerSelectedProperty = MainTableColumn.this.selectedProperty();
                        ReadOnlyBooleanProperty rowSelectedProperty = this.getTableRow().selectedProperty();
                        BooleanBinding isNotEmptyProperty = this.textProperty().isNotEmpty();
                        this.highlightTargetCell = isTargetColumnProperty.and((ObservableBooleanValue)rowSelectedProperty.not()).and((ObservableBooleanValue)isNotEmptyProperty);
                        this.highlightReferenceCell = headerSelectedProperty.and((ObservableBooleanValue)rowSelectedProperty.not()).and((ObservableBooleanValue)isNotEmptyProperty).and((ObservableBooleanValue)isTargetColumnProperty.not());
                        this.highlightTargetCell.addListener((obsX, oldValX, newValX) -> this.pseudoClassStateChanged(MainWindow.PSEUDO_CLASS_TARGET_COLUMN_CELL, (boolean)newValX));
                        this.highlightReferenceCell.addListener((obsX, oldValX, newValX) -> this.pseudoClassStateChanged(MainWindow.PSEUDO_CLASS_REFERENCE_COLUMN_CELL, (boolean)newValX));
                    }
                });
            }

            public void updateItem(Object item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setText(null);
                    this.pseudoClassStateChanged(MainWindow.PSEUDO_CLASS_TABLE_CELL_BOLD, false);
                } else {
                    Integer rankOfCurrentRow;
                    KnnTableRow currentRow;
                    this.setText(item.toString());
                    boolean isBold = false;
                    if (this.getTableRow() != null && (currentRow = (KnnTableRow)this.getTableRow().getItem()) != null && (rankOfCurrentRow = Integer.valueOf(currentRow.rankProperty().get())) != null) {
                        isBold = rankOfCurrentRow > 0 && rankOfCurrentRow <= (Integer)k.getValue();
                    }
                    this.pseudoClassStateChanged(MainWindow.PSEUDO_CLASS_TABLE_CELL_BOLD, isBold);
                }
            }
        });
    }

    public String getTitle() {
        return this.title;
    }

    public KnnInputData.DataType getDataType() {
        return this.dataColumn.getDataType();
    }

    public CheckBox getChkHeader() {
        return this.chkHeader;
    }

    public final StringProperty titleProperty() {
        return this.chkHeader.textProperty();
    }

    public final BooleanProperty selectedProperty() {
        return this.chkHeader.selectedProperty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSelected(boolean flag) {
        if (flag) {
            if (!this.getDataType().isAvailableForCalculation()) throw new RuntimeException("This should never happen [" + this.getTitle() + "]");
            this.dataColumn.setSelected(true);
            this.chkHeader.setSelected(true);
            return;
        } else {
            this.dataColumn.setSelected(false);
            this.chkHeader.setSelected(false);
            this.chkHeader.setDisable(!this.getDataType().isAvailableForCalculation());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAsTargetCol(boolean flag) {
        if (flag) {
            this.dataColumn.setSelected(false);
            if (!this.getDataType().isAvailableForCalculation()) throw new RuntimeException("This should never happen [" + this.getTitle() + "]");
            this.chkHeader.setSelected(false);
            this.chkHeader.setDisable(true);
            return;
        } else {
            this.chkHeader.setDisable(!this.getDataType().isAvailableForCalculation());
        }
    }

    private static void setupTooltip(Node node, Tooltip tooltip) {
        node.setOnMouseEntered(e -> {
            double x = node.localToScreen(node.getBoundsInLocal()).getMinX();
            double y = node.localToScreen(node.getBoundsInLocal()).getMaxY();
            tooltip.show(node, x, y + 5.0);
        });
        node.setOnMouseExited(e -> tooltip.hide());
    }
}

