/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.knn.gui.table;

import ch.wsl.fps.knn.gui.table.KnnTableCell;
import ch.wsl.fps.knn.model.DataCell;
import ch.wsl.fps.knn.model.DataRow;
import ch.wsl.fps.knn.model.KnnInputData;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;

public class KnnTableRow {
    private final List<String> titles;
    private final List<KnnTableCell> cells = new ArrayList<KnnTableCell>();
    private final ReadOnlyObjectWrapper<DataRow> dataRowProperty = new ReadOnlyObjectWrapper();
    private final SimpleIntegerProperty rankProperty = new SimpleIntegerProperty();

    private KnnTableRow(List<String> titles, DataRow dataRow) {
        this.titles = titles;
        this.dataRowProperty.set((Object)dataRow);
    }

    public SimpleStringProperty getCellStringForColumn(String title) {
        int colNr = this.getColNr(title);
        return this.cells.get(colNr).getObsDisplayValue();
    }

    public SimpleObjectProperty<Object> getCellValueForColumn(String title) {
        int colNr = this.getColNr(title);
        return this.cells.get(colNr).getObsValue();
    }

    private int getColNr(String title) {
        int colNr = 0;
        while (colNr < this.titles.size()) {
            if (this.titles.get(colNr).equals(title)) {
                return colNr;
            }
            ++colNr;
        }
        throw new IllegalArgumentException("No title found with name '" + title + "'");
    }

    public void setCellValueForColumn(String title, Double value) {
        this.getCellValueForColumn(title).set((Object)value);
    }

    public ReadOnlyObjectProperty<DataRow> dataRowProperty() {
        return this.dataRowProperty.getReadOnlyProperty();
    }

    public SimpleIntegerProperty rankProperty() {
        return this.rankProperty;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("KnnTableRow");
        for (KnnTableCell cell : this.cells) {
            sb.append(" ");
            sb.append(cell.getClass().getSimpleName());
            sb.append("[" + cell.getObsValue().getValue() + "]");
        }
        return sb.toString();
    }

    public static KnnTableRow getEmptyRow(List<String> titles) {
        KnnTableRow instance = new KnnTableRow(titles, null);
        int nrOfCols = titles.size();
        int i = 0;
        while (i < nrOfCols) {
            KnnTableCell cell = new KnnTableCell(null);
            instance.cells.add(cell);
            ++i;
        }
        return instance;
    }

    public static List<KnnTableRow> getRowsFromInputData(KnnInputData inputData) {
        ArrayList<KnnTableRow> result = new ArrayList<KnnTableRow>();
        for (DataRow row : inputData.getDataRows()) {
            result.add(KnnTableRow.getKnnTableRowFromInputDataRow(inputData, row));
        }
        return result;
    }

    private static KnnTableRow getKnnTableRowFromInputDataRow(KnnInputData inputData, DataRow dataRow) {
        KnnTableRow result = new KnnTableRow(inputData.getTitles(), dataRow);
        int nrOfCols = inputData.getNrOfCols();
        int i = 0;
        while (i < nrOfCols) {
            DataCell modelCell = dataRow.getCell(inputData.getTitles().get(i));
            KnnTableCell cell = new KnnTableCell(modelCell.getOriginalValue());
            result.cells.add(cell);
            ++i;
        }
        return result;
    }
}

