/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.knn.gui.controls;

import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;

public class DoubleTextField
extends TextField {
    private final ReadOnlyObjectWrapper<Double> valueProperty = new ReadOnlyObjectWrapper();

    public DoubleTextField() {
        this.getStyleClass().add((Object)"number-textfield");
        this.setText("");
        this.initTextFormatter();
        this.textProperty().addListener((observable, oldValue, newValue) -> this.updateValueProperty());
    }

    private void initTextFormatter() {
        this.setTextFormatter(new TextFormatter(change -> {
            String newText = change.getControlNewText();
            if (newText.isEmpty()) {
                return change;
            }
            if (newText.equals("-")) {
                return change;
            }
            if (newText.startsWith(".")) {
                return change;
            }
            if (newText.matches("-?[0-9]+(\\.)?[0-9]*")) {
                return change;
            }
            return null;
        }));
    }

    private void updateValueProperty() {
        String text = this.getText();
        if (text.isEmpty()) {
            this.valueProperty.set(null);
        } else if (text.equals("-")) {
            this.valueProperty.set(null);
        } else {
            this.valueProperty.set((Object)this.parseValue(text));
        }
    }

    private Double parseValue(String text) {
        Double result = null;
        try {
            result = Double.valueOf(text);
        }
        catch (NumberFormatException e) {
            result = null;
        }
        return result;
    }

    public final ReadOnlyObjectProperty<Double> valueProperty() {
        return this.valueProperty.getReadOnlyProperty();
    }

    public final Double getValue() {
        return (Double)this.valueProperty.get();
    }
}

