/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.knn.gui;

import ch.wsl.fps.knn.gui.table.MainTableColumn;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import com.sun.javafx.tk.FontMetrics;
import com.sun.javafx.tk.Toolkit;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarFile;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.JOptionPane;

class MainWindowHelper {
    private MainWindowHelper() {
    }

    static void bindHorizontalTableScrollbars(TableView<?> ... allTables) {
        if (allTables == null || allTables.length < 1) {
            return;
        }
        ArrayList<ScrollBar> allScrollbars = new ArrayList<ScrollBar>();
        TableView<?>[] tableViewArray = allTables;
        int n = allTables.length;
        int n2 = 0;
        while (n2 < n) {
            TableView<?> table = tableViewArray[n2];
            allScrollbars.add(MainWindowHelper.getScrollBar(table, Orientation.HORIZONTAL));
            ++n2;
        }
        int i = 1;
        while (i < allScrollbars.size()) {
            ScrollBar first = (ScrollBar)allScrollbars.get(0);
            ScrollBar current = (ScrollBar)allScrollbars.get(i);
            first.valueProperty().bindBidirectional((Property)current.valueProperty());
            ++i;
        }
    }

    static ScrollBar getScrollBar(TableView<?> table, Orientation orientaton) {
        for (Node node : table.lookupAll(".scroll-bar")) {
            ScrollBar scrollBar = (ScrollBar)node;
            if (scrollBar.getOrientation() != orientaton) continue;
            return scrollBar;
        }
        return null;
    }

    static void disableTableColumnReordering(TableView<?> tableView) {
        TableHeaderRow header = (TableHeaderRow)tableView.lookup("TableHeaderRow");
        header.reorderingProperty().addListener((o, oldVal, newVal) -> header.setReordering(false));
    }

    static void removeTableHeader(TableView<?> tableView) {
        TableHeaderRow header = (TableHeaderRow)tableView.lookup("TableHeaderRow");
        header.setMinHeight(0.0);
        header.setPrefHeight(0.0);
        header.setMaxHeight(0.0);
        header.setVisible(false);
    }

    static void bindTableSelection(TableView<?> t1, TableView<?> t2) {
        t1.getSelectionModel().selectedIndexProperty().addListener((obs, oldVal, newVal) -> Platform.runLater(() -> t2.getSelectionModel().select(((Integer)newVal).intValue())));
        t2.getSelectionModel().selectedIndexProperty().addListener((obs, oldVal, newVal) -> Platform.runLater(() -> t1.getSelectionModel().select(((Integer)newVal).intValue())));
    }

    static void disableTableSelection(TableView<?> table) {
        table.getSelectionModel().selectedIndexProperty().addListener((obs, oldVal, newVal) -> Platform.runLater(() -> table.getSelectionModel().clearSelection()));
    }

    static void optimizeMainTableColumnWidths(TableView<?> mainTable) {
        Platform.runLater(() -> {
            for (TableColumn column : mainTable.getColumns()) {
                MainTableColumn mainTableCol = (MainTableColumn)column;
                column.prefWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                    FontMetrics fontMetrics = Toolkit.getToolkit().getFontLoader().getFontMetrics(mainTableCol.getChkHeader().getFont());
                    double prefWidth = fontMetrics.computeStringWidth(mainTableCol.getTitle()) + 25.0f + 15.0f + 10.0f;
                    return prefWidth;
                }, (Observable[])new Observable[]{mainTableCol.titleProperty()}));
            }
        });
    }

    static Image getWslLogo() {
        String path = "data/WSL64.png";
        InputStream in = MainWindowHelper.class.getClassLoader().getResourceAsStream("data/WSL64.png");
        if (in != null) {
            return new Image(in);
        }
        return new Image("file:data/WSL64.png");
    }

    static File getFileFromFileChooserOpenCsv(Stage stage) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("CSV-Datei importieren");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("CSV-Dateien", new String[]{"*.csv"}), new FileChooser.ExtensionFilter("Alle Dateien", new String[]{"*.*"})});
        fileChooser.setInitialDirectory(new File("."));
        File selectedFile = fileChooser.showOpenDialog((Window)stage);
        return selectedFile;
    }

    static File getFileFromFileChooserOpenProject(Stage stage) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Projekt laden");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Projekt-Dateien", new String[]{"*.knnx"}), new FileChooser.ExtensionFilter("Alle Dateien", new String[]{"*.*"})});
        fileChooser.setInitialDirectory(new File("."));
        File selectedFile = fileChooser.showOpenDialog((Window)stage);
        return selectedFile;
    }

    static File getFileFromFileChooserSaveProject(Stage stage) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Projekt speichern");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Projekt-Dateien", new String[]{"*.knnx"}), new FileChooser.ExtensionFilter("Alle Dateien", new String[]{"*.*"})});
        fileChooser.setInitialDirectory(new File("."));
        File selectedFile = fileChooser.showSaveDialog((Window)stage);
        return selectedFile;
    }

    static void openManual() {
        String manualPath = "Bedienungsanleitung-WSL-kNN.pdf";
        MainWindowHelper.openPdfFile("Bedienungsanleitung-WSL-kNN.pdf");
    }

    private static void openPdfFile(String path) {
        MainWindowHelper.copyFileFromJarToFilesystemIfNecessary(path);
        File file = new File(path);
        try {
            Desktop.getDesktop().open(file);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            JOptionPane.showMessageDialog(null, e1.getMessage(), "Fehler beim \u00d6ffnen der Datei", 0);
        }
    }

    private static void copyFileFromJarToFilesystemIfNecessary(String path) {
        if (!MainWindowHelper.isStartedFromJar()) {
            return;
        }
        File fileInFilesystem = new File(path);
        if (!fileInFilesystem.exists()) {
            System.out.println("File in file system does not exist. File will be copied from jar.");
            MainWindowHelper.copyFileFromJarToFilesystem(path);
        } else if (MainWindowHelper.hasFilesystemFileDifferentDateThanFileInJar(path)) {
            System.out.println("File in file system has different last-modified date than file in jar. File in file system will be replaced.");
            MainWindowHelper.copyFileFromJarToFilesystem(path);
        } else {
            return;
        }
    }

    private static boolean isStartedFromJar() {
        URL url = MainWindowHelper.class.getResource("MainWindowHelper.class");
        boolean isStartedFromJar = url.toString().startsWith("jar") || url.toString().startsWith("rsrc");
        return isStartedFromJar;
    }

    private static boolean hasFilesystemFileDifferentDateThanFileInJar(String path) {
        File fileInFilesystem = new File(path);
        long fileInFilesystemLastModified = -2L;
        long fileInJarLastModified = -2L;
        try {
            fileInFilesystemLastModified = fileInFilesystem.lastModified();
            fileInJarLastModified = MainWindowHelper.getJarFileLastModified(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        if (fileInFilesystemLastModified <= 0L || fileInJarLastModified <= 0L) {
            return true;
        }
        return fileInFilesystemLastModified != fileInJarLastModified;
    }

    private static void copyFileFromJarToFilesystem(String path) {
        File fileInFilesystem;
        block15: {
            fileInFilesystem = new File(path);
            InputStream in = MainWindowHelper.class.getClassLoader().getResourceAsStream(path);
            if (in == null) {
                System.err.println("file '" + path + "' not found in jar");
                return;
            }
            String[] dirs = path.split("\\\\|/");
            String dir = "";
            int i = 0;
            while (i < dirs.length - 1) {
                dir = String.valueOf(dir) + dirs[i] + "/";
                ++i;
            }
            File f = new File(dir);
            f.mkdirs();
            FileOutputStream out = null;
            byte[] buffer = new byte[4096];
            try {
                try {
                    int readBytes;
                    out = new FileOutputStream(fileInFilesystem);
                    while ((readBytes = in.read(buffer)) > 0) {
                        out.write(buffer, 0, readBytes);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        in.close();
                        out.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                in.close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        long lastModified = MainWindowHelper.getJarFileLastModified(path);
        if (lastModified >= 0L) {
            fileInFilesystem.setLastModified(lastModified);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static long getJarFileLastModified(String filePath) {
        block16: {
            filePath = "/" + filePath;
            jar = null;
            try {
                block17: {
                    jar = MainWindowHelper.getJarFile();
                    if (jar == null) break block16;
                    enumEntries = jar.entries();
                    break block17;
                    while (true) {
                        file = enumEntries.nextElement();
                        if (!file.getName().equals(filePath.substring(1))) break;
                        var7_6 = time = file.getTime();
                        return var7_6;
                    }
                }
                try {
                    if (enumEntries.hasMoreElements()) ** continue;
                }
                catch (Exception var2_3) {}
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException var9_7) {}
                }
            }
        }
        return -1L;
    }

    private static JarFile getJarFile() {
        JarFile jar = null;
        try {
            jar = new JarFile("WslKnn.jar");
            return jar;
        }
        catch (Exception exception) {
            try {
                String jarFilePath = ClassLoader.getSystemClassLoader().getResource(".").toURI().getPath().replaceFirst("/", "");
                jar = new JarFile(String.valueOf(jarFilePath) + File.separator + "WslKnn.jar");
                return jar;
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }
}

