/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.knn.gui;

import ch.wsl.fps.knn.ZipFileHelper;
import ch.wsl.fps.knn.gui.KnnExceptionHandler;
import ch.wsl.fps.knn.gui.KnnXyChart;
import ch.wsl.fps.knn.gui.MainWindowHelper;
import ch.wsl.fps.knn.gui.controls.DoubleTextField;
import ch.wsl.fps.knn.gui.table.KnnTableRow;
import ch.wsl.fps.knn.gui.table.MainTableColumn;
import ch.wsl.fps.knn.gui.table.RowMetricsEntry;
import ch.wsl.fps.knn.model.Calculator;
import ch.wsl.fps.knn.model.DataCell;
import ch.wsl.fps.knn.model.DataColumn;
import ch.wsl.fps.knn.model.DataRow;
import ch.wsl.fps.knn.model.InvalidInputFormatException;
import ch.wsl.fps.knn.model.KnnInputData;
import ch.wsl.fps.knn.model.PersistentSettings;
import ch.wsl.fps.knn.model.TargetDataColumn;
import ch.wsl.fps.knn.model.TargetDataRow;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;

public class MainWindow
extends Application {
    public static final DecimalFormat GLOBAL_DOUBLE_FORMAT = new DecimalFormat("0.###");
    public static final PseudoClass PSEUDO_CLASS_TABLE_CELL_BOLD = PseudoClass.getPseudoClass((String)"table-cell-bold");
    public static final PseudoClass PSEUDO_CLASS_TARGET_COLUMN_CELL = PseudoClass.getPseudoClass((String)"target-column-cell");
    public static final PseudoClass PSEUDO_CLASS_REFERENCE_COLUMN_CELL = PseudoClass.getPseudoClass((String)"reference-column-cell");
    private static final PseudoClass PSEUDO_CLASS_TARGET_COLUMN_TARGET_CELL = PseudoClass.getPseudoClass((String)"target-column-target-cell");
    private static final PseudoClass PSEUDO_CLASS_TABLE_CELL_HIGHLIGHT = PseudoClass.getPseudoClass((String)"table-cell-highlight");
    private static final String KNN_VERSION = "2.0 BETA";
    private static final LocalDate KNN_DATE = LocalDate.of(2019, 12, 13);
    private static boolean LOG_TO_FILE = MainWindow.isStartedFromJar();
    private Stage stage;
    private Scene scene;
    @FXML
    private Pane paneDragOk;
    @FXML
    private ComboBox<String> cmbZielgroesse;
    @FXML
    private Spinner<Integer> txtParamK;
    @FXML
    private Button btnCalc;
    @FXML
    private Pane panelChart;
    private final KnnXyChart chart = new KnnXyChart();
    @FXML
    private TextFlow lblSchritt1;
    @FXML
    private TextFlow lblSchritt2;
    @FXML
    private TextFlow lblSchritt3;
    @FXML
    private TextFlow lblSchritt4;
    @FXML
    private TextFlow lblSchritt5;
    @FXML
    private TextFlow lblSchritt6;
    @FXML
    private TableView<RowMetricsEntry> tblStatistics;
    @FXML
    private TableColumn<RowMetricsEntry, Number> colRank;
    @FXML
    private TableColumn<RowMetricsEntry, String> colDistanz;
    @FXML
    private Label lblPlaceholder;
    @FXML
    private TableView<KnnTableRow> tblCsv;
    @FXML
    private TableView<KnnTableRow> tblKorrelationskoeff;
    @FXML
    private TableView<KnnTableRow> tblAvg;
    @FXML
    private TableView<KnnTableRow> tblStdAbw;
    @FXML
    private TableView<KnnTableRow> tblSchaetzereignis;
    @FXML
    private Menu mnuFile;
    @FXML
    private MenuItem mnuLoadCsv;
    @FXML
    private MenuItem mnuLoadKnnX;
    @FXML
    private MenuItem mnuSaveKnnX;
    @FXML
    private MenuItem mnuSaveAsKnnX;
    @FXML
    private MenuItem mnuExit;
    @FXML
    private MenuItem mnuManual;
    @FXML
    private MenuItem mnuInfo;
    private final SimpleObjectProperty<KnnInputData> inputData = new SimpleObjectProperty();
    private final SimpleObjectProperty<File> currentProjectFile = new SimpleObjectProperty();
    private final SimpleBooleanProperty hasUnsavedChanges = new SimpleBooleanProperty(false);
    private boolean isVerticalScrollbarsBound = false;
    private final ObservableSet<String> selectedCols = FXCollections.observableSet((Object[])new String[0]);
    private final ObservableSet<String> highlightedSchaetzereignisTableCells = FXCollections.observableSet((Object[])new String[0]);
    private final BooleanBinding markResultInvalid = Bindings.createBooleanBinding(() -> {
        if (this.selectedCols.size() == 0) {
            return true;
        }
        if (this.highlightedSchaetzereignisTableCells.isEmpty()) {
            return false;
        }
        if (this.highlightedSchaetzereignisTableCells.size() == 1 && this.highlightedSchaetzereignisTableCells.contains(null)) {
            return false;
        }
        return true;
    }, (Observable[])new Observable[]{this.selectedCols, this.highlightedSchaetzereignisTableCells});
    private boolean doNotCalculate;
    private static final int THRESHOLD_NR_OF_ROWS_FOR_ON_THE_FLY_CALC = 350;
    private boolean ignoreNextTableSync;

    public MainWindow() {
        this.markResultInvalid.addListener((obs, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.clearResult();
            }
        });
        this.doNotCalculate = false;
        this.ignoreNextTableSync = false;
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            System.out.println("arg" + i + ": " + arg);
            if (arg.equalsIgnoreCase("-logtofile") || arg.equalsIgnoreCase("logtofile")) {
                LOG_TO_FILE = true;
            } else if (arg.equalsIgnoreCase("-logdialog") || arg.equalsIgnoreCase("logdialog")) {
                KnnExceptionHandler.setLogDialog(true);
            } else if (arg.equalsIgnoreCase("-stacktrace") || arg.equalsIgnoreCase("stacktrace")) {
                KnnExceptionHandler.setLogStackTrace(true);
            }
            ++i;
        }
        if (LOG_TO_FILE) {
            try {
                FileOutputStream os = new FileOutputStream("knn.log", true);
                PrintStream ps = new PrintStream(os);
                System.setOut(ps);
                System.setErr(ps);
            }
            catch (FileNotFoundException e) {
                KnnExceptionHandler.handle(e);
            }
        }
        MainWindow.launch((String[])args);
    }

    private static boolean isStartedFromJar() {
        return MainWindow.class.getResource("MainWindow.class").toString().startsWith("rsrc");
    }

    public void start(Stage stage) throws Exception {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> KnnExceptionHandler.handle(e, "Uncaught Exception in Thread " + t + "\n"));
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(((Object)((Object)this)).getClass().getResource("MainWindow.fxml"));
        loader.setController((Object)this);
        Parent root = (Parent)loader.load();
        this.initDragAndDrop(root);
        this.initMenu();
        this.initControls();
        this.stage = stage;
        this.scene = new Scene(root, 962.0, 680.0);
        String style = MainWindow.class.getResource("MainWindow.css").toExternalForm();
        this.scene.getStylesheets().add((Object)style);
        stage.setOnCloseRequest(evt -> {
            if (!this.canContinue_checkUnsavedChanges()) {
                evt.consume();
            }
        });
        stage.titleProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            if (this.currentProjectFile.get() == null) {
                return "WSL-kNN";
            }
            if (this.hasUnsavedChanges.get()) {
                return "WSL-kNN - " + ((File)this.currentProjectFile.get()).toString() + "*";
            }
            return "WSL-kNN - " + ((File)this.currentProjectFile.get()).toString();
        }, (Observable[])new Observable[]{this.currentProjectFile, this.hasUnsavedChanges}));
        stage.getIcons().add((Object)MainWindowHelper.getWslLogo());
        stage.setScene(this.scene);
        stage.setMinWidth(860.0);
        stage.setMinHeight(570.0);
        stage.show();
        this.adaptTableHeaders();
        MainWindowHelper.bindHorizontalTableScrollbars(this.tblCsv, this.tblKorrelationskoeff, this.tblAvg, this.tblStdAbw, this.tblSchaetzereignis);
        this.tblStatistics.getItems().addListener(c -> {
            if (this.tblStatistics.getItems().size() > 0 && !this.isVerticalScrollbarsBound) {
                this.bindVerticalTableScrollbars();
            } else if (this.tblStatistics.getItems().size() == 0 && this.isVerticalScrollbarsBound) {
                this.unbindVerticalTableScrollbars();
            }
        });
        for (String arg : this.getParameters().getRaw()) {
            File file;
            if (arg.endsWith(".csv") || arg.endsWith(".CSV")) {
                file = new File(arg);
                this.loadCsv(file);
                continue;
            }
            if (!arg.endsWith(".knnx") && !arg.endsWith(".knnX") && !arg.endsWith(".KNNX")) continue;
            file = new File(arg);
            this.loadKnnX(file);
        }
    }

    public void stop() throws Exception {
        ZipFileHelper.deleteTempFile();
    }

    private void initDragAndDrop(Parent root) {
        root.setOnDragEntered(e -> {
            if (MainWindow.isValidDragboardData(e.getDragboard())) {
                this.paneDragOk.setVisible(true);
            }
        });
        root.setOnDragExited(e -> this.paneDragOk.setVisible(false));
        root.setOnDragOver(e -> {
            if (MainWindow.isValidDragboardData(e.getDragboard())) {
                e.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            }
            e.consume();
        });
        root.setOnDragDropped(e -> {
            boolean success = false;
            if (this.canContinue_checkUnsavedChanges() && MainWindow.isValidDragboardData(e.getDragboard())) {
                File file = (File)e.getDragboard().getFiles().get(0);
                if (file.getName().endsWith("csv") || file.getName().endsWith("CSV")) {
                    success = this.loadCsv(file);
                } else if (file.getName().endsWith("knnx") || file.getName().endsWith("KNNX")) {
                    success = this.loadKnnX(file);
                }
            }
            e.setDropCompleted(success);
            e.consume();
        });
    }

    private static boolean isValidDragboardData(Dragboard dragboard) {
        if (!dragboard.hasFiles() || dragboard.getFiles().size() != 1) {
            return false;
        }
        File file = (File)dragboard.getFiles().get(0);
        String fileName = file.getName();
        return fileName.endsWith("csv") || fileName.endsWith("CSV") || fileName.endsWith("knnx") || fileName.endsWith("KNNX");
    }

    private void initMenu() {
        this.mnuLoadCsv.setOnAction(event -> this.loadCsvWithFileChooser());
        this.mnuLoadKnnX.setOnAction(event -> this.loadKnnXWithFileChooser());
        this.mnuSaveKnnX.setOnAction(event -> this.saveKnnX((File)this.currentProjectFile.get()));
        this.mnuSaveKnnX.disableProperty().bind((ObservableValue)this.currentProjectFile.isNotNull().and((ObservableBooleanValue)this.hasUnsavedChanges).not());
        this.mnuSaveAsKnnX.setOnAction(event -> this.saveKnnXWithFileChooser());
        this.mnuSaveAsKnnX.disableProperty().bind((ObservableValue)this.inputData.isNull());
        this.mnuExit.setOnAction(event -> {
            if (this.canContinue_checkUnsavedChanges()) {
                Platform.exit();
            }
        });
        this.mnuManual.setOnAction(event -> MainWindowHelper.openManual());
        this.mnuInfo.setOnAction(event -> this.showInfoDialog());
    }

    private void initControls() {
        SimpleListProperty listZielgroesse = new SimpleListProperty();
        listZielgroesse.bind((ObservableValue)this.cmbZielgroesse.itemsProperty());
        this.cmbZielgroesse.disableProperty().bind((ObservableValue)listZielgroesse.emptyProperty());
        this.cmbZielgroesse.valueProperty().addListener((obs, oldTitle, newTitle) -> {
            this.resetTargetValue();
            for (TableColumn col : this.tblCsv.getColumns()) {
                MainTableColumn mainTableCol = (MainTableColumn)col;
                boolean isNewTargetCol = mainTableCol.getTitle().equals(newTitle) && mainTableCol.getDataType().isAvailableForCalculation();
                mainTableCol.setAsTargetCol(isNewTargetCol);
            }
            this.tblKorrelationskoeff.refresh();
            this.tblAvg.refresh();
            this.tblStdAbw.refresh();
            for (TableColumn col : this.tblSchaetzereignis.getColumns()) {
                if (col.getText().equals(oldTitle)) {
                    col.setEditable(true);
                    continue;
                }
                if (!col.getText().equals(newTitle)) continue;
                col.setEditable(false);
            }
            this.tblSchaetzereignis.refresh();
            DataColumn dataColNowSelectedAsTargetCol = ((KnnInputData)this.inputData.get()).getDataColumn((String)newTitle);
            if (dataColNowSelectedAsTargetCol != null && dataColNowSelectedAsTargetCol.getDataType().isAvailableForCalculation()) {
                ((KnnInputData)this.inputData.get()).setTargetColumn(dataColNowSelectedAsTargetCol.getAsTargetColumn());
            } else {
                ((KnnInputData)this.inputData.get()).setTargetColumn(null);
            }
            this.calcCorrelation();
            this.tryReCalc();
        });
        this.cmbZielgroesse.setCellFactory(lv -> new ListCell<String>(){

            public void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setText(null);
                } else {
                    this.setText(item.toString());
                    MainTableColumn currentCol = MainWindow.this.tblCsv.getColumns().stream().filter(col -> ((MainTableColumn)((Object)col)).getTitle().equals(item)).findAny().orElse(null);
                    this.setDisable(currentCol != null && !currentCol.getDataType().isAvailableForCalculation());
                }
            }
        });
        this.txtParamK.disableProperty().bind((ObservableValue)this.cmbZielgroesse.valueProperty().isNull());
        this.txtParamK.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 99, 8));
        this.txtParamK.setEditable(true);
        this.txtParamK.focusedProperty().addListener((obs, oldVal, newVal) -> {
            if (!newVal.booleanValue()) {
                if (this.txtParamK.getEditor().getText().matches("[0-9]+")) {
                    this.txtParamK.increment(0);
                } else {
                    this.txtParamK.getEditor().setText(String.valueOf(this.txtParamK.getValue()));
                }
            }
        });
        this.txtParamK.valueProperty().addListener((obs, oldVal, newVal) -> this.tryReCalc());
        this.btnCalc.setOnAction(event -> {
            if (((KnnInputData)this.inputData.get()).getTargetColumn() != null) {
                this.calculate(true);
            } else {
                String msg = "Keine g\u00fcltige Zielgr\u00f6sse ausgew\u00e4hlt!";
                this.showAlert(Alert.AlertType.ERROR, msg);
            }
        });
        this.btnCalc.disableProperty().bind((ObservableValue)this.cmbZielgroesse.valueProperty().isNull());
        this.panelChart.getChildren().add((Object)this.chart);
        this.lblSchritt1.setOnMouseEntered(e -> this.highlightSchritt(Kurzanleitung.Schritt1, true));
        this.lblSchritt1.setOnMouseExited(e -> this.highlightSchritt(Kurzanleitung.Schritt1, false));
        this.lblSchritt2.setOnMouseEntered(e -> this.highlightSchritt(Kurzanleitung.Schritt2, true));
        this.lblSchritt2.setOnMouseExited(e -> this.highlightSchritt(Kurzanleitung.Schritt2, false));
        this.lblSchritt3.setOnMouseEntered(e -> this.highlightSchritt(Kurzanleitung.Schritt3, true));
        this.lblSchritt3.setOnMouseExited(e -> this.highlightSchritt(Kurzanleitung.Schritt3, false));
        this.lblSchritt4.setOnMouseEntered(e -> this.highlightSchritt(Kurzanleitung.Schritt4, true));
        this.lblSchritt4.setOnMouseExited(e -> this.highlightSchritt(Kurzanleitung.Schritt4, false));
        this.lblSchritt5.setOnMouseEntered(e -> this.highlightSchritt(Kurzanleitung.Schritt5, true));
        this.lblSchritt5.setOnMouseExited(e -> this.highlightSchritt(Kurzanleitung.Schritt5, false));
        this.lblSchritt6.setOnMouseEntered(e -> this.highlightSchritt(Kurzanleitung.Schritt6, true));
        this.lblSchritt6.setOnMouseExited(e -> this.highlightSchritt(Kurzanleitung.Schritt6, false));
        this.tblStatistics.setOnSort(e -> Platform.runLater(() -> this.syncTableSorting(this.tblStatistics)));
        this.tblStatistics.setRowFactory(tv -> new TableRow<RowMetricsEntry>(){

            public void updateItem(RowMetricsEntry item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.pseudoClassStateChanged(PSEUDO_CLASS_TABLE_CELL_BOLD, false);
                } else {
                    boolean isBold = false;
                    int rank = item.rankProperty().get();
                    if (rank > 0 && rank <= (Integer)MainWindow.this.txtParamK.getValue()) {
                        isBold = true;
                    }
                    this.pseudoClassStateChanged(PSEUDO_CLASS_TABLE_CELL_BOLD, isBold);
                }
            }
        });
        this.colRank.setCellValueFactory(element -> ((RowMetricsEntry)element.getValue()).rankProperty());
        this.colDistanz.setCellValueFactory(element -> ((RowMetricsEntry)element.getValue()).formattedDistanzProperty());
        this.tblCsv.setOnSort(e -> Platform.runLater(() -> this.syncTableSorting(this.tblCsv)));
        MainWindowHelper.bindTableSelection(this.tblCsv, this.tblStatistics);
        MainWindowHelper.disableTableSelection(this.tblKorrelationskoeff);
        MainWindowHelper.disableTableSelection(this.tblAvg);
        MainWindowHelper.disableTableSelection(this.tblStdAbw);
    }

    private void adaptTableHeaders() {
        MainWindowHelper.disableTableColumnReordering(this.tblCsv);
        MainWindowHelper.removeTableHeader(this.tblKorrelationskoeff);
        MainWindowHelper.removeTableHeader(this.tblAvg);
        MainWindowHelper.removeTableHeader(this.tblStdAbw);
        MainWindowHelper.removeTableHeader(this.tblSchaetzereignis);
    }

    private void bindVerticalTableScrollbars() {
        this.isVerticalScrollbarsBound = true;
        ScrollBar scrollbarTblCsvVertical = MainWindowHelper.getScrollBar(this.tblCsv, Orientation.VERTICAL);
        ScrollBar scrollbarTblCsvHorizontal = MainWindowHelper.getScrollBar(this.tblCsv, Orientation.HORIZONTAL);
        ScrollBar scrollbarTblStatistics = MainWindowHelper.getScrollBar(this.tblStatistics, Orientation.VERTICAL);
        scrollbarTblCsvVertical.valueProperty().bindBidirectional((Property)scrollbarTblStatistics.valueProperty());
        this.lblPlaceholder.visibleProperty().bind((ObservableValue)scrollbarTblCsvHorizontal.visibleProperty());
        this.lblPlaceholder.managedProperty().bind((ObservableValue)scrollbarTblCsvHorizontal.visibleProperty());
    }

    private void unbindVerticalTableScrollbars() {
        this.isVerticalScrollbarsBound = false;
        ScrollBar scrollbarTblCsvVertical = MainWindowHelper.getScrollBar(this.tblCsv, Orientation.VERTICAL);
        scrollbarTblCsvVertical.setValue(0.0);
        ScrollBar scrollbarTblStatistics = MainWindowHelper.getScrollBar(this.tblStatistics, Orientation.VERTICAL);
        scrollbarTblCsvVertical.valueProperty().unbindBidirectional((Property)scrollbarTblStatistics.valueProperty());
        this.lblPlaceholder.visibleProperty().unbind();
        this.lblPlaceholder.managedProperty().unbind();
    }

    private void loadCsvWithFileChooser() {
        if (this.canContinue_checkUnsavedChanges()) {
            File file = MainWindowHelper.getFileFromFileChooserOpenCsv(this.stage);
            this.loadCsv(file);
        }
    }

    private boolean loadCsv(File file) {
        if (file == null || !file.isFile()) {
            System.out.println("Fehler beim Laden der CSV-Datei: " + file);
            return false;
        }
        this.clearAllTablesAndChart();
        try {
            String filePath = file.getAbsolutePath();
            this.inputData.set((Object)ZipFileHelper.loadFromCsv(filePath));
            this.loadRowsIntoTable();
            this.calcAvgAndStdDev();
        }
        catch (FileNotFoundException e) {
            KnnExceptionHandler.userFriendlyAlert(e, "CSV-Datei konnte nicht geladen werden.\n\n" + e.getLocalizedMessage());
            return false;
        }
        catch (IOException e) {
            KnnExceptionHandler.userFriendlyAlert(e, "CSV-Datei konnte nicht geladen werden.\n\n" + e.getLocalizedMessage());
            return false;
        }
        catch (InvalidInputFormatException e) {
            KnnExceptionHandler.userFriendlyAlert(e, "CSV-Datei konnte nicht geladen werden.\n\n" + e.getLocalizedMessage());
            return false;
        }
        catch (Exception e) {
            KnnExceptionHandler.userFriendlyAlert(e, "CSV-Datei konnte nicht geladen werden.");
            return false;
        }
        return true;
    }

    private void loadKnnXWithFileChooser() {
        if (this.canContinue_checkUnsavedChanges()) {
            File file = MainWindowHelper.getFileFromFileChooserOpenProject(this.stage);
            this.loadKnnX(file);
        }
    }

    private boolean loadKnnX(File file) {
        if (file == null || !file.isFile()) {
            System.out.println("Fehler beim Laden der knnx-Datei: " + file);
            return false;
        }
        this.clearAllTablesAndChart();
        try {
            ZipFileHelper.InputDataWithSettings inputDataWithSettings = ZipFileHelper.loadFromKnnX(file.getAbsolutePath());
            this.inputData.set((Object)inputDataWithSettings.getInputData());
            this.loadRowsIntoTable();
            this.calcAvgAndStdDev();
            this.loadSettings(inputDataWithSettings.getSettings());
        }
        catch (IOException e) {
            KnnExceptionHandler.userFriendlyAlert(e, "Projekt-Datei konnte nicht geladen werden.\n\n" + e.getLocalizedMessage());
            return false;
        }
        catch (InvalidInputFormatException e) {
            KnnExceptionHandler.userFriendlyAlert(e, "Projekt-Datei konnte nicht geladen werden.\n\n" + e.getLocalizedMessage());
            return false;
        }
        catch (Exception e) {
            KnnExceptionHandler.userFriendlyAlert(e, "CSV-Datei konnte nicht geladen werden.");
            return false;
        }
        this.currentProjectFile.set((Object)file);
        return true;
    }

    private void clearAllTablesAndChart() {
        this.hasUnsavedChanges.set(false);
        this.currentProjectFile.set(null);
        this.cmbZielgroesse.getItems().clear();
        this.inputData.set(null);
        this.tblStatistics.getItems().clear();
        this.tblStatistics.getSortOrder().clear();
        this.tblCsv.getItems().clear();
        this.tblCsv.getColumns().clear();
        this.tblKorrelationskoeff.getItems().clear();
        this.tblKorrelationskoeff.getColumns().clear();
        this.tblAvg.getItems().clear();
        this.tblAvg.getColumns().clear();
        this.tblStdAbw.getItems().clear();
        this.tblStdAbw.getColumns().clear();
        this.tblSchaetzereignis.getItems().clear();
        this.tblSchaetzereignis.getColumns().clear();
        this.chart.clearAll();
    }

    private void clearResult() {
        this.tblStatistics.getItems().clear();
        for (KnnTableRow row : this.tblCsv.getItems()) {
            row.rankProperty().set(Integer.MAX_VALUE);
        }
        this.tblCsv.refresh();
        this.resetTargetValue();
        this.chart.clearAll();
    }

    private void resetTargetValue() {
        if (((KnnInputData)this.inputData.get()).getTargetColumn() != null) {
            String targetTitle = ((KnnInputData)this.inputData.get()).getTargetColumn().getTitle();
            KnnTableRow tableRow = (KnnTableRow)this.tblSchaetzereignis.getItems().get(0);
            tableRow.setCellValueForColumn(targetTitle, null);
        }
    }

    private void loadRowsIntoTable() {
        if (((KnnInputData)this.inputData.get()).isEmpty() || ((KnnInputData)this.inputData.get()).getDataRows().size() == 0) {
            String msg = "CSV enth\u00e4lt keine Daten!";
            this.showAlert(Alert.AlertType.ERROR, msg);
            return;
        }
        for (String title : ((KnnInputData)this.inputData.get()).getTitles()) {
            this.cmbZielgroesse.getItems().add((Object)title);
            MainTableColumn colMain = this.createMainTableColumn(title);
            this.tblCsv.getColumns().add((Object)colMain);
            colMain.getChkHeader().selectedProperty().addListener((obs, oldVal, newVal) -> {
                if (newVal.booleanValue()) {
                    this.selectedCols.add((Object)title);
                }
                if (!newVal.booleanValue()) {
                    this.selectedCols.remove((Object)title);
                    this.highlightedSchaetzereignisTableCells.remove((Object)title);
                }
                this.tryReCalc();
            });
            TableColumn colKoeff = new TableColumn(title);
            this.initStatisticsTableColumnCellFactory((TableColumn<KnnTableRow, String>)colKoeff);
            colKoeff.setCellValueFactory(element -> ((KnnTableRow)element.getValue()).getCellStringForColumn(title));
            colKoeff.prefWidthProperty().bind((ObservableValue)colMain.widthProperty());
            this.tblKorrelationskoeff.getColumns().add((Object)colKoeff);
            TableColumn colAvg = new TableColumn(title);
            this.initStatisticsTableColumnCellFactory((TableColumn<KnnTableRow, String>)colAvg);
            colAvg.setCellValueFactory(element -> ((KnnTableRow)element.getValue()).getCellStringForColumn(title));
            colAvg.prefWidthProperty().bind((ObservableValue)colMain.widthProperty());
            this.tblAvg.getColumns().add((Object)colAvg);
            TableColumn colStdAbw = new TableColumn(title);
            this.initStatisticsTableColumnCellFactory((TableColumn<KnnTableRow, String>)colStdAbw);
            colStdAbw.setCellValueFactory(element -> ((KnnTableRow)element.getValue()).getCellStringForColumn(title));
            colStdAbw.prefWidthProperty().bind((ObservableValue)colMain.widthProperty());
            this.tblStdAbw.getColumns().add((Object)colStdAbw);
            TableColumn colSchaetz = new TableColumn(title);
            colSchaetz.setCellFactory(col -> new TextFieldCell());
            colSchaetz.setEditable(true);
            colSchaetz.setCellValueFactory(element -> ((KnnTableRow)element.getValue()).getCellValueForColumn(title));
            colSchaetz.prefWidthProperty().bind((ObservableValue)colMain.widthProperty());
            this.tblSchaetzereignis.getColumns().add((Object)colSchaetz);
        }
        for (KnnTableRow row : KnnTableRow.getRowsFromInputData((KnnInputData)this.inputData.get())) {
            this.tblCsv.getItems().add((Object)row);
        }
        this.tblKorrelationskoeff.getItems().clear();
        this.tblKorrelationskoeff.getItems().add((Object)KnnTableRow.getEmptyRow(((KnnInputData)this.inputData.get()).getTitles()));
        this.tblKorrelationskoeff.getSelectionModel().setCellSelectionEnabled(true);
        this.tblAvg.getItems().clear();
        this.tblAvg.getItems().add((Object)KnnTableRow.getEmptyRow(((KnnInputData)this.inputData.get()).getTitles()));
        this.tblAvg.getSelectionModel().setCellSelectionEnabled(true);
        this.tblStdAbw.getItems().clear();
        this.tblStdAbw.getItems().add((Object)KnnTableRow.getEmptyRow(((KnnInputData)this.inputData.get()).getTitles()));
        this.tblStdAbw.getSelectionModel().setCellSelectionEnabled(true);
        this.tblSchaetzereignis.getItems().clear();
        this.tblSchaetzereignis.getItems().add((Object)KnnTableRow.getEmptyRow(((KnnInputData)this.inputData.get()).getTitles()));
        this.tblSchaetzereignis.getSelectionModel().setCellSelectionEnabled(true);
        MainWindowHelper.optimizeMainTableColumnWidths(this.tblCsv);
        this.loadTableStatistics(null);
    }

    private MainTableColumn createMainTableColumn(String title) {
        DataColumn dataCol = ((KnnInputData)this.inputData.get()).getDataColumn(title);
        MainTableColumn col = new MainTableColumn(dataCol, (ObjectProperty<String>)this.cmbZielgroesse.valueProperty(), (ObservableValue<Integer>)this.txtParamK.valueProperty());
        return col;
    }

    private void initStatisticsTableColumnCellFactory(TableColumn<KnnTableRow, String> col) {
        col.setCellFactory(e -> new TableCell<KnnTableRow, String>(){
            private BooleanExpression highlightTargetCell;
            private BooleanExpression highlightReferenceCell;
            {
                this.tableRowProperty().addListener((obs, oldVal, newVal) -> {
                    if (oldVal == null && newVal != null) {
                        int colIndex = this.getTableView().getColumns().indexOf((Object)this.getTableColumn());
                        MainTableColumn mainTableCol = (MainTableColumn)((Object)((Object)MainWindow.this.tblCsv.getColumns().get(colIndex)));
                        BooleanBinding isTargetColumnProperty = MainWindow.this.cmbZielgroesse.valueProperty().isEqualTo((Object)mainTableCol.getTitle());
                        BooleanProperty headerSelectedProperty = mainTableCol.selectedProperty();
                        ReadOnlyBooleanProperty rowSelectedProperty = this.getTableRow().selectedProperty();
                        BooleanBinding isNotEmptyProperty = this.textProperty().isNotEmpty();
                        this.highlightTargetCell = isTargetColumnProperty.and((ObservableBooleanValue)rowSelectedProperty.not()).and((ObservableBooleanValue)isNotEmptyProperty);
                        this.highlightReferenceCell = headerSelectedProperty.and((ObservableBooleanValue)rowSelectedProperty.not()).and((ObservableBooleanValue)isNotEmptyProperty).and((ObservableBooleanValue)isTargetColumnProperty.not());
                        this.highlightTargetCell.addListener((obsX, oldValX, newValX) -> this.pseudoClassStateChanged(PSEUDO_CLASS_TARGET_COLUMN_CELL, (boolean)newValX));
                        this.highlightReferenceCell.addListener((obsX, oldValX, newValX) -> this.pseudoClassStateChanged(PSEUDO_CLASS_REFERENCE_COLUMN_CELL, (boolean)newValX));
                    }
                });
            }

            public void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(item.toString());
                }
            }
        });
    }

    private void calcAvgAndStdDev() {
        List<DataColumn> allDataCols = ((KnnInputData)this.inputData.get()).getDataColumns();
        Calculator.preCalcAvgAndStdDev(allDataCols);
        this.loadTablesAvgStdAbw(allDataCols);
    }

    private void calcCorrelation() {
        List<DataColumn> allDataCols = ((KnnInputData)this.inputData.get()).getDataColumns();
        TargetDataColumn targetCol = ((KnnInputData)this.inputData.get()).getTargetColumn();
        Calculator.preCalcCorrelationCoefficient(allDataCols, targetCol);
        this.loadTableKorrelation(allDataCols);
    }

    private void loadSettings(PersistentSettings settings) {
        this.doNotCalculate = true;
        this.cmbZielgroesse.setValue((Object)settings.getZielgroesse());
        this.txtParamK.getValueFactory().setValue((Object)settings.getK());
        List<String> selectedColumns = settings.getSelectedColumns();
        this.tblCsv.getColumns().stream().forEach(col -> {
            MainTableColumn mainTableCol = (MainTableColumn)((Object)col);
            if (selectedColumns.contains(mainTableCol.getTitle())) {
                mainTableCol.setSelected(true);
            }
        });
        KnnTableRow tableRow = (KnnTableRow)this.tblSchaetzereignis.getItems().get(0);
        boolean targetRowComplete = true;
        for (Map.Entry<String, Double> entry : settings.getSchaetzereignis().entrySet()) {
            tableRow.setCellValueForColumn(entry.getKey(), entry.getValue());
            if (entry.getValue() != null) continue;
            targetRowComplete = false;
        }
        this.doNotCalculate = false;
        if (settings.getZielgroesse() != null && targetRowComplete) {
            TableColumn sortedColumn;
            this.calculate(true);
            if (settings.getSortedColumnNr() >= 0 && settings.getSortedColumnNr() < 2) {
                sortedColumn = (TableColumn)this.tblStatistics.getColumns().get(settings.getSortedColumnNr());
                this.tblStatistics.getSortOrder().add((Object)sortedColumn);
                sortedColumn.setSortType(settings.getSortOrder());
            } else if (settings.getSortedColumnNr() >= 2) {
                sortedColumn = (TableColumn)this.tblCsv.getColumns().get(settings.getSortedColumnNr() - 2);
                this.tblCsv.getSortOrder().add((Object)sortedColumn);
                sortedColumn.setSortType(settings.getSortOrder());
            }
        }
    }

    private void saveKnnXWithFileChooser() {
        File file = MainWindowHelper.getFileFromFileChooserSaveProject(this.stage);
        this.saveKnnX(file);
    }

    private void saveKnnX(File file) {
        if (file == null) {
            System.out.println("Fehler beim Speichern der knnx-Datei: " + file);
            return;
        }
        if (this.inputData == null) {
            String msg = "Es muss zuerst eine CSV-Datei importiert werden!";
            this.showAlert(Alert.AlertType.ERROR, msg);
            return;
        }
        try {
            ZipFileHelper.save(file.getAbsolutePath(), this.getSettings());
            this.currentProjectFile.set((Object)file);
            this.hasUnsavedChanges.set(false);
        }
        catch (IOException e) {
            KnnExceptionHandler.userFriendlyAlert(e, "Projekt-Datei konnte nicht gespeichert werden.\n\n" + e.getLocalizedMessage());
        }
    }

    private PersistentSettings getSettings() {
        PersistentSettings result = new PersistentSettings();
        result.setZielgroesse((String)this.cmbZielgroesse.getValue());
        result.setK((Integer)this.txtParamK.getValue());
        ArrayList<String> selectedColumns = new ArrayList<String>();
        ((KnnInputData)this.inputData.get()).getDataColumns().stream().filter(e -> e.isSelected()).forEach(e -> {
            boolean bl = selectedColumns.add(e.getTitle());
        });
        result.setSelectedColumns(selectedColumns);
        HashMap<String, Double> schaetzereignis = new HashMap<String, Double>();
        TargetDataRow targetRow = this.parseTargetRow(true, false);
        selectedColumns.forEach(title -> {
            Object v0 = schaetzereignis.put((String)title, targetRow.getCell((String)title).containsValidCalcValue() ? Double.valueOf(targetRow.getCell((String)title).getCalcValue()) : null);
        });
        result.setSchaetzereignis(schaetzereignis);
        if (!this.tblStatistics.getSortOrder().isEmpty()) {
            TableColumn sortedColumn = (TableColumn)this.tblStatistics.getSortOrder().get(0);
            result.setSortedColumnNr(this.tblStatistics.getColumns().indexOf((Object)sortedColumn));
            result.setSortOrder(sortedColumn.getSortType());
        } else if (!this.tblCsv.getSortOrder().isEmpty()) {
            TableColumn sortedColumn = (TableColumn)this.tblCsv.getSortOrder().get(0);
            result.setSortedColumnNr(this.tblCsv.getColumns().indexOf((Object)sortedColumn) + 2);
            result.setSortOrder(sortedColumn.getSortType());
        } else {
            result.setSortedColumnNr(-1);
            result.setSortOrder(null);
        }
        return result;
    }

    private void highlightSchritt(Kurzanleitung schritt, boolean highlight) {
        String highlightColor = "#ff9999";
        switch (schritt) {
            case Schritt1: {
                if (highlight) {
                    this.mnuFile.setStyle("-fx-background-color: #ff9999");
                    break;
                }
                this.mnuFile.setStyle("");
                break;
            }
            case Schritt2: {
                if (highlight) {
                    this.cmbZielgroesse.setStyle("-fx-background-color: #ff9999");
                    break;
                }
                this.cmbZielgroesse.setStyle("");
                break;
            }
            case Schritt3: {
                for (TableColumn col : this.tblCsv.getColumns()) {
                    MainTableColumn mainTableCol = (MainTableColumn)col;
                    CheckBox checkBox = mainTableCol.getChkHeader();
                    Region checkBoxBox = (Region)checkBox.lookup(".box");
                    if (highlight) {
                        checkBoxBox.setStyle("-fx-background-color: #ff9999");
                        continue;
                    }
                    checkBoxBox.setStyle("");
                }
                break;
            }
            case Schritt4: {
                if (highlight) {
                    this.highlightedSchaetzereignisTableCells.add(null);
                    this.tblSchaetzereignis.setStyle("-fx-background-color: #ff9999");
                    break;
                }
                this.highlightedSchaetzereignisTableCells.remove(null);
                this.tblSchaetzereignis.setStyle("");
                break;
            }
            case Schritt5: {
                if (highlight) {
                    this.txtParamK.getEditor().setStyle("-fx-background-color: #ff9999");
                    break;
                }
                this.txtParamK.getEditor().setStyle("");
                break;
            }
            case Schritt6: {
                if (highlight) {
                    this.btnCalc.setStyle("-fx-background-color: #ff9999");
                    break;
                }
                this.btnCalc.setStyle("");
                break;
            }
            default: {
                throw new RuntimeException(schritt.name());
            }
        }
    }

    private void tryReCalc() {
        if (this.doNotCalculate) {
            return;
        }
        if (this.currentProjectFile.isNotNull().get()) {
            this.hasUnsavedChanges.set(true);
        }
        if (((KnnInputData)this.inputData.get()).getTargetColumn() != null) {
            if (((KnnInputData)this.inputData.get()).getDataRows().size() <= 350) {
                this.calculate(false);
            } else {
                this.clearResult();
            }
        }
    }

    private void calculate(boolean showAlert) {
        List<DataColumn> allDataCols = ((KnnInputData)this.inputData.get()).getDataColumns();
        TargetDataColumn targetCol = ((KnnInputData)this.inputData.get()).getTargetColumn();
        List<DataRow> allDataRows = ((KnnInputData)this.inputData.get()).getDataRows();
        TargetDataRow targetRow = this.parseTargetRow(false, showAlert);
        if (targetRow != null && this.selectedCols.size() > 0) {
            Calculator.calc(allDataCols, allDataRows, targetCol, targetRow, (Integer)this.txtParamK.getValue());
            this.updateTableCsv(allDataRows);
            this.loadTableStatistics(allDataRows);
            double schaetzwert = this.loadSchaetzereignisTargetVariable(targetRow);
            this.chart.setData(allDataRows, targetCol.getTitle(), schaetzwert, (Integer)this.txtParamK.getValue());
            this.tblStatistics.refresh();
            this.tblCsv.refresh();
        } else {
            this.clearResult();
        }
    }

    private TargetDataRow parseTargetRow(boolean ignoreInvalid, boolean showAlert) {
        if (this.tblSchaetzereignis.getItems().isEmpty()) {
            return null;
        }
        KnnTableRow tableRow = (KnnTableRow)this.tblSchaetzereignis.getItems().get(0);
        HashMap<DataColumn, DataCell> targetRowCells = new HashMap<DataColumn, DataCell>();
        LinkedHashSet<String> invalidCols = new LinkedHashSet<String>();
        for (DataColumn dataCol : ((KnnInputData)this.inputData.get()).getDataColumns()) {
            String title = dataCol.getTitle();
            DataCell cell = new DataCell(tableRow.getCellValueForColumn(title).get(), dataCol, true);
            targetRowCells.put(dataCol, cell);
            if (cell.containsValidCalcValue() || !((KnnInputData)this.inputData.get()).getDataColumn(title).isSelected() || ignoreInvalid) continue;
            invalidCols.add(title);
            this.highlightedSchaetzereignisTableCells.add((Object)title);
        }
        if (invalidCols.size() > 0 && showAlert) {
            String missingFields = Arrays.toString(invalidCols.toArray()).replaceAll("\\[|\\]", "");
            String msg = "Geben Sie eine g\u00fcltige Zahl f\u00fcr die folgenden Variable(n) in das Sch\u00e4tzereignis ein:\n\n" + missingFields;
            this.showAlert(Alert.AlertType.ERROR, msg);
            return null;
        }
        if (invalidCols.size() > 0 && !showAlert) {
            return null;
        }
        TargetDataRow result = new TargetDataRow(targetRowCells);
        return result;
    }

    private void updateTableCsv(List<DataRow> allRows) {
        this.tblCsv.getItems().forEach(row -> {
            int rank = allRows.stream().filter(dataRow -> dataRow.equals(row.dataRowProperty().get())).findAny().get().getRank();
            row.rankProperty().set(rank);
        });
    }

    private void loadTablesAvgStdAbw(List<DataColumn> allDataCols) {
        this.tblAvg.getItems().clear();
        this.tblStdAbw.getItems().clear();
        KnnTableRow rowAvg = KnnTableRow.getEmptyRow(((KnnInputData)this.inputData.get()).getTitles());
        KnnTableRow rowStdAbw = KnnTableRow.getEmptyRow(((KnnInputData)this.inputData.get()).getTitles());
        for (DataColumn col : allDataCols) {
            rowAvg.setCellValueForColumn(col.getTitle(), col.getAvg());
            rowStdAbw.setCellValueForColumn(col.getTitle(), col.getStdAbw());
        }
        this.tblAvg.getItems().add((Object)rowAvg);
        this.tblStdAbw.getItems().add((Object)rowStdAbw);
    }

    private void loadTableKorrelation(List<DataColumn> allDataCols) {
        this.tblKorrelationskoeff.getItems().clear();
        KnnTableRow rowKoeff = KnnTableRow.getEmptyRow(((KnnInputData)this.inputData.get()).getTitles());
        for (DataColumn col : allDataCols) {
            rowKoeff.setCellValueForColumn(col.getTitle(), col.getKorrelationsKoeff());
        }
        this.tblKorrelationskoeff.getItems().add((Object)rowKoeff);
    }

    private void loadTableStatistics(List<DataRow> allDataRows) {
        TableColumn sortOrder = this.tblStatistics.getSortOrder().size() == 1 ? (TableColumn)this.tblStatistics.getSortOrder().get(0) : null;
        TableColumn.SortType sortType = sortOrder != null ? sortOrder.getSortType() : null;
        this.tblStatistics.getItems().clear();
        if (allDataRows != null) {
            for (DataRow row : allDataRows) {
                this.tblStatistics.getItems().add((Object)RowMetricsEntry.getNewEntry(row.getRank(), row.getDistance(), row));
            }
            this.syncTableSorting(this.tblCsv);
        }
        if (sortOrder != null) {
            this.tblStatistics.getSortOrder().add((Object)sortOrder);
            if (sortType != null) {
                sortOrder.setSortType(sortType);
            }
        }
    }

    private void syncTableSorting(TableView<?> sortEventOrigin) {
        boolean bothTablesSorted;
        if (this.ignoreNextTableSync) {
            this.ignoreNextTableSync = false;
            return;
        }
        boolean bl = bothTablesSorted = !this.tblStatistics.getSortOrder().isEmpty() && !this.tblCsv.getSortOrder().isEmpty();
        if (bothTablesSorted) {
            this.ignoreNextTableSync = true;
        }
        if (sortEventOrigin == this.tblCsv) {
            this.tblStatistics.getSortOrder().clear();
            this.tblStatistics.getItems().sort((o1, o2) -> {
                KnnTableRow knnTableRow1 = this.tblCsv.getItems().stream().filter(e -> e.dataRowProperty().get() == o1.dataRowProperty().get()).findAny().get();
                KnnTableRow knnTableRow2 = this.tblCsv.getItems().stream().filter(e -> e.dataRowProperty().get() == o2.dataRowProperty().get()).findAny().get();
                int pos1 = this.tblCsv.getItems().indexOf((Object)knnTableRow1);
                int pos2 = this.tblCsv.getItems().indexOf((Object)knnTableRow2);
                return pos1 - pos2;
            });
        } else if (sortEventOrigin == this.tblStatistics) {
            this.tblCsv.getSortOrder().clear();
            this.tblCsv.getItems().sort((o1, o2) -> {
                RowMetricsEntry rowMetricsEntry1 = this.tblStatistics.getItems().stream().filter(e -> e.dataRowProperty().get() == o1.dataRowProperty().get()).findAny().orElse(null);
                RowMetricsEntry rowMetricsEntry2 = this.tblStatistics.getItems().stream().filter(e -> e.dataRowProperty().get() == o2.dataRowProperty().get()).findAny().orElse(null);
                int pos1 = this.tblStatistics.getItems().indexOf((Object)rowMetricsEntry1);
                int pos2 = this.tblStatistics.getItems().indexOf((Object)rowMetricsEntry2);
                return pos1 - pos2;
            });
        }
    }

    private double loadSchaetzereignisTargetVariable(TargetDataRow targetRow) {
        String targetTitle = ((KnnInputData)this.inputData.get()).getTargetColumn().getTitle();
        double schaetzwert = targetRow.getCell(targetTitle).getCalcValue();
        KnnTableRow tableRow = (KnnTableRow)this.tblSchaetzereignis.getItems().get(0);
        tableRow.setCellValueForColumn(targetTitle, schaetzwert);
        return schaetzwert;
    }

    private boolean canContinue_checkUnsavedChanges() {
        if (this.currentProjectFile.isNotNull().get() && this.hasUnsavedChanges.get()) {
            String msg = "Das aktuell ge\u00f6ffnete Projekt enth\u00e4lt ungespeicherte \u00c4nderungen. Sollen diese gespeichert werden?";
            ButtonType buttonTypeSave = new ButtonType("\u00c4nderungen speichern und fortfahren");
            ButtonType buttonTypeDiscard = new ButtonType("\u00c4nderungen verwerfen und fortfahren");
            ButtonType buttonTypeCancel = new ButtonType("Abbrechen");
            ButtonType[] allButtons = new ButtonType[]{buttonTypeSave, buttonTypeDiscard, buttonTypeCancel};
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, msg, allButtons);
            alert.setHeaderText(null);
            alert.setTitle("WSL-kNN");
            alert.initOwner(this.scene.getWindow());
            alert.getDialogPane().getStylesheets().clear();
            alert.getDialogPane().getStylesheets().addAll((Collection)this.scene.getStylesheets());
            Optional result = alert.showAndWait();
            if (result.isPresent() && result.get() == buttonTypeSave) {
                this.saveKnnX((File)this.currentProjectFile.get());
                return true;
            }
            return result.isPresent() && result.get() == buttonTypeDiscard;
        }
        return true;
    }

    private void showInfoDialog() {
        StringBuilder sb = new StringBuilder();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("d. MMMM YYYY");
        sb.append("WSL-kNN v.2.0 BETA / " + formatter.format(KNN_DATE));
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        sb.append("Bereitgestellt durch:");
        sb.append(System.lineSeparator());
        sb.append("Eidg. Forschungsanstalt WSL");
        sb.append(System.lineSeparator());
        sb.append("Z\u00fcrcherstrasse 111");
        sb.append(System.lineSeparator());
        sb.append("CH-8903 Birmensdorf");
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        sb.append("Softwareentwicklung:");
        sb.append(System.lineSeparator());
        sb.append("Stefan Holm");
        sb.append(System.lineSeparator());
        String contentText = sb.toString();
        this.showAlert(Alert.AlertType.INFORMATION, contentText, "Info");
    }

    private void showAlert(Alert.AlertType alertType, String msg) {
        this.showAlert(alertType, msg, "WSL-kNN");
    }

    private void showAlert(Alert.AlertType alertType, String msg, String title) {
        Alert alert = new Alert(alertType, msg, new ButtonType[]{ButtonType.OK});
        alert.setHeaderText(null);
        alert.setTitle(title);
        alert.initOwner(this.scene.getWindow());
        alert.getDialogPane().getStylesheets().clear();
        alert.getDialogPane().getStylesheets().addAll((Collection)this.scene.getStylesheets());
        alert.show();
    }

    private static enum Kurzanleitung {
        Schritt1,
        Schritt2,
        Schritt3,
        Schritt4,
        Schritt5,
        Schritt6;

    }

    private class TextFieldCell
    extends TableCell<KnnTableRow, Object> {
        private final DoubleTextField textField = new DoubleTextField();
        private BooleanExpression highlightTargetCell;
        private BooleanExpression highlightReferenceCell;
        private boolean isInsideUpdateItem = false;
        private boolean isCommittingValue = false;

        public TextFieldCell() {
            this.tableRowProperty().addListener((obs, oldVal, newVal) -> {
                if (oldVal == null && newVal != null) {
                    int colIndex = this.getTableView().getColumns().indexOf((Object)this.getTableColumn());
                    MainTableColumn mainTableCol = (MainTableColumn)((Object)((Object)MainWindow.this.tblCsv.getColumns().get(colIndex)));
                    BooleanBinding isTargetColumnProperty = MainWindow.this.cmbZielgroesse.valueProperty().isEqualTo((Object)mainTableCol.getTitle());
                    BooleanProperty headerSelectedProperty = mainTableCol.selectedProperty();
                    ReadOnlyBooleanProperty rowSelectedProperty = this.getTableRow().selectedProperty();
                    BooleanBinding isNotEmptyProperty = this.emptyProperty().not();
                    this.highlightTargetCell = isTargetColumnProperty.and((ObservableBooleanValue)rowSelectedProperty.not()).and((ObservableBooleanValue)isNotEmptyProperty);
                    this.highlightReferenceCell = headerSelectedProperty.and((ObservableBooleanValue)rowSelectedProperty.not()).and((ObservableBooleanValue)isNotEmptyProperty).and((ObservableBooleanValue)isTargetColumnProperty.not());
                    this.highlightTargetCell.addListener((obsX, oldValX, newValX) -> {
                        this.textField.pseudoClassStateChanged(PSEUDO_CLASS_TARGET_COLUMN_CELL, (boolean)newValX);
                        this.textField.pseudoClassStateChanged(PSEUDO_CLASS_TARGET_COLUMN_TARGET_CELL, (boolean)newValX);
                    });
                    this.highlightReferenceCell.addListener((obsX, oldValX, newValX) -> this.textField.pseudoClassStateChanged(PSEUDO_CLASS_REFERENCE_COLUMN_CELL, (boolean)newValX));
                    MainWindow.this.highlightedSchaetzereignisTableCells.addListener(c -> {
                        boolean highlight = MainWindow.this.highlightedSchaetzereignisTableCells.contains((Object)mainTableCol.getTitle()) || MainWindow.this.highlightedSchaetzereignisTableCells.contains(null);
                        this.textField.pseudoClassStateChanged(PSEUDO_CLASS_TABLE_CELL_HIGHLIGHT, highlight);
                    });
                }
            });
            this.addEventFilter(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
                if (!this.isEmpty() && this.getTableColumn().isEditable() && !this.textField.isFocused()) {
                    this.textField.requestFocus();
                }
            });
            this.textField.textProperty().addListener((observable, oldVal, newVal) -> {
                if (!this.isInsideUpdateItem) {
                    this.tryToCommitValue();
                    int colIndex = this.getTableView().getColumns().indexOf((Object)this.getTableColumn());
                    MainTableColumn mainTableCol = (MainTableColumn)((Object)((Object)MainWindow.this.tblCsv.getColumns().get(colIndex)));
                    if (mainTableCol.selectedProperty().get()) {
                        MainWindow.this.tryReCalc();
                    }
                }
            });
            this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (!newValue.booleanValue() && !this.isCommittingValue) {
                    this.textField.setText(this.textField.getValue() == null ? "" : GLOBAL_DOUBLE_FORMAT.format(this.textField.getValue()));
                }
            });
            this.setStyle("-fx-padding: 0;");
        }

        private void tryToCommitValue() {
            this.isCommittingValue = true;
            Double newValue = this.textField.getValue();
            int colIndex = this.getTableView().getColumns().indexOf((Object)this.getTableColumn());
            MainTableColumn mainTableCol = (MainTableColumn)((Object)MainWindow.this.tblCsv.getColumns().get(colIndex));
            this.getTableView().edit(this.getTableRow().getIndex(), this.getTableColumn());
            this.startEdit();
            this.commitEdit(newValue);
            MainWindow.this.highlightedSchaetzereignisTableCells.remove((Object)mainTableCol.getTitle());
            this.textField.requestFocus();
            this.isCommittingValue = false;
        }

        protected void updateItem(Object item, boolean empty) {
            if (this.isCommittingValue) {
                return;
            }
            this.isInsideUpdateItem = true;
            super.updateItem(item, empty);
            this.setText(null);
            if (empty) {
                this.setGraphic(null);
                this.textField.setText("");
            } else {
                this.setGraphic((Node)this.textField);
                if (!this.textField.isFocused()) {
                    this.textField.setText(item == null ? "" : GLOBAL_DOUBLE_FORMAT.format(item));
                }
                this.textField.setEditable(this.getTableColumn().isEditable());
            }
            this.isInsideUpdateItem = false;
        }
    }
}

