/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.knn.gui;

import ch.wsl.fps.knn.gui.MainWindowHelper;
import ch.wsl.fps.knn.model.DataRow;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.ScatterChart;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class KnnXyChart
extends StackPane {
    private final NumberAxis xAxis = new NumberAxis();
    private final NumberAxis yAxis = new NumberAxis();
    private final ScatterChart<Number, Number> chart = new ScatterChart((Axis)this.xAxis, (Axis)this.yAxis);
    private final XYChart.Series<Number, Number> seriesNaechsteNachbarn = new XYChart.Series();
    private final XYChart.Series<Number, Number> seriesNichtAusgewaehlt = new XYChart.Series();
    private final XYChart.Series<Number, Number> seriesSchaetzwert = new XYChart.Series();

    public KnnXyChart() {
        this.xAxis.setLabel("Euklidische Distanz");
        this.yAxis.setLabel("Y-Wert");
        this.seriesSchaetzwert.setName("Sch\u00e4tzwert");
        this.seriesSchaetzwert.getData().add((Object)new XYChart.Data((Object)0, (Object)0));
        this.seriesNaechsteNachbarn.setName("k n\u00e4chste Nachbarn");
        this.seriesNaechsteNachbarn.getData().add((Object)new XYChart.Data((Object)0, (Object)0));
        this.seriesNichtAusgewaehlt.setName("\u00fcbrige Datens\u00e4tze");
        this.seriesNichtAusgewaehlt.getData().add((Object)new XYChart.Data((Object)0, (Object)0));
        this.chart.getData().add(this.seriesSchaetzwert);
        this.chart.getData().add(this.seriesNaechsteNachbarn);
        this.chart.getData().add(this.seriesNichtAusgewaehlt);
        this.clearAll();
        this.chart.setMinWidth(270.0);
        this.chart.setMaxHeight(250.0);
        this.getChildren().add(this.chart);
        this.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                Stage stage = new Stage();
                stage.initOwner(this.getScene().getWindow());
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("WSL-kNN");
                stage.getIcons().add((Object)MainWindowHelper.getWslLogo());
                stage.setScene(new Scene((Parent)this.getCopy()));
                stage.getScene().getStylesheets().addAll((Collection)this.getScene().getStylesheets());
                stage.setWidth(800.0);
                stage.setHeight(600.0);
                stage.showAndWait();
            }
        });
    }

    public void setData(List<DataRow> allRows, String targetTitle, double schaetzwert, int k) {
        this.clearAll();
        this.yAxis.setLabel(targetTitle);
        this.loadData(allRows, targetTitle, k);
        this.setSchaetzwert(schaetzwert);
    }

    public void clearAll() {
        this.seriesNaechsteNachbarn.getData().clear();
        this.seriesNichtAusgewaehlt.getData().clear();
        this.seriesSchaetzwert.getData().clear();
    }

    private void loadData(List<DataRow> allRows, String targetTitle, int k) {
        int i = allRows.size() - 1;
        while (i >= 0) {
            DataRow dataRow = allRows.get(i);
            XYChart.Data data = new XYChart.Data((Object)dataRow.getDistance(), (Object)dataRow.getCell(targetTitle).getCalcValue());
            if (dataRow.getRank() <= k) {
                this.seriesNaechsteNachbarn.getData().add((Object)data);
            } else {
                this.seriesNichtAusgewaehlt.getData().add((Object)data);
            }
            --i;
        }
    }

    private void setSchaetzwert(double schaetzwert) {
        XYChart.Data data = new XYChart.Data((Object)0, (Object)schaetzwert);
        StackPane stackPane = new StackPane();
        stackPane.setPrefWidth(12.0);
        stackPane.setPrefHeight(12.0);
        data.setNode((Node)stackPane);
        this.seriesSchaetzwert.getData().clear();
        this.seriesSchaetzwert.getData().add((Object)data);
    }

    private KnnXyChart getCopy() {
        KnnXyChart copy = new KnnXyChart();
        this.seriesNaechsteNachbarn.getData().forEach(data -> {
            boolean bl = knnXyChart.seriesNaechsteNachbarn.getData().add((Object)new XYChart.Data((Object)((Number)data.getXValue()), (Object)((Number)data.getYValue())));
        });
        this.seriesNichtAusgewaehlt.getData().forEach(data -> {
            boolean bl = knnXyChart.seriesNichtAusgewaehlt.getData().add((Object)new XYChart.Data((Object)((Number)data.getXValue()), (Object)((Number)data.getYValue())));
        });
        if (this.seriesSchaetzwert.getData().size() > 0) {
            copy.setSchaetzwert(((Number)((XYChart.Data)this.seriesSchaetzwert.getData().get(0)).getYValue()).doubleValue());
        }
        copy.xAxis.setLabel(this.xAxis.getLabel());
        copy.chart.setMinWidth(-1.0);
        copy.chart.setMaxHeight(-1.0);
        int SIZE = 10;
        copy.chart.getData().stream().flatMap(series -> series.getData().stream()).forEach(data -> {
            StackPane stackPane = (StackPane)data.getNode();
            stackPane.setPrefHeight(10.0);
            stackPane.setPrefWidth(10.0);
        });
        copy.seriesNaechsteNachbarn.getData().forEach(data -> data.getNode().toFront());
        copy.seriesSchaetzwert.getData().forEach(data -> data.getNode().toFront());
        return copy;
    }
}

