/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.knn.gui;

import java.io.PrintWriter;
import java.io.StringWriter;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;

public class KnnExceptionHandler {
    private static final boolean PRINT = true;
    private static volatile boolean DIALOG = false;
    private static volatile boolean STACKTRACE = false;

    public static void userFriendlyAlert(Throwable e, String contentText) {
        KnnExceptionHandler.handle(e);
        Alert alert = new Alert(Alert.AlertType.ERROR, contentText, new ButtonType[]{ButtonType.OK});
        alert.setHeaderText(null);
        alert.show();
    }

    public static void handle(Throwable e) {
        KnnExceptionHandler.handle(e, null);
    }

    public static void log(Throwable e) {
        System.err.println("Exception logged in KnnExceptionHandler.log:");
        e.printStackTrace();
    }

    public static void logReduced(Throwable e) {
        System.err.println("Exception logged in KnnExceptionHandler.logReduced:");
        System.err.println(String.valueOf(e.getClass().getName()) + ": " + e.getLocalizedMessage());
        KnnExceptionHandler.printFirstRowsOfStackTrace(e, 3);
    }

    private static void printFirstRowsOfStackTrace(Throwable e, int nrOfRows) {
        int i = 0;
        while (i < nrOfRows && i < e.getStackTrace().length) {
            System.err.println("\tat " + e.getStackTrace()[i]);
            ++i;
        }
        System.err.println();
    }

    public static void handle(Throwable e, String msgPrefix) {
        if (DIALOG && STACKTRACE) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String contentText = String.valueOf(msgPrefix != null ? msgPrefix : "") + sw.toString();
            Alert alert = new Alert(Alert.AlertType.ERROR, contentText, new ButtonType[]{ButtonType.OK});
            alert.setHeaderText(null);
            alert.show();
        } else if (DIALOG) {
            String contentText = String.valueOf(msgPrefix != null ? msgPrefix : "") + e;
            Alert alert = new Alert(Alert.AlertType.ERROR, contentText, new ButtonType[]{ButtonType.OK});
            alert.setHeaderText(null);
            alert.show();
        }
        System.err.println("Exception logged in KnnExceptionHandler.handle:");
        if (msgPrefix != null) {
            System.err.print(msgPrefix);
        }
        e.printStackTrace();
    }

    public static void setLogDialog(boolean flag) {
        DIALOG = flag;
    }

    public static void setLogStackTrace(boolean flag) {
        STACKTRACE = flag;
    }
}

