/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.knn;

import ch.wsl.fps.knn.gui.KnnExceptionHandler;
import ch.wsl.fps.knn.model.InvalidInputFormatException;
import ch.wsl.fps.knn.model.KnnInputData;
import ch.wsl.fps.knn.model.PersistentSettings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.mozilla.universalchardet.UniversalDetector;

public class ZipFileHelper {
    private static final String TEMP_ZIP_FILE = ".temp" + System.nanoTime() + ".knnx";
    private static final String SETTINGS_FILE = "settings.ini";

    public static KnnInputData loadFromCsv(String filePath) throws FileNotFoundException, IOException, InvalidInputFormatException {
        ZipFileHelper.storeToTempZip(filePath);
        char delimiter = ZipFileHelper.detectDelimiter();
        Reader in = ZipFileHelper.readFromZip(TEMP_ZIP_FILE, false).getReader();
        return KnnInputData.parseCsvFromReaderToKnnInputData(in, delimiter);
    }

    public static InputDataWithSettings loadFromKnnX(String knnFilePath) throws IOException, InvalidInputFormatException {
        ZipFileHelper.copyFile(knnFilePath, TEMP_ZIP_FILE);
        char delimiter = ZipFileHelper.detectDelimiter();
        ReaderWithSettings readerWithSettings = ZipFileHelper.readFromZip(TEMP_ZIP_FILE, true);
        KnnInputData inputData = KnnInputData.parseCsvFromReaderToKnnInputData(readerWithSettings.getReader(), delimiter);
        InputDataWithSettings result = new InputDataWithSettings();
        result.setInputData(inputData);
        result.setSettings(readerWithSettings.getSettings());
        return result;
    }

    private static ReaderWithSettings readFromZip(String zipFilePath, boolean readSettings) throws IOException {
        ReaderWithSettings readerWithSettings = new ReaderWithSettings();
        final ZipFile zipFile = new ZipFile(zipFilePath);
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry element = e.nextElement();
            if (element.getName().endsWith(".csv")) {
                InputStream is0 = zipFile.getInputStream(element);
                Charset charsetCsv = ZipFileHelper.guessCharset(is0);
                is0.close();
                InputStream is = zipFile.getInputStream(element);
                InputStreamReader reader = new InputStreamReader(is, charsetCsv){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        zipFile.close();
                    }
                };
                readerWithSettings.setReader(reader);
            }
            if (!readSettings || !element.getName().equals(SETTINGS_FILE)) continue;
            InputStream is = zipFile.getInputStream(element);
            readerWithSettings.setSettings(PersistentSettings.read(is));
            is.close();
        }
        return readerWithSettings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void storeToTempZip(String csvFilePath) throws FileNotFoundException, IOException {
        ZipFileHelper.deleteTempFile();
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            FileInputStream in = new FileInputStream(csvFilePath);
            try {
                try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(TEMP_ZIP_FILE));){
                    int count;
                    File originalCsv = new File(csvFilePath);
                    ZipEntry zipEntryOriginalCsv = new ZipEntry(originalCsv.getName());
                    zipEntryOriginalCsv.setLastModifiedTime(FileTime.fromMillis(originalCsv.lastModified()));
                    out.putNextEntry(zipEntryOriginalCsv);
                    byte[] b = new byte[1024];
                    while ((count = in.read(b)) > 0) {
                        out.write(b, 0, count);
                    }
                    ZipFileHelper.hideTempZipFileOnWindows();
                }
                if (in == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void hideTempZipFileOnWindows() {
        File tempZipFile = new File(TEMP_ZIP_FILE);
        Path path = tempZipFile.toPath();
        try {
            Files.setAttribute(path, "dos:hidden", Boolean.TRUE, LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException e) {
            KnnExceptionHandler.handle(e);
        }
    }

    public static void deleteTempFile() {
        File tempZipFile = new File(TEMP_ZIP_FILE);
        tempZipFile.delete();
    }

    public static void save(String knnXfilePath, PersistentSettings settings) throws IOException {
        ZipFileHelper.copyFile(TEMP_ZIP_FILE, knnXfilePath);
        ZipFileHelper.saveSettingsFileToDestKnnxFile(knnXfilePath, settings);
    }

    private static void copyFile(String sourceFileString, String destFileString) throws IOException {
        File sourceFile = new File(sourceFileString);
        if (!sourceFile.isFile()) {
            throw new IOException("Datei " + sourceFileString + " existiert nicht.");
        }
        Path sourcePath = sourceFile.toPath();
        Path pathDest = new File(destFileString).toPath();
        Files.copy(sourcePath, pathDest, StandardCopyOption.REPLACE_EXISTING);
    }

    private static void saveSettingsFileToDestKnnxFile(String knnXfilePath, PersistentSettings settings) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        Path path = Paths.get(knnXfilePath, new String[0]);
        URI uri = URI.create("jar:" + path.toUri());
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileSystem fileSystem = FileSystems.newFileSystem(uri, env);){
            Path settingsPath = fileSystem.getPath(SETTINGS_FILE, new String[0]);
            Throwable throwable2 = null;
            Object var10_13 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(settingsPath, StandardCharsets.UTF_8, StandardOpenOption.CREATE);){
                settings.write(writer);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static char detectDelimiter() throws IOException, InvalidInputFormatException {
        var0 = null;
        var1_2 = null;
        try {
            block20: {
                block19: {
                    in = ZipFileHelper.readFromZip(ZipFileHelper.TEMP_ZIP_FILE, false).getReader();
                    try {
                        block18: {
                            bufferedReader = new BufferedReader(in);
                            try {
                                firstLine = bufferedReader.readLine();
                                if (firstLine == null) {
                                    throw new InvalidInputFormatException("CSV-Datei enth\u00e4lt keine Daten.");
                                }
                                nrOfSemicolons = firstLine.split(";").length - 1;
                                nrOfCommas = firstLine.split(",").length - 1;
                                nrOfTabs = firstLine.split("\t").length - 1;
                                if (nrOfSemicolons > 0) {
                                    System.out.println("Delimiter = ';'");
                                    if (bufferedReader == null) break block18;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Throwable var0_1) {
                                if (bufferedReader == null) throw var0_1;
                                bufferedReader.close();
                                throw var0_1;
                            }
                            bufferedReader.close();
                        }
                        if (in == null) return ';';
                    }
                    catch (Throwable var1_3) {
                        if (var0 == null) {
                            var0 = var1_3;
                        } else if (var0 != var1_3) {
                            var0.addSuppressed(var1_3);
                        }
                        if (in == null) throw var0;
                        in.close();
                        throw var0;
                    }
                    in.close();
                    return ';';
lbl-1000:
                    // 1 sources

                    {
                        if (nrOfCommas <= 0) ** GOTO lbl-1000
                        System.out.println("Delimiter = ','");
                        if (bufferedReader == null) break block19;
                    }
                    bufferedReader.close();
                }
                if (in == null) return ',';
                in.close();
                return ',';
lbl-1000:
                // 1 sources

                {
                    if (nrOfTabs <= 0) ** GOTO lbl-1000
                    System.out.println("Delimiter = '\\t'");
                    if (bufferedReader == null) break block20;
                }
                bufferedReader.close();
            }
            if (in == null) return '\t';
            in.close();
            return '\t';
lbl-1000:
            // 1 sources

            {
                throw new InvalidInputFormatException("Entweder enth\u00e4lt die CSV-Datei nur eine Spalte, oder die Spalten sind mit einem unbekannten Trennzeichen getrennt. Erlaubte Trennzeichen sind Semikolon, Komma, Tab. Das Trennzeichen muss f\u00fcr die gesamte CSV-Datei einheitlich sein.");
            }
        }
        catch (Throwable var1_4) {
            if (var0 == null) {
                var0 = var1_4;
                throw var0;
            }
            if (var0 == var1_4) throw var0;
            var0.addSuppressed(var1_4);
            throw var0;
        }
    }

    private static Charset guessCharset(InputStream is) throws IOException {
        int nread;
        UniversalDetector detector = new UniversalDetector();
        byte[] buf = new byte[4096];
        while ((nread = is.read(buf)) > 0 && !detector.isDone()) {
            detector.handleData(buf, 0, nread);
        }
        detector.dataEnd();
        String encoding = detector.getDetectedCharset();
        if (encoding != null) {
            System.out.println("Detected encoding = " + encoding);
        } else {
            System.out.println("No encoding detected.");
            encoding = "UTF-8";
        }
        detector.reset();
        return Charset.forName(encoding);
    }

    public static class InputDataWithSettings {
        private KnnInputData inputData;
        private PersistentSettings settings;

        public KnnInputData getInputData() {
            return this.inputData;
        }

        private void setInputData(KnnInputData inputData) {
            this.inputData = inputData;
        }

        public PersistentSettings getSettings() {
            return this.settings;
        }

        private void setSettings(PersistentSettings settings) {
            this.settings = settings;
        }
    }

    private static class ReaderWithSettings {
        private Reader reader;
        private PersistentSettings settings;

        private ReaderWithSettings() {
        }

        public Reader getReader() {
            return this.reader;
        }

        private void setReader(Reader reader) {
            this.reader = reader;
        }

        public PersistentSettings getSettings() {
            return this.settings;
        }

        private void setSettings(PersistentSettings settings) {
            this.settings = settings;
        }
    }
}

