/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.util;

import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoExceptionHandler;
import ch.wsl.fps.hepromo.model.modelle.AbstractModel;
import ch.wsl.fps.hepromo.util.ExportMethodResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CsvCreator {
    private static final String CHARSET = "UTF-8";

    public ExportMethodResult create(AbstractModel model, File csvFile, DecimalFormat decimalFormat) {
        String finalXMLString = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<kalkulation>\n" + model.getModelAsXmlString(decimalFormat) + "</kalkulation>";
        ExportMethodResult exportMethodResult = this.generateCsv(finalXMLString, csvFile);
        return exportMethodResult;
    }

    private ExportMethodResult generateCsv(String xmlString, File csvFile) {
        try {
            Element rootElement = CsvCreator.getRootElement(xmlString);
            StringBuilder sbCsv = new StringBuilder();
            String ergebnisSuffix = CsvCreator.getErgebnisSuffix(rootElement);
            sbCsv.append("Modellname;Arbeitsort;Erstelldatum;Arbeitsobjekt;;Arbeitssystem;;Faktoren;;Ergebnis" + ergebnisSuffix);
            sbCsv.append("\n");
            sbCsv.append(rootElement.getElementsByTagName("modellname").item(0).getTextContent());
            sbCsv.append(";");
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            Element elementArbeitsort = (Element)xpath.evaluate("info/arbeitsort", rootElement, XPathConstants.NODE);
            if (elementArbeitsort != null) {
                sbCsv.append(elementArbeitsort.getTextContent());
            }
            sbCsv.append(";");
            sbCsv.append(rootElement.getElementsByTagName("creationdate").item(0).getTextContent());
            sbCsv.append(";");
            Element elementArbeitsobjekt = (Element)xpath.evaluate("arbeitsobjekt", rootElement, XPathConstants.NODE);
            Element elementArbeitssystem = (Element)xpath.evaluate("arbeitssystem", rootElement, XPathConstants.NODE);
            Element elementFaktoren = (Element)xpath.evaluate("faktoren", rootElement, XPathConstants.NODE);
            Element elementErgebnis = (Element)xpath.evaluate("ergebnis", rootElement, XPathConstants.NODE);
            List<String> entriesArbeitsobjekt = CsvCreator.getInputEntries(elementArbeitsobjekt);
            List<String> entriesArbeitssystem = CsvCreator.getInputEntries(elementArbeitssystem);
            List<String> entriesFaktoren = CsvCreator.getInputEntries(elementFaktoren);
            List<String> entriesErgebnis = CsvCreator.getOutputEntries(elementErgebnis);
            List<String> concatedList = CsvCreator.concatLists(";;;", entriesArbeitsobjekt, entriesArbeitssystem, entriesFaktoren, entriesErgebnis);
            for (String str : concatedList) {
                sbCsv.append(str);
                sbCsv.append("\n");
            }
            ExportMethodResult exportMethodResult = CsvCreator.saveCsv(sbCsv.toString(), csvFile);
            if (exportMethodResult.success) {
                System.out.println("CSV erfolgreich erstellt");
            }
            return exportMethodResult;
        }
        catch (Exception e) {
            HeProMoExceptionHandler.handle(e);
            return new ExportMethodResult(false, false);
        }
    }

    private static String getErgebnisSuffix(Element rootElement) {
        NodeList nodeListErgebnisSuffix = rootElement.getElementsByTagName("ergebnisSuffix");
        if (nodeListErgebnisSuffix.getLength() == 0) {
            return "";
        }
        return nodeListErgebnisSuffix.item(0).getTextContent();
    }

    private static Element getRootElement(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xmlString));
        Document doc = builder.parse(is);
        Element rootElement = doc.getDocumentElement();
        rootElement.normalize();
        return rootElement;
    }

    private static List<String> getInputEntries(Element parent) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < parent.getChildNodes().getLength()) {
            if (parent.getChildNodes().item(i).getNodeType() == 1) {
                Element entry = (Element)parent.getChildNodes().item(i);
                String label = entry.getElementsByTagName("label").item(0).getTextContent();
                String value = entry.getElementsByTagName("value").item(0).getTextContent();
                result.add(String.valueOf(label) + ";" + value);
            }
            ++i;
        }
        return result;
    }

    private static List<String> getOutputEntries(Element parent) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < parent.getChildNodes().getLength()) {
            if (parent.getChildNodes().item(i).getNodeType() == 1) {
                Element ergebniszeile = (Element)parent.getChildNodes().item(i);
                String zeile = "";
                int spalte = 0;
                while (spalte < ergebniszeile.getChildNodes().getLength()) {
                    Node item = ergebniszeile.getChildNodes().item(spalte);
                    if (item.getNodeType() == 1) {
                        zeile = String.valueOf(zeile) + item.getTextContent() + ";";
                    }
                    ++spalte;
                }
                result.add(zeile);
            }
            ++i;
        }
        return result;
    }

    private static List<String> concatLists(String linePrefix, List<?> ... lists) {
        ArrayList<String> result = new ArrayList<String>();
        int row = 0;
        while (row < CsvCreator.getMaxSize(lists)) {
            String line = row == 0 ? "" : linePrefix;
            List<?>[] listArray = lists;
            int n = lists.length;
            int n2 = 0;
            while (n2 < n) {
                List<?> list = listArray[n2];
                line = row < list.size() ? String.valueOf(line) + list.get(row) + ";" : String.valueOf(line) + ";;";
                ++n2;
            }
            result.add(line);
            ++row;
        }
        return result;
    }

    private static int getMaxSize(List<?> ... lists) {
        int max = 0;
        List<?>[] listArray = lists;
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            List<?> list = listArray[n2];
            if (list.size() > max) {
                max = list.size();
            }
            ++n2;
        }
        return max;
    }

    private static ExportMethodResult saveCsv(String content, File file) {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (PrintWriter printWriter = new PrintWriter(file);){
                printWriter.write(content);
                return new ExportMethodResult(true, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            String msg = String.valueOf(GuiStrings.getString("HeProMoWindow.FehlerBeimErstellenDerDatei")) + "\n" + e.getLocalizedMessage();
            JOptionPane.showMessageDialog(null, msg, GuiStrings.getString("HeProMoWindow.DialogTitleFehler"), 0);
            return new ExportMethodResult(false, true);
        }
        catch (Exception e) {
            HeProMoExceptionHandler.handle(e);
            return new ExportMethodResult(false, false);
        }
    }
}

