/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.modelle;

import ch.wsl.fps.hepromo.model.Ergebnis;
import ch.wsl.fps.hepromo.model.Faktoren;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.ModelStrings;
import ch.wsl.fps.hepromo.model.aobj.Arbeitsobjekt;
import ch.wsl.fps.hepromo.model.asys.Arbeitssystem;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculator;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public abstract class AbstractModel
implements HeProMoInputData {
    protected String arbeitsort;
    protected Arbeitsobjekt arbeitsobjekt;
    protected Arbeitssystem arbeitssystem;
    protected Faktoren faktoren;
    protected AbstractCalculator calculator;
    protected static final String defaultWaehrungskuerzel = "Fr.";
    public static final double KOSTENSATZ_MOTORSAEGE_CHF_PRO_PMH15 = 18.0;

    protected final void setInputData(HeProMoInputData inputData) {
        this.arbeitsobjekt = inputData.getArbeitsobjekt();
        this.arbeitssystem = inputData.getArbeitssystem();
        this.faktoren = inputData.getFaktoren();
    }

    public Ergebnis getErgebnis() {
        return this.calculator.calculate();
    }

    @Override
    public Arbeitsobjekt getArbeitsobjekt() {
        return this.arbeitsobjekt;
    }

    @Override
    public Arbeitssystem getArbeitssystem() {
        return this.arbeitssystem;
    }

    @Override
    public Faktoren getFaktoren() {
        return this.faktoren;
    }

    public AbstractCalculator getCalculator() {
        return this.calculator;
    }

    @Override
    public String getArbeitsort() {
        return this.arbeitsort;
    }

    public void setArbeitsort(String arbeitsort) {
        this.arbeitsort = arbeitsort;
    }

    public String getModelAsXmlString(DecimalFormat decimalFormat) {
        String xmlModelName = "\t<modellname>" + this.getModelName() + "</modellname>\n";
        String xmlInfo = this.getMetaInformationAsXmlString();
        String xmlPdfTitles = this.getPdfTitlesAsXmlString();
        String waehrung = this.getFaktoren().getWaehrungskuerzel();
        String xmlFaktoren = this.getFaktoren().getLabelValuePairList(decimalFormat).getAsXmlString("faktoren");
        String xmlAo = this.getArbeitsobjekt().getLabelValuePairList(decimalFormat).getAsXmlString("arbeitsobjekt");
        String xmlAs = this.getArbeitssystem().getLabelValuePairList(decimalFormat, waehrung).getAsXmlString("arbeitssystem");
        String xmlErgebnis = this.getErgebnis().getErgebnisAsXmlString(decimalFormat, waehrung);
        String result = String.valueOf(xmlModelName) + xmlInfo + xmlPdfTitles + xmlFaktoren + xmlAo + xmlAs + xmlErgebnis;
        return result;
    }

    private String getMetaInformationAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<info>\n");
        if (this.arbeitsort.length() > 0) {
            sb.append("\t<arbeitsort>");
            sb.append(this.arbeitsort);
            sb.append("</arbeitsort>\n");
        }
        sb.append("\t<creationdate>");
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        sb.append(sdf.format(new GregorianCalendar().getTime()));
        sb.append("</creationdate>\n");
        sb.append("</info>\n");
        return sb.toString();
    }

    private String getPdfTitlesAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<pdftitles>\n");
        sb.append("\t<haupttitel>");
        sb.append((Object)ModelStrings.PdfLabels.AbstractModel_PdfTitles_Haupttitel);
        sb.append("</haupttitel>\n");
        sb.append("\t<arbeitsort>");
        sb.append((Object)ModelStrings.PdfLabels.AbstractModel_PdfTitles_ArbeitsortHolzschlag);
        sb.append("</arbeitsort>\n");
        sb.append("\t<arbeitsobjekt>");
        sb.append((Object)ModelStrings.PdfLabels.AbstractModel_PdfTitles_Arbeitsobjekt);
        sb.append("</arbeitsobjekt>\n");
        sb.append("\t<arbeitssystem>");
        sb.append((Object)ModelStrings.PdfLabels.AbstractModel_PdfTitles_Arbeitssystem);
        sb.append("</arbeitssystem>\n");
        sb.append("\t<faktoren>");
        sb.append((Object)ModelStrings.PdfLabels.AbstractModel_PdfTitles_Faktoren);
        sb.append("</faktoren>\n");
        sb.append("\t<ergebnis>");
        sb.append((Object)ModelStrings.PdfLabels.AbstractModel_PdfTitles_Ergebnis);
        sb.append("</ergebnis>\n");
        sb.append("\t<ergebnisSuffix>");
        sb.append(this.getErgebnisTitleSuffix());
        sb.append("</ergebnisSuffix>\n");
        sb.append("</pdftitles>\n");
        return sb.toString();
    }

    protected abstract String getModelName();

    protected String getErgebnisTitleSuffix() {
        return "";
    }
}

