/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektSeilkranPlanung;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel;

public class CalculatorSeilkranPlanung
extends AbstractCalculatorSingleModel {
    public CalculatorSeilkranPlanung(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    public ArbeitsobjektSeilkranPlanung getArbeitsobjekt() {
        return (ArbeitsobjektSeilkranPlanung)super.getArbeitsobjekt();
    }

    @Override
    protected double calcPsh0_hProM3() {
        double psh15 = this.getPsh15_Projektierung();
        double psh0 = psh15 / this.f_0bis15;
        return psh0 /= this.getRelevanteHolzmenge();
    }

    @Override
    protected double getAnzahlPersonalVollzeitAequivalente() {
        if (this.getArbeitsobjekt().isLinieAbsteckenOhneProjekt()) {
            return 2.0;
        }
        double psh15_Abstecken = this.getPsh15_Abstecken();
        double psh15_ProfilAufnehmen = this.getPsh15_ProfilAufnehmen();
        double psh15_ProjektAusarbeiten = this.getPsh15_ProjektAusarbeiten();
        double psh15_Gesamt = psh15_Abstecken + psh15_ProfilAufnehmen + psh15_ProjektAusarbeiten;
        double anzPers_Mischrechnung = (psh15_Abstecken + psh15_ProfilAufnehmen) / psh15_Gesamt * 2.0 + psh15_ProjektAusarbeiten / psh15_Gesamt * 1.0;
        return anzPers_Mischrechnung;
    }

    private double getPsh15_Projektierung() {
        double psh15 = this.getPsh15_Abstecken();
        if (!this.getArbeitsobjekt().isLinieAbsteckenOhneProjekt()) {
            psh15 += this.getPsh15_ProfilAufnehmen() + this.getPsh15_ProjektAusarbeiten();
        }
        return psh15;
    }

    private double getPsh15_Abstecken() {
        double l = this.getArbeitsobjekt().getLinienlaenge_m();
        double psh15 = 0.008333333333333333 * (50.0 + 0.6 * l);
        return psh15;
    }

    private double getPsh15_ProfilAufnehmen() {
        double l = this.getArbeitsobjekt().getLinienlaenge_m();
        double psh15 = 0.008333333333333333 * (0.4 * l);
        return psh15;
    }

    private double getPsh15_ProjektAusarbeiten() {
        double l = this.getArbeitsobjekt().getLinienlaenge_m();
        double psh15 = 0.016666666666666666 * (60.0 + 0.2 * l);
        return psh15;
    }

    @Override
    protected double getLaufzeitAnteilMaschine() {
        return 0.0;
    }
}

