/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektSchlepper;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemSchlepper;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel;

public class CalculatorSchlepper
extends AbstractCalculatorSingleModel {
    double anzahlSchlepper = 1.0;

    public CalculatorSchlepper(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    public ArbeitsobjektSchlepper getArbeitsobjekt() {
        return (ArbeitsobjektSchlepper)super.getArbeitsobjekt();
    }

    @Override
    public ArbeitssystemSchlepper getArbeitssystem() {
        return (ArbeitssystemSchlepper)super.getArbeitssystem();
    }

    @Override
    protected double calcPsh0_hProM3() {
        if (!this.getArbeitssystem().isRueckegehilfe() && this.getArbeitssystem().getRueckgehilfeEinsatzanteil().getRueckgehilfeEinsatzZeitFaktor() > 0.0) {
            throw new RuntimeException("Ung\u00fcltiger R\u00fcckegehilfe-Einsatzanteil");
        }
        double a1 = -1.06866;
        double a2 = 19.04929;
        double v0 = 0.704;
        double p = 0.85735;
        double vMit = this.getArbeitsobjekt().getMittlererStueckInhalt();
        double grundproduktivitaet = a2 + (a1 - a2) / (1.0 + Math.pow(vMit / v0, p));
        double produktivitaetsZuschlag = this.getProductivityAdditionsSum();
        double pmh15_oR = 1.0 / ((1.0 + produktivitaetsZuschlag) * grundproduktivitaet);
        double psh15_oR = pmh15_oR / (this.anzahlSchlepper * this.getLaufzeitAnteilMaschine());
        double psh0_oR = psh15_oR / this.f_0bis15;
        return psh0_oR;
    }

    @Override
    protected double getAnzahlPersonalVollzeitAequivalente() {
        if (this.getArbeitssystem().isRueckegehilfe()) {
            return 1.0 + this.getArbeitssystem().getRueckgehilfeEinsatzanteil().getRueckgehilfeEinsatzZeitFaktor();
        }
        return 1.0;
    }

    private double getProductivityAdditionsSum() {
        double m0 = this.getM0();
        double m1 = this.getM1();
        double m3 = this.getM3();
        double m4 = this.getM4();
        double m6 = this.getM6();
        double m7 = this.getM7();
        double m8 = this.getM8();
        double m9 = this.getM9();
        double m10 = this.getM10();
        double sum = m0 + m1 + m3 + m4 + m6 + m7 + m8 + m9 + m10;
        return sum;
    }

    private double getM0() {
        switch (this.getArbeitsobjekt().getRueckeart()) {
            case NurVorruecken: {
                return 0.7;
            }
            case NurFertigruecken: {
                return 0.05;
            }
            case GesamtesRuecken: {
                return 0.0;
            }
        }
        throw new RuntimeException();
    }

    private double getM1() {
        switch (this.getArbeitssystem().getSchlepperTyp()) {
            case Forstspezialschlepper: {
                if (this.getArbeitsobjekt().getMittlererStueckInhalt() > 0.5) {
                    return 0.1;
                }
                return 0.0;
            }
            case AndereSchleppertypen: {
                return 0.0;
            }
        }
        throw new RuntimeException();
    }

    private double getM3() {
        if (this.getArbeitsobjekt().getRueckeart() == ArbeitsobjektSchlepper.Rueckeart.NurVorruecken) {
            return 0.0;
        }
        switch (this.getArbeitsobjekt().getFahrentfernung()) {
            case Bis200m: {
                return 0.0;
            }
            case Ab200bis400m: {
                return -0.1;
            }
            case Ueber400m: {
                return -0.2;
            }
        }
        throw new RuntimeException();
    }

    private double getM4() {
        if (this.getArbeitsobjekt().getRueckeart() == ArbeitsobjektSchlepper.Rueckeart.NurFertigruecken) {
            return 0.0;
        }
        switch (this.getArbeitsobjekt().getZuzugentfernung()) {
            case Bis20m: {
                return 0.0;
            }
            case Ab20bis30m: 
            case Ab30bis40m: {
                return -0.1;
            }
            case Ueber40m: {
                return -0.15;
            }
        }
        throw new RuntimeException();
    }

    private double getM6() {
        switch (this.getArbeitssystem().getRueckgehilfeEinsatzanteil()) {
            case Unbekannt: 
            case Prz_0: 
            case Prz_1bis25: 
            case Prz_26bis50: {
                return 0.0;
            }
            case Prz_51bis75: 
            case Prz_76bis100: {
                return 0.15;
            }
        }
        throw new RuntimeException();
    }

    private double getM7() {
        switch (this.getArbeitsobjekt().getRueckenImSaft()) {
            case Ja: {
                return -0.1;
            }
            case Nein: {
                return 0.0;
            }
        }
        throw new RuntimeException();
    }

    private double getM8() {
        switch (this.getArbeitsobjekt().getSchlagordnung()) {
            case MehrAlsEinViertelNichtEingehalten: {
                return -0.1;
            }
            case WenigerAlsEinViertelNichtEingehalten: {
                return 0.0;
            }
        }
        throw new RuntimeException();
    }

    private double getM9() {
        switch (this.getArbeitsobjekt().getAnzahlSortimente()) {
            case WenigerAlsVier: {
                return 0.0;
            }
            case VierBisSechs: {
                return -0.05;
            }
            case MehrAlsSechs: {
                return -0.1;
            }
        }
        throw new RuntimeException();
    }

    private double getM10() {
        switch (this.getArbeitsobjekt().getRueckeBedingungen()) {
            case SehrEinfach: {
                return 0.1;
            }
            case Einfach: {
                return 0.05;
            }
            case Mittel: {
                return 0.0;
            }
            case Schwierig: {
                return -0.05;
            }
            case SehrSchwierig: {
                return -0.1;
            }
        }
        throw new RuntimeException();
    }

    @Override
    protected double getLaufzeitAnteilMaschine() {
        return 1.0;
    }
}

