/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektMotormanuell;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektSchichtholzAufarbeiten;
import ch.wsl.fps.hepromo.model.calc.CalculatorIhUndSchichtholzAufarbeiten;

public class CalculatorSchichtholzAufarbeiten
extends CalculatorIhUndSchichtholzAufarbeiten {
    public CalculatorSchichtholzAufarbeiten(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    protected ArbeitsobjektSchichtholzAufarbeiten getArbeitsobjekt() {
        return (ArbeitsobjektSchichtholzAufarbeiten)super.getArbeitsobjekt();
    }

    @Override
    protected double getA3() {
        double faktor = -1.0;
        switch (this.getArbeitsobjekt().getBaumartenGruppe()) {
            case Fichte: 
            case Tanne: {
                faktor = 34.3;
                break;
            }
            case Foehre_Laerche: {
                faktor = 27.4;
                break;
            }
            case Laubholz: {
                faktor = 21.4;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        double a3 = faktor * (double)this.getArbeitsobjekt().getAnteilSpalten_Prz() / 100.0;
        return a3;
    }

    @Override
    protected double getM3() {
        switch (this.getArbeitsobjekt().getStuecklaengen()) {
            case Laenge1m: {
                return 1.0;
            }
            case Laenge2m: {
                return 0.64;
            }
        }
        throw new RuntimeException();
    }

    @Override
    protected double[] getKoeffizienten(ArbeitsobjektMotormanuell.Baumartgruppe baGruppe) {
        switch (baGruppe) {
            case Fichte: 
            case Tanne: 
            case Foehre_Laerche: {
                return new double[]{4.0, 20.0, -0.0166, -18.461};
            }
            case Laubholz: {
                return new double[]{1.4504, 0.1998, -0.5495, 2.1618};
            }
        }
        throw new RuntimeException();
    }

    @Override
    protected double getRelevanteHolzmenge() {
        return this.getArbeitsobjekt().getMengeSchichtholz_m3iR();
    }
}

