/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektRadharvester2014;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemRadharvester2014;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel2014;

public class CalculatorRadharvester2014
extends AbstractCalculatorSingleModel2014 {
    public CalculatorRadharvester2014(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    protected ArbeitsobjektRadharvester2014 getArbeitsobjekt() {
        return (ArbeitsobjektRadharvester2014)super.getArbeitsobjekt();
    }

    @Override
    protected double calcPsh0_hProM3() {
        double m3ProPsh15 = this.calcProduktivitaet_m3oRProPsh15();
        if (this.rindenAbzugBeruecksichtigen) {
            double rindenabzug_fix = 0.9;
            double rindenabzug_variabel = this.getArbeitsobjekt().getRindenAbzugFaktor();
            m3ProPsh15 *= rindenabzug_variabel / rindenabzug_fix;
        }
        double psh15ProM3 = 1.0 / m3ProPsh15;
        double psh0ProM3 = psh15ProM3 / this.f_0bis15;
        return psh0ProM3;
    }

    private double calcProduktivitaet_m3oRProPsh15() {
        double a = -34.4624;
        double b = this.getArbeitssystem().getMaschinentyp() == ArbeitssystemRadharvester2014.Maschinentyp.Mittel ? 0.0 : -24.9268;
        double c = 14.7029;
        double d = this.getArbeitssystem().getMaschinentyp() == ArbeitssystemRadharvester2014.Maschinentyp.Mittel ? 0.0 : 9.5333;
        double bhd = this.getArbeitsobjekt().getBhd_cm();
        if (this.getArbeitssystem().getMaschinentyp() == ArbeitssystemRadharvester2014.Maschinentyp.Mittel && bhd < 12.0) {
            throw new RuntimeException("Beim Maschinentyp 'Mittel' darf der BHD nicht kleiner als 12cm sein!");
        }
        if (this.getArbeitssystem().getMaschinentyp() == ArbeitssystemRadharvester2014.Maschinentyp.Gross && bhd < 15.0) {
            throw new RuntimeException("Beim Maschinentyp 'Gross' darf der BHD nicht kleiner als 15cm sein!");
        }
        if (bhd > 75.0) {
            throw new RuntimeException("BHD darf nicht gr\u00f6sser als 75cm sein!");
        }
        if (this.getArbeitssystem().getMaschinentyp() == ArbeitssystemRadharvester2014.Maschinentyp.Mittel && bhd > 50.0) {
            bhd = 50.0;
        }
        if (this.getArbeitssystem().getMaschinentyp() == ArbeitssystemRadharvester2014.Maschinentyp.Gross && bhd > 60.0) {
            bhd = 60.0;
        }
        double tap = a + b + c * Math.log(bhd) + d * Math.log(bhd);
        return tap *= this.getArbeitsobjekt().getGesamtfaktorAllerZuschlaege();
    }

    @Override
    protected ArbeitssystemRadharvester2014 getArbeitssystem() {
        return (ArbeitssystemRadharvester2014)super.getArbeitssystem();
    }
}

