/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.Ergebnis;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektRadharvester;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemRadharvester;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel;

public class CalculatorRadharvester
extends AbstractCalculatorSingleModel {
    public CalculatorRadharvester(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    public Ergebnis calculate() {
        Ergebnis ergebnis = super.calculate();
        ergebnis.hideDauerDerArbeit();
        return ergebnis;
    }

    @Override
    protected ArbeitsobjektRadharvester getArbeitsobjekt() {
        return (ArbeitsobjektRadharvester)super.getArbeitsobjekt();
    }

    @Override
    protected ArbeitssystemRadharvester getArbeitssystem() {
        return (ArbeitssystemRadharvester)super.getArbeitssystem();
    }

    @Override
    protected double calcPsh0_hProM3() {
        double ba;
        if (this.getArbeitssystem().getMaschinenKategorie() != this.getArbeitssystem().getMaschinenTyp().getMaschinenKategorie()) {
            throw new RuntimeException("Maschinenkategorie / Maschinentyp nicht kompatibel");
        }
        double[] hk1und2 = this.getHK1und2();
        double hk1 = hk1und2[0];
        double hk2 = hk1und2[1];
        double pv = this.getArbeitsobjekt().getVolumenMittelstamm_m3();
        switch (this.getArbeitsobjekt().getBaumartGruppe()) {
            case Fichte: {
                ba = 0.0;
                break;
            }
            case Foehre_Laerche: {
                ba = 1.0;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        double prod15 = -3.87 + 11.43 * Math.pow(pv, 0.25) - 3.5 * Math.pow(hk1, 0.4) + 10.06 * Math.pow(pv, 0.25) * Math.pow(hk1, 0.4) + 0.52 * hk2 + 1.01 * ba;
        double pmh15 = 1.0 / prod15;
        switch (this.getArbeitssystem().getMaschinenKategorie()) {
            case Mittel: {
                this.f_0bis15 = 1.1;
                break;
            }
            case Gross: {
                this.f_0bis15 = 1.3;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        double psh0 = pmh15 / this.f_0bis15;
        return psh0;
    }

    @Override
    protected double getLaufzeitAnteilMaschine() {
        return 1.0;
    }

    private double[] getHK1und2() {
        double[] techParam = this.getArbeitssystem().getMaschinenTyp().getTechnologieFaktoren();
        double a = (techParam[0] - 111.75) / 29.07;
        double b = (techParam[1] - 9.43) / 0.98;
        double c = (techParam[2] - 126.06) / 40.31;
        double d = (techParam[3] - 30.69) / 6.63;
        double e = (techParam[4] - 51.06) / 8.74;
        double f = (techParam[5] - 20.69) / 2.91;
        double hk1 = 0.44 * a + 0.34 * b + 0.45 * c + 0.39 * d + 0.41 * e + 0.39 * f + 4.1;
        double hk2 = 0.27 * a - 0.65 * b + 0.02 * c - 0.49 * d + 0.34 * e + 0.38 * f;
        return new double[]{hk1, hk2};
    }
}

