/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.Ergebnis;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.ModelStrings;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektMotormanuellGesamt2014;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemMotormanuell2014;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel2014;

public class CalculatorMotormanuellGesamt2014
extends AbstractCalculatorSingleModel2014 {
    public CalculatorMotormanuellGesamt2014(HeProMoInputData inputData) {
        super(inputData);
        this.f_indir = 1.4;
    }

    @Override
    public Ergebnis calculate() {
        Ergebnis ergebnis = super.calculate();
        if (ergebnis.getAnzahl_m3() > 0.0) {
            double prod_wpph = ergebnis.getProduktivitaet_fmORproWPPH();
            double prod_wpsh = prod_wpph * this.getAnzahlPersonalVollzeitAequivalente();
            if (this.rindenAbzugBeruecksichtigen) {
                this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.M3_IR_PRO_WPSH, prod_wpsh / this.getArbeitsobjekt().getRindenAbzugFaktor());
            }
            this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.M3_OR_PRO_WPSH, prod_wpsh);
        }
        ergebnis.setLabelPersonal1(ModelStrings.PdfLabels.ModelMotormanuellGesamt2014_LabelPersonal.toString());
        return ergebnis;
    }

    @Override
    protected Ergebnis.ProdEinheit getProdEinheit1() {
        return Ergebnis.ProdEinheit.M3_IR_PRO_WPSH;
    }

    @Override
    protected Ergebnis.ProdEinheit getProdEinheit2() {
        return Ergebnis.ProdEinheit.M3_OR_PRO_WPSH;
    }

    @Override
    protected ArbeitsobjektMotormanuellGesamt2014 getArbeitsobjekt() {
        return (ArbeitsobjektMotormanuellGesamt2014)super.getArbeitsobjekt();
    }

    @Override
    protected ArbeitssystemMotormanuell2014 getArbeitssystem() {
        return (ArbeitssystemMotormanuell2014)super.getArbeitssystem();
    }

    @Override
    protected double calcPsh0_hProM3() {
        double f_wegzeitenUndPausen_fix = 1.125;
        double m3ProWPSH = this.calcM3oRProWPSH();
        if (this.rindenAbzugBeruecksichtigen) {
            double rindenabzug_fix = 0.9;
            double rindenabzug_variabel = this.getArbeitsobjekt().getRindenAbzugFaktor();
            m3ProWPSH *= rindenabzug_variabel / rindenabzug_fix;
        }
        double WPSHproM3 = 1.0 / m3ProWPSH;
        double WSHproM3 = WPSHproM3 / (f_wegzeitenUndPausen_fix * this.f_stoer);
        double PSH15proM3 = WSHproM3 / this.f_indir;
        double PSH0proM3 = PSH15proM3 / this.f_0bis15;
        return PSH0proM3;
    }

    private double calcM3oRProWPSH() {
        int anteilKiefern_Prz;
        int anteilLaubholz_Prz;
        double a = -8.8441;
        double b = this.getArbeitsobjekt().getRegion() == ArbeitsobjektMotormanuellGesamt2014.Region.Huegelland ? 1.5564 : 0.0;
        double c = 2.7332;
        double d = 2.5214;
        double e = -1.3273;
        double f = this.getArbeitsobjekt().getRegion() == ArbeitsobjektMotormanuellGesamt2014.Region.Huegelland ? -0.1601 : 0.0;
        double g = -0.3171;
        double h = 0.4712;
        double bhd_original = this.getArbeitsobjekt().getBhd_cm();
        double bhd = bhd_original;
        if (bhd < 15.0) {
            throw new RuntimeException("BHD muss mindestens 15cm sein!");
        }
        if (bhd > 100.0) {
            throw new RuntimeException("BHD muss kleiner als 100cm sein!");
        }
        if (this.getArbeitsobjekt().getRegion() == ArbeitsobjektMotormanuellGesamt2014.Region.Huegelland) {
            bhd = Math.min(bhd, 90.0);
        }
        if (this.getArbeitsobjekt().getRegion() == ArbeitsobjektMotormanuellGesamt2014.Region.Gebirge) {
            bhd = Math.min(bhd, 75.0);
        }
        if (bhd < 35.0) {
            bhd = 35.0;
        }
        if ((anteilLaubholz_Prz = this.getArbeitsobjekt().getAnteilLaubholz_Prz()) + (anteilKiefern_Prz = this.getArbeitsobjekt().getAnteilKiefer_Prz()) > 100) {
            throw new RuntimeException("Kieferanteil und Laubholzanteil d\u00fcrfen zusammen nicht mehr als 100% ergeben!");
        }
        double anteilLaubholz = (double)anteilLaubholz_Prz / 100.0;
        double anteilKiefern = (double)anteilKiefern_Prz / 100.0;
        double tap = a + b + c * Math.log(bhd) + d * anteilLaubholz + e * anteilKiefern + f * Math.log(bhd) + g * Math.log(bhd) * anteilLaubholz + h * Math.log(bhd) * anteilKiefern;
        tap *= this.getAnzahlPersonalVollzeitAequivalente();
        if (bhd_original < 35.0) {
            double kBaumart = this.calcKBaumartNachPfeiffer1978();
            tap = (tap - (kBaumart *= this.getAnzahlPersonalVollzeitAequivalente())) / 20.0 * (bhd_original - 15.0) + kBaumart;
        }
        return tap;
    }

    private double calcKBaumartNachPfeiffer1978() {
        double result = 0.0;
        double anteilLaub = (double)this.getArbeitsobjekt().getAnteilLaubholz_Prz() / 100.0;
        double anteilKiefer = (double)this.getArbeitsobjekt().getAnteilKiefer_Prz() / 100.0;
        if (this.getArbeitsobjekt().getRegion() == ArbeitsobjektMotormanuellGesamt2014.Region.Huegelland) {
            result += 0.86 * (1.0 - anteilKiefer - anteilLaub);
            result += 0.94 * anteilKiefer;
            result += 1.54 * anteilLaub;
        } else {
            result += 0.52 * (1.0 - anteilKiefer - anteilLaub);
            result += 0.63 * anteilKiefer;
            result += 1.18 * anteilLaub;
        }
        return result;
    }

    @Override
    protected double getAnzahlPersonalVollzeitAequivalente() {
        return this.getArbeitssystem().getVollzeitAequivalent();
    }

    @Override
    protected double getLaufzeitAnteilMaschine() {
        double laufzeitAnteil = 0.7;
        return this.getAnzahlPersonalVollzeitAequivalente() * laufzeitAnteil;
    }
}

