/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektMotormanuell;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel;

public abstract class CalculatorMotormanuell
extends AbstractCalculatorSingleModel {
    public CalculatorMotormanuell(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    protected ArbeitsobjektMotormanuell getArbeitsobjekt() {
        return (ArbeitsobjektMotormanuell)super.getArbeitsobjekt();
    }

    @Override
    protected double calcPsh0_hProM3() {
        double raz = this.calcRAZ_minProM3oR(this.getArbeitsobjekt().getBaumartenGruppe());
        double kBA = this.getUmrechnungsfaktorVoR_ViR(this.getArbeitsobjekt().getBaumartenGruppe());
        double m = this.getMulitplicationFactorsProduct();
        double a = this.getAdditionsSum();
        double psh0 = kBA * 0.016666666666666666 * (m * raz + a);
        return psh0;
    }

    protected double calcRAZ_minProM3oR(ArbeitsobjektMotormanuell.Baumartgruppe baGruppe) {
        double[] c = this.getKoeffizienten(baGruppe);
        double kBA = this.getUmrechnungsfaktorVoR_ViR(this.getArbeitsobjekt().getBaumartenGruppe());
        double vMit = this.getArbeitsobjekt().getMassenmittelstamm_m3iR() * kBA;
        double result = c[0] * Math.exp(c[1] * Math.pow(vMit, c[2]) + c[3]);
        return result;
    }

    protected double getMulitplicationFactorsProduct() {
        double m1 = this.getM1();
        double m2 = this.getM2();
        double m3 = this.getM3();
        double m4 = this.getM4();
        double m5 = this.getM5();
        double m6 = this.getM6();
        double product = m1 * m2 * m3 * m4 * m5 * m6;
        return product;
    }

    protected double getAdditionsSum() {
        double a1 = this.getA1();
        double a2 = this.getA2();
        double a3 = this.getA3();
        double sum = a1 + a2 + a3;
        return sum;
    }

    protected double getM1() {
        return 1.0;
    }

    protected double getM2() {
        return 1.0;
    }

    protected double getM3() {
        return 1.0;
    }

    protected double getM4() {
        return 1.0;
    }

    protected double getM5() {
        return 1.0;
    }

    protected double getM6() {
        switch (this.getArbeitsobjekt().getHindernisse()) {
            case Keine: {
                return 1.0;
            }
            case Gering: {
                return 1.05;
            }
            case Maessig: {
                return 1.1;
            }
            case Stark: {
                return 1.2;
            }
        }
        throw new RuntimeException();
    }

    protected double getA1() {
        return 0.0;
    }

    protected double getA2() {
        return 0.0;
    }

    protected double getA3() {
        return 0.0;
    }

    protected double getUmrechnungsfaktorVoR_ViR(ArbeitsobjektMotormanuell.Baumartgruppe baGruppe) {
        switch (baGruppe) {
            case Fichte: 
            case Tanne: {
                return 0.89;
            }
            case Foehre_Laerche: {
                return 0.92;
            }
            case Laubholz: {
                return 0.93;
            }
        }
        throw new RuntimeException();
    }

    protected abstract double[] getKoeffizienten(ArbeitsobjektMotormanuell.Baumartgruppe var1);
}

