/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektMobilseilkranSeilen;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemSeilkran;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel;

public class CalculatorMobilseilkranSeilen
extends AbstractCalculatorSingleModel {
    public CalculatorMobilseilkranSeilen(HeProMoInputData inputData) {
        super(inputData);
        this.f_indir = 1.0;
        this.f_stoer = 1.053;
    }

    @Override
    protected ArbeitsobjektMobilseilkranSeilen getArbeitsobjekt() {
        return (ArbeitsobjektMobilseilkranSeilen)super.getArbeitsobjekt();
    }

    @Override
    protected ArbeitssystemSeilkran getArbeitssystem() {
        return (ArbeitssystemSeilkran)super.getArbeitssystem();
    }

    @Override
    protected double calcPsh0_hProM3() {
        double psh0_Anhaengen = this.getPsh0_Anhaengen();
        double psh0_SeitlicherZuzug = this.getPsh0_SeitlicherZuzug();
        double psh0_VertikalbewegungImBestand = this.getPsh0_VertikalbewegungImBestand();
        double psh0_FahrtAmTragseil = this.getPsh0_FahrtAmTragseil();
        double psh0_VertikalbewegungAmAbsenkplatz = this.getPsh0_VertikalbewegungAmAbsenkplatz();
        double psh0_Abhaengen = this.getPsh0_Abhaengen();
        double psh0_SeilenLast = psh0_Anhaengen + psh0_SeitlicherZuzug + psh0_VertikalbewegungImBestand + psh0_FahrtAmTragseil + psh0_VertikalbewegungAmAbsenkplatz + psh0_Abhaengen;
        double stueckVolumen = this.getArbeitsobjekt().getMittleresStueckvolumen_m3();
        double fd = this.getArbeitsobjekt().getMittlereFahrdistanz_m();
        double lastVolumen = 0.691 + 0.668 * stueckVolumen + 0.0014 * fd;
        double psh0_Seilen = psh0_SeilenLast / lastVolumen;
        if (this.rindenAbzugBeruecksichtigen) {
            psh0_Seilen /= this.getArbeitsobjekt().getRindenAbzugFaktor();
        }
        return psh0_Seilen;
    }

    @Override
    public void setFaktorStoerzeiten(double value) {
        this.f_stoer = value;
    }

    private double getPsh0_Anhaengen() {
        double stueckVolumen = this.getArbeitsobjekt().getMittleresStueckvolumen_m3();
        double psh0 = 0.016666666666666666 * (0.642 - 0.399 * Math.log(stueckVolumen));
        return psh0;
    }

    private double getPsh0_SeitlicherZuzug() {
        double a = -1.0;
        double b = -1.0;
        switch (this.getArbeitsobjekt().getSchwierigkeitSeitlicherZuzug()) {
            case Einfach: {
                a = 0.883;
                b = 0.061;
                break;
            }
            case Erschwert: {
                a = 1.578;
                b = 0.068;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        double dz = this.getArbeitsobjekt().getMittlereDistanzSeitlicherZuzug_m();
        double psh0 = 0.016666666666666666 * (a + b * dz);
        return psh0;
    }

    private double getPsh0_VertikalbewegungImBestand() {
        double psh0 = 0.0106;
        return psh0;
    }

    private double getPsh0_FahrtAmTragseil() {
        double fd = this.getArbeitsobjekt().getMittlereFahrdistanz_m();
        double psh0 = 0.016666666666666666 * (1.0452 + 0.00934 * fd);
        return psh0;
    }

    private double getPsh0_VertikalbewegungAmAbsenkplatz() {
        double psh0 = 0.0151;
        return psh0;
    }

    private double getPsh0_Abhaengen() {
        double stueckVolumen = this.getArbeitsobjekt().getMittleresStueckvolumen_m3();
        double psh0 = 0.016666666666666666 * (0.266 * Math.pow(stueckVolumen, -0.69));
        return psh0;
    }

    @Override
    protected double getAnzahlPersonalVollzeitAequivalente() {
        return this.getArbeitssystem().getAnzahlPersonal();
    }

    @Override
    protected double getLaufzeitAnteilMaschine() {
        return (double)this.getArbeitssystem().getAnteilSeilkranLaufzeit_Prz() / 100.0;
    }
}

