/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektMobilerHacker;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemMobilerHacker;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel;

public class CalculatorMobilerHacker
extends AbstractCalculatorSingleModel {
    public CalculatorMobilerHacker(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    protected ArbeitsobjektMobilerHacker getArbeitsobjekt() {
        return (ArbeitsobjektMobilerHacker)super.getArbeitsobjekt();
    }

    @Override
    protected ArbeitssystemMobilerHacker getArbeitssystem() {
        return (ArbeitssystemMobilerHacker)super.getArbeitssystem();
    }

    @Override
    protected double calcPsh0_hProM3() {
        double psh15_Fahren = this.getPsh15_Fahren();
        double psh15_Hacken = this.getPsh15_Hacken();
        double psh15_Entladen = this.getPsh15_Entladen();
        double psh15_Hackschnitzel = psh15_Fahren + psh15_Hacken + psh15_Entladen;
        double psh0 = psh15_Hackschnitzel / this.f_0bis15;
        return psh0;
    }

    private double getPsh15_Fahren() {
        double tF = this.getTF();
        double kf = 1.2;
        double dLV = this.getDLV();
        double psh15 = tF / 60.0 * (1.0 / dLV) * kf;
        return psh15;
    }

    private double getDLV() {
        double c = this.getArbeitssystem().getKippContainerVolumen_m3();
        double dBH = 0.95;
        double dUF = 0.4;
        double dLV = c * dBH * dUF;
        return dLV;
    }

    private double getTF() {
        double vSTLA;
        double vRMLA;
        double vRMLE;
        double ale = 0.5;
        double rmsLELA = 2 * this.getArbeitsobjekt().getFahrstreckeFeinerschliessung_m();
        double stsLELA = 2 * this.getArbeitsobjekt().getFahrstreckeStrasse_m();
        boolean gh = this.getArbeitssystem().getHackerTyp() == ArbeitssystemMobilerHacker.HackerTyp.AufLastwagen;
        double vrm = this.getVrm();
        double[] sTsFLandRMsFL = this.getSTsFLandRMsFL();
        double rmsFL = sTsFLandRMsFL[1];
        double rmsLE = gh ? 0.0 : ale * rmsLELA;
        double rmsLA = gh ? 0.0 : (1.0 - ale) * rmsLELA;
        double vRMFL = vrm * 0.5;
        if (vRMFL < 15.0) {
            vRMFL = 15.0;
        }
        if ((vRMLE = vrm * 1.0) < 15.0) {
            vRMLE = 15.0;
        }
        if ((vRMLA = vrm * 0.64) < 15.0) {
            vRMLA = 15.0;
        }
        double tRMFL = rmsFL / vRMFL;
        double tRMLE = rmsLE / vRMLE;
        double tRMLA = rmsLA / vRMLA;
        double tRM = tRMFL + tRMLE + tRMLA;
        double stsFL = sTsFLandRMsFL[0];
        double stsLE = ale * stsLELA;
        double stsLA = (1.0 - ale) * stsLELA;
        double vSTFL = 60.0;
        double vSTLE = 126.45 + 0.314 * stsLE;
        if (vSTLE > 200.0) {
            vSTLE = 200.0;
        }
        if ((vSTLA = 69.1 + 0.8 * stsLA) > 200.0) {
            vSTLA = 200.0;
        }
        double tSTFL = stsFL / vSTFL;
        double tSTLE = stsLE / vSTLE;
        double tSTLA = stsLA / vSTLA;
        double tST = tSTFL + tSTLE + tSTLA;
        double tF = tRM + tST;
        return tF;
    }

    private double getVrm() {
        double bg = 89.0;
        double cgX = 22.0;
        double cgY = 11.0;
        double cgZ = 7.5;
        double hk = this.getArbeitsobjekt().getHindernisKategorie().value();
        double gk = this.getArbeitsobjekt().getNeigungsKategorie().value();
        double vrmEben = bg - cgX * (hk - 1.0);
        double vrmAbwaerts = vrmEben - cgZ * (gk - 1.0);
        double vrmAufwaerts = vrmEben - cgY * (gk - 1.0);
        double vrm = (vrmEben + vrmAbwaerts + vrmAufwaerts) / 3.0;
        return vrm;
    }

    private double[] getSTsFLandRMsFL() {
        double rmsFL;
        double stsFL;
        ArbeitsobjektMobilerHacker ao = this.getArbeitsobjekt();
        double ast = (0.0 + (double)ao.getFahrstreckeStrasse_m()) / (double)ao.getFahrstreckeTotal_m();
        double sfl = this.getSFL();
        if (this.getArbeitssystem().getHackerTyp() == ArbeitssystemMobilerHacker.HackerTyp.AufForwarder) {
            stsFL = ast * sfl;
            rmsFL = (1.0 - ast) * sfl;
        } else {
            stsFL = sfl;
            rmsFL = 0.0;
        }
        return new double[]{stsFL, rmsFL};
    }

    private double getSRP() {
        double nt = this.getArbeitsobjekt().getHackgutmenge_m3();
        double dRPV = this.getDRPV();
        double nrp = nt / dRPV;
        double e = this.getArbeitsobjekt().getHolzlagerLaenge_m();
        double srp = e / nrp;
        return srp;
    }

    private double getSFL() {
        double dLV = this.getDLV();
        double srp = this.getSRP();
        double dRPV = this.getDRPV();
        double sfl = dLV * srp / dRPV;
        return sfl;
    }

    private double getPsh15_Hacken() {
        double vpz = this.getVpz();
        double ghf = this.getArbeitssystem().getHackerTyp() == ArbeitssystemMobilerHacker.HackerTyp.AufLastwagen ? 2.5 : 1.0;
        double duf = 0.4;
        double vb = this.getArbeitsobjekt().getHackgutart() == ArbeitsobjektMobilerHacker.Hackgutart.Rundholzabschnitte ? 1 : 0;
        double psh15_Hacken = Math.pow((17.55 + 165.48 * vpz - 74.33 * Math.pow(vpz, 2.0) - 10.48 * vb) * ghf * duf, -1.0);
        return psh15_Hacken *= 0.917795;
    }

    private double getVpz() {
        double spz = this.getSpZ();
        double dRPV = this.getDRPV();
        double vpz = this.getArbeitsobjekt().getVpz(spz, dRPV);
        return vpz;
    }

    private double getSpZ() {
        double var_cm = this.getArbeitsobjekt().getHackgutart() == ArbeitsobjektMobilerHacker.Hackgutart.Kronen ? this.getArbeitsobjekt().getMittlererZopfDrm_m() * 100.0 : this.getArbeitsobjekt().getMittlererBhdAushieb_m() * 100.0;
        double spz = var_cm <= 20.0 ? 11.494 * Math.pow(var_cm, -0.7854) : 1.5357 * Math.pow(var_cm, -0.1176);
        if (spz < 1.0) {
            spz = 1.0;
        }
        return spz;
    }

    private double getDRPV() {
        double dBHD_cm = this.getArbeitsobjekt().getMittlererBhdAushieb_m() * 100.0;
        double e = this.getArbeitsobjekt().getHolzlagerLaenge_m();
        double nt = this.getArbeitsobjekt().getHackgutmenge_m3();
        double ev = 1.18 * nt / e;
        double dRPV = 0.0247 * dBHD_cm + 1.0644 * ev - 0.31973;
        return dRPV;
    }

    private double getPsh15_Entladen() {
        double psh15_Hacken = this.getPsh15_Hacken();
        double fe = 0.2;
        double psh15_Entladen = psh15_Hacken * fe;
        return psh15_Entladen;
    }

    @Override
    protected double getRelevanteHolzmenge() {
        return this.getArbeitsobjekt().getHackgutmenge_m3();
    }

    @Override
    protected double getLaufzeitAnteilMaschine() {
        return 1.0;
    }
}

