/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.Ergebnis;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektKonventionellerSeilkranDemontage;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektKonventionellerSeilkranGesamt;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektKonventionellerSeilkranMontage;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektKonventionellerSeilkranSeilen;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektSeilkranLagerplatz;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektSeilkranPlanung;
import ch.wsl.fps.hepromo.model.asys.Arbeitssystem;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemSeilkran;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemSeilkranGesamt;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemSeilkranLagerplatz;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorComposedModel;
import ch.wsl.fps.hepromo.model.calc.CalculatorKonventionellerSeilkranDemontage;
import ch.wsl.fps.hepromo.model.calc.CalculatorKonventionellerSeilkranMontage;
import ch.wsl.fps.hepromo.model.calc.CalculatorKonventionellerSeilkranSeilen;
import ch.wsl.fps.hepromo.model.calc.CalculatorSeilkranLagerplatz;
import ch.wsl.fps.hepromo.model.calc.CalculatorSeilkranPlanung;

public class CalculatorKonventionellerSeilkranGesamt
extends AbstractCalculatorComposedModel {
    public CalculatorKonventionellerSeilkranGesamt(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    protected ArbeitsobjektKonventionellerSeilkranGesamt getArbeitsobjekt() {
        return (ArbeitsobjektKonventionellerSeilkranGesamt)super.getArbeitsobjekt();
    }

    @Override
    protected ArbeitssystemSeilkranGesamt getArbeitssystem() {
        return (ArbeitssystemSeilkranGesamt)super.getArbeitssystem();
    }

    @Override
    public Ergebnis calculate() {
        Ergebnis ePlanung = this.getErgebnisPlanung();
        Ergebnis eMontage = this.getErgebnisMontage();
        Ergebnis eSeilen = this.getErgebnisSeilen();
        Ergebnis eDemontage = this.getErgebnisDemontage();
        double psh0ProM_Seilen = eSeilen.getPsh0_hProM3();
        Ergebnis eLagerplatz = this.getErgebnisLagerplatz(psh0ProM_Seilen);
        Ergebnis ergebnis = new Ergebnis();
        ergebnis.setAnzahl_m3(eSeilen.getAnzahl_m3());
        ergebnis.setZeitTotal(ePlanung.getZeitTotal() + eMontage.getZeitTotal() + eSeilen.getZeitTotal() + eDemontage.getZeitTotal());
        ergebnis.setZeitPersonal(ePlanung.getZeitPersonal() + eMontage.getZeitPersonal() + eSeilen.getZeitPersonal() + eDemontage.getZeitPersonal() + eLagerplatz.getZeitPersonal());
        ergebnis.setZeitMaschine1(eMontage.getZeitMaschine1() + eSeilen.getZeitMaschine1() + eDemontage.getZeitMaschine1());
        ergebnis.setZeitMaschine2(eLagerplatz.getZeitMaschine1());
        ergebnis.setZeitUmsetzen(this.getArbeitssystem().getUmsetzenZeit_h());
        ergebnis.setZeitWeitereAufwaende(this.getArbeitssystem().getWeitereAufwaendeZeit_h());
        ergebnis.setKostenPersonal_total(ePlanung.getKostenPersonal_total() + eMontage.getKostenPersonal_total() + eSeilen.getKostenPersonal_total() + eDemontage.getKostenPersonal_total() + eLagerplatz.getKostenPersonal_total());
        ergebnis.setKostenMaschine1_total(eMontage.getKostenMaschine1_total() + eSeilen.getKostenMaschine1_total() + eDemontage.getKostenMaschine1_total());
        ergebnis.setKostenMaschine2_total(eLagerplatz.getKostenMaschine1_total());
        ergebnis.setKostenUmsetzen_total(this.getArbeitssystem().getUmsetzenBetrag_CHF());
        ergebnis.setKostenWeitereAufwaende_total(this.getArbeitssystem().getWeitereAufwaendeBetrag_CHF());
        this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.M3_OR_PRO_PMH15_BEIM_SEILEN, ergebnis.getAnzahl_m3() / eSeilen.getZeitMaschine1());
        this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.M3_IR_PRO_PMH15_BEIM_SEILEN, ergebnis.getAnzahl_m3() / eSeilen.getZeitMaschine1() / this.getArbeitsobjekt().getRindenAbzugFaktor());
        this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.M3_PRO_PSH15, ergebnis.getAnzahl_m3() / ergebnis.getZeitMaschine1());
        ergebnis.setRisikoVerwaltungGewinn_Prz(ePlanung.getRisikoVerwaltungGewinn_Prz());
        ergebnis.setMehrwertsteuer_Prz(ePlanung.getMehrwertsteuer_Prz());
        ergebnis.setLabelPersonal1(this.getArbeitssystem().getLabelPersonal1());
        ergebnis.setLabelMaschine1(this.getArbeitssystem().getLabelMaschine1());
        ergebnis.setLabelMaschine2(this.getArbeitssystem().getLabelMaschine2());
        return ergebnis;
    }

    @Override
    protected Ergebnis.ProdEinheit getProdEinheit1() {
        return Ergebnis.ProdEinheit.M3_IR_PRO_PMH15_BEIM_SEILEN;
    }

    @Override
    protected Ergebnis.ProdEinheit getProdEinheit2() {
        return Ergebnis.ProdEinheit.M3_OR_PRO_PMH15_BEIM_SEILEN;
    }

    private Ergebnis getErgebnisPlanung() {
        ArbeitsobjektSeilkranPlanung arbeitsObjekt = this.getArbeitsobjekt().getTeilobjektPlanung();
        Arbeitssystem arbeitsSystem = this.getArbeitssystem().getTeilsystemPlanung();
        HeProMoInputData inputData = this.createHeProMoInputData(arbeitsObjekt, arbeitsSystem, this.faktoren);
        CalculatorSeilkranPlanung calc = new CalculatorSeilkranPlanung(inputData);
        calc.setRindenAbzugBeruecksichtigen(this.rindenAbzugBeruecksichtigen);
        Ergebnis ergebnis = calc.calculate();
        return ergebnis;
    }

    private Ergebnis getErgebnisMontage() {
        ArbeitsobjektKonventionellerSeilkranMontage arbeitsObjekt = this.getArbeitsobjekt().getTeilobjektMontage();
        ArbeitssystemSeilkran arbeitsSystem = this.getArbeitssystem().getTeilsystemInstallation();
        HeProMoInputData inputData = this.createHeProMoInputData(arbeitsObjekt, arbeitsSystem, this.faktoren);
        CalculatorKonventionellerSeilkranMontage calc = new CalculatorKonventionellerSeilkranMontage(inputData);
        calc.setRindenAbzugBeruecksichtigen(this.rindenAbzugBeruecksichtigen);
        Ergebnis ergebnis = calc.calculate();
        return ergebnis;
    }

    private Ergebnis getErgebnisSeilen() {
        ArbeitsobjektKonventionellerSeilkranSeilen arbeitsObjekt = this.getArbeitsobjekt().getTeilobjektSeilen();
        ArbeitssystemSeilkran arbeitsSystem = this.getArbeitssystem().getTeilsystemSeilen();
        HeProMoInputData inputData = this.createHeProMoInputData(arbeitsObjekt, arbeitsSystem, this.faktoren);
        CalculatorKonventionellerSeilkranSeilen calc = new CalculatorKonventionellerSeilkranSeilen(inputData);
        calc.setRindenAbzugBeruecksichtigen(this.rindenAbzugBeruecksichtigen);
        calc.setFaktorIndirekteArbeitszeit(1.0);
        calc.setFaktorStoerzeiten(1.022);
        Ergebnis ergebnis = calc.calculate();
        return ergebnis;
    }

    private Ergebnis getErgebnisDemontage() {
        ArbeitsobjektKonventionellerSeilkranDemontage arbeitsObjekt = this.getArbeitsobjekt().getTeilobjektDemontage();
        ArbeitssystemSeilkran arbeitsSystem = this.getArbeitssystem().getTeilsystemInstallation();
        HeProMoInputData inputData = this.createHeProMoInputData(arbeitsObjekt, arbeitsSystem, this.faktoren);
        CalculatorKonventionellerSeilkranDemontage calc = new CalculatorKonventionellerSeilkranDemontage(inputData);
        calc.setRindenAbzugBeruecksichtigen(this.rindenAbzugBeruecksichtigen);
        Ergebnis ergebnis = calc.calculate();
        return ergebnis;
    }

    private Ergebnis getErgebnisLagerplatz(double systemzeitSeilen_psh0proM) {
        ArbeitsobjektSeilkranLagerplatz arbeitsObjekt = this.getArbeitsobjekt().getTeilobjektLagerplatz(systemzeitSeilen_psh0proM);
        ArbeitssystemSeilkranLagerplatz arbeitsSystem = this.getArbeitssystem().getTeilsystemLagerplatz();
        HeProMoInputData inputData = this.createHeProMoInputData(arbeitsObjekt, arbeitsSystem, this.faktoren);
        CalculatorSeilkranLagerplatz calc = new CalculatorSeilkranLagerplatz(inputData);
        calc.setRindenAbzugBeruecksichtigen(this.rindenAbzugBeruecksichtigen);
        calc.setFaktorIndirekteArbeitszeit(1.0);
        calc.setFaktorStoerzeiten(1.022);
        Ergebnis ergebnis = calc.calculate();
        return ergebnis;
    }
}

