/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.ErgebnisHelikopterFliegen;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektHelikopterFliegen;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemHelikopterFliegen;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel;

public class CalculatorHelikopterFliegen
extends AbstractCalculatorSingleModel {
    public CalculatorHelikopterFliegen(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    public ErgebnisHelikopterFliegen calculate() {
        ErgebnisHelikopterFliegen ergebnis = (ErgebnisHelikopterFliegen)super.calculate();
        ergebnis.setKostenMaschine1_total(this.getArbeitssystem().getKostensatzMaschine1_proH() * ergebnis.getZeitMaschine1() + this.getArbeitssystem().getAnflugPauschale());
        ergebnis.setRotationszeit(this.getPsh0Rot() * 60.0);
        return ergebnis;
    }

    @Override
    protected ErgebnisHelikopterFliegen getNewErgebnisInstance() {
        return new ErgebnisHelikopterFliegen();
    }

    @Override
    protected double calcPsh0_hProM3() {
        double psh0_rot = this.getPsh0Rot();
        double psh0_heli_hProM3 = psh0_rot / this.getArbeitssystem().getLastVolumen();
        double UNBEKANNTER_KORREKTURFAKTOR = 1.25;
        psh0_heli_hProM3 *= UNBEKANNTER_KORREKTURFAKTOR;
        if (this.rindenAbzugBeruecksichtigen) {
            psh0_heli_hProM3 /= this.getArbeitsobjekt().getRindenAbzugFaktor();
        }
        return psh0_heli_hProM3;
    }

    @Override
    protected double getLaufzeitAnteilMaschine() {
        return 1.0;
    }

    @Override
    protected double getAnzahlPersonalVollzeitAequivalente() {
        return this.getArbeitssystem().getAnzahlPersonal();
    }

    private double getPsh0Rot() {
        double koeff1 = 0.0;
        double koeff2 = 0.0;
        switch (this.getArbeitssystem().getHelikopterKlasse()) {
            case Leicht: {
                koeff1 = 1.87;
                koeff2 = 4.0E-4;
                break;
            }
            case Mittel: {
                koeff1 = 1.87;
                koeff2 = 0.0027;
                break;
            }
            case Schwer: {
                koeff1 = 2.36;
                koeff2 = 0.001;
            }
        }
        double result = 0.016666666666666666 * (koeff1 + 3.2E-4 * (double)this.getArbeitsobjekt().getHorizontalDistanz_m() + koeff2 * (double)this.getArbeitsobjekt().getVertikalDistanz_m());
        return result;
    }

    @Override
    protected ArbeitsobjektHelikopterFliegen getArbeitsobjekt() {
        return (ArbeitsobjektHelikopterFliegen)super.getArbeitsobjekt();
    }

    @Override
    protected ArbeitssystemHelikopterFliegen getArbeitssystem() {
        return (ArbeitssystemHelikopterFliegen)super.getArbeitssystem();
    }
}

