/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.Ergebnis;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektHelikopterAufarbeiten;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemHelikopterAufarbeiten;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel;

public class CalculatorHelikopterAufarbeiten
extends AbstractCalculatorSingleModel {
    public CalculatorHelikopterAufarbeiten(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    protected ArbeitsobjektHelikopterAufarbeiten getArbeitsobjekt() {
        return (ArbeitsobjektHelikopterAufarbeiten)super.getArbeitsobjekt();
    }

    @Override
    protected ArbeitssystemHelikopterAufarbeiten getArbeitssystem() {
        return (ArbeitssystemHelikopterAufarbeiten)super.getArbeitssystem();
    }

    @Override
    protected double getAnzahlPersonalVollzeitAequivalente() {
        return this.getArbeitssystem().getAnzahlPersonal1();
    }

    @Override
    public Ergebnis calculate() {
        Ergebnis e = super.calculate();
        double psh0_total = e.getPsh0_total();
        int anzahl_maschinen = this.getArbeitssystem().getAnzahlMaschine2();
        double maschinen_laufzeitanteil = 1.0;
        double pmh0 = (double)anzahl_maschinen * psh0_total * maschinen_laufzeitanteil;
        double pmh15 = pmh0 * this.f_0bis15;
        double kf = this.faktoren.getKorrekturFaktor();
        e.setZeitMaschine2(pmh15 *= kf);
        e.setKostenMaschine2_total(this.getArbeitssystem().getKostensatzMaschine2_proH() * e.getZeitMaschine2());
        return e;
    }

    @Override
    protected double calcPsh0_hProM3() {
        double psh0_lagerplatz = this.getPsh0Lagerplatz();
        double UNBEKANNTER_KORREKTURFAKTOR = 0.9090909090909091;
        psh0_lagerplatz *= UNBEKANNTER_KORREKTURFAKTOR;
        if (this.rindenAbzugBeruecksichtigen) {
            psh0_lagerplatz /= this.getArbeitsobjekt().getRindenAbzugFaktor();
        }
        return psh0_lagerplatz;
    }

    @Override
    protected double getLaufzeitAnteilMaschine() {
        if (this.getArbeitsobjekt().getArbeitsVerfahren() == ArbeitsobjektHelikopterAufarbeiten.ArbeitsVerfahren.Sortimentsverfahren) {
            return 0.5;
        }
        return 1.0;
    }

    @Override
    protected int getAnzahlMaschinen() {
        return this.getArbeitssystem().getAnzahlMaschine1();
    }

    private double getPsh0Lagerplatz() {
        double result = 0.0;
        block0 : switch (this.getArbeitsobjekt().getArbeitsVerfahren()) {
            case Sortimentsverfahren: {
                result = 0.05;
                break;
            }
            case Vollbaumverfahren: {
                switch (this.getArbeitsobjekt().getBaumartenGruppe()) {
                    case Fichte: 
                    case Tanne: {
                        result = 0.058823529411764705;
                        break block0;
                    }
                    case Foehre_Laerche: {
                        result = 0.05;
                        break block0;
                    }
                    case Laubholz: {
                        result = 0.045454545454545456;
                    }
                }
            }
        }
        return result;
    }
}

