/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.Ergebnis;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektHacker2018;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemHacker2018;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel2014;

public class CalculatorHacker2018
extends AbstractCalculatorSingleModel2014 {
    public CalculatorHacker2018(HeProMoInputData inputData) {
        super(inputData);
        this.f_indir = 1.5;
    }

    @Override
    public ArbeitsobjektHacker2018 getArbeitsobjekt() {
        return (ArbeitsobjektHacker2018)super.getArbeitsobjekt();
    }

    @Override
    public ArbeitssystemHacker2018 getArbeitssystem() {
        return (ArbeitssystemHacker2018)super.getArbeitssystem();
    }

    @Override
    public Ergebnis calculate() {
        Ergebnis ergebnis = super.calculate();
        this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.SRM_PRO_PMH15, ergebnis.getProduktivitaet(Ergebnis.ProdEinheit.M3_PRO_PSH15));
        return ergebnis;
    }

    @Override
    protected Ergebnis.ProdEinheit getProdEinheit1() {
        return Ergebnis.ProdEinheit.SRM_PRO_PMH15;
    }

    @Override
    protected Ergebnis.ProdEinheit getProdEinheit2() {
        return Ergebnis.ProdEinheit.EMPTY;
    }

    @Override
    protected double calcPsh0_hProM3() {
        double pmh15_Hacken_hProSrm;
        double produktivitaet_SrmProMAS = this.getProduktivitaet_SrmProMAS();
        double pmh15_Gesamt_hProSrm = pmh15_Hacken_hProSrm = 1.0 / produktivitaet_SrmProMAS;
        double pmh0_Gesamt_hProSrm = pmh15_Gesamt_hProSrm / this.f_0bis15;
        return pmh0_Gesamt_hProSrm;
    }

    private double getProduktivitaet_SrmProMAS() {
        ArbeitsobjektHacker2018.Zielsortiment zielsortiment = this.getArbeitsobjekt().getZielsortiment();
        int motorleistungKw = this.getArbeitssystem().getHackerMotorleistung().getMotorleistungCalc_Kw();
        double result = CalculatorHacker2018.getProduktivitaet_SrmProMAS(zielsortiment, motorleistungKw);
        return result;
    }

    public static final double getProduktivitaet_SrmProMAS(ArbeitsobjektHacker2018.Zielsortiment zielsortiment, double motorleistungKw) {
        switch (zielsortiment) {
            case Energierundholz: {
                return 0.2848 * Math.pow(motorleistungKw, 1.0276);
            }
            case Waldrestholz: {
                return 0.5177 * Math.pow(motorleistungKw, 0.8486);
            }
        }
        throw new RuntimeException();
    }

    public static final double convertFromCHFproSrmToCHFproPMH15(double CHFproSrm, ArbeitsobjektHacker2018.Zielsortiment zielsortiment, double motorleistungKw) {
        double produktivitaet_SrmProPMH15 = CalculatorHacker2018.getProduktivitaet_SrmProMAS(zielsortiment, motorleistungKw);
        double CHFproPMH15 = CHFproSrm * produktivitaet_SrmProPMH15;
        return CHFproPMH15;
    }

    public static final double convertFromCHFproPMH15ToCHFproSrm(double CHFproPMH15, ArbeitsobjektHacker2018.Zielsortiment zielsortiment, double motorleistungKw) {
        double produktivitaet_SrmProPMH15 = CalculatorHacker2018.getProduktivitaet_SrmProMAS(zielsortiment, motorleistungKw);
        double CHFproSrm = CHFproPMH15 / produktivitaet_SrmProPMH15;
        return CHFproSrm;
    }
}

