/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.Ergebnis;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.ModelStrings;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektForwarder2018;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemForwarder2018;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel2014;

public class CalculatorForwarder2018
extends AbstractCalculatorSingleModel2014 {
    private ErgebnisAnzeige ergebnisAnzeige = ErgebnisAnzeige.Rundholz;

    public CalculatorForwarder2018(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    public Ergebnis calculate() {
        Ergebnis ergebnis = super.calculate();
        if (ergebnis.getAnzahl_m3() > 0.0 && this.getErgebnisAnzeige() == ErgebnisAnzeige.Energieholz) {
            this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.M3_IR_PRO_PMH15, ergebnis.getProduktivitaet_m3ProPmh15());
            this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.M3_OR_PRO_PMH15, ergebnis.getProduktivitaet_m3ProPmh15() * this.getArbeitsobjekt().getRindenAbzugFaktor());
        }
        return ergebnis;
    }

    @Override
    public ArbeitsobjektForwarder2018 getArbeitsobjekt() {
        return (ArbeitsobjektForwarder2018)super.getArbeitsobjekt();
    }

    @Override
    public ArbeitssystemForwarder2018 getArbeitssystem() {
        return (ArbeitssystemForwarder2018)super.getArbeitssystem();
    }

    @Override
    protected Ergebnis.ProdEinheit getProdEinheit1() {
        if (this.getErgebnisAnzeige() == ErgebnisAnzeige.Rundholz) {
            return super.getProdEinheit1();
        }
        return Ergebnis.ProdEinheit.M3_IR_PRO_PMH15;
    }

    @Override
    protected Ergebnis.ProdEinheit getProdEinheit2() {
        if (this.getErgebnisAnzeige() == ErgebnisAnzeige.Rundholz) {
            return super.getProdEinheit2();
        }
        return Ergebnis.ProdEinheit.EMPTY;
    }

    @Override
    protected double calcPsh0_hProM3() {
        double m3ProPMH15 = this.getProduktivitaet_m3proPMH15();
        if (this.rindenAbzugBeruecksichtigen) {
            double rindenabzug_fix = 0.89;
            double rindenabzug_variabel = this.getArbeitsobjekt().getRindenAbzugFaktor();
            m3ProPMH15 *= rindenabzug_variabel / rindenabzug_fix;
        }
        double pmh15 = 1.0 / m3ProPMH15;
        double pmh0 = pmh15 / this.f_0bis15;
        return pmh0;
    }

    @Override
    protected double getRelevanteHolzmenge() {
        switch (this.getErgebnisAnzeige()) {
            case Rundholz: {
                double holzmenge = this.getArbeitsobjekt().getVerkaufRundholz_m3oR();
                return holzmenge;
            }
            case Energieholz: {
                double holzmenge = this.getArbeitsobjekt().getEnergieholzmenge_m3iR();
                return holzmenge;
            }
        }
        throw new RuntimeException(this.getErgebnisAnzeige().toString());
    }

    private double getProduktivitaet_m3proPMH15() {
        switch (this.getErgebnisAnzeige()) {
            case Rundholz: {
                return this.getProduktivitaetStammholz_m3oRproPMH15();
            }
            case Energieholz: {
                return this.getProduktivitaetStammholz_m3oRproPMH15() / this.getKfEnergieholz();
            }
        }
        throw new RuntimeException(this.getErgebnisAnzeige().toString());
    }

    private double getProduktivitaetStammholz_m3oRproPMH15() {
        double bhdMit = this.getArbeitsobjekt().getBhdMit_cm();
        double result = (4.14 + 0.31 * bhdMit) * this.getReduktionGesamt();
        return result;
    }

    private double getReduktionGesamt() {
        double result = 1.0 - this.getReduktionR\u00fcckeentfernung() - this.getReduktionHangneigung() - this.getReduktionAnzahlSortimente() - this.getReduktionErschwernisse() - this.getReduktionAbstandR\u00fcckegassen() + this.getReduktionForwarderTyp();
        return result;
    }

    private double getReduktionR\u00fcckeentfernung() {
        switch (this.getArbeitsobjekt().getRueckeentfernung()) {
            case EntfKleiner200m: {
                return 0.0;
            }
            case Entf201bis400m: {
                return 0.05;
            }
            case Entf401bis600m: {
                return 0.1;
            }
            case Entf601bis900m: {
                return 0.15;
            }
            case Entf901bis1200m: {
                return 0.175;
            }
            case EntfGroesser1200m: {
                return 0.2;
            }
        }
        throw new RuntimeException(this.getArbeitsobjekt().getRueckeentfernung().name());
    }

    private double getReduktionHangneigung() {
        switch (this.getArbeitsobjekt().getHangneigung()) {
            case NeigungBis15Prozent: {
                return 0.0;
            }
            case Neigung15Bis25Prozent: {
                return 0.025;
            }
            case NeigungGroesser25Prozent: {
                return 0.05;
            }
        }
        throw new RuntimeException(this.getArbeitsobjekt().getHangneigung().name());
    }

    private double getReduktionAnzahlSortimente() {
        switch (this.getArbeitsobjekt().getAnzahlSortimente()) {
            case AnzahlBis3: {
                return 0.0;
            }
            case Anzahl4Bis6: {
                return 0.025;
            }
            case Anzahl7UndMehr: {
                return 0.05;
            }
        }
        throw new RuntimeException(this.getArbeitsobjekt().getAnzahlSortimente().name());
    }

    private double getReduktionErschwernisse() {
        switch (this.getArbeitsobjekt().getErschwernisse()) {
            case Keine: {
                return 0.0;
            }
            case Wenige: {
                return 0.05;
            }
            case Viele: {
                return 0.1;
            }
        }
        throw new RuntimeException(this.getArbeitsobjekt().getErschwernisse().name());
    }

    private double getReduktionAbstandR\u00fcckegassen() {
        switch (this.getArbeitsobjekt().getAbstandRueckegasse()) {
            case Circa40m: {
                return 0.0;
            }
            case Circa30m: {
                return 0.05;
            }
            case Circa20m: {
                return 0.15;
            }
        }
        throw new RuntimeException(this.getArbeitsobjekt().getAbstandRueckegasse().name());
    }

    private double getReduktionForwarderTyp() {
        switch (this.getArbeitssystem().getForwardertyp()) {
            case Mittel: {
                return 0.0;
            }
            case Gross: {
                return 0.2;
            }
        }
        throw new RuntimeException(this.getArbeitssystem().getForwardertyp().name());
    }

    private double getKfEnergieholz() {
        double bhd = this.getArbeitsobjekt().getBhdMit_cm();
        double forwardertyp = this.getArbeitssystem().getForwardertyp() == ArbeitssystemForwarder2018.Forwardertyp.Gross ? 1 : 0;
        double abstandRueckegasse = -1.0;
        switch (this.getArbeitsobjekt().getAbstandRueckegasse()) {
            case Circa40m: {
                abstandRueckegasse = 1.0;
                break;
            }
            case Circa30m: {
                abstandRueckegasse = 0.5;
                break;
            }
            case Circa20m: {
                abstandRueckegasse = 0.0;
                break;
            }
            default: {
                throw new RuntimeException(this.getArbeitsobjekt().getAbstandRueckegasse().name());
            }
        }
        double eholzanfall_proHa = this.getArbeitsobjekt().getEnergieholzanfall_m3iRproHa().getEnergieholzanfall_m3ProHa();
        double zopfdurchmesser = this.getArbeitsobjekt().getZopfdurchmesser_cm();
        double kf = (-0.005 * Math.pow(bhd, 2.0) + 0.469 * bhd + 0.089 * bhd * forwardertyp + 3.159 * abstandRueckegasse + 2.975) / (6.171 * Math.log(bhd) + 0.021 * eholzanfall_proHa + 0.268 * zopfdurchmesser - 15.586);
        return kf;
    }

    public ErgebnisAnzeige getErgebnisAnzeige() {
        return this.ergebnisAnzeige;
    }

    public void setErgebnisAnzeige(ErgebnisAnzeige ergebnisAnzeige) {
        this.ergebnisAnzeige = ergebnisAnzeige;
        this.rindenAbzugBeruecksichtigen = ergebnisAnzeige == ErgebnisAnzeige.Rundholz;
    }

    @Override
    public void setRindenAbzugBeruecksichtigen(boolean flag) {
        super.setRindenAbzugBeruecksichtigen(flag);
    }

    public static enum ErgebnisAnzeige {
        Rundholz("CalculatorForwarder2018.enumRundholz"),
        Energieholz("CalculatorForwarder2018.enumEnergieholz");

        private final String text;

        private ErgebnisAnzeige(String text) {
            this.text = text;
        }

        public String toString() {
            return ModelStrings.getString(this.text);
        }
    }
}

