/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.Ergebnis;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektForwarder;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemForwarder;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel;

public class CalculatorForwarder
extends AbstractCalculatorSingleModel {
    public CalculatorForwarder(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    public Ergebnis calculate() {
        Ergebnis ergebnis = super.calculate();
        this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.M3_IR_PRO_PMH15, ergebnis.getProduktivitaet_m3ProPmh15());
        return ergebnis;
    }

    @Override
    protected Ergebnis.ProdEinheit getProdEinheit1() {
        return Ergebnis.ProdEinheit.M3_PRO_PMH15;
    }

    @Override
    protected ArbeitsobjektForwarder getArbeitsobjekt() {
        return (ArbeitsobjektForwarder)super.getArbeitsobjekt();
    }

    @Override
    protected ArbeitssystemForwarder getArbeitssystem() {
        return (ArbeitssystemForwarder)super.getArbeitssystem();
    }

    private ArbeitsobjektForwarder ao() {
        return this.getArbeitsobjekt();
    }

    @Override
    protected double calcPsh0_hProM3() {
        double kf = this.getArbeitssystem().getForwarderTyp().getKF();
        double tR = this.getTR_min();
        double dLV = this.getDurchschnittlichesLastvolumen();
        double psh0 = tR * kf / (dLV * 60.0 * this.f_0bis15);
        return psh0;
    }

    private double getTR_min() {
        double f;
        double e;
        double d;
        double rpq = this.getRPQ();
        double dLV = this.getDurchschnittlichesLastvolumen();
        double dRPV = this.getDRPV();
        double dSR = this.ao().getDurchschnittlicheAnzahlSortimente();
        if (this.getArbeitssystem().getForwarderTyp() == ArbeitssystemForwarder.ForwarderTyp.Klein) {
            d = 0.35;
            e = 1.0;
            f = 0.5;
        } else if (this.getArbeitssystem().getForwarderTyp() == ArbeitssystemForwarder.ForwarderTyp.Mittel) {
            d = 0.2;
            e = 0.35;
            f = 0.4;
        } else {
            throw new RuntimeException();
        }
        double tTL = ((d + 0.2 * rpq) / dRPV + e) * dLV;
        double tTE = (f - 0.1 * dSR + 0.1 * Math.pow(dSR, 2.0)) * dLV;
        double nt = this.ao().getHolzmenge_m3();
        double nrp = nt / dRPV;
        double ste = (double)this.ao().getErschliessungsLaengeEinseitig_m() * ((double)this.ao().getErschliessungsLaengeEinseitigAnteilStrasse_Prz() / 100.0);
        double stb = (double)this.ao().getErschliessungsLaengeBeidseitig_m() * ((double)this.ao().getErschliessungsLaengeBeidseitigAnteilStrasse_Prz() / 100.0);
        double ee = this.ao().getErschliessungsLaengeEinseitig_m();
        double eb = this.ao().getErschliessungsLaengeBeidseitig_m();
        double so = this.ao().getAnzahlVerschiedeneSortimente();
        double srp = (ee + eb) / nrp;
        double sFL = dLV * so * srp / (dRPV * dSR);
        double stPFL = (ste + stb) / (ee + eb);
        double sstLEaf = (double)(this.ao().getFahrstreckeAufStrasse() * this.ao().getFahrstreckenAnteilStrasseLeerfahrtAufwaerts_Prz()) / 100.0;
        double sstLEab = (double)(this.ao().getFahrstreckeAufStrasse() * this.ao().getFahrstreckenAnteilStrasseLeerfahrtAbwaerts_Prz()) / 100.0;
        double sstLEeb = (double)this.ao().getFahrstreckeAufStrasse() - sstLEaf - sstLEab;
        double sstLAaf = (double)(this.ao().getFahrstreckeAufStrasse() * this.ao().getFahrstreckenAnteilStrasseLastfahrtAufwaerts_Prz()) / 100.0;
        double sstLAab = (double)(this.ao().getFahrstreckeAufStrasse() * this.ao().getFahrstreckenAnteilStrasseLastfahrtAbwaerts_Prz()) / 100.0;
        double sstLAeb = (double)this.ao().getFahrstreckeAufStrasse() - sstLAaf - sstLAab;
        double sstFL = sFL * stPFL;
        double srmLEaf = (double)(this.ao().getFahrstreckeAufFeinerschliessung() * this.ao().getFahrstreckenAnteilFeinerschliessungLeerfahrtAufwaerts_Prz()) / 100.0;
        double srmLEab = (double)(this.ao().getFahrstreckeAufFeinerschliessung() * this.ao().getFahrstreckenAnteilFeinerschliessungLeerfahrtAbwaerts_Prz()) / 100.0;
        double srmLEeb = (double)this.ao().getFahrstreckeAufFeinerschliessung() - srmLEaf - srmLEab;
        double srmLAaf = (double)(this.ao().getFahrstreckeAufFeinerschliessung() * this.ao().getFahrstreckenAnteilFeinerschliessungLastfahrtAufwaerts_Prz()) / 100.0;
        double srmLAab = (double)(this.ao().getFahrstreckeAufFeinerschliessung() * this.ao().getFahrstreckenAnteilFeinerschliessungLastfahrtAbwaerts_Prz()) / 100.0;
        double srmLAeb = (double)this.ao().getFahrstreckeAufFeinerschliessung() - srmLAaf - srmLAab;
        double srmFL = sFL - sstFL;
        double srmFLaf = srmFL * (double)this.ao().getFahrstreckenAnteilFeinerschliessungFahrenBeimLadenAufwaerts_Prz() / 100.0;
        double srmFLab = srmFL * (double)this.ao().getFahrstreckenAnteilFeinerschliessungFahrenBeimLadenAbwaerts_Prz() / 100.0;
        double srmFLeb = srmFL - srmFLaf - srmFLab;
        double vStLEaf = 126.45 + 0.314 * sstLEaf;
        vStLEaf = vStLEaf > 200.0 ? 200.0 : vStLEaf;
        double vStLEab = 126.45 + 0.314 * sstLEab;
        vStLEab = vStLEab > 200.0 ? 200.0 : vStLEab;
        double vStLEeb = 126.45 + 0.314 * sstLEeb;
        vStLEeb = vStLEeb > 200.0 ? 200.0 : vStLEeb;
        double dtStLEaf = sstLEaf / vStLEaf;
        double dtStLEab = sstLEab / vStLEab;
        double dtStLEeb = sstLEeb / vStLEeb;
        double vStLAab = 69.1 + 0.8 * sstLAab;
        vStLAab = vStLAab > 200.0 ? 200.0 : vStLAab;
        double vStLAeb = 69.1 + 0.8 * sstLAeb;
        vStLAeb = vStLAeb > 200.0 ? 200.0 : vStLAeb;
        double dtStLAaf = sstLAaf / 62.0;
        double dtStLAab = sstLAab / vStLAab;
        double dtStLAeb = sstLAeb / vStLAeb;
        double tStFL = sstFL / 60.0;
        double tStLE = dtStLEaf + dtStLEab + dtStLEeb;
        double tStLA = dtStLAaf + dtStLAab + dtStLAeb;
        double cGy = 11.0;
        double cGx = 22.0;
        double cGz = 7.5;
        double bg = 89.0;
        double hk = this.ao().getHindernisKategorieFeinerschliessung().value();
        double gk = this.ao().getNeigungsKategorieFeinerschliessung().value();
        double vRMaf = bg - cGx * (hk - 1.0) - cGy * (gk - 1.0);
        double vRMab = bg - cGx * (hk - 1.0) + cGz * (gk - 1.0);
        double vRMeb = bg - cGx * (hk - 1.0);
        double vRMLEaf = vRMaf * 1.0;
        vRMLEaf = vRMLEaf < 15.0 ? 15.0 : vRMLEaf;
        double vRMLEab = vRMab * 1.0;
        vRMLEab = vRMLEab < 15.0 ? 15.0 : vRMLEab;
        double vRMLEeb = vRMeb * 1.0;
        vRMLEeb = vRMLEeb < 15.0 ? 15.0 : vRMLEeb;
        double vRMFLaf = vRMaf * 0.5;
        vRMFLaf = vRMFLaf < 15.0 ? 15.0 : vRMFLaf;
        double vRMFLab = vRMab * 0.5;
        vRMFLab = vRMFLab < 15.0 ? 15.0 : vRMFLab;
        double vRMFLeb = vRMeb * 0.5;
        vRMFLeb = vRMFLeb < 15.0 ? 15.0 : vRMFLeb;
        double vRMLAaf = vRMaf * 0.64;
        vRMLAaf = vRMLAaf < 15.0 ? 15.0 : vRMLAaf;
        double vRMLAab = vRMab * 0.64;
        vRMLAab = vRMLAab < 15.0 ? 15.0 : vRMLAab;
        double vRMLAeb = vRMeb * 0.64;
        vRMLAeb = vRMLAeb < 15.0 ? 15.0 : vRMLAeb;
        double dtRMFLaf = srmFLaf / vRMFLaf;
        double dtRMFLab = srmFLab / vRMFLab;
        double dtRMFLeb = srmFLeb / vRMFLeb;
        double dtRMLEaf = srmLEaf / vRMLEaf;
        double dtRMLEab = srmLEab / vRMLEab;
        double dtRMLEeb = srmLEeb / vRMLEeb;
        double dtRMLAaf = srmLAaf / vRMLAaf;
        double dtRMLAab = srmLAab / vRMLAab;
        double dtRMLAeb = srmLAeb / vRMLAeb;
        double tRMFL = dtRMFLaf + dtRMFLab + dtRMFLeb;
        double tRMLE = dtRMLEaf + dtRMLEab + dtRMLEeb;
        double tRMLA = dtRMLAaf + dtRMLAab + dtRMLAeb;
        double tRM = tRMFL + tRMLE + tRMLA;
        double tSt = tStFL + tStLE + tStLA;
        double tF = tRM + tSt;
        double tR = tTL + tTE + tF;
        return tR;
    }

    private double getRPQ() {
        double nhp = (double)this.ao().getNadelholzAnteil_Prz() / 100.0;
        double lhp = (double)this.ao().getLaubholzAnteil_Prz() / 100.0;
        double ev = this.getEv();
        double dBHD_cm = this.ao().getDurchschnittlicherBhdAushieb_cm();
        double rpq = -0.01237798 * dBHD_cm + 0.349602 * ev + 0.999837 * nhp + 1.12327 * lhp;
        if (rpq > 1.0) {
            rpq = 1.0;
        }
        return rpq;
    }

    private double getDRPV() {
        double ev = this.getEv();
        double dBHD_cm = this.ao().getDurchschnittlicherBhdAushieb_cm();
        double dRPV = 0.024657 * dBHD_cm + 1.0644 * ev - 0.319737;
        return dRPV;
    }

    private double getEv() {
        double ee = this.ao().getErschliessungsLaengeEinseitig_m();
        double eb = this.ao().getErschliessungsLaengeBeidseitig_m();
        double nt = this.ao().getHolzmenge_m3();
        double ev = 2.0 * nt / (ee + 2.0 * eb);
        return ev;
    }

    private double getDurchschnittlichesLastvolumen() {
        double lq = this.getArbeitssystem().getLadeQuerschnittsFlaeche_m2();
        double s = 2 * (this.ao().getFahrstreckeAufStrasse() + this.ao().getFahrstreckeAufFeinerschliessung());
        double dBH = s < 200.0 ? 0.85 : (s <= 800.0 ? 0.9 : 0.95);
        double nt = this.ao().getHolzmenge_m3();
        double dHL = this.ao().getDurchschnittlicheHolzlaenge_m();
        double lhk = nt * ((double)this.ao().getLaubholzAnteil_Prz() / 100.0) * ((double)this.ao().getAnteilKrumm_Prz() / 100.0);
        double lhg = nt * ((double)this.ao().getLaubholzAnteil_Prz() / 100.0) - lhk;
        double nhk = nt * ((double)this.ao().getNadelholzAnteil_Prz() / 100.0) * ((double)this.ao().getAnteilKrumm_Prz() / 100.0);
        double nhg = nt * ((double)this.ao().getNadelholzAnteil_Prz() / 100.0) - nhk;
        double dUF = (0.53 * lhk + 0.59 * nhg + 0.57 * (lhg + nhk)) / nt;
        double dLV = lq * dBH * dHL * dUF;
        return dLV;
    }

    @Override
    protected double getLaufzeitAnteilMaschine() {
        return 1.0;
    }
}

