/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektFaellenMotormanuell;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektMotormanuell;
import ch.wsl.fps.hepromo.model.calc.CalculatorMotormanuell;

public class CalculatorFaellenMotormanuell
extends CalculatorMotormanuell {
    public CalculatorFaellenMotormanuell(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    protected ArbeitsobjektFaellenMotormanuell getArbeitsobjekt() {
        return (ArbeitsobjektFaellenMotormanuell)super.getArbeitsobjekt();
    }

    @Override
    protected double getM5() {
        switch (this.getArbeitsobjekt().getHangneigung()) {
            case Hangneigung_0bis30: {
                return 1.0;
            }
            case Hangneigung_31bis50: {
                return 1.05;
            }
            case Hangneigung_51bis70: {
                return 1.1;
            }
            case Hangneigung_71bis100: {
                return 1.25;
            }
        }
        throw new RuntimeException();
    }

    @Override
    protected double getA2() {
        double anteilFaellenMitHandseilzug = this.getArbeitsobjekt().getAnteilFaellenHandseilzug_Prz() / 100.0;
        double massenmittelstamm_m3oR = this.getArbeitsobjekt().getMassenmittelstamm_m3iR() * super.getUmrechnungsfaktorVoR_ViR(this.getArbeitsobjekt().getBaumartenGruppe());
        double result = -1.0;
        result = anteilFaellenMitHandseilzug < 0.1 ? anteilFaellenMitHandseilzug / massenmittelstamm_m3oR * 16.0 : (anteilFaellenMitHandseilzug < 0.5 ? anteilFaellenMitHandseilzug / massenmittelstamm_m3oR * (16.0 - 0.2 * (anteilFaellenMitHandseilzug * 100.0 - 10.0)) : anteilFaellenMitHandseilzug / massenmittelstamm_m3oR * 8.0);
        return result;
    }

    @Override
    protected double[] getKoeffizienten(ArbeitsobjektMotormanuell.Baumartgruppe baGruppe) {
        switch (baGruppe) {
            case Fichte: 
            case Tanne: {
                return new double[]{2.0, 2.4291, -0.1596, -0.9108};
            }
            case Foehre_Laerche: {
                return new double[]{2.0, 2.4236, -0.1602, -1.2105};
            }
            case Laubholz: {
                return new double[]{0.00236, 6.9216, -0.0634, 1.0};
            }
        }
        throw new RuntimeException();
    }

    @Override
    protected double getLaufzeitAnteilMaschine() {
        switch (this.getArbeitsobjekt().getBaumartenGruppe()) {
            case Fichte: 
            case Tanne: {
                return 0.48;
            }
            case Foehre_Laerche: {
                return 0.54;
            }
            case Laubholz: {
                return 0.61;
            }
        }
        throw new RuntimeException();
    }
}

