/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.Ergebnis;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculator;

public abstract class AbstractCalculatorSingleModel
extends AbstractCalculator {
    protected double f_stoer = 1.0;
    protected double f_0bis15 = 1.1;
    protected double f_indir = 1.1;
    protected double f_wegzeitenUndPausen;

    public AbstractCalculatorSingleModel(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    public Ergebnis calculate() {
        this.f_wegzeitenUndPausen = this.getArbeitssystem().getFaktorWegzeitenUndPausen();
        Ergebnis ergebnis = this.getNewErgebnisInstance();
        double holzmenge = this.getRelevanteHolzmenge();
        if (holzmenge > 0.0) {
            double psh0_hProM3 = this.calcPsh0_hProM3();
            double psh0_total = psh0_hProM3 * holzmenge;
            double anzahlPersonen_fte = this.getAnzahlPersonalVollzeitAequivalente();
            double psh15 = psh0_total * this.f_0bis15;
            double wsh = psh15 * this.f_indir;
            double wpsh = wsh * this.f_wegzeitenUndPausen * this.f_stoer;
            if (anzahlPersonen_fte < 1.0) {
                wpsh *= anzahlPersonen_fte;
            }
            double pph0 = anzahlPersonen_fte * psh0_total;
            double pph15 = pph0 * this.f_0bis15;
            double wph = pph15 * this.f_indir;
            double wpph = wph * this.f_wegzeitenUndPausen * this.f_stoer;
            int anzahl_maschinen = this.getAnzahlMaschinen();
            double maschinen_laufzeitanteil = this.getLaufzeitAnteilMaschine();
            double pmh0 = (double)anzahl_maschinen * psh0_total * maschinen_laufzeitanteil;
            double pmh15 = pmh0 * this.f_0bis15;
            double kf = this.faktoren.getKorrekturFaktor();
            wpph *= kf;
            pmh15 *= kf;
            psh15 *= kf;
            wpsh *= kf;
            ergebnis.setPsh0_hProM3(psh0_hProM3);
            ergebnis.setPsh0_total(psh0_total);
            ergebnis.setZeitPersonal(wpph);
            ergebnis.setZeitMaschine1(pmh15);
            ergebnis.setZeitUmsetzen(this.getArbeitssystem().getUmsetzenZeit_h());
            ergebnis.setZeitWeitereAufwaende(this.getArbeitssystem().getWeitereAufwaendeZeit_h());
            ergebnis.setZeitTotal(wpsh);
            ergebnis.setKostenPersonal_total(this.getArbeitssystem().getAnsatzPersonalKombiniertGewichtet() * wpph);
            ergebnis.setKostenMaschine1_total(this.getArbeitssystem().getKostensatzMaschine1_proH() * ergebnis.getZeitMaschine1());
            ergebnis.setKostenUmsetzen_total(this.getArbeitssystem().getUmsetzenBetrag_CHF());
            ergebnis.setKostenWeitereAufwaende_total(this.getArbeitssystem().getWeitereAufwaendeBetrag_CHF());
            this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.M3_PRO_PSH15, holzmenge / psh15);
            this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.M3_PRO_PMH15, holzmenge / pmh15);
            this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.FM_OR_PRO_WPPH, holzmenge / wpph);
            ergebnis.setAnzahl_m3(holzmenge);
        }
        ergebnis.setRisikoVerwaltungGewinn_Prz(this.faktoren.getMargin());
        ergebnis.setMehrwertsteuer_Prz(this.faktoren.getMehrwertsteuer());
        ergebnis.setLabelPersonal1(this.getArbeitssystem().getLabelPersonal1());
        ergebnis.setLabelMaschine1(this.getArbeitssystem().getLabelMaschine1());
        ergebnis.setLabelMaschine2(this.getArbeitssystem().getLabelMaschine2());
        return ergebnis;
    }

    protected Ergebnis getNewErgebnisInstance() {
        return new Ergebnis();
    }

    protected double getAnzahlPersonalVollzeitAequivalente() {
        return 1.0;
    }

    protected abstract double calcPsh0_hProM3();

    protected abstract double getLaufzeitAnteilMaschine();

    protected int getAnzahlMaschinen() {
        return 1;
    }

    protected double getRelevanteHolzmenge() {
        return this.rindenAbzugBeruecksichtigen ? this.getArbeitsobjekt().getHolzmenge_m3() * this.getArbeitsobjekt().getRindenAbzugFaktor() : this.getArbeitsobjekt().getHolzmenge_m3();
    }

    public double getFaktorStoerungen() {
        return this.f_stoer;
    }

    public double getFaktorVerlusteBis15min() {
        return this.f_0bis15;
    }

    public double getFaktorIndirekteArbeitszeit() {
        return this.f_indir;
    }

    public void setFaktorStoerzeiten(double value) {
        this.f_stoer = value;
    }

    public void setFaktorIndirekteArbeitszeit(double value) {
        this.f_indir = value;
    }
}

