/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.asys;

import ch.wsl.fps.hepromo.model.LabelValuePairList;
import ch.wsl.fps.hepromo.model.asys.Arbeitssystem;
import java.text.DecimalFormat;

public class ArbeitssystemRadharvester
extends Arbeitssystem {
    private static final long serialVersionUID = 1L;
    private MaschinenKategorie maschinenKategorie;
    private MaschinenTyp maschinenTyp;

    public MaschinenKategorie getMaschinenKategorie() {
        return this.maschinenKategorie;
    }

    public void setMaschinenKategorie(MaschinenKategorie maschinenKategorie) {
        this.maschinenKategorie = maschinenKategorie;
    }

    public MaschinenTyp getMaschinenTyp() {
        return this.maschinenTyp;
    }

    public void setMaschinenTyp(MaschinenTyp maschinenTyp) {
        this.maschinenTyp = maschinenTyp;
    }

    @Override
    public LabelValuePairList getLabelValuePairList(DecimalFormat decimalFormat, String waehrung) {
        LabelValuePairList list = super.getLabelValuePairList(decimalFormat, waehrung);
        list.add("Maschinenkategorie", this.maschinenKategorie);
        list.add("Maschinentyp", this.maschinenTyp);
        return list;
    }

    public static enum MaschinenKategorie {
        Mittel,
        Gross;


        public String toString() {
            switch (this) {
                case Mittel: {
                    return "mittel";
                }
                case Gross: {
                    return "gross";
                }
            }
            throw new RuntimeException();
        }
    }

    public static enum MaschinenTyp {
        Standard_mittel(MaschinenKategorie.Mittel, 45, "Standardwert - mittel"),
        Oesa(MaschinenKategorie.Mittel, 45, "\u00d6sa SuperEVA - FMG 746"),
        Silvatec854(MaschinenKategorie.Mittel, 51, "Silvatec 854 TH - Silvatec 235"),
        Timberjack870A(MaschinenKategorie.Mittel, 45, "Timberjack 870 - TJ 743"),
        Timberjack870B(MaschinenKategorie.Mittel, 45, "Timberjack 870B - TJ 743C"),
        Valmet9014(MaschinenKategorie.Mittel, 52, "Valmet 901/4 - Valmet 984"),
        Valmet9016(MaschinenKategorie.Mittel, 44, "Valmet 901/6 - Valmet 942"),
        Standard_gross(MaschinenKategorie.Gross, 60, "Standardwert - gross"),
        FMG(MaschinenKategorie.Gross, 45, "FMG Lokomo 990 - FMG 746"),
        Hemek(MaschinenKategorie.Gross, 55, "Hemek 880 - Woodking 550"),
        Herma(MaschinenKategorie.Gross, 46, "Herma 2010 - SP 550"),
        Ponsse(MaschinenKategorie.Gross, 60, "Ponsse Ergo HS 16 - Ponsse H60"),
        Silvatec866(MaschinenKategorie.Gross, 56, "Silvatec 866 TH - Silvatec 445 MD 5"),
        Skogsjan(MaschinenKategorie.Gross, 55, "Skogsjan 687 XL - Skogsjan 601 XL"),
        Timberjack1270A(MaschinenKategorie.Gross, 50, "Timberjack 1270 - TJ 746C"),
        Timberjack1270B(MaschinenKategorie.Gross, 60, "Timberjack 1270 - TJ 755"),
        Valmet911(MaschinenKategorie.Gross, 45, "Valmet 911 - PAN 728");

        private final MaschinenKategorie mKat;
        private final int maxFaellDrm_cm;
        private final String fullName;

        private MaschinenTyp(MaschinenKategorie mKat, int maxFaellDrm_cm, String fullName) {
            this.mKat = mKat;
            this.maxFaellDrm_cm = maxFaellDrm_cm;
            this.fullName = fullName;
        }

        public MaschinenKategorie getMaschinenKategorie() {
            return this.mKat;
        }

        public int getMaxFaellDrm_cm() {
            return this.maxFaellDrm_cm;
        }

        public String toString() {
            return this.fullName;
        }

        public double[] getTechnologieFaktoren() {
            switch (this) {
                case FMG: {
                    return new double[]{114.0, 10.2, 155.0, 30.0, 45.0, 21.0};
                }
                case Hemek: {
                    return new double[]{147.0, 10.2, 100.0, 38.0, 55.0, 19.0};
                }
                case Herma: {
                    return new double[]{150.0, 10.7, 170.0, 30.0, 46.0, 21.0};
                }
                case Oesa: {
                    return new double[]{99.5, 9.5, 125.0, 29.0, 45.0, 21.0};
                }
                case Ponsse: {
                    return new double[]{157.0, 10.0, 190.0, 27.0, 60.0, 24.0};
                }
                case Silvatec854: {
                    return new double[]{119.0, 9.4, 72.0, 20.6, 51.0, 18.0};
                }
                case Silvatec866: {
                    return new double[]{160.0, 10.0, 168.0, 28.9, 56.0, 11.0};
                }
                case Skogsjan: {
                    return new double[]{158.0, 10.0, 180.0, 28.9, 55.0, 22.0};
                }
                case Standard_gross: {
                    return new double[]{156.0, 10.0, 168.0, 39.3, 60.0, 24.0};
                }
                case Standard_mittel: {
                    return new double[]{113.0, 10.0, 125.0, 38.4, 45.0, 17.0};
                }
                case Timberjack1270A: {
                    return new double[]{114.0, 10.3, 147.0, 31.0, 50.0, 21.0};
                }
                case Timberjack1270B: {
                    return new double[]{156.0, 10.0, 168.0, 39.3, 60.0, 24.0};
                }
                case Timberjack870A: {
                    return new double[]{112.0, 10.1, 102.0, 26.0, 45.0, 16.0};
                }
                case Timberjack870B: {
                    return new double[]{113.0, 10.0, 125.0, 38.4, 45.0, 17.0};
                }
                case Valmet9014: {
                    return new double[]{83.0, 9.4, 98.0, 22.6, 52.0, 20.0};
                }
                case Valmet9016: {
                    return new double[]{83.0, 9.5, 81.0, 30.2, 44.0, 15.0};
                }
                case Valmet911: {
                    return new double[]{130.0, 9.2, 145.0, 32.0, 45.0, 21.0};
                }
            }
            throw new RuntimeException();
        }
    }
}

