/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.asys;

import ch.wsl.fps.hepromo.model.LabelValuePairList;
import ch.wsl.fps.hepromo.model.ModelStrings;
import ch.wsl.fps.hepromo.model.asys.Arbeitssystem;
import java.io.Serializable;
import java.text.DecimalFormat;

public class ArbeitssystemHacker2018
extends Arbeitssystem {
    public static final HackerMotorleistung HACKER_KW_100_BIS_199 = new HackerMotorleistung(100, 150, 199, false);
    public static final HackerMotorleistung HACKER_KW_200_BIS_299 = new HackerMotorleistung(200, 250, 299, false);
    public static final HackerMotorleistung HACKER_KW_300_BIS_399 = new HackerMotorleistung(300, 350, 399, false);
    public static final HackerMotorleistung HACKER_KW_400_BIS_499 = new HackerMotorleistung(400, 450, 499, false);
    public final HackerMotorleistung HACKER_BENUTZERDEFINIERT = new HackerMotorleistung(-1, 100, -1, true);
    private static final long serialVersionUID = 1L;
    private HackerMotorleistung hackerMotorleistung;
    private boolean displayHackerKostenProPMH15;
    private HackerMotorleistung[] allHackerMotorleistung = new HackerMotorleistung[]{HACKER_KW_100_BIS_199, HACKER_KW_200_BIS_299, HACKER_KW_300_BIS_399, HACKER_KW_400_BIS_499, this.HACKER_BENUTZERDEFINIERT};

    public HackerMotorleistung getHackerMotorleistung() {
        return this.hackerMotorleistung;
    }

    public void setHackerMotorleistung(HackerMotorleistung hackerMotorleistung) {
        this.hackerMotorleistung = hackerMotorleistung;
    }

    public boolean isDisplayHackerKostenProPMH15() {
        return this.displayHackerKostenProPMH15;
    }

    public void setDisplayHackerKostenProPMH15(boolean displayHackerKostenProPMH15) {
        this.displayHackerKostenProPMH15 = displayHackerKostenProPMH15;
    }

    public HackerMotorleistung[] getAllHackerMotorleistung() {
        return this.allHackerMotorleistung;
    }

    public void setAllHackerMotorleistung(HackerMotorleistung[] allHackerMotorleistung) {
        this.allHackerMotorleistung = allHackerMotorleistung;
    }

    public static HackerMotorleistung getBenutzerdefinierteHackerMotorleistung(int motorleistung_kW) {
        return new HackerMotorleistung(-1, motorleistung_kW, -1, true);
    }

    @Override
    public LabelValuePairList getLabelValuePairList(DecimalFormat decimalFormat, String waehrung) {
        LabelValuePairList list = super.getLabelValuePairList(decimalFormat, waehrung);
        list.addOnTop(ModelStrings.getString("ArbeitssystemHacker2018.HackerMotorleistung"), this.hackerMotorleistung.toString());
        return list;
    }

    public static class HackerMotorleistung
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int motorleistungMin_kW;
        private int motorleistungCalc_kW;
        private int motorleistungMax_kW;
        private boolean wasChanged = false;
        private final boolean benutzerdefiniert;

        private HackerMotorleistung(int motorleistungMin_kW, int motorleistungCalc_kW, int motorleistungMax_kW, boolean benutzerdefiniert) {
            this.motorleistungMin_kW = motorleistungMin_kW;
            this.motorleistungCalc_kW = motorleistungCalc_kW;
            this.motorleistungMax_kW = motorleistungMax_kW;
            this.benutzerdefiniert = benutzerdefiniert;
        }

        public String toString() {
            if (this.isBenutzerdefiniert()) {
                if (this.wasChanged) {
                    return String.valueOf(ModelStrings.getString("ArbeitssystemHacker2018.enumBenutzerdefiniert")) + " (" + this.motorleistungCalc_kW + " kW)";
                }
                return ModelStrings.getString("ArbeitssystemHacker2018.enumBenutzerdefiniert");
            }
            return String.valueOf(this.motorleistungMin_kW) + " - " + this.motorleistungMax_kW + " kW";
        }

        public int getMotorleistungCalc_Kw() {
            return this.motorleistungCalc_kW;
        }

        public boolean isBenutzerdefiniert() {
            return this.benutzerdefiniert;
        }

        public void setMotorleistungCalc_Kw(int value) {
            if (!this.benutzerdefiniert) {
                throw new RuntimeException("Leistung kann nicht ver\u00e4ndert werden.");
            }
            this.wasChanged = true;
            this.motorleistungCalc_kW = value;
        }
    }
}

