/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.aobj;

import ch.wsl.fps.hepromo.model.LabelValuePairList;
import ch.wsl.fps.hepromo.model.ModelStrings;
import ch.wsl.fps.hepromo.model.aobj.Arbeitsobjekt;
import java.io.Serializable;
import java.text.DecimalFormat;

public class ArbeitsobjektSchlepper2014
extends Arbeitsobjekt {
    private static final long serialVersionUID = 1L;
    private double mittlererStueckinhalt;
    private MittlereFahrentfernung mittlereFahrentfernung;
    private BeizugsdistanzArrayWithSelection beizugsdistanzArrayWithSelection = new BeizugsdistanzArrayWithSelection();

    public double getMittlererStueckinhalt() {
        return this.mittlererStueckinhalt;
    }

    public void setMittlererStueckinhalt(double mittlererStueckinhalt) {
        this.mittlererStueckinhalt = mittlererStueckinhalt;
    }

    public MittlereFahrentfernung getMittlereFahrentfernung() {
        return this.mittlereFahrentfernung;
    }

    public void setMittlereFahrentfernung(MittlereFahrentfernung mittlereFahrentfernung) {
        this.mittlereFahrentfernung = mittlereFahrentfernung;
    }

    public BeizugsdistanzArrayWithSelection getBeizugsdistanzArrayWithSelection() {
        return this.beizugsdistanzArrayWithSelection;
    }

    public void setBeizugsdistanzArrayWithSelection(BeizugsdistanzArrayWithSelection beizugsdistanzArrayWithSelection) {
        this.beizugsdistanzArrayWithSelection = beizugsdistanzArrayWithSelection;
    }

    @Override
    public LabelValuePairList getLabelValuePairList(DecimalFormat decimalFormat) {
        LabelValuePairList list = super.getLabelValuePairList(decimalFormat);
        list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.ArbeitsobjektSchlepper2014_MittlererStueckinhalt, this.mittlererStueckinhalt);
        list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.ArbeitsobjektSchlepper2014_MittlereFahrentfernung, this.mittlereFahrentfernung);
        list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.ArbeitsobjektSchlepper2014_ZuschlagBeizugsdistanz, this.beizugsdistanzArrayWithSelection.getSelection().toString());
        return list;
    }

    public double getGesamtfaktorAllerZuschlaege() {
        double result = 1.0 + this.beizugsdistanzArrayWithSelection.getSelection().getWert();
        return result;
    }

    @Override
    protected double getRindenAbzugFaktorBerechnet() {
        return 0.89;
    }

    public static class Beizugsdistanz
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final DecimalFormat df = new DecimalFormat("+#.## %;-#.## %");
        private static final int Bis20m = 0;
        private static final int Von20bis40m = 1;
        private static final int Ueber40m = 2;
        private static final int Benutzerdefiniert = 3;
        private int name;
        private boolean wasChanged = false;
        private double wert = 0.0;

        public static Beizugsdistanz[] getNewArrayWithAllValues() {
            return new Beizugsdistanz[]{new Beizugsdistanz(0, 0.0), new Beizugsdistanz(1, -0.1), new Beizugsdistanz(2, -0.2), new Beizugsdistanz(3, 0.0)};
        }

        private Beizugsdistanz(int name, double wert) {
            this.name = name;
            this.wert = wert;
        }

        public boolean isBenutzerdefiniert() {
            return this.name == 3;
        }

        public double getWert() {
            return this.wert;
        }

        public void setWert(double wert) {
            if (!this.isBenutzerdefiniert() || wert < -0.50001 || wert > 1.0E-5) {
                throw new RuntimeException();
            }
            this.wasChanged = true;
            this.wert = wert;
        }

        public String toString() {
            switch (this.name) {
                case 0: {
                    return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektSchlepper2014_BeizugBis20m) + " (" + this.df.format(this.getWert()) + ")".toString();
                }
                case 1: {
                    return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektSchlepper2014_Beizug20bis40m) + " (" + this.df.format(this.getWert()) + ")".toString();
                }
                case 2: {
                    return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektSchlepper2014_BeizugUeber40m) + " (" + this.df.format(this.getWert()) + ")".toString();
                }
                case 3: {
                    if (this.wasChanged) {
                        return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektSchlepper2014_benutzerdefiniert) + " (" + this.df.format(this.getWert()) + ")".toString();
                    }
                    return ModelStrings.PdfLabels.ArbeitsobjektSchlepper2014_benutzerdefiniert.toString();
                }
            }
            throw new RuntimeException();
        }
    }

    public static class BeizugsdistanzArrayWithSelection
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Beizugsdistanz[] allValues = Beizugsdistanz.getNewArrayWithAllValues();
        private Beizugsdistanz selection = this.allValues[0];

        public Beizugsdistanz getSelection() {
            return this.selection;
        }

        public void setSelection(Beizugsdistanz selection) {
            if (this.allValues[0] != selection && this.allValues[1] != selection && this.allValues[2] != selection && this.allValues[3] != selection) {
                throw new RuntimeException();
            }
            this.selection = selection;
        }
    }

    public static enum MittlereFahrentfernung {
        EntfBis300m,
        Entf301bis500m,
        Entf501bis700m,
        Entf701bis900m,
        EntfUeber900m;


        public String toString() {
            switch (this) {
                case EntfBis300m: {
                    return ModelStrings.PdfLabels.ArbeitsobjektSchlepper2014_EntfernungBis300m.toString();
                }
                case Entf301bis500m: {
                    return ModelStrings.PdfLabels.ArbeitsobjektSchlepper2014_Entfernung301bis500m.toString();
                }
                case Entf501bis700m: {
                    return ModelStrings.PdfLabels.ArbeitsobjektSchlepper2014_Entfernung501bis700m.toString();
                }
                case Entf701bis900m: {
                    return ModelStrings.PdfLabels.ArbeitsobjektSchlepper2014_Entfernung701bis900m.toString();
                }
                case EntfUeber900m: {
                    return ModelStrings.PdfLabels.ArbeitsobjektSchlepper2014_EntfernungUeber900m.toString();
                }
            }
            throw new RuntimeException();
        }

        public int value() {
            switch (this) {
                case EntfBis300m: {
                    return 1;
                }
                case Entf301bis500m: {
                    return 2;
                }
                case Entf501bis700m: {
                    return 3;
                }
                case Entf701bis900m: {
                    return 4;
                }
                case EntfUeber900m: {
                    return 5;
                }
            }
            throw new RuntimeException();
        }

        public static MittlereFahrentfernung parseDouble(double value) {
            if (value <= 300.0) {
                return EntfBis300m;
            }
            if (value <= 500.0) {
                return Entf301bis500m;
            }
            if (value <= 700.0) {
                return Entf501bis700m;
            }
            if (value <= 900.0) {
                return Entf701bis900m;
            }
            return EntfUeber900m;
        }
    }
}

