/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.aobj;

import ch.wsl.fps.hepromo.model.LabelValuePairList;
import ch.wsl.fps.hepromo.model.ModelStrings;
import ch.wsl.fps.hepromo.model.aobj.Arbeitsobjekt;
import java.io.Serializable;
import java.text.DecimalFormat;

public class ArbeitsobjektRadharvester2014
extends Arbeitsobjekt {
    private static final long serialVersionUID = 1L;
    private int bhd_cm;
    private FoermigkeitArrayWithSelection foermigkeitArrayWithSelection = new FoermigkeitArrayWithSelection();
    private LaubholzAnteilArrayWithSelection laubholzAnteilArrayWithSelection = new LaubholzAnteilArrayWithSelection();
    private LiegendesHolzArrayWithSelection liegendesHolzArrayWithSelection = new LiegendesHolzArrayWithSelection();

    public int getBhd_cm() {
        return this.bhd_cm;
    }

    public void setBhd_cm(int bhd_cm) {
        this.bhd_cm = bhd_cm;
    }

    public FoermigkeitArrayWithSelection getFoermigkeitArrayWithSelection() {
        return this.foermigkeitArrayWithSelection;
    }

    public void setFoermigkeitArrayWithSelection(FoermigkeitArrayWithSelection foermigkeitArrayWithSelection) {
        this.foermigkeitArrayWithSelection = foermigkeitArrayWithSelection;
    }

    public LaubholzAnteilArrayWithSelection getLaubholzAnteilArrayWithSelection() {
        return this.laubholzAnteilArrayWithSelection;
    }

    public void setLaubholzAnteilArrayWithSelection(LaubholzAnteilArrayWithSelection laubholzAnteilArrayWithSelection) {
        this.laubholzAnteilArrayWithSelection = laubholzAnteilArrayWithSelection;
    }

    public LiegendesHolzArrayWithSelection getLiegendesHolzArrayWithSelection() {
        return this.liegendesHolzArrayWithSelection;
    }

    public void setLiegendesHolzArrayWithSelection(LiegendesHolzArrayWithSelection liegendesHolzArrayWithSelection) {
        this.liegendesHolzArrayWithSelection = liegendesHolzArrayWithSelection;
    }

    @Override
    public LabelValuePairList getLabelValuePairList(DecimalFormat decimalFormat) {
        LabelValuePairList list = super.getLabelValuePairList(decimalFormat);
        list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_BHD_cm, this.bhd_cm);
        list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_ZuschlagFoermigkeit, this.foermigkeitArrayWithSelection.getSelection().toString());
        list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_ZuschlagAnteilLaubholz, this.laubholzAnteilArrayWithSelection.getSelection().toString());
        list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_ZuschlagLiegendesHolz, this.liegendesHolzArrayWithSelection.getSelection().toString());
        return list;
    }

    public double getGesamtfaktorAllerZuschlaege() {
        double result = 1.0 + this.foermigkeitArrayWithSelection.getSelection().getWert() + this.laubholzAnteilArrayWithSelection.getSelection().getWert() + this.liegendesHolzArrayWithSelection.getSelection().getWert();
        return result;
    }

    @Override
    protected double getRindenAbzugFaktorBerechnet() {
        return 0.89;
    }

    public static class Foermigkeit
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final DecimalFormat df = new DecimalFormat("+#.## %;-#.## %");
        private static final int Vollholzig = 0;
        private static final int Normalholzig = 1;
        private static final int Abholzig = 2;
        private static final int Benutzerdefiniert = 3;
        private int name;
        private boolean wasChanged = false;
        private double wert = 0.0;

        public static Foermigkeit[] getNewArrayWithAllValues() {
            return new Foermigkeit[]{new Foermigkeit(0, 0.05), new Foermigkeit(1, 0.0), new Foermigkeit(2, -0.05), new Foermigkeit(3, 0.0)};
        }

        private Foermigkeit(int name, double wert) {
            this.name = name;
            this.wert = wert;
        }

        public boolean isBenutzerdefiniert() {
            return this.name == 3;
        }

        public double getWert() {
            return this.wert;
        }

        public void setWert(double wert) {
            if (!this.isBenutzerdefiniert() || Math.abs(wert) > 0.1001) {
                throw new RuntimeException();
            }
            this.wasChanged = true;
            this.wert = wert;
        }

        public String toString() {
            switch (this.name) {
                case 0: {
                    return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_vollholzig) + " (" + this.df.format(this.getWert()) + ")".toString();
                }
                case 1: {
                    return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_normalholzig) + " (" + this.df.format(this.getWert()) + ")".toString();
                }
                case 2: {
                    return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_abholzig) + " (" + this.df.format(this.getWert()) + ")".toString();
                }
                case 3: {
                    if (this.wasChanged) {
                        return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_benutzerdefiniert) + " (" + this.df.format(this.getWert()) + ")".toString();
                    }
                    return ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_benutzerdefiniert.toString();
                }
            }
            throw new RuntimeException();
        }
    }

    public static class FoermigkeitArrayWithSelection
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Foermigkeit[] allValues = Foermigkeit.getNewArrayWithAllValues();
        private Foermigkeit selection = this.allValues[1];

        public Foermigkeit getSelection() {
            return this.selection;
        }

        public void setSelection(Foermigkeit selection) {
            if (this.allValues[0] != selection && this.allValues[1] != selection && this.allValues[2] != selection && this.allValues[3] != selection) {
                throw new RuntimeException();
            }
            this.selection = selection;
        }
    }

    public static class LaubholzAnteil
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final DecimalFormat df = new DecimalFormat("+#.## %;-#.## %");
        private static final int Null = 0;
        private static final int Bis25 = 1;
        private static final int Bis50 = 2;
        private static final int Bis75 = 3;
        private static final int Bis100 = 4;
        private static final int Benutzerdefiniert = 5;
        private int name;
        private boolean wasChanged = false;
        private double wert = 0.0;

        public static LaubholzAnteil[] getNewArrayWithAllValues() {
            return new LaubholzAnteil[]{new LaubholzAnteil(0, 0.0), new LaubholzAnteil(1, -0.025), new LaubholzAnteil(2, -0.05), new LaubholzAnteil(3, -0.075), new LaubholzAnteil(4, -0.1), new LaubholzAnteil(5, 0.0)};
        }

        private LaubholzAnteil(int name, double wert) {
            this.name = name;
            this.wert = wert;
        }

        public boolean isBenutzerdefiniert() {
            return this.name == 5;
        }

        public double getWert() {
            return this.wert;
        }

        public void setWert(double wert) {
            if (!this.isBenutzerdefiniert() || Math.abs(wert) > 0.15001) {
                throw new RuntimeException();
            }
            this.wasChanged = true;
            this.wert = wert;
        }

        public String toString() {
            switch (this.name) {
                case 0: {
                    return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_0Prz) + " (" + this.df.format(this.getWert()) + ")".toString();
                }
                case 1: {
                    return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_bis25Prz) + " (" + this.df.format(this.getWert()) + ")".toString();
                }
                case 2: {
                    return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_bis50Prz) + " (" + this.df.format(this.getWert()) + ")".toString();
                }
                case 3: {
                    return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_bis75Prz) + " (" + this.df.format(this.getWert()) + ")".toString();
                }
                case 4: {
                    return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_bis100Prz) + " (" + this.df.format(this.getWert()) + ")".toString();
                }
                case 5: {
                    if (this.wasChanged) {
                        return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_benutzerdefiniert) + " (" + this.df.format(this.getWert()) + ")".toString();
                    }
                    return ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_benutzerdefiniert.toString();
                }
            }
            throw new RuntimeException();
        }
    }

    public static class LaubholzAnteilArrayWithSelection
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final LaubholzAnteil[] allValues = LaubholzAnteil.getNewArrayWithAllValues();
        private LaubholzAnteil selection = this.allValues[0];

        public LaubholzAnteil getSelection() {
            return this.selection;
        }

        public void setSelection(LaubholzAnteil selection) {
            if (this.allValues[0] != selection && this.allValues[1] != selection && this.allValues[2] != selection && this.allValues[3] != selection && this.allValues[4] != selection && this.allValues[5] != selection) {
                throw new RuntimeException();
            }
            this.selection = selection;
        }
    }

    public static class LiegendesHolz
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final DecimalFormat df = new DecimalFormat("+#.## %;-#.## %");
        private static final int Keines = 0;
        private static final int VorgeruecktBis25 = 1;
        private static final int VorgeruecktBis50 = 2;
        private static final int ZugefaelttBis25 = 3;
        private static final int ZugefaelltBis50 = 4;
        private static final int Benutzerdefiniert = 5;
        private int name;
        private boolean wasChanged = false;
        private double wert = 0.0;

        public static LiegendesHolz[] getNewArrayWithAllValues() {
            return new LiegendesHolz[]{new LiegendesHolz(0, 0.0), new LiegendesHolz(1, 0.125), new LiegendesHolz(2, 0.25), new LiegendesHolz(3, -0.0625), new LiegendesHolz(4, -0.125), new LiegendesHolz(5, 0.0)};
        }

        private LiegendesHolz(int name, double wert) {
            this.name = name;
            this.wert = wert;
        }

        public boolean isBenutzerdefiniert() {
            return this.name == 5;
        }

        public double getWert() {
            return this.wert;
        }

        public void setWert(double wert) {
            if (!this.isBenutzerdefiniert() || Math.abs(wert) > 0.4001) {
                throw new RuntimeException();
            }
            this.wasChanged = true;
            this.wert = wert;
        }

        public String toString() {
            switch (this.name) {
                case 0: {
                    return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_Keines) + " (" + this.df.format(this.getWert()) + ")".toString();
                }
                case 1: {
                    return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_VorgeruecktesHolzBis25Prz) + " (" + this.df.format(this.getWert()) + ")".toString();
                }
                case 2: {
                    return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_VorgeruecktesHolzBis50Prz) + " (" + this.df.format(this.getWert()) + ")".toString();
                }
                case 3: {
                    return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_ZugefaelltesHolzBis25Prz) + " (" + this.df.format(this.getWert()) + ")".toString();
                }
                case 4: {
                    return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_ZugefaelltesHolzBis50Prz) + " (" + this.df.format(this.getWert()) + ")".toString();
                }
                case 5: {
                    if (this.wasChanged) {
                        return (Object)((Object)ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_benutzerdefiniert) + " (" + this.df.format(this.getWert()) + ")".toString();
                    }
                    return ModelStrings.PdfLabels.ArbeitsobjektRadharvester2014_benutzerdefiniert.toString();
                }
            }
            throw new RuntimeException();
        }
    }

    public static class LiegendesHolzArrayWithSelection
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final LiegendesHolz[] allValues = LiegendesHolz.getNewArrayWithAllValues();
        private LiegendesHolz selection = this.allValues[0];

        public LiegendesHolz getSelection() {
            return this.selection;
        }

        public void setSelection(LiegendesHolz selection) {
            if (this.allValues[0] != selection && this.allValues[1] != selection && this.allValues[2] != selection && this.allValues[3] != selection && this.allValues[4] != selection && this.allValues[5] != selection) {
                throw new RuntimeException();
            }
            this.selection = selection;
        }
    }
}

