/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.aobj;

import ch.wsl.fps.hepromo.model.LabelValuePairList;
import ch.wsl.fps.hepromo.model.aobj.Arbeitsobjekt;
import ch.wsl.fps.hepromo.model.aobj.FeinerschliessungGelaendebedingungen;
import java.text.DecimalFormat;

public class ArbeitsobjektMobilerHacker
extends Arbeitsobjekt {
    private static final long serialVersionUID = 1L;
    private double laubholzAnteil_Prz;
    private int anzahlBaeume;
    private Hackgutart hackgutart;
    private double mittlererBhdAushieb_m;
    private double mittlererZopfDrm_m;
    private int fahrstreckeStrasse_m;
    private int fahrstreckeFeinerschliessung_m;
    private int holzlagerLaenge_m;
    private FeinerschliessungGelaendebedingungen.HindernisKategorie hindernisKategorie;
    private FeinerschliessungGelaendebedingungen.NeigungsKategorie neigungsKategorie;

    public double getLaubholzAnteil_Prz() {
        return this.laubholzAnteil_Prz;
    }

    public void setLaubholzAnteil_Prz(double laubholzAnteil_Prz) {
        this.laubholzAnteil_Prz = laubholzAnteil_Prz;
    }

    public int getAnzahlBaeume() {
        return this.anzahlBaeume;
    }

    public void setAnzahlBaeume(int anzahlBaeume) {
        this.anzahlBaeume = anzahlBaeume;
    }

    public Hackgutart getHackgutart() {
        return this.hackgutart;
    }

    public void setHackgutart(Hackgutart hackgutart) {
        this.hackgutart = hackgutart;
    }

    public double getMittlererBhdAushieb_m() {
        return this.mittlererBhdAushieb_m;
    }

    public void setMittlererBhdAushieb_m(double mittlererBhdAushieb_m) {
        this.mittlererBhdAushieb_m = mittlererBhdAushieb_m;
    }

    public double getMittlererZopfDrm_m() {
        return this.mittlererZopfDrm_m;
    }

    public void setMittlererZopfDrm_m(double mittlererZopfDrm_m) {
        this.mittlererZopfDrm_m = mittlererZopfDrm_m;
    }

    public int getFahrstreckeStrasse_m() {
        return this.fahrstreckeStrasse_m;
    }

    public void setFahrstreckeStrasse_m(int fahrstreckeStrasse_m) {
        this.fahrstreckeStrasse_m = fahrstreckeStrasse_m;
    }

    public int getFahrstreckeFeinerschliessung_m() {
        return this.fahrstreckeFeinerschliessung_m;
    }

    public void setFahrstreckeFeinerschliessung_m(int fahrstreckeFeinerschliessung_m) {
        this.fahrstreckeFeinerschliessung_m = fahrstreckeFeinerschliessung_m;
    }

    public int getFahrstreckeTotal_m() {
        return this.getFahrstreckeStrasse_m() + this.getFahrstreckeFeinerschliessung_m();
    }

    public int getHolzlagerLaenge_m() {
        return this.holzlagerLaenge_m;
    }

    public void setHolzlagerLaenge_m(int holzlagerLaenge_m) {
        this.holzlagerLaenge_m = holzlagerLaenge_m;
    }

    public FeinerschliessungGelaendebedingungen.HindernisKategorie getHindernisKategorie() {
        return this.hindernisKategorie;
    }

    public void setHindernisKategorie(FeinerschliessungGelaendebedingungen.HindernisKategorie hindernisKategorie) {
        this.hindernisKategorie = hindernisKategorie;
    }

    public FeinerschliessungGelaendebedingungen.NeigungsKategorie getNeigungsKategorie() {
        return this.neigungsKategorie;
    }

    public void setNeigungsKategorie(FeinerschliessungGelaendebedingungen.NeigungsKategorie neigungsKategorie) {
        this.neigungsKategorie = neigungsKategorie;
    }

    public double getVpz(double spz, double dRPV) {
        double vz;
        double[] vvVkVn = this.getVvVkVn();
        double vv = vvVkVn[0];
        double vk = vvVkVn[1];
        double vn = vvVkVn[2];
        switch (this.getHackgutart()) {
            case Vollbaeume: {
                vz = vv * spz;
                break;
            }
            case Kronen: {
                vz = vk * spz;
                break;
            }
            case Rundholzabschnitte: {
                vz = vn * spz;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        double vpz = dRPV < vz ? dRPV : vz;
        return vpz;
    }

    public double getHackgutmenge_m3() {
        double[] vvVkVn = this.getVvVkVn();
        double vv = vvVkVn[0];
        double vk = vvVkVn[1];
        double vn = vvVkVn[2];
        double anz = this.getAnzahlBaeume();
        double nt = -1.0;
        switch (this.getHackgutart()) {
            case Vollbaeume: {
                nt = vv * anz;
                break;
            }
            case Kronen: {
                nt = vk * anz;
                break;
            }
            case Rundholzabschnitte: {
                nt = vn * anz;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return nt;
    }

    @Override
    public void setHolzmenge_m3(double holzmenge) {
        throw new RuntimeException("This setter should not be used in this class, since the value is calculated automatically");
    }

    @Override
    public double getHolzmenge_m3() {
        return this.getHackgutmenge_m3();
    }

    private double[] getVvVkVn() {
        double dBhd_cm = this.getMittlererBhdAushieb_m() * 100.0;
        double vd = 2.0E-4 * Math.pow(dBhd_cm, 2.3897);
        double vrNadel = 10.009 * Math.pow(dBhd_cm, -1.1549) * vd;
        double vrLaub = 27.519 * Math.pow(dBhd_cm, -1.36) * vd;
        double vvNadel = vd + vrNadel;
        double vvLaub = vd + vrLaub;
        double kmNadel = 4.0E-5 * Math.pow(dBhd_cm, 2.0) - 0.0215 * dBhd_cm - 0.4238;
        double kmLaub = 6.0E-5 * Math.pow(dBhd_cm, 2.0) - 0.0264 * dBhd_cm - 0.3887;
        double dZD_cm = this.getMittlererZopfDrm_m() * 100.0;
        double alzdNadel = (dZD_cm - dBhd_cm) / kmNadel + 1.3;
        double alzdLaub = (dZD_cm - dBhd_cm) / kmLaub + 1.3;
        double dGesamtLaengeNadel_m = 0.0 - dBhd_cm / kmNadel + 1.3;
        double dGesamtLaengeLaub_m = 0.0 - dBhd_cm / kmLaub + 1.3;
        double dBasisDurchmNadel_cm = dBhd_cm - kmNadel * 1.3;
        double dBasisDurchmLaub_cm = dBhd_cm - kmLaub * 1.3;
        double dVolumenKegelGesamtNadel = 1.0471975511965976 * Math.pow(dBasisDurchmNadel_cm / 200.0, 2.0) * dGesamtLaengeNadel_m;
        double dVolumenKegelGesamtLaub = 1.0471975511965976 * Math.pow(dBasisDurchmLaub_cm / 200.0, 2.0) * dGesamtLaengeLaub_m;
        double dSpitzLaengeNadel_m = dGesamtLaengeNadel_m - alzdNadel;
        double dSpitzLaengeLaub_m = dGesamtLaengeLaub_m - alzdLaub;
        double dVolumenKegelSpitzeNadel = 1.0471975511965976 * Math.pow(dZD_cm / 200.0, 2.0) * dSpitzLaengeNadel_m;
        double dVolumenKegelSpitzeLaub = 1.0471975511965976 * Math.pow(dZD_cm / 200.0, 2.0) * dSpitzLaengeLaub_m;
        double dVolumenKegelBasisNadel = dVolumenKegelGesamtNadel - dVolumenKegelSpitzeNadel;
        double dVolumenKegelBasisLaub = dVolumenKegelGesamtLaub - dVolumenKegelSpitzeLaub;
        double vnNadel = dVolumenKegelBasisNadel;
        double vnLaub = dVolumenKegelBasisLaub;
        double vkNadel = vvNadel - vnNadel;
        double vkLaub = vvLaub - vnLaub;
        double anteilLaub = this.getLaubholzAnteil_Prz() / 100.0;
        double vv = vvNadel * (1.0 - anteilLaub) + vvLaub * anteilLaub;
        double vk = vkNadel * (1.0 - anteilLaub) + vkLaub * anteilLaub;
        double vn = vnNadel * (1.0 - anteilLaub) + vnLaub * anteilLaub;
        return new double[]{vv, vk, vn};
    }

    @Override
    public LabelValuePairList getLabelValuePairList(DecimalFormat decimalFormat) {
        LabelValuePairList list = super.getLabelValuePairList(decimalFormat);
        list.add("Laubholzanteil (%)", this.laubholzAnteil_Prz);
        list.add("Anzahl B\u00e4ume", this.anzahlBaeume);
        list.add("Hackgutart", this.hackgutart);
        list.add("Mittlerer BHD Aushieb (m)", this.mittlererBhdAushieb_m);
        list.add("Mittlerer Zopfdurchmesser (m)", this.mittlererZopfDrm_m);
        list.add("Fahrstrecke auf Strasse (m)", this.fahrstreckeStrasse_m);
        list.add("Fahrstrecke auf Feinerschliessung (m)", this.fahrstreckeFeinerschliessung_m);
        list.add("L\u00e4nge Holzlager (m)", this.holzlagerLaenge_m);
        list.add("Hinderniskategorie", this.hindernisKategorie);
        list.add("Neigungskategorie", this.neigungsKategorie);
        return list;
    }

    public static enum Hackgutart {
        Vollbaeume,
        Kronen,
        Rundholzabschnitte;


        public String toString() {
            switch (this) {
                case Vollbaeume: {
                    return "Vollb\u00e4ume";
                }
                case Kronen: {
                    return "Kronen";
                }
                case Rundholzabschnitte: {
                    return "Rundholzabschnitte";
                }
            }
            throw new RuntimeException();
        }
    }
}

