/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.aobj;

import ch.wsl.fps.hepromo.model.LabelValuePairList;
import ch.wsl.fps.hepromo.model.ModelStrings;
import ch.wsl.fps.hepromo.model.aobj.Arbeitsobjekt;
import java.io.Serializable;
import java.text.DecimalFormat;

public class ArbeitsobjektForwarder2018
extends Arbeitsobjekt {
    private double energieholzmenge_m3iR;
    private double energieholzAusSchaftholz_m3iR;
    private double energieholzAusAstderbholzUndReisig_m3iR;
    private double verkaufRundholz_m3oR;
    private boolean holzmengenUnveraendertSeitBerechnungEnergieholzmengen;
    private int bhdMit_cm;
    private Rueckeentfernung rueckeentfernung;
    private Hangneigung hangneigung;
    private AnzahlSortimente anzahlSortimente;
    private Erschwernisse erschwernisse;
    private AbstandRueckegasse abstandRueckegasse;
    private int zopfdurchmesser_cm;
    private Energieholzanfall energieholzanfall_m3iRproHa;
    private Energieholzanfall[] allEnergieholzanfall = new Energieholzanfall[]{new Energieholzanfall(ModelStrings.getString("ArbeitsobjektForwarder2018.enumKlein"), 15, false), new Energieholzanfall(ModelStrings.getString("ArbeitsobjektForwarder2018.enumMittel"), 70, false), new Energieholzanfall(ModelStrings.getString("ArbeitsobjektForwarder2018.enumGross"), 130, false), new Energieholzanfall(ModelStrings.getString("ArbeitsobjektForwarder2018.enumBenutzerdefiniert"), 70, true)};

    public double getEnergieholzmenge_m3iR() {
        return this.energieholzmenge_m3iR;
    }

    public void setEnergieholzmenge_m3iR(double energieholzmenge_m3iR) {
        this.energieholzmenge_m3iR = energieholzmenge_m3iR;
    }

    public double getEnergieholzAusSchaftholz_m3iR() {
        return this.energieholzAusSchaftholz_m3iR;
    }

    public void setEnergieholzAusSchaftholz_m3iR(double energieholzAusSchaftholz_m3iR) {
        this.energieholzAusSchaftholz_m3iR = energieholzAusSchaftholz_m3iR;
    }

    public double getEnergieholzAusAstderbholzUndReisig_m3iR() {
        return this.energieholzAusAstderbholzUndReisig_m3iR;
    }

    public void setEnergieholzAusAstderbholzUndReisig_m3iR(double energieholzAusAstderbholzUndReisig_m3iR) {
        this.energieholzAusAstderbholzUndReisig_m3iR = energieholzAusAstderbholzUndReisig_m3iR;
    }

    public double getVerkaufRundholz_m3oR() {
        return this.verkaufRundholz_m3oR;
    }

    public void setVerkaufRundholz_m3oR(double verkaufRundholz_m3oR) {
        this.verkaufRundholz_m3oR = verkaufRundholz_m3oR;
    }

    public boolean isHolzmengenUnveraendertSeitBerechnungEnergieholzmengen() {
        return this.holzmengenUnveraendertSeitBerechnungEnergieholzmengen;
    }

    public void setHolzmengenUnveraendertSeitBerechnungEnergieholzmengen(boolean holzmengenUnveraendertSeitBerechnungEnergieholzmengen) {
        this.holzmengenUnveraendertSeitBerechnungEnergieholzmengen = holzmengenUnveraendertSeitBerechnungEnergieholzmengen;
    }

    public int getBhdMit_cm() {
        return this.bhdMit_cm;
    }

    public void setBhdMit_cm(int bhdMit_cm) {
        this.bhdMit_cm = bhdMit_cm;
    }

    public Rueckeentfernung getRueckeentfernung() {
        return this.rueckeentfernung;
    }

    public void setRueckeentfernung(Rueckeentfernung rueckeentfernung) {
        this.rueckeentfernung = rueckeentfernung;
    }

    public Hangneigung getHangneigung() {
        return this.hangneigung;
    }

    public void setHangneigung(Hangneigung hangneigung) {
        this.hangneigung = hangneigung;
    }

    public AnzahlSortimente getAnzahlSortimente() {
        return this.anzahlSortimente;
    }

    public void setAnzahlSortimente(AnzahlSortimente anzahlSortimente) {
        this.anzahlSortimente = anzahlSortimente;
    }

    public Erschwernisse getErschwernisse() {
        return this.erschwernisse;
    }

    public void setErschwernisse(Erschwernisse erschwernisse) {
        this.erschwernisse = erschwernisse;
    }

    public AbstandRueckegasse getAbstandRueckegasse() {
        return this.abstandRueckegasse;
    }

    public void setAbstandRueckegasse(AbstandRueckegasse abstandRueckegasse) {
        this.abstandRueckegasse = abstandRueckegasse;
    }

    public int getZopfdurchmesser_cm() {
        return this.zopfdurchmesser_cm;
    }

    public void setZopfdurchmesser_cm(int zopfdurchmesser_cm) {
        this.zopfdurchmesser_cm = zopfdurchmesser_cm;
    }

    public Energieholzanfall getEnergieholzanfall_m3iRproHa() {
        return this.energieholzanfall_m3iRproHa;
    }

    public void setEnergieholzanfall_m3iRproHa(Energieholzanfall energieholzanfall_m3iRproHa) {
        this.energieholzanfall_m3iRproHa = energieholzanfall_m3iRproHa;
    }

    public Energieholzanfall[] getAllEnergieholzanfall() {
        return this.allEnergieholzanfall;
    }

    public void setAllEnergieholzanfall(Energieholzanfall[] allEnergieholzanfall) {
        this.allEnergieholzanfall = allEnergieholzanfall;
    }

    @Override
    protected double getRindenAbzugFaktorBerechnet() {
        return 0.89;
    }

    @Override
    public LabelValuePairList getLabelValuePairList(DecimalFormat decimalFormat) {
        LabelValuePairList list = super.getLabelValuePairList(decimalFormat);
        list.add(ModelStrings.getString("ArbeitsobjektForwarder2018.Energieholz_iR"), this.energieholzmenge_m3iR);
        list.add(ModelStrings.getString("ArbeitsobjektForwarder2018.EnergieholzAusSchaftholz_m3iR"), this.energieholzAusSchaftholz_m3iR);
        list.add(ModelStrings.getString("ArbeitsobjektForwarder2018.EnergieholzAusAstderbholzUndReisig_m3iR"), this.energieholzAusAstderbholzUndReisig_m3iR);
        list.add(ModelStrings.getString("ArbeitsobjektForwarder2018.VerkaufRundholz_m3oR"), this.verkaufRundholz_m3oR);
        list.add(ModelStrings.getString("ArbeitsobjektForwarder2018.MittlererBhd_cm"), this.bhdMit_cm);
        list.add(ModelStrings.getString("ArbeitsobjektForwarder2018.RueckeEntfernung"), this.rueckeentfernung);
        list.add(ModelStrings.getString("ArbeitsobjektForwarder2018.Hangneigung"), this.hangneigung);
        list.add(ModelStrings.getString("ArbeitsobjektForwarder2018.AnzahlSortimente"), this.anzahlSortimente);
        list.add(ModelStrings.getString("ArbeitsobjektForwarder2018.Erschwernisse"), this.erschwernisse);
        list.add(ModelStrings.getString("ArbeitsobjektForwarder2018.AbstandRueckegasse"), this.abstandRueckegasse);
        list.add(ModelStrings.getString("ArbeitsobjektForwarder2018.Zopfdurchmesser_cm"), this.zopfdurchmesser_cm);
        list.add(ModelStrings.getString("ArbeitsobjektForwarder2018.Energieholzanfall"), this.energieholzanfall_m3iRproHa.toStringNoHtml());
        return list;
    }

    @Override
    protected String getPdfLabelHolzmenge() {
        return ModelStrings.getString("ArbeitsobjektForwarder2018.Schaftholz_m3iR");
    }

    public static enum AbstandRueckegasse {
        Circa40m,
        Circa30m,
        Circa20m;


        public String toString() {
            switch (this) {
                case Circa40m: {
                    return "40 m";
                }
                case Circa30m: {
                    return "30 m";
                }
                case Circa20m: {
                    return "20 m";
                }
            }
            throw new RuntimeException(this.name());
        }
    }

    public static enum AnzahlSortimente {
        AnzahlBis3,
        Anzahl4Bis6,
        Anzahl7UndMehr;


        public String toString() {
            switch (this) {
                case AnzahlBis3: {
                    return "1-3";
                }
                case Anzahl4Bis6: {
                    return "4-6";
                }
                case Anzahl7UndMehr: {
                    return ModelStrings.getString("ArbeitsobjektForwarder2018.enum7undMehr");
                }
            }
            throw new RuntimeException(this.name());
        }
    }

    public static class Energieholzanfall
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String name;
        private int energieholzanfall_m3ProHa;
        private boolean wasChanged = false;
        private final boolean benutzerdefiniert;

        private Energieholzanfall(String name, int energieholzanfall_m3ProHa, boolean benutzerdefiniert) {
            this.name = name;
            this.energieholzanfall_m3ProHa = energieholzanfall_m3ProHa;
            this.benutzerdefiniert = benutzerdefiniert;
        }

        public String toString() {
            if (this.benutzerdefiniert && !this.wasChanged) {
                return "<html><nobr>" + this.name + "</nobr></html>";
            }
            return "<html><nobr>" + this.name + " (" + this.energieholzanfall_m3ProHa + " m<sup>3</sup>)</nobr></html>";
        }

        public String toStringNoHtml() {
            return String.valueOf(this.name) + " (" + this.energieholzanfall_m3ProHa + " m3)";
        }

        public int getEnergieholzanfall_m3ProHa() {
            return this.energieholzanfall_m3ProHa;
        }

        public boolean isBenutzerdefiniert() {
            return this.benutzerdefiniert;
        }

        public void setEnergieholzanfall_m3ProHa(int value) {
            if (!this.benutzerdefiniert) {
                throw new RuntimeException("Wert kann nur bei benutzerdefiniertem Typ ver\u00e4ndert werden.");
            }
            this.wasChanged = true;
            this.energieholzanfall_m3ProHa = value;
        }
    }

    public static enum Erschwernisse {
        Keine,
        Wenige,
        Viele;


        public String toString() {
            switch (this) {
                case Keine: {
                    return ModelStrings.getString("ArbeitsobjektForwarder2018.enumKeine");
                }
                case Wenige: {
                    return ModelStrings.getString("ArbeitsobjektForwarder2018.enumWenige");
                }
                case Viele: {
                    return ModelStrings.getString("ArbeitsobjektForwarder2018.enumViele");
                }
            }
            throw new RuntimeException(this.name());
        }
    }

    public static enum Hangneigung {
        NeigungBis15Prozent,
        Neigung15Bis25Prozent,
        NeigungGroesser25Prozent;


        public String toString() {
            switch (this) {
                case NeigungBis15Prozent: {
                    return "<15 %";
                }
                case Neigung15Bis25Prozent: {
                    return "15-25 %";
                }
                case NeigungGroesser25Prozent: {
                    return ">25 %";
                }
            }
            throw new RuntimeException(this.name());
        }
    }

    public static enum Rueckeentfernung {
        EntfKleiner200m,
        Entf201bis400m,
        Entf401bis600m,
        Entf601bis900m,
        Entf901bis1200m,
        EntfGroesser1200m;


        public String toString() {
            switch (this) {
                case EntfKleiner200m: {
                    return "<200 m";
                }
                case Entf201bis400m: {
                    return "201-400 m";
                }
                case Entf401bis600m: {
                    return "401-600 m";
                }
                case Entf601bis900m: {
                    return "601-900 m";
                }
                case Entf901bis1200m: {
                    return "901-1200 m";
                }
                case EntfGroesser1200m: {
                    return ">1200 m";
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Rueckeentfernung getFromDistanceInMeters(double value) {
            if (value <= 200.0) {
                return EntfKleiner200m;
            }
            if (value <= 400.0) {
                return Entf201bis400m;
            }
            if (value <= 600.0) {
                return Entf401bis600m;
            }
            if (value <= 900.0) {
                return Entf601bis900m;
            }
            if (value <= 1200.0) {
                return Entf901bis1200m;
            }
            return EntfGroesser1200m;
        }
    }
}

