/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model;

import ch.wsl.fps.hepromo.model.ModelStrings;
import java.text.DecimalFormat;
import java.util.HashMap;

public class Ergebnis {
    protected double psh0_hProM3;
    protected double psh0_total;
    protected double zeitPersonal;
    protected double zeitMaschine1;
    protected double zeitMaschine2;
    protected double zeitMaschine3;
    protected double zeitUmsetzen;
    protected double zeitWeitereAufwaende;
    protected double zeitTotal;
    protected double kostenPersonal_total;
    protected double kostenMaschine1_total;
    protected double kostenMaschine2_total;
    protected double kostenMaschine3_total;
    protected double kostenUmsetzen_total;
    protected double kostenWeitereAufwaende_total;
    private final HashMap<ProdEinheit, Double> produktivitaeten = new HashMap();
    protected ProdEinheit prodEinheit;
    protected ProdEinheit prodEinheit2;
    private double anzahl_m3;
    protected double faktorRisikoVerwaltungGewinn;
    protected double faktorMehrwertsteuer;
    protected String labelPersonal1;
    protected String labelMaschine1;
    protected String labelMaschine2;
    protected String labelMaschine3;
    protected boolean showDauerDerArbeit;
    protected boolean showProduktivitaet;

    public Ergebnis() {
        this.produktivitaeten.put(ProdEinheit.EMPTY, -1.0);
        this.prodEinheit = ProdEinheit.M3_PRO_PSH15;
        this.prodEinheit2 = ProdEinheit.EMPTY;
        this.faktorRisikoVerwaltungGewinn = 1.0;
        this.faktorMehrwertsteuer = 1.0;
        this.labelPersonal1 = null;
        this.labelMaschine1 = null;
        this.labelMaschine2 = null;
        this.labelMaschine3 = null;
        this.showDauerDerArbeit = true;
        this.showProduktivitaet = true;
    }

    public void setPsh0_hProM3(double psh0_hProM3) {
        this.psh0_hProM3 = psh0_hProM3;
    }

    public void setPsh0_total(double psh0_total) {
        this.psh0_total = psh0_total;
    }

    public void setZeitPersonal(double zeitPersonal) {
        this.zeitPersonal = zeitPersonal;
    }

    public void setZeitMaschine1(double zeitMaschine1) {
        this.zeitMaschine1 = zeitMaschine1;
    }

    public void setZeitMaschine2(double zeitMaschine2) {
        this.zeitMaschine2 = zeitMaschine2;
    }

    public void setZeitMaschine3(double zeitMaschine3) {
        this.zeitMaschine3 = zeitMaschine3;
    }

    public void setZeitUmsetzen(double zeitUmsetzen) {
        this.zeitUmsetzen = zeitUmsetzen;
    }

    public void setZeitWeitereAufwaende(double zeitWeitereAufwaende) {
        this.zeitWeitereAufwaende = zeitWeitereAufwaende;
    }

    public void setZeitTotal(double zeitTotal) {
        this.zeitTotal = zeitTotal;
    }

    public void setKostenPersonal_total(double kostenPersonal_total) {
        this.kostenPersonal_total = kostenPersonal_total;
    }

    public void setKostenMaschine1_total(double kostenMaschine1_total) {
        this.kostenMaschine1_total = kostenMaschine1_total;
    }

    public void setKostenMaschine2_total(double kostenMaschine2_total) {
        this.kostenMaschine2_total = kostenMaschine2_total;
    }

    public void setKostenMaschine3_total(double kostenMaschine3_total) {
        this.kostenMaschine3_total = kostenMaschine3_total;
    }

    public void setKostenUmsetzen_total(double kostenUmsetzen_total) {
        this.kostenUmsetzen_total = kostenUmsetzen_total;
    }

    public void setKostenWeitereAufwaende_total(double kostenWeitereAufwaende_total) {
        this.kostenWeitereAufwaende_total = kostenWeitereAufwaende_total;
    }

    public void setProduktivitaet(Purpose purpose, ProdEinheit prodEinheit, double produktivitaet) {
        if (purpose == Purpose.FIRST) {
            this.prodEinheit = prodEinheit;
        } else if (purpose == Purpose.SECOND) {
            this.prodEinheit2 = prodEinheit;
        }
        this.produktivitaeten.put(prodEinheit, produktivitaet);
    }

    public void setAnzahl_m3(double anzahl_m3) {
        this.anzahl_m3 = anzahl_m3;
    }

    public void setRisikoVerwaltungGewinn_Prz(double value) {
        this.faktorRisikoVerwaltungGewinn = value / 100.0 + 1.0;
    }

    public void setMehrwertsteuer_Prz(double value) {
        this.faktorMehrwertsteuer = value / 100.0 + 1.0;
    }

    public double getPsh0_hProM3() {
        return this.psh0_hProM3;
    }

    public double getPsh0_total() {
        return this.psh0_total;
    }

    public double getZeitPersonal() {
        return this.zeitPersonal;
    }

    public double getZeitMaschine1() {
        return this.zeitMaschine1;
    }

    public double getZeitMaschine2() {
        return this.zeitMaschine2;
    }

    public double getZeitMaschine3() {
        return this.zeitMaschine3;
    }

    public double getZeitUmsetzen() {
        return this.zeitUmsetzen;
    }

    public double getZeitWeitereAufwaende() {
        return this.zeitWeitereAufwaende;
    }

    public double getZeitTotal() {
        return this.zeitTotal;
    }

    public double getKostenPersonal_proM3() {
        if (this.getAnzahl_m3() <= 0.0) {
            return 0.0;
        }
        return this.getKostenPersonal_total() / this.getAnzahl_m3();
    }

    public double getKostenMaschine1_proM3() {
        if (this.getAnzahl_m3() <= 0.0) {
            return 0.0;
        }
        return this.getKostenMaschine1_total() / this.getAnzahl_m3();
    }

    public double getKostenMaschine2_proM3() {
        if (this.getAnzahl_m3() <= 0.0) {
            return 0.0;
        }
        return this.getKostenMaschine2_total() / this.getAnzahl_m3();
    }

    public double getKostenMaschine3_proM3() {
        if (this.getAnzahl_m3() <= 0.0) {
            return 0.0;
        }
        return this.getKostenMaschine3_total() / this.getAnzahl_m3();
    }

    public double getKostenUmsetzen_proM3() {
        if (this.getAnzahl_m3() <= 0.0) {
            return 0.0;
        }
        return this.getKostenUmsetzen_total() / this.getAnzahl_m3();
    }

    public double getKostenWeitereAufwaende_proM3() {
        if (this.getAnzahl_m3() <= 0.0) {
            return 0.0;
        }
        return this.getKostenWeitereAufwaende_total() / this.getAnzahl_m3();
    }

    public double getKostenTotal_proM3() {
        if (this.getAnzahl_m3() <= 0.0) {
            return 0.0;
        }
        return this.getKostenTotal_total() / this.getAnzahl_m3();
    }

    public double getKostenPersonal_total() {
        return this.kostenPersonal_total;
    }

    public double getKostenMaschine1_total() {
        return this.kostenMaschine1_total;
    }

    public double getKostenMaschine2_total() {
        return this.kostenMaschine2_total;
    }

    public double getKostenMaschine3_total() {
        return this.kostenMaschine3_total;
    }

    public double getKostenUmsetzen_total() {
        return this.kostenUmsetzen_total;
    }

    public double getKostenWeitereAufwaende_total() {
        return this.kostenWeitereAufwaende_total;
    }

    public double getKostenTotal_total() {
        double sum = this.getKostenPersonal_total() + this.getKostenMaschine1_total() + this.getKostenMaschine2_total() + this.getKostenMaschine3_total() + this.getKostenUmsetzen_total() + this.getKostenWeitereAufwaende_total();
        sum *= this.faktorRisikoVerwaltungGewinn;
        return sum *= this.faktorMehrwertsteuer;
    }

    public double getProduktivitaet() {
        return this.getProduktivitaet(this.prodEinheit);
    }

    public double getProduktivitaet2() {
        return this.getProduktivitaet(this.prodEinheit2);
    }

    public double getProduktivitaet_m3ProPsh15() {
        return this.getProduktivitaet(ProdEinheit.M3_PRO_PSH15);
    }

    public double getProduktivitaet_m3ProPmh15() {
        return this.getProduktivitaet(ProdEinheit.M3_PRO_PMH15);
    }

    public double getProduktivitaet_fmORproWPPH() {
        return this.getProduktivitaet(ProdEinheit.FM_OR_PRO_WPPH);
    }

    public double getProduktivitaet(ProdEinheit prodEinheit) {
        if (prodEinheit != null && this.produktivitaeten.containsKey((Object)prodEinheit)) {
            return this.produktivitaeten.get((Object)prodEinheit);
        }
        return -1.0;
    }

    public double getAnzahl_m3() {
        return this.anzahl_m3;
    }

    public double getRisikoVerwaltungGewinn_Prz() {
        double value = (this.faktorRisikoVerwaltungGewinn - 1.0) * 100.0;
        return value;
    }

    public double getMehrwertsteuer_Prz() {
        double value = (this.faktorMehrwertsteuer - 1.0) * 100.0;
        return value;
    }

    public void setLabelPersonal1(String label) {
        this.labelPersonal1 = label;
    }

    public void setLabelMaschine1(String label) {
        this.labelMaschine1 = label;
    }

    public void setLabelMaschine2(String label) {
        this.labelMaschine2 = label;
    }

    public void setLabelMaschine3(String label) {
        this.labelMaschine3 = label;
    }

    public String getLabelPersonal1() {
        return this.labelPersonal1;
    }

    public String getLabelMaschine1() {
        return this.labelMaschine1;
    }

    public String getLabelMaschine2() {
        return this.labelMaschine2;
    }

    public String getLabelMaschine3() {
        return this.labelMaschine3;
    }

    public void hideDauerDerArbeit() {
        this.showDauerDerArbeit = false;
    }

    public void hideProduktivitaet() {
        this.showProduktivitaet = false;
    }

    public String getErgebnisAsXmlString(DecimalFormat decimalFormat, String waehrung) {
        String[][] strings;
        StringBuilder sb = new StringBuilder();
        sb.append("<ergebnis>\n");
        String[][] stringArray = strings = this.getErgebnisStrings(decimalFormat, waehrung);
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String[] element = stringArray[n2];
            if (element != null) {
                if (element.length == 0) {
                    sb.append("\t<leerzeile/>\n");
                } else {
                    sb.append("\t<ergebniszeile>\n");
                    sb.append("\t\t<spalte1>");
                    sb.append(element[0]);
                    sb.append("</spalte1>\n");
                    sb.append("\t\t<spalte2>");
                    sb.append(element[1]);
                    sb.append("</spalte2>\n");
                    sb.append("\t\t<spalte3>");
                    sb.append(element[2]);
                    sb.append("</spalte3>\n");
                    sb.append("\t\t<spalte4>");
                    sb.append(element[3]);
                    sb.append("</spalte4>\n");
                    sb.append("\t\t<spalte5>");
                    sb.append(element[4]);
                    sb.append("</spalte5>\n");
                    sb.append("\t</ergebniszeile>\n");
                }
            }
            ++n2;
        }
        sb.append("</ergebnis>\n");
        return sb.toString();
    }

    protected String[][] getErgebnisStrings(DecimalFormat df, String waehrung) {
        if (this.getProduktivitaet() < 0.0) {
            this.hideProduktivitaet();
        }
        String[][] strings = new String[11][];
        if (this.getAnzahl_m3() > 1.0) {
            String[] stringArray;
            String[] stringArray2;
            String[] stringArray3;
            String[] stringArray4;
            String[] stringArray5;
            String[] stringArray6;
            strings[0] = new String[]{"", ModelStrings.PdfLabels.Ergebnis_Zeitaufwand_Std.toString(), "", (Object)((Object)ModelStrings.PdfLabels.Ergebnis_Kosten) + " (" + waehrung + ")", ""};
            if (this.showDauerDerArbeit) {
                String[] stringArray7 = new String[5];
                stringArray7[0] = ModelStrings.PdfLabels.Ergebnis_DauerDerArbeit.toString();
                stringArray7[1] = df.format(this.getZeitTotal());
                stringArray7[2] = "";
                stringArray7[3] = ModelStrings.PdfLabels.Ergebnis_proM3.toString();
                stringArray6 = stringArray7;
                stringArray7[4] = ModelStrings.PdfLabels.Ergebnis_total.toString();
            } else {
                String[] stringArray8 = new String[5];
                stringArray8[0] = "";
                stringArray8[1] = "";
                stringArray8[2] = "";
                stringArray8[3] = ModelStrings.PdfLabels.Ergebnis_proM3.toString();
                stringArray6 = stringArray8;
                stringArray8[4] = ModelStrings.PdfLabels.Ergebnis_total.toString();
            }
            strings[1] = stringArray6;
            if (this.labelPersonal1 != null) {
                String[] stringArray9 = new String[5];
                stringArray9[0] = this.labelPersonal1;
                stringArray9[1] = df.format(this.getZeitPersonal());
                stringArray9[2] = "WPPH";
                stringArray9[3] = df.format(this.getKostenPersonal_proM3());
                stringArray5 = stringArray9;
                stringArray9[4] = df.format(this.getKostenPersonal_total());
            } else {
                stringArray5 = strings[2] = null;
            }
            if (this.labelMaschine1 != null) {
                String[] stringArray10 = new String[5];
                stringArray10[0] = this.labelMaschine1;
                stringArray10[1] = df.format(this.getZeitMaschine1());
                stringArray10[2] = "PMH15";
                stringArray10[3] = df.format(this.getKostenMaschine1_proM3());
                stringArray4 = stringArray10;
                stringArray10[4] = df.format(this.getKostenMaschine1_total());
            } else {
                stringArray4 = strings[3] = null;
            }
            if (this.labelMaschine2 != null) {
                String[] stringArray11 = new String[5];
                stringArray11[0] = this.labelMaschine2;
                stringArray11[1] = df.format(this.getZeitMaschine2());
                stringArray11[2] = "PMH15";
                stringArray11[3] = df.format(this.getKostenMaschine2_proM3());
                stringArray3 = stringArray11;
                stringArray11[4] = df.format(this.getKostenMaschine2_total());
            } else {
                stringArray3 = strings[4] = null;
            }
            if (this.labelMaschine3 != null) {
                String[] stringArray12 = new String[5];
                stringArray12[0] = this.labelMaschine3;
                stringArray12[1] = df.format(this.getZeitMaschine3());
                stringArray12[2] = "PMH15";
                stringArray12[3] = df.format(this.getKostenMaschine3_proM3());
                stringArray2 = stringArray12;
                stringArray12[4] = df.format(this.getKostenMaschine3_total());
            } else {
                stringArray2 = null;
            }
            strings[5] = stringArray2;
            strings[6] = new String[]{ModelStrings.PdfLabels.Ergebnis_Umsetzen.toString(), df.format(this.getZeitUmsetzen()), "", df.format(this.getKostenUmsetzen_proM3()), df.format(this.getKostenUmsetzen_total())};
            strings[7] = new String[]{ModelStrings.PdfLabels.Ergebnis_WeitereAufwaende.toString(), df.format(this.getZeitWeitereAufwaende()), "", df.format(this.getKostenWeitereAufwaende_proM3()), df.format(this.getKostenWeitereAufwaende_total())};
            strings[8] = new String[]{ModelStrings.PdfLabels.Ergebnis_Total.toString(), "", "", "<b>" + df.format(this.getKostenTotal_proM3()) + "</b>", df.format(this.getKostenTotal_total())};
            strings[9] = new String[0];
            if (this.showProduktivitaet) {
                String[] stringArray13 = new String[5];
                stringArray13[0] = (Object)((Object)ModelStrings.PdfLabels.Ergebnis_Produktivitaet) + " (" + (Object)((Object)this.prodEinheit) + ")";
                stringArray13[1] = df.format(this.getProduktivitaet());
                stringArray13[2] = "";
                stringArray13[3] = "";
                stringArray = stringArray13;
                stringArray13[4] = "";
            } else {
                stringArray = null;
            }
            strings[10] = stringArray;
        } else {
            String[] stringArray;
            String[] stringArray14;
            String[] stringArray15;
            String[] stringArray16;
            String[] stringArray17;
            String[] stringArray18;
            strings[0] = new String[]{"", ModelStrings.PdfLabels.Ergebnis_Zeitaufwand_Std.toString(), "", (Object)((Object)ModelStrings.PdfLabels.Ergebnis_Kosten) + " (" + waehrung + ")", ""};
            if (this.showDauerDerArbeit) {
                String[] stringArray19 = new String[5];
                stringArray19[0] = ModelStrings.PdfLabels.Ergebnis_DauerDerArbeit.toString();
                stringArray19[1] = df.format(this.getZeitTotal());
                stringArray19[2] = "";
                stringArray19[3] = ModelStrings.PdfLabels.Ergebnis_total.toString();
                stringArray18 = stringArray19;
                stringArray19[4] = "";
            } else {
                String[] stringArray20 = new String[5];
                stringArray20[0] = "";
                stringArray20[1] = "";
                stringArray20[2] = "";
                stringArray20[3] = ModelStrings.PdfLabels.Ergebnis_total.toString();
                stringArray18 = stringArray20;
                stringArray20[4] = "";
            }
            strings[1] = stringArray18;
            if (this.labelPersonal1 != null) {
                String[] stringArray21 = new String[5];
                stringArray21[0] = this.labelPersonal1;
                stringArray21[1] = df.format(this.getZeitPersonal());
                stringArray21[2] = "WPPH";
                stringArray21[3] = df.format(this.getKostenPersonal_total());
                stringArray17 = stringArray21;
                stringArray21[4] = "";
            } else {
                stringArray17 = strings[2] = null;
            }
            if (this.labelMaschine1 != null) {
                String[] stringArray22 = new String[5];
                stringArray22[0] = this.labelMaschine1;
                stringArray22[1] = df.format(this.getZeitMaschine1());
                stringArray22[2] = "PMH15";
                stringArray22[3] = df.format(this.getKostenMaschine1_total());
                stringArray16 = stringArray22;
                stringArray22[4] = "";
            } else {
                stringArray16 = strings[3] = null;
            }
            if (this.labelMaschine2 != null) {
                String[] stringArray23 = new String[5];
                stringArray23[0] = this.labelMaschine2;
                stringArray23[1] = df.format(this.getZeitMaschine2());
                stringArray23[2] = "PMH15";
                stringArray23[3] = df.format(this.getKostenMaschine2_total());
                stringArray15 = stringArray23;
                stringArray23[4] = "";
            } else {
                stringArray15 = strings[4] = null;
            }
            if (this.labelMaschine3 != null) {
                String[] stringArray24 = new String[5];
                stringArray24[0] = this.labelMaschine3;
                stringArray24[1] = df.format(this.getZeitMaschine3());
                stringArray24[2] = "PMH15";
                stringArray24[3] = df.format(this.getKostenMaschine3_total());
                stringArray14 = stringArray24;
                stringArray24[4] = "";
            } else {
                stringArray14 = null;
            }
            strings[5] = stringArray14;
            strings[6] = new String[]{ModelStrings.PdfLabels.Ergebnis_Umsetzen.toString(), df.format(this.getZeitUmsetzen()), "", df.format(this.getKostenUmsetzen_total()), ""};
            strings[7] = new String[]{ModelStrings.PdfLabels.Ergebnis_WeitereAufwaende.toString(), df.format(this.getZeitWeitereAufwaende()), "", df.format(this.getKostenWeitereAufwaende_total()), ""};
            strings[8] = new String[]{ModelStrings.PdfLabels.Ergebnis_Total.toString(), "", "", "<b>" + df.format(this.getKostenTotal_total()) + "</b>", ""};
            strings[9] = new String[0];
            if (this.showProduktivitaet) {
                String[] stringArray25 = new String[5];
                stringArray25[0] = (Object)((Object)ModelStrings.PdfLabels.Ergebnis_Produktivitaet) + " (" + (Object)((Object)this.prodEinheit) + ")";
                stringArray25[1] = df.format(this.getProduktivitaet());
                stringArray25[2] = "";
                stringArray25[3] = "";
                stringArray = stringArray25;
                stringArray25[4] = "";
            } else {
                stringArray = null;
            }
            strings[10] = stringArray;
        }
        return strings;
    }

    public static enum ProdEinheit {
        EMPTY,
        FM_OR_PRO_WPPH,
        M3_PRO_PMH15,
        M3_IR_PRO_PMH15_BEIM_SEILEN,
        M3_OR_PRO_PMH15_BEIM_SEILEN,
        M3_PRO_PSH15,
        M3_IR_PRO_PMH15,
        M3_OR_PRO_PMH15,
        M3_IR_PRO_PSH15,
        M3_OR_PRO_PSH15,
        M3_IR_PRO_WSH,
        M3_OR_PRO_WSH,
        M3_IR_PRO_WPSH,
        M3_OR_PRO_WPSH,
        SRM_PRO_PMH15;


        public String toString() {
            switch (this) {
                case EMPTY: {
                    return "";
                }
                case FM_OR_PRO_WPPH: {
                    throw new RuntimeException();
                }
                case M3_PRO_PMH15: {
                    return ModelStrings.PdfLabels.AbstractCalculatorSingleModel2014_m3_pro_PMH15.toString();
                }
                case M3_IR_PRO_PMH15_BEIM_SEILEN: {
                    return ModelStrings.PdfLabels.CalculatorSeilkranGesamt_ProduktivitaetBeimSeilen_m3iRproPMH15.toString();
                }
                case M3_OR_PRO_PMH15_BEIM_SEILEN: {
                    return ModelStrings.PdfLabels.CalculatorSeilkranGesamt_ProduktivitaetBeimSeilen_m3oRproPMH15.toString();
                }
                case M3_PRO_PSH15: {
                    return ModelStrings.PdfLabels.Ergebnis_m3_pro_PSH15.toString();
                }
                case M3_IR_PRO_PMH15: {
                    return ModelStrings.PdfLabels.AbstractCalculatorSingleModel2014_m3iR_pro_PMH15.toString();
                }
                case M3_OR_PRO_PMH15: {
                    return ModelStrings.PdfLabels.AbstractCalculatorSingleModel2014_m3oR_pro_PMH15.toString();
                }
                case M3_IR_PRO_PSH15: {
                    return ModelStrings.getString("CalculatorKombiseilgeraet2018.m3iRProPSH15");
                }
                case M3_OR_PRO_PSH15: {
                    return ModelStrings.getString("CalculatorKombiseilgeraet2018.m3oRProPSH15");
                }
                case M3_IR_PRO_WSH: {
                    return ModelStrings.getString("CalculatorKombiseilgeraet2018.m3iRProWSH");
                }
                case M3_OR_PRO_WSH: {
                    return ModelStrings.getString("CalculatorKombiseilgeraet2018.m3oRProWSH");
                }
                case M3_IR_PRO_WPSH: {
                    return ModelStrings.PdfLabels.CalculatorMotormanuellGesamt2014_m3iR_pro_WPSH.toString();
                }
                case M3_OR_PRO_WPSH: {
                    return ModelStrings.PdfLabels.CalculatorMotormanuellGesamt2014_m3oR_pro_WPSH.toString();
                }
                case SRM_PRO_PMH15: {
                    return ModelStrings.getString("CalculatorHacker2018.SrmProPMH15");
                }
            }
            throw new RuntimeException("unhandled case: " + this.name());
        }
    }

    public static enum Purpose {
        FIRST,
        SECOND,
        ADDITIONAL;

    }
}

