/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle.panel.asys;

import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoWindow;
import ch.wsl.fps.hepromo.gui.modelle.Hacker2018;
import ch.wsl.fps.hepromo.gui.modelle.panel.asys.KostensaetzePanel2014;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektHacker2018;
import ch.wsl.fps.hepromo.model.calc.CalculatorHacker2018;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class KostensaetzePanelHacker2018
extends KostensaetzePanel2014 {
    private static final long serialVersionUID = 1L;
    private JLabel lblEinheit;
    private JRadioButton radPMH15;
    private JRadioButton radSrm;

    public KostensaetzePanelHacker2018(HeProMoWindow parent) {
        super(parent);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 4;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(15, 55, 0, 0);
        this.lblEinheit = new JLabel(GuiStrings.getString("KostensaetzePanelHacker2018.EinheitKostensatzHacker"));
        this.add((Component)this.lblEinheit, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 4;
        c.fill = 2;
        c.insets = new Insets(2, 65, 0, 0);
        this.radPMH15 = new JRadioButton(GuiStrings.getString("KostensaetzePanelHacker2018.KostenProPMH15"));
        this.radPMH15.setSelected(true);
        this.radPMH15.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ArbeitsobjektHacker2018.Zielsortiment zielsortiment = KostensaetzePanelHacker2018.this.getHackerWindow().getZielsortiment();
                    double motorleistungKw = KostensaetzePanelHacker2018.this.getHackerWindow().getMotorleistungHacker_kW();
                    double kostensatzAlt = KostensaetzePanelHacker2018.super.getAnsatzMaschine1();
                    double kostensatzNeu = CalculatorHacker2018.convertFromCHFproSrmToCHFproPMH15(kostensatzAlt, zielsortiment, motorleistungKw);
                    KostensaetzePanelHacker2018.super.setAnsatzMaschine1(kostensatzNeu);
                    KostensaetzePanelHacker2018.this.updateWaehrungskuerzel();
                }
            }
        });
        this.add((Component)this.radPMH15, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 8;
        c.gridwidth = 4;
        c.fill = 2;
        c.insets = new Insets(0, 65, 0, 0);
        this.radSrm = new JRadioButton(GuiStrings.getString("KostensaetzePanelHacker2018.KostenProSrm"));
        this.radSrm.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ArbeitsobjektHacker2018.Zielsortiment zielsortiment = KostensaetzePanelHacker2018.this.getHackerWindow().getZielsortiment();
                    double motorleistungKw = KostensaetzePanelHacker2018.this.getHackerWindow().getMotorleistungHacker_kW();
                    double kostensatzAlt = KostensaetzePanelHacker2018.super.getAnsatzMaschine1();
                    double kostensatzNeu = CalculatorHacker2018.convertFromCHFproPMH15ToCHFproSrm(kostensatzAlt, zielsortiment, motorleistungKw);
                    KostensaetzePanelHacker2018.super.setAnsatzMaschine1(kostensatzNeu);
                    KostensaetzePanelHacker2018.this.updateWaehrungskuerzel();
                }
            }
        });
        this.add((Component)this.radSrm, c);
        ButtonGroup group = new ButtonGroup();
        group.add(this.radPMH15);
        group.add(this.radSrm);
    }

    @Override
    public double getAnsatzMaschine1() {
        if (this.radPMH15.isSelected()) {
            return super.getAnsatzMaschine1();
        }
        ArbeitsobjektHacker2018.Zielsortiment zielsortiment = this.getHackerWindow().getZielsortiment();
        double motorleistungKw = this.getHackerWindow().getMotorleistungHacker_kW();
        double ansatzCHFproSrm = super.getAnsatzMaschine1();
        double ansatzCHFproPMH15 = CalculatorHacker2018.convertFromCHFproSrmToCHFproPMH15(ansatzCHFproSrm, zielsortiment, motorleistungKw);
        return ansatzCHFproPMH15;
    }

    @Override
    public void setAnsatzMaschine1(double ansatz) {
        if (this.radPMH15.isSelected()) {
            super.setAnsatzMaschine1(ansatz);
        } else {
            this.radPMH15.setSelected(true);
            super.setAnsatzMaschine1(ansatz);
        }
    }

    public boolean isDisplayHackerKostenProPMH15() {
        return this.radPMH15.isSelected();
    }

    public void setDisplayHackerKostenProPMH15(boolean displayHackerKostenProPMH15) {
        if (displayHackerKostenProPMH15) {
            this.radPMH15.setSelected(true);
        } else {
            this.radSrm.setSelected(true);
        }
    }

    private void updateWaehrungskuerzel() {
        String einheitProPMH15 = GuiStrings.getString("KostensaetzePanel2014.ProPMH15");
        String einheitProSrm = GuiStrings.getString("KostensaetzePanelHacker2018.proSrm");
        String oldText = this.lblMaschine1B.getText();
        if (this.radPMH15.isSelected()) {
            this.lblMaschine1B.setText(oldText.replace(einheitProSrm, einheitProPMH15));
            this.lblMaschine1_Info.setVisible(true);
        } else {
            this.lblMaschine1B.setText(oldText.replace(einheitProPMH15, einheitProSrm));
            this.lblMaschine1_Info.setVisible(false);
        }
    }

    @Override
    public void updateWaehrungskuerzel(String newValue) {
        super.updateWaehrungskuerzel(newValue);
        this.updateWaehrungskuerzel();
    }

    private Hacker2018 getHackerWindow() {
        return (Hacker2018)this.parent;
    }
}

