/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle.panel.asys;

import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoWindow;
import ch.wsl.fps.hepromo.gui.TitledBorderFactory;
import ch.wsl.fps.hepromo.gui.modelle.panel.asys.IWaehrungsanzeige;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class KostensaetzePanel2014
extends JPanel
implements IWaehrungsanzeige {
    private static final long serialVersionUID = 1L;
    protected final HeProMoWindow parent;
    private final boolean showZusaetzlichePersonen;
    private final boolean showPersonal1;
    private final boolean showMaschine2;
    private final boolean showMaschine3;
    private JSpinner txtAnsatzPersonal1;
    private JSpinner txtAnsatzPersonal2;
    private JSpinner txtAnsatzPersonal3;
    private JSpinner txtAnsatzPersonal4;
    private JSpinner txtEinsatzanteilPersonal1_Prz;
    private JSpinner txtEinsatzanteilPersonal2_Prz;
    private JSpinner txtEinsatzanteilPersonal3_Prz;
    private JSpinner txtEinsatzanteilPersonal4_Prz;
    private JSpinner txtAnteilPersonalKosten1_Prz;
    private JSpinner txtAnteilPersonalKosten2_Prz;
    private JSpinner txtAnteilPersonalKosten3_Prz;
    private JSpinner txtAnteilPersonalKosten4_Prz;
    private JSpinner txtAnsatzMaschine1;
    private JSpinner txtAnsatzMaschine2;
    private JSpinner txtAnsatzMaschine3;
    protected JLabel lblPersonal1A;
    protected JLabel lblPersonal2A;
    protected JLabel lblPersonal3A;
    protected JLabel lblPersonal4A;
    protected JLabel lblPersonal1B = new JLabel(GuiStrings.getString("KostensaetzePanel2014.SFrProStd"));
    protected JLabel lblPersonal2B = new JLabel(GuiStrings.getString("KostensaetzePanel2014.SFrProStd"));
    protected JLabel lblPersonal3B = new JLabel(GuiStrings.getString("KostensaetzePanel2014.SFrProStd"));
    protected JLabel lblPersonal4B = new JLabel(GuiStrings.getString("KostensaetzePanel2014.SFrProStd"));
    protected JLabel lblMaschine1A = new JLabel(GuiStrings.getString("KostensaetzePanel2014.Maschine"));
    protected JLabel lblMaschine1B = new JLabel(GuiStrings.getString("KostensaetzePanel2014.SFrProPMH15"));
    protected JLabel lblMaschine1_Info;
    protected JLabel lblMaschine2A = new JLabel(GuiStrings.getString("KostensaetzePanel2014.Maschine"));
    protected JLabel lblMaschine2B = new JLabel(GuiStrings.getString("KostensaetzePanel2014.SFrProPMH15"));
    protected JLabel lblMaschine2_Info;
    protected JLabel lblMaschine3A = new JLabel(GuiStrings.getString("KostensaetzePanel2014.Maschine"));
    protected JLabel lblMaschine3B = new JLabel(GuiStrings.getString("KostensaetzePanel2014.SFrProPMH15"));
    protected JLabel lblMaschine3_Info;

    public KostensaetzePanel2014(HeProMoWindow parent) {
        this(parent, false);
    }

    public KostensaetzePanel2014(HeProMoWindow parent, boolean showZusaetzlichePersonen) {
        this(parent, showZusaetzlichePersonen, true);
    }

    public KostensaetzePanel2014(HeProMoWindow parent, boolean showZusaetzlichePersonen, boolean showPersonal1) {
        this(parent, showZusaetzlichePersonen, showPersonal1, false);
    }

    public KostensaetzePanel2014(HeProMoWindow parent, boolean showZusaetzlichePersonen, boolean showPersonal1, boolean showMaschine2) {
        this(parent, showZusaetzlichePersonen, showPersonal1, showMaschine2, false);
    }

    public KostensaetzePanel2014(HeProMoWindow parent, boolean showZusaetzlichePersonen, boolean showPersonal1, boolean showMaschine2, boolean showMaschine3) {
        this.parent = parent;
        this.showZusaetzlichePersonen = showZusaetzlichePersonen;
        this.showPersonal1 = showPersonal1;
        this.showMaschine2 = showMaschine2;
        this.showMaschine3 = showMaschine3;
        this.initPanel();
        this.initData();
    }

    protected void initPanel() {
        GridBagConstraints c;
        this.setBorder(TitledBorderFactory.createTitledBorder(GuiStrings.getString("KostensaetzePanel2014.Title")));
        this.setLayout(new GridBagLayout());
        if (this.showZusaetzlichePersonen) {
            c = new GridBagConstraints();
            c.gridx = 4;
            c.gridy = 0;
            c.fill = 2;
            c.weightx = 100.0;
            c.insets = new Insets(0, 10, 0, 0);
            JLabel lblEinsatzanteil_Prz = new JLabel(GuiStrings.getString("KostensaetzePanel2014.Einsatzzeitanteil_Prz"));
            this.add((Component)lblEinsatzanteil_Prz, c);
            c = new GridBagConstraints();
            c.gridx = 5;
            c.gridy = 0;
            c.fill = 2;
            c.weightx = 100.0;
            c.insets = new Insets(0, 10, 0, 0);
            JLabel lblAnteilPersonalkosten_Prz = new JLabel(GuiStrings.getString("KostensaetzePanel2014.AnteilPersonalkosten_Prz"));
            this.add((Component)lblAnteilPersonalkosten_Prz, c);
        }
        if (this.showPersonal1) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.fill = 2;
            c.weightx = 100.0;
            c.insets = new Insets(0, 0, 0, 5);
            this.lblPersonal1A = new JLabel(GuiStrings.getString("KostensaetzePanel2014.Arbeitskraft1"));
            this.add((Component)this.lblPersonal1A, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.fill = 2;
            c.weightx = 100.0;
            this.txtAnsatzPersonal1 = new JSpinner();
            this.add((Component)this.txtAnsatzPersonal1, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 1;
            c.fill = 2;
            c.insets = new Insets(0, 5, 0, 0);
            this.add((Component)this.lblPersonal1B, c);
        }
        if (this.showZusaetzlichePersonen) {
            c = new GridBagConstraints();
            c.gridx = 4;
            c.gridy = 1;
            c.fill = 2;
            c.weightx = 100.0;
            c.insets = new Insets(0, 10, 0, 0);
            this.txtEinsatzanteilPersonal1_Prz = new JSpinner();
            this.add((Component)this.txtEinsatzanteilPersonal1_Prz, c);
            c = new GridBagConstraints();
            c.gridx = 5;
            c.gridy = 1;
            c.fill = 2;
            c.weightx = 100.0;
            c.insets = new Insets(0, 10, 0, 0);
            this.txtAnteilPersonalKosten1_Prz = new JSpinner();
            this.txtAnteilPersonalKosten1_Prz.setEnabled(false);
            this.add((Component)this.txtAnteilPersonalKosten1_Prz, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 2;
            c.fill = 2;
            c.weightx = 100.0;
            c.insets = new Insets(0, 0, 0, 5);
            this.lblPersonal2A = new JLabel(GuiStrings.getString("KostensaetzePanel2014.Arbeitskraft2"));
            this.add((Component)this.lblPersonal2A, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 2;
            c.fill = 2;
            c.weightx = 100.0;
            this.txtAnsatzPersonal2 = new JSpinner();
            this.add((Component)this.txtAnsatzPersonal2, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 2;
            c.fill = 2;
            c.insets = new Insets(0, 5, 0, 0);
            this.add((Component)this.lblPersonal2B, c);
            c = new GridBagConstraints();
            c.gridx = 4;
            c.gridy = 2;
            c.fill = 2;
            c.weightx = 100.0;
            c.insets = new Insets(0, 10, 0, 0);
            this.txtEinsatzanteilPersonal2_Prz = new JSpinner();
            this.add((Component)this.txtEinsatzanteilPersonal2_Prz, c);
            c = new GridBagConstraints();
            c.gridx = 5;
            c.gridy = 2;
            c.fill = 2;
            c.weightx = 100.0;
            c.insets = new Insets(0, 10, 0, 0);
            this.txtAnteilPersonalKosten2_Prz = new JSpinner();
            this.txtAnteilPersonalKosten2_Prz.setEnabled(false);
            this.add((Component)this.txtAnteilPersonalKosten2_Prz, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 3;
            c.fill = 2;
            c.weightx = 100.0;
            c.insets = new Insets(0, 0, 0, 5);
            this.lblPersonal3A = new JLabel(GuiStrings.getString("KostensaetzePanel2014.Arbeitskraft3"));
            this.add((Component)this.lblPersonal3A, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 3;
            c.fill = 2;
            c.weightx = 100.0;
            this.txtAnsatzPersonal3 = new JSpinner();
            this.add((Component)this.txtAnsatzPersonal3, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 3;
            c.fill = 2;
            c.insets = new Insets(0, 5, 0, 0);
            this.add((Component)this.lblPersonal3B, c);
            c = new GridBagConstraints();
            c.gridx = 4;
            c.gridy = 3;
            c.fill = 2;
            c.weightx = 150.0;
            c.insets = new Insets(0, 10, 0, 0);
            this.txtEinsatzanteilPersonal3_Prz = new JSpinner();
            this.add((Component)this.txtEinsatzanteilPersonal3_Prz, c);
            c = new GridBagConstraints();
            c.gridx = 5;
            c.gridy = 3;
            c.fill = 2;
            c.weightx = 150.0;
            c.insets = new Insets(0, 10, 0, 0);
            this.txtAnteilPersonalKosten3_Prz = new JSpinner();
            this.txtAnteilPersonalKosten3_Prz.setEnabled(false);
            this.add((Component)this.txtAnteilPersonalKosten3_Prz, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 4;
            c.fill = 2;
            c.weightx = 100.0;
            c.insets = new Insets(0, 0, 0, 5);
            this.lblPersonal4A = new JLabel(GuiStrings.getString("KostensaetzePanel2014.Arbeitskraft4"));
            this.add((Component)this.lblPersonal4A, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 4;
            c.fill = 2;
            c.weightx = 100.0;
            this.txtAnsatzPersonal4 = new JSpinner();
            this.add((Component)this.txtAnsatzPersonal4, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 4;
            c.fill = 2;
            c.insets = new Insets(0, 5, 0, 0);
            this.add((Component)this.lblPersonal4B, c);
            c = new GridBagConstraints();
            c.gridx = 4;
            c.gridy = 4;
            c.fill = 2;
            c.weightx = 100.0;
            c.insets = new Insets(0, 10, 0, 0);
            this.txtEinsatzanteilPersonal4_Prz = new JSpinner();
            this.add((Component)this.txtEinsatzanteilPersonal4_Prz, c);
            c = new GridBagConstraints();
            c.gridx = 5;
            c.gridy = 4;
            c.fill = 2;
            c.weightx = 100.0;
            c.insets = new Insets(0, 10, 0, 0);
            this.txtAnteilPersonalKosten4_Prz = new JSpinner();
            this.txtAnteilPersonalKosten4_Prz.setEnabled(false);
            this.add((Component)this.txtAnteilPersonalKosten4_Prz, c);
        }
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 5;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(10, 0, 0, 5);
        this.add((Component)this.lblMaschine1A, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 5;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(10, 0, 0, 0);
        this.txtAnsatzMaschine1 = new JSpinner();
        this.add((Component)this.txtAnsatzMaschine1, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 5;
        c.fill = 2;
        c.insets = new Insets(10, 5, 0, 0);
        this.add((Component)this.lblMaschine1B, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 5;
        c.fill = 2;
        c.insets = new Insets(10, 5, 0, 0);
        this.lblMaschine1_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("KostensaetzePanel2014.InfoButtonKostenProBetriebsstundePMH15"));
        this.add((Component)this.lblMaschine1_Info, c);
        if (this.showMaschine2) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 6;
            c.fill = 2;
            c.weightx = 100.0;
            c.insets = new Insets(10, 0, 0, 5);
            this.add((Component)this.lblMaschine2A, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 6;
            c.fill = 2;
            c.weightx = 100.0;
            c.insets = new Insets(10, 0, 0, 0);
            this.txtAnsatzMaschine2 = new JSpinner();
            this.add((Component)this.txtAnsatzMaschine2, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 6;
            c.fill = 2;
            c.insets = new Insets(10, 5, 0, 0);
            this.add((Component)this.lblMaschine2B, c);
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = 6;
            c.fill = 2;
            c.insets = new Insets(10, 5, 0, 0);
            this.lblMaschine2_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("KostensaetzePanel2014.InfoButtonKostenProBetriebsstundePMH15"));
            this.add((Component)this.lblMaschine2_Info, c);
        }
        if (this.showMaschine3) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 7;
            c.fill = 2;
            c.weightx = 100.0;
            c.insets = new Insets(10, 0, 0, 5);
            this.add((Component)this.lblMaschine3A, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 7;
            c.fill = 2;
            c.weightx = 100.0;
            c.insets = new Insets(10, 0, 0, 0);
            this.txtAnsatzMaschine3 = new JSpinner();
            this.add((Component)this.txtAnsatzMaschine3, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 7;
            c.fill = 2;
            c.insets = new Insets(10, 5, 0, 0);
            this.add((Component)this.lblMaschine3B, c);
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = 7;
            c.fill = 2;
            c.insets = new Insets(10, 5, 0, 0);
            this.lblMaschine3_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("KostensaetzePanel2014.InfoButtonKostenProBetriebsstundePMH15"));
            this.add((Component)this.lblMaschine3_Info, c);
        }
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 9;
        c.fill = 1;
        c.weighty = 100.0;
        this.add((Component)new JPanel(), c);
    }

    protected void initData() {
        if (this.showPersonal1) {
            this.txtAnsatzPersonal1.setModel(new SpinnerNumberModel(55.0, 0.0, 1000.0, 1.0));
            this.txtAnsatzPersonal1.setEditor(new JSpinner.NumberEditor(this.txtAnsatzPersonal1, "0.##"));
            this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtAnsatzPersonal1);
        }
        if (this.showZusaetzlichePersonen) {
            this.txtEinsatzanteilPersonal1_Prz.setModel(new SpinnerNumberModel(100, 100, 100, 1));
            this.txtEinsatzanteilPersonal1_Prz.setEnabled(false);
            this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtEinsatzanteilPersonal1_Prz);
            this.txtAnteilPersonalKosten1_Prz.setModel(new SpinnerNumberModel(0, 0, 100, 1));
            this.txtAnteilPersonalKosten1_Prz.setEditor(new JSpinner.NumberEditor(this.txtAnteilPersonalKosten1_Prz, "0.##"));
            this.txtAnsatzPersonal2.setModel(new SpinnerNumberModel(55.0, 0.0, 1000.0, 1.0));
            this.txtAnsatzPersonal2.setEditor(new JSpinner.NumberEditor(this.txtAnsatzPersonal2, "0.##"));
            this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtAnsatzPersonal2);
            this.txtEinsatzanteilPersonal2_Prz.setModel(new SpinnerNumberModel(100, 0, 100, 1));
            this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtEinsatzanteilPersonal2_Prz);
            this.txtAnteilPersonalKosten2_Prz.setModel(new SpinnerNumberModel(0, 0, 100, 1));
            this.txtAnteilPersonalKosten2_Prz.setEditor(new JSpinner.NumberEditor(this.txtAnteilPersonalKosten2_Prz, "0.##"));
            this.txtAnsatzPersonal3.setModel(new SpinnerNumberModel(55.0, 0.0, 1000.0, 1.0));
            this.txtAnsatzPersonal3.setEditor(new JSpinner.NumberEditor(this.txtAnsatzPersonal3, "0.##"));
            this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtAnsatzPersonal3);
            this.txtEinsatzanteilPersonal3_Prz.setModel(new SpinnerNumberModel(100, 0, 100, 1));
            this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtEinsatzanteilPersonal3_Prz);
            this.txtAnteilPersonalKosten3_Prz.setModel(new SpinnerNumberModel(0, 0, 100, 1));
            this.txtAnteilPersonalKosten3_Prz.setEditor(new JSpinner.NumberEditor(this.txtAnteilPersonalKosten3_Prz, "0.##"));
            this.txtAnsatzPersonal4.setModel(new SpinnerNumberModel(55.0, 0.0, 1000.0, 1.0));
            this.txtAnsatzPersonal4.setEditor(new JSpinner.NumberEditor(this.txtAnsatzPersonal4, "0.##"));
            this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtAnsatzPersonal4);
            this.txtEinsatzanteilPersonal4_Prz.setModel(new SpinnerNumberModel(100, 0, 100, 1));
            this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtEinsatzanteilPersonal4_Prz);
            this.txtAnteilPersonalKosten4_Prz.setModel(new SpinnerNumberModel(0, 0, 100, 1));
            this.txtAnteilPersonalKosten4_Prz.setEditor(new JSpinner.NumberEditor(this.txtAnteilPersonalKosten4_Prz, "0.##"));
        }
        this.txtAnsatzMaschine1.setModel(new SpinnerNumberModel(14.0, 0.0, 1000.0, 1.0));
        this.txtAnsatzMaschine1.setEditor(new JSpinner.NumberEditor(this.txtAnsatzMaschine1, "0.##"));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtAnsatzMaschine1);
        if (this.showMaschine2) {
            this.txtAnsatzMaschine2.setModel(new SpinnerNumberModel(14.0, 0.0, 1000.0, 1.0));
            this.txtAnsatzMaschine2.setEditor(new JSpinner.NumberEditor(this.txtAnsatzMaschine2, "0.##"));
            this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtAnsatzMaschine2);
        }
        if (this.showMaschine3) {
            this.txtAnsatzMaschine3.setModel(new SpinnerNumberModel(14.0, 0.0, 1000.0, 1.0));
            this.txtAnsatzMaschine3.setEditor(new JSpinner.NumberEditor(this.txtAnsatzMaschine3, "0.##"));
            this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtAnsatzMaschine3);
        }
        if (this.showZusaetzlichePersonen) {
            this.onInputChangedBeforeCalculation(this);
        }
    }

    public double getAnsatzPersonal1() {
        if (this.showPersonal1) {
            return (Double)this.txtAnsatzPersonal1.getValue();
        }
        return 0.0;
    }

    public void setAnsatzPersonal1(double ansatz) {
        if (this.showPersonal1) {
            this.txtAnsatzPersonal1.setValue(ansatz);
        }
    }

    public void setLabelPersonal(String name) {
        if (this.showPersonal1) {
            this.lblPersonal1A.setText(this.setFirstLetterOfStringToUpperCase(name));
        }
    }

    public int getEinsatzanteilPersonal1_Prz() {
        return (Integer)this.txtEinsatzanteilPersonal1_Prz.getValue();
    }

    public void setEinsatzzeitanteilPersonal1_Prz(int value) {
        this.txtEinsatzanteilPersonal1_Prz.setValue(value);
        this.onInputChangedBeforeCalculation(this);
    }

    public double getAnsatzPersonal2() {
        return (Double)this.txtAnsatzPersonal2.getValue();
    }

    public void setAnsatzPersonal2(double ansatz) {
        this.txtAnsatzPersonal2.setValue(ansatz);
        this.onInputChangedBeforeCalculation(this);
    }

    public int getEinsatzanteilPersonal2_Prz() {
        return (Integer)this.txtEinsatzanteilPersonal2_Prz.getValue();
    }

    public void setEinsatzzeitanteilPersonal2_Prz(int value) {
        this.txtEinsatzanteilPersonal2_Prz.setValue(value);
        this.onInputChangedBeforeCalculation(this);
    }

    public double getAnsatzPersonal3() {
        return (Double)this.txtAnsatzPersonal3.getValue();
    }

    public void setAnsatzPersonal3(double ansatz) {
        this.txtAnsatzPersonal3.setValue(ansatz);
        this.onInputChangedBeforeCalculation(this);
    }

    public int getEinsatzanteilPersonal3_Prz() {
        return (Integer)this.txtEinsatzanteilPersonal3_Prz.getValue();
    }

    public void setEinsatzzeitanteilPersonal3_Prz(int value) {
        this.txtEinsatzanteilPersonal3_Prz.setValue(value);
        this.onInputChangedBeforeCalculation(this);
    }

    public double getAnsatzPersonal4() {
        return (Double)this.txtAnsatzPersonal4.getValue();
    }

    public void setAnsatzPersonal4(double ansatz) {
        this.txtAnsatzPersonal4.setValue(ansatz);
        this.onInputChangedBeforeCalculation(this);
    }

    public int getEinsatzanteilPersonal4_Prz() {
        return (Integer)this.txtEinsatzanteilPersonal4_Prz.getValue();
    }

    public void setEinsatzzeitanteilPersonal4_Prz(int value) {
        this.txtEinsatzanteilPersonal4_Prz.setValue(value);
        this.onInputChangedBeforeCalculation(this);
    }

    public double getAnsatzMaschine1() {
        return (Double)this.txtAnsatzMaschine1.getValue();
    }

    public void setAnsatzMaschine1(double ansatz) {
        this.txtAnsatzMaschine1.setValue(ansatz);
    }

    public void setLabelMaschine1(String name) {
        this.lblMaschine1A.setText(this.setFirstLetterOfStringToUpperCase(name));
    }

    public double getAnsatzMaschine2() {
        return (Double)this.txtAnsatzMaschine2.getValue();
    }

    public void setAnsatzMaschine2(double ansatz) {
        this.txtAnsatzMaschine2.setValue(ansatz);
    }

    public void setLabelMaschine2(String name) {
        this.lblMaschine2A.setText(this.setFirstLetterOfStringToUpperCase(name));
    }

    public double getAnsatzMaschine3() {
        return (Double)this.txtAnsatzMaschine3.getValue();
    }

    public void setAnsatzMaschine3(double ansatz) {
        this.txtAnsatzMaschine3.setValue(ansatz);
    }

    public void setLabelMaschine3(String name) {
        this.lblMaschine3A.setText(this.setFirstLetterOfStringToUpperCase(name));
    }

    private String setFirstLetterOfStringToUpperCase(String inputString) {
        if (inputString == null) {
            return null;
        }
        String result = String.valueOf(inputString.substring(0, 1).toUpperCase()) + inputString.substring(1, inputString.length());
        return result;
    }

    public void onInputChangedBeforeCalculation(Object eventSource) {
        double anteil1 = (double)this.getEinsatzanteilPersonal1_Prz() / 100.0 * this.getAnsatzPersonal1();
        double anteil2 = (double)this.getEinsatzanteilPersonal2_Prz() / 100.0 * this.getAnsatzPersonal2();
        double anteil3 = (double)this.getEinsatzanteilPersonal3_Prz() / 100.0 * this.getAnsatzPersonal3();
        double anteil4 = (double)this.getEinsatzanteilPersonal4_Prz() / 100.0 * this.getAnsatzPersonal4();
        double gesamtkostensatz = anteil1 + anteil2 + anteil3 + anteil4;
        this.txtAnteilPersonalKosten1_Prz.setValue((int)(100.0 * anteil1 / gesamtkostensatz));
        this.txtAnteilPersonalKosten2_Prz.setValue((int)(100.0 * anteil2 / gesamtkostensatz));
        this.txtAnteilPersonalKosten3_Prz.setValue((int)(100.0 * anteil3 / gesamtkostensatz));
        this.txtAnteilPersonalKosten4_Prz.setValue((int)(100.0 * anteil4 / gesamtkostensatz));
    }

    @Override
    public void updateWaehrungskuerzel(String newValue) {
        this.lblPersonal1B.setText(String.valueOf(newValue) + GuiStrings.getString("KostensaetzePanel2014.ProStd"));
        this.lblPersonal2B.setText(String.valueOf(newValue) + GuiStrings.getString("KostensaetzePanel2014.ProStd"));
        this.lblPersonal3B.setText(String.valueOf(newValue) + GuiStrings.getString("KostensaetzePanel2014.ProStd"));
        this.lblPersonal4B.setText(String.valueOf(newValue) + GuiStrings.getString("KostensaetzePanel2014.ProStd"));
        this.lblMaschine1B.setText(String.valueOf(newValue) + GuiStrings.getString("KostensaetzePanel2014.ProPMH15"));
        this.lblMaschine2B.setText(String.valueOf(newValue) + GuiStrings.getString("KostensaetzePanel2014.ProPMH15"));
        this.lblMaschine3B.setText(String.valueOf(newValue) + GuiStrings.getString("KostensaetzePanel2014.ProPMH15"));
    }
}

