/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle.panel.asys;

import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoWindow;
import ch.wsl.fps.hepromo.gui.TitledBorderFactory;
import ch.wsl.fps.hepromo.gui.modelle.panel.asys.IWaehrungsanzeige;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class KostensaetzePanel
extends JPanel
implements IWaehrungsanzeige {
    private static final long serialVersionUID = 1L;
    protected final HeProMoWindow parent;
    private JSpinner txtAnsatzPersonal = new JSpinner();
    private JSpinner txtAnsatzMaschine = new JSpinner();
    protected JLabel lblMaschineA = new JLabel(GuiStrings.getString("KostensaetzePanel.Maschine"));
    protected JLabel lblPersonalA = new JLabel(GuiStrings.getString("KostensaetzePanel.Personal"));
    protected JLabel lblMaschineB = new JLabel(GuiStrings.getString("KostensaetzePanel.SFr_pro_BStd"));
    protected JLabel lblPersonalB = new JLabel(GuiStrings.getString("KostensaetzePanel.SFr_pro_Std"));

    public KostensaetzePanel(HeProMoWindow parent) {
        this.parent = parent;
        this.initPanel();
        this.initData();
    }

    protected void initPanel() {
        this.setBorder(TitledBorderFactory.createTitledBorder(GuiStrings.getString("KostensaetzePanel.Title")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        this.add((Component)this.lblPersonalA, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        this.add((Component)this.txtAnsatzPersonal, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 2;
        c.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.lblPersonalB, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.add((Component)this.lblMaschineA, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.add((Component)this.txtAnsatzMaschine, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.fill = 2;
        c.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.lblMaschineB, c);
    }

    protected void initData() {
        this.txtAnsatzPersonal.setModel(new SpinnerNumberModel(55.0, 0.0, 1000.0, 1.0));
        this.txtAnsatzPersonal.setEditor(new JSpinner.NumberEditor(this.txtAnsatzPersonal, "0.##"));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtAnsatzPersonal);
        this.txtAnsatzMaschine.setModel(new SpinnerNumberModel(14.0, 0.0, 1000.0, 1.0));
        this.txtAnsatzMaschine.setEditor(new JSpinner.NumberEditor(this.txtAnsatzMaschine, "0.##"));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtAnsatzMaschine);
    }

    public double getAnsatzPersonal() {
        return (Double)this.txtAnsatzPersonal.getValue();
    }

    public void setAnsatzPersonal(double ansatz) {
        this.txtAnsatzPersonal.setValue(ansatz);
    }

    public double getAnsatzMaschine() {
        return (Double)this.txtAnsatzMaschine.getValue();
    }

    public void setAnsatzMaschine(double ansatz) {
        this.txtAnsatzMaschine.setValue(ansatz);
    }

    public void setLabelPersonal(String name) {
        this.lblPersonalA.setText(name);
    }

    public void setLabelMaschine(String name) {
        this.lblMaschineA.setText(name);
    }

    @Override
    public void updateWaehrungskuerzel(String newValue) {
        this.lblMaschineB.setText(String.valueOf(newValue) + GuiStrings.getString("KostensaetzePanel.Pro_BStd"));
        this.lblPersonalB.setText(String.valueOf(newValue) + GuiStrings.getString("KostensaetzePanel.Pro_Std"));
    }
}

