/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle.panel.asys;

import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoWindow;
import ch.wsl.fps.hepromo.gui.TitledBorderFactory;
import ch.wsl.fps.hepromo.gui.modelle.HelikopterFliegenBase;
import ch.wsl.fps.hepromo.gui.modelle.panel.asys.IWaehrungsanzeige;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemHelikopterFliegen;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

public class HelikopterPanel
extends JPanel
implements IWaehrungsanzeige {
    private static final long serialVersionUID = 1L;
    private final HeProMoWindow parent;
    private JLabel lblHelikopterkosten = new JLabel(GuiStrings.getString("HelikopterPanel.Helikopterkosten_SFr_pro_BMin"));
    private JLabel lblAnflugpauschale = new JLabel(GuiStrings.getString("HelikopterPanel.Anflugpauschale_SFr"));
    private JSpinner txtHelikopterKosten_proMin;
    private JSpinner txtAnflugpauschale;
    private JComboBox<ArbeitssystemHelikopterFliegen.HelikopterKlasse> cmbHeliklasse;
    private JSpinner txtLastvolumen_m3;
    private JCheckBox chkLastvolumenAutomatischBerechnen;

    public HelikopterPanel(HeProMoWindow parent) {
        this.parent = parent;
        this.initPanel();
        this.initData();
    }

    private void initPanel() {
        this.setBorder(TitledBorderFactory.createTitledBorder(GuiStrings.getString("HelikopterPanel.Title")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.lblHelikopterkosten, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtHelikopterKosten_proMin = new JSpinner(new SpinnerNumberModel(60, 0, 500, 1));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtHelikopterKosten_proMin);
        this.add((Component)this.txtHelikopterKosten_proMin, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.add((Component)this.lblAnflugpauschale, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtAnflugpauschale = new JSpinner(new SpinnerNumberModel(500, 0, 5000, 1));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtAnflugpauschale);
        this.add((Component)this.txtAnflugpauschale, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        JLabel lblHeliklasse = new JLabel(GuiStrings.getString("HelikopterPanel.Heliklasse"));
        this.add((Component)lblHeliklasse, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbHeliklasse = new JComboBox();
        this.add(this.cmbHeliklasse, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 100.0;
        JLabel lblLastvolumen = new JLabel("<html>" + GuiStrings.getString("HelikopterPanel.Lastvolumen") + " (m<sup>3</sup>)</html>");
        this.add((Component)lblLastvolumen, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtLastvolumen_m3 = new JSpinner(new SpinnerNumberModel(1.0, 0.5, 20.0, 0.1));
        this.txtLastvolumen_m3.setEditor(new JSpinner.NumberEditor(this.txtLastvolumen_m3, "0.####"));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtLastvolumen_m3);
        this.txtLastvolumen_m3.setEnabled(false);
        this.add((Component)this.txtLastvolumen_m3, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(0, 15, 0, 0);
        this.chkLastvolumenAutomatischBerechnen = new JCheckBox(GuiStrings.getString("HelikopterPanel.LastvolumenAutomatischBerechnen"));
        this.chkLastvolumenAutomatischBerechnen.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean auto = HelikopterPanel.this.chkLastvolumenAutomatischBerechnen.isSelected();
                HelikopterPanel.this.txtLastvolumen_m3.setEnabled(!auto);
                if (auto) {
                    ((HelikopterFliegenBase)HelikopterPanel.this.parent).adaptLastvolumen();
                }
            }
        });
        this.chkLastvolumenAutomatischBerechnen.setSelected(true);
        this.add((Component)this.chkLastvolumenAutomatischBerechnen, c);
    }

    private void initData() {
        ArbeitssystemHelikopterFliegen.HelikopterKlasse[] helikopterKlasseArray = ArbeitssystemHelikopterFliegen.HelikopterKlasse.values();
        int n = helikopterKlasseArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArbeitssystemHelikopterFliegen.HelikopterKlasse heliKlasse = helikopterKlasseArray[n2];
            this.cmbHeliklasse.addItem(heliKlasse);
            ++n2;
        }
        this.parent.addDefaultActionListener(this.cmbHeliklasse);
        this.cmbHeliklasse.setSelectedItem((Object)ArbeitssystemHelikopterFliegen.HelikopterKlasse.Mittel);
    }

    public void onInputChangedBeforeCalculation(Object eventSource) {
        if (this.cmbHeliklasse.equals(eventSource)) {
            ((HelikopterFliegenBase)this.parent).adaptLastvolumen();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String message = GuiStrings.getString("HelikopterPanel.WarnungKostensatzMessage");
                    JOptionPane.showMessageDialog(HelikopterPanel.this.parent, message, GuiStrings.getString("HelikopterPanel.WarnungKostensatzTitle"), 2);
                }
            });
        }
    }

    public int getHelikopterKosten_proMin() {
        return (Integer)this.txtHelikopterKosten_proMin.getValue();
    }

    public int getAnflugpauschale() {
        return (Integer)this.txtAnflugpauschale.getValue();
    }

    public ArbeitssystemHelikopterFliegen.HelikopterKlasse getHelikopterKlasse() {
        return (ArbeitssystemHelikopterFliegen.HelikopterKlasse)((Object)this.cmbHeliklasse.getSelectedItem());
    }

    public double getLastvolumen_m3() {
        return (Double)this.txtLastvolumen_m3.getValue();
    }

    public boolean isLastvolumenAutomatischBerechnen() {
        return this.chkLastvolumenAutomatischBerechnen.isSelected();
    }

    public void setHelikopterKosten_proMin(int value) {
        this.txtHelikopterKosten_proMin.setValue(value);
    }

    public void setAnflugpauschale(int anflugPauschale) {
        this.txtAnflugpauschale.setValue(anflugPauschale);
    }

    public void setHelikopterKlasse(ArbeitssystemHelikopterFliegen.HelikopterKlasse helikopterKlasse) {
        this.cmbHeliklasse.setSelectedItem((Object)helikopterKlasse);
    }

    public void setLastvolumen_m3(double lastVolumen) {
        this.txtLastvolumen_m3.setValue(lastVolumen);
    }

    public void setLastvolumenAutomatischBerechnen(boolean flag) {
        this.chkLastvolumenAutomatischBerechnen.setSelected(flag);
    }

    @Override
    public void updateWaehrungskuerzel(String newValue) {
        this.lblHelikopterkosten.setText(String.valueOf(GuiStrings.getString("HelikopterPanel.Helikopterkosten")) + " (" + newValue + GuiStrings.getString("HelikopterPanel.Pro_BMin") + ")");
        this.lblAnflugpauschale.setText(String.valueOf(GuiStrings.getString("HelikopterPanel.Anflugpauschale")) + " (" + newValue + ")");
    }
}

