/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle.panel.aobj;

import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoWindow;
import ch.wsl.fps.hepromo.gui.TitledBorderFactory;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektSchlepper2014;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BestandPanelSchlepper2014
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final HeProMoWindow parent;
    private JSpinner txtHolzmenge_m3iR;
    private JLabel lblHolzmenge_m3oR_readOnly;
    private JSpinner txtMittlererStueckinhalt;
    private JComboBox<ArbeitsobjektSchlepper2014.MittlereFahrentfernung> cmbMittlereFahrentfernung;

    public BestandPanelSchlepper2014(HeProMoWindow parent) {
        this.parent = parent;
        this.initPanel();
        this.initData();
    }

    private void initPanel() {
        this.setBorder(TitledBorderFactory.createTitledBorder(GuiStrings.getString("BestandPanelSchlepper2014.AusscheidenderBestand")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        JLabel lblHolzmenge_iR = new JLabel(GuiStrings.getString("BestandPanelSchlepper2014.Holzmenge_m3_iR"));
        this.add((Component)lblHolzmenge_iR, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtHolzmenge_m3iR = new JSpinner();
        this.add((Component)this.txtHolzmenge_m3iR, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 13;
        c.insets = new Insets(0, 15, 0, 0);
        this.lblHolzmenge_m3oR_readOnly = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BestandPanelSchlepper2014.TooltipUmrechnungsfaktor"));
        this.lblHolzmenge_m3oR_readOnly.setHorizontalTextPosition(2);
        this.add((Component)this.lblHolzmenge_m3oR_readOnly, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        JLabel lblMittlererStueckinhalt = new JLabel(GuiStrings.getString("BestandPanelSchlepper2014.MittlererStueckinhalt_m3_iR_pro_Stk"));
        this.add((Component)lblMittlererStueckinhalt, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtMittlererStueckinhalt = new JSpinner();
        this.add((Component)this.txtMittlererStueckinhalt, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(0, 0, 5, 0);
        JLabel lblMittlereFahrentfernung = new JLabel(GuiStrings.getString("BestandPanelSchlepper2014.MittlereFahrentfernung"));
        this.add((Component)lblMittlereFahrentfernung, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(0, 0, 5, 0);
        this.cmbMittlereFahrentfernung = new JComboBox();
        this.add(this.cmbMittlereFahrentfernung, c);
    }

    private void initData() {
        this.txtHolzmenge_m3iR.setModel(new SpinnerNumberModel(100.0, 0.0, 100000.0, 50.0));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtHolzmenge_m3iR);
        this.txtHolzmenge_m3iR.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BestandPanelSchlepper2014.this.updateLabelHolzmenge_m3iR();
            }
        });
        this.txtMittlererStueckinhalt.setModel(new SpinnerNumberModel(0.5, 0.05, 3.0, 0.01));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtMittlererStueckinhalt);
        ArbeitsobjektSchlepper2014.MittlereFahrentfernung[] mittlereFahrentfernungArray = ArbeitsobjektSchlepper2014.MittlereFahrentfernung.values();
        int n = mittlereFahrentfernungArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArbeitsobjektSchlepper2014.MittlereFahrentfernung value = mittlereFahrentfernungArray[n2];
            this.cmbMittlereFahrentfernung.addItem(value);
            ++n2;
        }
        this.parent.addDefaultActionListener(this.cmbMittlereFahrentfernung);
    }

    public void updateLabelHolzmengeMitRindenabzug() {
        this.updateLabelHolzmenge_m3iR();
    }

    private void updateLabelHolzmenge_m3iR() {
        DecimalFormat df = new DecimalFormat(",###.##");
        double value = (Double)this.txtHolzmenge_m3iR.getValue();
        this.lblHolzmenge_m3oR_readOnly.setText("<html>(" + df.format(value *= this.parent.getModel().getArbeitsobjekt().getRindenAbzugFaktor()) + " m<sup>3</sup> " + GuiStrings.getString("BestandPanelSchlepper2014.oR") + ")</html>");
    }

    public double getHolzmenge_m3() {
        return (Double)this.txtHolzmenge_m3iR.getValue();
    }

    public void setHolzmenge_m3(double holzmenge_m3) {
        this.txtHolzmenge_m3iR.setValue(holzmenge_m3);
        this.updateLabelHolzmenge_m3iR();
    }

    public double getMittlererStueckinhalt() {
        return (Double)this.txtMittlererStueckinhalt.getValue();
    }

    public void setMittlererStueckinhalt(double mittlererStueckinhalt) {
        this.txtMittlererStueckinhalt.setValue(mittlererStueckinhalt);
    }

    public ArbeitsobjektSchlepper2014.MittlereFahrentfernung getMittlereFahrentfernung() {
        return (ArbeitsobjektSchlepper2014.MittlereFahrentfernung)((Object)this.cmbMittlereFahrentfernung.getSelectedItem());
    }

    public void setMittlereFahrentfernung(ArbeitsobjektSchlepper2014.MittlereFahrentfernung mittlereFahrentfernung) {
        this.cmbMittlereFahrentfernung.setSelectedItem((Object)mittlereFahrentfernung);
    }
}

