/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle;

import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoWindow;
import ch.wsl.fps.hepromo.gui.MainWindow;
import ch.wsl.fps.hepromo.gui.TitledBorderFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class PoltervolumenSchaetzmethode
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final Icon iconQuader = PoltervolumenSchaetzmethode.getIcon("data/quader.png");
    protected static final Icon iconHalbzylinder = PoltervolumenSchaetzmethode.getIcon("data/zylinder.png");
    private final JLabel lblIcon = new JLabel();
    protected final JLabel lblHoehe = new JLabel(GuiStrings.getString("PoltervolumenSchaetzmethode.MittlereHoehe_m"));
    protected final JLabel lblBreite = new JLabel(GuiStrings.getString("PoltervolumenSchaetzmethode.MittlereBreite_m"));
    protected final JLabel lblTiefe = new JLabel(GuiStrings.getString("PoltervolumenSchaetzmethode.MittlereTiefe_m"));
    protected final JLabel lblOptional1 = new JLabel();
    protected final JLabel lblOptional2 = new JLabel();
    protected final JLabel lblOptional3 = new JLabel();
    protected final JSpinner txtHoehe = new JSpinner(new SpinnerNumberModel(4.0, 0.5, 50.0, 0.2));
    protected final JSpinner txtBreite = new JSpinner(new SpinnerNumberModel(12.0, 0.5, 50.0, 0.2));
    protected final JSpinner txtTiefe = new JSpinner(new SpinnerNumberModel(5.0, 0.5, 50.0, 0.2));
    protected final JSpinner txtOptional1 = new JSpinner();
    protected final JSpinner txtOptional2 = new JSpinner();
    protected final JComboBox<Integer> cmbOptional3 = new JComboBox();
    private final JLabel lblResult = new JLabel(GuiStrings.getString("PoltervolumenSchaetzmethode.Hackschnitzelmenge_Srm"));
    private final JSpinner txtResult = new JSpinner();

    public PoltervolumenSchaetzmethode(Icon icon, boolean showOptional1, boolean showOptional2, boolean showOptional3) {
        this.lblIcon.setIcon(icon);
        this.init(showOptional1, showOptional2, showOptional3);
    }

    private void init(boolean showOptional1, boolean showOptional2, boolean showOptional3) {
        JLabel lblInfoButton;
        HeProMoWindow.adjustJSpinnerFormatter(this.txtHoehe, false);
        HeProMoWindow.adjustJSpinnerFormatter(this.txtBreite, false);
        HeProMoWindow.adjustJSpinnerFormatter(this.txtTiefe, false);
        HeProMoWindow.adjustJSpinnerFormatter(this.txtOptional1, false);
        HeProMoWindow.adjustJSpinnerFormatter(this.txtOptional2, false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 99;
        c.insets = new Insets(0, 0, 0, 10);
        JPanel panelIcon = new JPanel();
        panelIcon.setBorder(TitledBorderFactory.createTitledBorder(GuiStrings.getString("PoltervolumenSchaetzmethode.Polterform")));
        panelIcon.add(this.lblIcon);
        this.add((Component)panelIcon, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.fill = 2;
        c.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.lblHoehe, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtHoehe.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                PoltervolumenSchaetzmethode.this.updateResult();
            }
        });
        this.add((Component)this.txtHoehe, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 2;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 10);
        this.add((Component)this.lblBreite, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtBreite.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                PoltervolumenSchaetzmethode.this.updateResult();
            }
        });
        this.add((Component)this.txtBreite, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 2;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 10);
        this.add((Component)this.lblTiefe, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtTiefe.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                PoltervolumenSchaetzmethode.this.updateResult();
            }
        });
        this.add((Component)this.txtTiefe, c);
        if (showOptional1) {
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 3;
            c.gridwidth = 2;
            c.fill = 2;
            c.insets = new Insets(0, 0, 0, 10);
            this.add((Component)this.lblOptional1, c);
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = 3;
            c.fill = 2;
            c.weightx = 100.0;
            this.txtOptional1.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    PoltervolumenSchaetzmethode.this.updateResult();
                }
            });
            this.add((Component)this.txtOptional1, c);
        }
        if (showOptional2) {
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 4;
            c.gridwidth = 2;
            c.fill = 2;
            c.insets = new Insets(0, 0, 0, 10);
            this.add((Component)this.lblOptional2, c);
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = 4;
            c.fill = 2;
            c.weightx = 100.0;
            this.txtOptional2.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    PoltervolumenSchaetzmethode.this.updateResult();
                }
            });
            this.add((Component)this.txtOptional2, c);
        }
        if (showOptional3) {
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 5;
            c.insets = new Insets(0, 0, 0, 10);
            this.add((Component)this.lblOptional3, c);
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = 5;
            c.fill = 2;
            c.weightx = 100.0;
            ((JLabel)((Object)this.cmbOptional3.getRenderer())).setHorizontalAlignment(4);
            this.cmbOptional3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PoltervolumenSchaetzmethode.this.updateResult();
                }
            });
            this.add(this.cmbOptional3, c);
            c = new GridBagConstraints();
            c.gridx = 4;
            c.gridy = 5;
            c.insets = new Insets(0, 10, 0, 0);
            lblInfoButton = GuiStrings.getInfoButtonBlue(GuiStrings.getString("PoltervolumenSchaetzmethode.InfoButtonKronenfussflaeche"));
            this.add((Component)lblInfoButton, c);
        } else {
            c = new GridBagConstraints();
            c.gridx = 4;
            c.gridy = 5;
            c.insets = new Insets(0, 26, 0, 0);
            this.add((Component)new JLabel(), c);
        }
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 6;
        c.gridwidth = 2;
        c.fill = 1;
        c.weighty = 100.0;
        this.add((Component)new JPanel(), c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 7;
        c.gridwidth = 2;
        c.fill = 2;
        c.insets = new Insets(0, 0, 10, 10);
        this.add((Component)this.lblResult, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 7;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(0, 0, 10, 0);
        this.txtResult.setEnabled(false);
        this.add((Component)this.txtResult, c);
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 7;
        c.insets = new Insets(0, 10, 10, 0);
        lblInfoButton = GuiStrings.getInfoButtonBlue(GuiStrings.getString("PoltervolumenSchaetzmethode.InfoButtonSrm"));
        this.add((Component)lblInfoButton, c);
    }

    @Override
    public abstract String toString();

    protected final void updateResult() {
        double result = (float)Math.round(this.getResult() * 10.0) / 10.0f;
        this.txtResult.setValue(result);
    }

    public abstract double getResult();

    private static Icon getIcon(String filePath) {
        URL imgURL = MainWindow.class.getClassLoader().getResource(filePath);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return new ImageIcon(filePath);
    }

    public static class SchaetzmethodeKuptz
    extends PoltervolumenSchaetzmethode {
        private static final long serialVersionUID = 1L;

        public SchaetzmethodeKuptz() {
            super(iconQuader, false, false, true);
            this.lblOptional3.setText(GuiStrings.getString("PoltervolumenSchaetzmethode.Kronenfussflaeche_Prz"));
            this.cmbOptional3.addItem(40);
            this.cmbOptional3.addItem(45);
            this.cmbOptional3.addItem(50);
            this.cmbOptional3.addItem(55);
            this.cmbOptional3.addItem(60);
            this.cmbOptional3.addItem(65);
            super.updateResult();
        }

        @Override
        public String toString() {
            return GuiStrings.getString("PoltervolumenSchaetzmethode.SchaetzmethodeKuptz");
        }

        @Override
        public double getResult() {
            double hoehe_m = (Double)this.txtHoehe.getValue();
            double breite_m = (Double)this.txtBreite.getValue();
            double tiefe_m = (Double)this.txtTiefe.getValue();
            int kronenfussflaeche_Prz = (Integer)this.cmbOptional3.getSelectedItem();
            double umrechnungsfaktor = -1.0;
            switch (kronenfussflaeche_Prz) {
                case 40: {
                    umrechnungsfaktor = 1.0;
                    break;
                }
                case 45: {
                    umrechnungsfaktor = 1.1;
                    break;
                }
                case 50: {
                    umrechnungsfaktor = 1.2;
                    break;
                }
                case 55: {
                    umrechnungsfaktor = 1.4;
                    break;
                }
                case 60: {
                    umrechnungsfaktor = 1.5;
                    break;
                }
                case 65: {
                    umrechnungsfaktor = 1.6;
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(this, String.valueOf(GuiStrings.getString("PoltervolumenSchaetzmethode.FehlerUngueltigeKronenfussflaeche")) + String.valueOf(kronenfussflaeche_Prz), GuiStrings.getString("PoltervolumenSchaetzmethode.TitleFehler"), 0);
                }
            }
            double result = hoehe_m * breite_m * tiefe_m * umrechnungsfaktor;
            return result;
        }
    }

    public static class SchaetzmethodeKuptzWaldrestholz
    extends PoltervolumenSchaetzmethode {
        private static final long serialVersionUID = 1L;

        public SchaetzmethodeKuptzWaldrestholz() {
            super(iconHalbzylinder, false, false, true);
            this.lblHoehe.setText(GuiStrings.getString("PoltervolumenSchaetzmethode.HoeheStirnseite"));
            this.lblOptional3.setText(GuiStrings.getString("PoltervolumenSchaetzmethode.Kronenfussflaeche_Prz"));
            this.cmbOptional3.addItem(20);
            this.cmbOptional3.addItem(25);
            this.cmbOptional3.addItem(30);
            this.cmbOptional3.addItem(35);
            super.updateResult();
        }

        @Override
        public String toString() {
            return GuiStrings.getString("PoltervolumenSchaetzmethode.SchaetzmethodeKuptzWaldrestholz");
        }

        @Override
        public double getResult() {
            double hoehe_m = (Double)this.txtHoehe.getValue();
            double breite_m = (Double)this.txtBreite.getValue();
            double tiefe_m = (Double)this.txtTiefe.getValue();
            int kronenfussflaeche_Prz = (Integer)this.cmbOptional3.getSelectedItem();
            double umrechnungsfaktor = -1.0;
            switch (kronenfussflaeche_Prz) {
                case 20: {
                    umrechnungsfaktor = 0.4;
                    break;
                }
                case 25: {
                    umrechnungsfaktor = 0.6;
                    break;
                }
                case 30: {
                    umrechnungsfaktor = 0.7;
                    break;
                }
                case 35: {
                    umrechnungsfaktor = 0.8;
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(this, String.valueOf(GuiStrings.getString("PoltervolumenSchaetzmethode.FehlerUngueltigeKronenfussflaeche")) + String.valueOf(kronenfussflaeche_Prz), GuiStrings.getString("PoltervolumenSchaetzmethode.TitleFehler"), 0);
                }
            }
            double result = 0.7853981633974483 * hoehe_m * breite_m * tiefe_m * umrechnungsfaktor;
            return result;
        }
    }

    public static class SchaetzmethodeRauricaDetailliert
    extends PoltervolumenSchaetzmethode {
        private static final long serialVersionUID = 1L;

        public SchaetzmethodeRauricaDetailliert() {
            super(iconQuader, true, true, false);
            this.lblOptional1.setText(GuiStrings.getString("PoltervolumenSchaetzmethode.VolumenanteilNadelholz_Prz"));
            this.lblOptional2.setText(GuiStrings.getString("PoltervolumenSchaetzmethode.VolumenAnteilLaubholz_Prz"));
            this.txtOptional1.setModel(new SpinnerNumberModel(50, 0, 100, 1));
            this.txtOptional2.setModel(new SpinnerNumberModel(50, 0, 100, 1));
            HeProMoWindow.adjustJSpinnerFormatter(this.txtOptional1, false);
            HeProMoWindow.adjustJSpinnerFormatter(this.txtOptional2, false);
            super.updateResult();
        }

        @Override
        public String toString() {
            return GuiStrings.getString("PoltervolumenSchaetzmethode.SchaetzmethodeRauricaDetailliert");
        }

        @Override
        public double getResult() {
            double hoehe_m = (Double)this.txtHoehe.getValue();
            double breite_m = (Double)this.txtBreite.getValue();
            double tiefe_m = (Double)this.txtTiefe.getValue();
            double anteilNadel = (double)((Integer)this.txtOptional1.getValue()).intValue() / 100.0;
            double anteilDerbholz = (double)((Integer)this.txtOptional2.getValue()).intValue() / 100.0;
            double result = 2.8 * hoehe_m * breite_m * tiefe_m * 0.5 * (anteilNadel * 0.8 + (1.0 - anteilNadel) * 0.6) * (anteilDerbholz * 0.7 + (1.0 - anteilDerbholz) * 0.5);
            return result;
        }
    }

    public static class SchaetzmethodeRauricaGross
    extends PoltervolumenSchaetzmethode {
        private static final long serialVersionUID = 1L;

        public SchaetzmethodeRauricaGross() {
            super(iconQuader, false, false, false);
            this.updateResult();
        }

        @Override
        public String toString() {
            return GuiStrings.getString("PoltervolumenSchaetzmethode.SchaetzmethodeRauricaGross");
        }

        @Override
        public double getResult() {
            double hoehe_m = (Double)this.txtHoehe.getValue();
            double breite_m = (Double)this.txtBreite.getValue();
            double tiefe_m = (Double)this.txtTiefe.getValue();
            double result = hoehe_m * breite_m * tiefe_m * 0.4;
            return result;
        }
    }

    public static class SchaetzmethodeRauricaKlein
    extends PoltervolumenSchaetzmethode {
        private static final long serialVersionUID = 1L;

        public SchaetzmethodeRauricaKlein() {
            super(iconQuader, false, false, false);
            this.updateResult();
        }

        @Override
        public String toString() {
            return GuiStrings.getString("PoltervolumenSchaetzmethode.SchaetzmethodeRauricaKlein");
        }

        @Override
        public double getResult() {
            double hoehe_m = (Double)this.txtHoehe.getValue();
            double breite_m = (Double)this.txtBreite.getValue();
            double tiefe_m = (Double)this.txtTiefe.getValue();
            double result = hoehe_m * breite_m * tiefe_m * 0.6;
            return result;
        }
    }
}

