/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle;

import ch.wsl.fps.hepromo.gui.HeProMoWindow;
import ch.wsl.fps.hepromo.gui.modelle.panel.asys.ArbeitswegePausenPanel;
import ch.wsl.fps.hepromo.gui.modelle.panel.asys.HelikopterPanel;
import ch.wsl.fps.hepromo.gui.modelle.panel.asys.WeitereAufwaendePanel;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektHelikopterFliegen;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemHelikopterFliegen;
import javax.swing.JComboBox;
import javax.swing.JSpinner;

public abstract class HelikopterFliegenBase
extends HeProMoWindow {
    private static final long serialVersionUID = 1L;
    protected JSpinner txtHolzmenge_m3iR;
    protected JComboBox<ArbeitsobjektHelikopterFliegen.Holztyp> cmbHolztyp;
    protected JSpinner txtHorizontalDistanz_m;
    protected JSpinner txtVertikalDistanz_m;
    protected HelikopterPanel panelHelikopter;
    protected ArbeitswegePausenPanel panelArbeitswegePausen;
    protected WeitereAufwaendePanel panelWeitereAufwaende;

    public void adaptLastvolumen() {
        if (this.panelHelikopter != null && this.panelHelikopter.isLastvolumenAutomatischBerechnen()) {
            double lastVolumen = this.calcLastvolumen_m3();
            this.panelHelikopter.setLastvolumen_m3(lastVolumen);
        }
    }

    private double calcLastvolumen_m3() {
        ArbeitsobjektHelikopterFliegen.Holztyp holztyp = (ArbeitsobjektHelikopterFliegen.Holztyp)((Object)this.cmbHolztyp.getSelectedItem());
        ArbeitssystemHelikopterFliegen.HelikopterKlasse heliklasse = this.panelHelikopter.getHelikopterKlasse();
        double spezGewicht = 0.0;
        switch (holztyp) {
            case Laubholz_frisch: {
                spezGewicht = 10.0;
                break;
            }
            case Laubholz_angetrocknet: {
                spezGewicht = 9.0;
                break;
            }
            case Nadelholz_frisch: {
                spezGewicht = 8.4;
                break;
            }
            case Nadelholz_angetrocknet: {
                spezGewicht = 7.5;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        double lastKapaziaet = 0.0;
        switch (heliklasse) {
            case Leicht: {
                lastKapaziaet = 11.0;
                break;
            }
            case Mittel: {
                lastKapaziaet = 30.0;
                break;
            }
            case Schwer: {
                lastKapaziaet = 49.0;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        double ausnutzungsgrad = 0.8;
        double lastVolumen = lastKapaziaet / spezGewicht;
        return lastVolumen *= ausnutzungsgrad;
    }

    @Override
    protected void updateWaehrungskuerzel(String newValue) {
        super.updateWaehrungskuerzel(newValue);
        this.panelHelikopter.updateWaehrungskuerzel(newValue);
        this.panelWeitereAufwaende.updateWaehrungskuerzel(newValue);
    }
}

