/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle;

import ch.wsl.fps.hepromo.gui.ErgebnisColorListCellRenderer;
import ch.wsl.fps.hepromo.gui.ErgebnisPanel;
import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoWindow2014;
import ch.wsl.fps.hepromo.gui.MainWindow;
import ch.wsl.fps.hepromo.gui.TitledBorderFactory;
import ch.wsl.fps.hepromo.gui.modelle.BiomasseschaetzerEnergie2018;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektForwarder2018;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemForwarder2018;
import ch.wsl.fps.hepromo.model.calc.BiomasseCalculatorKompartimente2018;
import ch.wsl.fps.hepromo.model.calc.CalculatorForwarder2018;
import ch.wsl.fps.hepromo.model.modelle.AbstractModel;
import ch.wsl.fps.hepromo.model.modelle.ModelForwarder2018;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class Forwarder2018
extends HeProMoWindow2014 {
    private static final long serialVersionUID = 1L;
    private BiomasseschaetzerEnergie2018 energieholzschaetzer = null;
    private boolean holzmengenUnveraendertSeitBerechnungEnergieholzmengen = false;
    private boolean hinweisAenderungenBeimNachestenChangeZeigen = false;
    protected final DecimalFormat df = new DecimalFormat(",###.##");
    protected double verkaufsmenge_m3oR;
    protected JLabel lblSchaftholz_m3iR;
    protected JSpinner txtSchaftholz_m3iR;
    protected JLabel lblSchaftholz_Info;
    protected JLabel lblEnergieholzmenge_m3iR;
    protected JSpinner txtEnergieholzmenge_m3iR;
    protected JLabel lblEnergieholz_Info;
    protected JLabel lblEnergieholzAusSchaftholz_m3iR;
    protected JSpinner txtEnergieholzAusSchaftholz_m3iR;
    protected JLabel lblEnergieholzAusSchaftholz_Info;
    protected JLabel lblEnergieholzAusAstderbholzUndReisig_m3iR;
    protected JSpinner txtEnergieholzAusAstderbholzUndReisig_m3iR;
    private JLabel lblVerkaufRundholz_m3iR;
    protected JSpinner txtVerkaufRundholz_m3iR;
    protected JLabel lblVerkaufRundholz_m3oR_Info;
    protected JButton btnEnergieholzvolumenBerechnen;
    private JSpinner txtBhdMit_cm;
    private JComboBox<ArbeitsobjektForwarder2018.Rueckeentfernung> cmbRueckeentfernung;
    private JComboBox<ArbeitsobjektForwarder2018.Hangneigung> cmbHangneigung;
    private JComboBox<ArbeitsobjektForwarder2018.AnzahlSortimente> cmbAnzahlSortimente;
    private JComboBox<ArbeitsobjektForwarder2018.Erschwernisse> cmbErschwernisse;
    private JComboBox<ArbeitsobjektForwarder2018.AbstandRueckegasse> cmbAbstandRueckegasse;
    protected JLabel lblZopfdurchmesser_cm;
    protected JSpinner txtZopfdurchmesser_cm;
    protected JLabel lblEnergieholzanfall_m3iRproHa;
    protected JComboBox<ArbeitsobjektForwarder2018.Energieholzanfall> cmbEnergieholzanfall_m3iRproHa;
    protected JLabel lblEnergieholzanfall_Info;
    private JComboBox<ArbeitssystemForwarder2018.Forwardertyp> cmbForwardertyp;
    protected JLabel lblErgebnisanzeige;
    protected JComboBox<CalculatorForwarder2018.ErgebnisAnzeige> cmbErgebnisanzeige;
    private static final HashMap<ImgCode, ImageIcon> imageCache = new HashMap();
    protected JLabel lblSkizzeBaumteile;
    private JLabel lblMouseSensitiveArea;
    private ModelForwarder2018 model = new ModelForwarder2018();
    private static final Color HIGHLIGHT_COLOR = new Color(255, 221, 187);

    @Override
    protected void initPanelArbeitsobjekt(JPanel panel) {
        panel.setBorder(TitledBorderFactory.createTitledBorder(""));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 20.0;
        this.lblSchaftholz_m3iR = new JLabel(GuiStrings.getString("Forwarder2018.Schaftholz_m3iR"));
        panel.add((Component)this.lblSchaftholz_m3iR, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtSchaftholz_m3iR = new JSpinner();
        panel.add((Component)this.txtSchaftholz_m3iR, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 10, 0, 0);
        this.lblSchaftholz_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("Forwarder2018.InfoButtonSchaftholz"));
        panel.add((Component)this.lblSchaftholz_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 20.0;
        this.lblEnergieholzmenge_m3iR = new JLabel(GuiStrings.getString("Forwarder2018.Energieholz_m3iR"));
        panel.add((Component)this.lblEnergieholzmenge_m3iR, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtEnergieholzmenge_m3iR = new JSpinner();
        panel.add((Component)this.txtEnergieholzmenge_m3iR, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(0, 10, 0, 0);
        this.lblEnergieholz_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("Forwarder2018.InfoButtonEnergieholz"));
        panel.add((Component)this.lblEnergieholz_Info, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 1;
        c.anchor = 17;
        c.weightx = 30.0;
        c.insets = new Insets(0, 5, 0, 0);
        this.btnEnergieholzvolumenBerechnen = new JButton(GuiStrings.getString("Forwarder2018.Berechnen"));
        this.btnEnergieholzvolumenBerechnen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int bhd_cm = (Integer)Forwarder2018.this.txtBhdMit_cm.getValue();
                int zopf_cm = (Integer)Forwarder2018.this.txtZopfdurchmesser_cm.getValue();
                if (Forwarder2018.this.energieholzschaetzer == null) {
                    Forwarder2018.this.energieholzschaetzer = new BiomasseschaetzerEnergie2018(bhd_cm, zopf_cm, Forwarder2018.this, (Double)Forwarder2018.this.txtSchaftholz_m3iR.getValue());
                } else {
                    Forwarder2018.this.energieholzschaetzer.setBhd_cm(bhd_cm);
                    Forwarder2018.this.energieholzschaetzer.setZopf_cm(zopf_cm);
                    Forwarder2018.this.energieholzschaetzer.setVisible(true);
                }
            }
        });
        panel.add((Component)this.btnEnergieholzvolumenBerechnen, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 10, 0, 0);
        this.lblEnergieholzAusSchaftholz_m3iR = new JLabel(GuiStrings.getString("Forwarder2018.EnergieholzAusSchaftholz_m3iR"));
        panel.add((Component)this.lblEnergieholzAusSchaftholz_m3iR, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtEnergieholzAusSchaftholz_m3iR = new JSpinner();
        panel.add((Component)this.txtEnergieholzAusSchaftholz_m3iR, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 10, 0, 0);
        this.lblEnergieholzAusSchaftholz_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("Forwarder2018.InfoButtonEnergieholzAusSchaftholz"));
        panel.add((Component)this.lblEnergieholzAusSchaftholz_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 10, 0, 8);
        this.lblEnergieholzAusAstderbholzUndReisig_m3iR = new JLabel(GuiStrings.getString("Forwarder2018.EnergieholzAusAstderbholzUndReisig_m3iR"));
        panel.add((Component)this.lblEnergieholzAusAstderbholzUndReisig_m3iR, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtEnergieholzAusAstderbholzUndReisig_m3iR = new JSpinner();
        panel.add((Component)this.txtEnergieholzAusAstderbholzUndReisig_m3iR, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.fill = 2;
        c.weightx = 20.0;
        this.lblVerkaufRundholz_m3iR = new JLabel(GuiStrings.getString("Forwarder2018.VerkaufRundholz_m3iR"));
        panel.add((Component)this.lblVerkaufRundholz_m3iR, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 4;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtVerkaufRundholz_m3iR = new JSpinner();
        panel.add((Component)this.txtVerkaufRundholz_m3iR, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 4;
        c.gridwidth = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 10, 0, 0);
        this.lblVerkaufRundholz_m3oR_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("Forwarder2018.InfoButtonVerkaufRundholz"));
        this.lblVerkaufRundholz_m3oR_Info.setHorizontalTextPosition(2);
        this.lblVerkaufRundholz_m3oR_Info.setMinimumSize(new Dimension(120, 12));
        panel.add((Component)this.lblVerkaufRundholz_m3oR_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 5;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(10, 0, 0, 0);
        JLabel lblBhdMit_cm = new JLabel(GuiStrings.getString("Forwarder2018.MittlererBhd_cm"));
        panel.add((Component)lblBhdMit_cm, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 5;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(10, 0, 0, 0);
        this.txtBhdMit_cm = new JSpinner();
        panel.add((Component)this.txtBhdMit_cm, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 6;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblRueckeentfernung = new JLabel(GuiStrings.getString("Forwarder2018.Rueckeentfernung"));
        panel.add((Component)lblRueckeentfernung, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 6;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbRueckeentfernung = new JComboBox();
        panel.add(this.cmbRueckeentfernung, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 7;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblHangneigung = new JLabel(GuiStrings.getString("Forwarder2018.Hangneigung"));
        panel.add((Component)lblHangneigung, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 7;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbHangneigung = new JComboBox();
        panel.add(this.cmbHangneigung, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 8;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblAnzahlSortimente = new JLabel(GuiStrings.getString("Forwarder2018.AnzahlSortimente"));
        panel.add((Component)lblAnzahlSortimente, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 8;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbAnzahlSortimente = new JComboBox();
        panel.add(this.cmbAnzahlSortimente, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 9;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblErschwernisse = new JLabel(GuiStrings.getString("Forwarder2018.Erschwernisse"));
        panel.add((Component)lblErschwernisse, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 9;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbErschwernisse = new JComboBox();
        panel.add(this.cmbErschwernisse, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 10;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblAbstandRueckegasse = new JLabel(GuiStrings.getString("Forwarder2018.AbstandRueckegassen"));
        panel.add((Component)lblAbstandRueckegasse, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 10;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbAbstandRueckegasse = new JComboBox();
        panel.add(this.cmbAbstandRueckegasse, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 11;
        c.fill = 2;
        c.weightx = 20.0;
        this.lblZopfdurchmesser_cm = new JLabel(GuiStrings.getString("Forwarder2018.Zopfdurchmesser_cm"));
        panel.add((Component)this.lblZopfdurchmesser_cm, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 11;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtZopfdurchmesser_cm = new JSpinner();
        panel.add((Component)this.txtZopfdurchmesser_cm, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 12;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 0, 0, 5);
        this.lblEnergieholzanfall_m3iRproHa = new JLabel(GuiStrings.getString("Forwarder2018.Energieholzanfall_m3iRproHa"));
        panel.add((Component)this.lblEnergieholzanfall_m3iRproHa, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 12;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbEnergieholzanfall_m3iRproHa = new JComboBox();
        panel.add(this.cmbEnergieholzanfall_m3iRproHa, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 12;
        c.anchor = 17;
        c.insets = new Insets(0, 10, 0, 0);
        this.lblEnergieholzanfall_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("Forwarder2018.InfoButtonEnergieholzanfall"));
        panel.add((Component)this.lblEnergieholzanfall_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 13;
        c.weighty = 100.0;
        panel.add((Component)new JPanel(), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 14;
        c.fill = 1;
        c.weightx = 20.0;
        this.lblErgebnisanzeige = new JLabel(GuiStrings.getString("Forwarder2018.Ergebnisanzeige"));
        this.lblErgebnisanzeige.setBackground(ErgebnisPanel.ERGEBNIS_PANEL_BACKGROUND_COLOR);
        this.lblErgebnisanzeige.setOpaque(true);
        this.lblErgebnisanzeige.setFont(this.lblErgebnisanzeige.getFont().deriveFont(1));
        panel.add((Component)this.lblErgebnisanzeige, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 14;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbErgebnisanzeige = new JComboBox();
        this.cmbErgebnisanzeige.setName("ergebnisanzeige");
        this.cmbErgebnisanzeige.setRenderer(new ErgebnisColorListCellRenderer());
        this.cmbErgebnisanzeige.setFont(this.cmbErgebnisanzeige.getFont().deriveFont(1));
        panel.add(this.cmbErgebnisanzeige, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 5;
        c.gridwidth = 2;
        c.gridheight = 10;
        c.anchor = 13;
        c.insets = new Insets(0, 10, 0, 0);
        this.lblSkizzeBaumteile = new JLabel(Forwarder2018.getScaledImageIcon(ImgCode.ALLES));
        panel.add((Component)this.lblSkizzeBaumteile, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 5;
        c.fill = 1;
        this.lblMouseSensitiveArea = new JLabel();
        this.lblMouseSensitiveArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (!Forwarder2018.this.isMouseWithinSensitiveArea()) {
                    Forwarder2018.this.lblSkizzeBaumteile.setIcon(Forwarder2018.getScaledImageIcon(ImgCode.ALLES));
                }
            }
        });
        panel.add((Component)this.lblMouseSensitiveArea, c);
    }

    private static ImageIcon getScaledImageIcon(ImgCode imgCode) {
        if (imageCache.containsKey((Object)imgCode)) {
            return imageCache.get((Object)imgCode);
        }
        ImageIcon imageIconSkizzeBaumteile = Forwarder2018.getImageIcon("data/SkizzeBaumteile_" + imgCode.fileSuffix + ".png");
        Image imageSkizzeBaumteile = imageIconSkizzeBaumteile.getImage().getScaledInstance(-1, 230, 4);
        ImageIcon result = new ImageIcon(imageSkizzeBaumteile);
        imageCache.put(imgCode, result);
        return result;
    }

    private static ImageIcon getImageIcon(String filePath) {
        URL imgURL = MainWindow.class.getClassLoader().getResource(filePath);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return new ImageIcon(filePath);
    }

    @Override
    protected JPanel initSpecialPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(10, 8, 20, 5);
        JLabel lblForwardertyp = new JLabel(GuiStrings.getString("Forwarder2018.Forwardertyp"));
        panel.add((Component)lblForwardertyp, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(10, 5, 20, 5);
        this.cmbForwardertyp = new JComboBox();
        panel.add(this.cmbForwardertyp, c);
        return panel;
    }

    @Override
    protected void initData() {
        Object value;
        String labelPersonal = this.getModel().getArbeitssystem().getLabelPersonal1();
        String labelMaschine1 = this.getModel().getArbeitssystem().getLabelMaschine1();
        this.panelKostensaetze.setLabelPersonal(labelPersonal);
        this.panelKostensaetze.setLabelMaschine1(labelMaschine1);
        this.txtSchaftholz_m3iR.setModel(new SpinnerNumberModel(100.0, 0.0, 100000.0, 10.0));
        this.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtSchaftholz_m3iR);
        this.txtSchaftholz_m3iR.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Forwarder2018.this.onHolzmengenChange();
            }
        });
        this.txtEnergieholzmenge_m3iR.setModel(new SpinnerNumberModel(100.0, 0.0, 100000.0, 10.0));
        Forwarder2018.setSpinnerMaximumFractionDigits(this.txtEnergieholzmenge_m3iR);
        this.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtEnergieholzmenge_m3iR);
        this.txtEnergieholzmenge_m3iR.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Forwarder2018.this.onHolzmengenChange();
            }
        });
        this.txtEnergieholzAusSchaftholz_m3iR.setModel(new SpinnerNumberModel());
        Forwarder2018.setSpinnerMaximumFractionDigits(this.txtEnergieholzAusSchaftholz_m3iR);
        this.txtEnergieholzAusSchaftholz_m3iR.setEnabled(false);
        this.txtEnergieholzAusAstderbholzUndReisig_m3iR.setModel(new SpinnerNumberModel());
        Forwarder2018.setSpinnerMaximumFractionDigits(this.txtEnergieholzAusAstderbholzUndReisig_m3iR);
        this.txtEnergieholzAusAstderbholzUndReisig_m3iR.setEnabled(false);
        this.txtVerkaufRundholz_m3iR.setModel(new SpinnerNumberModel(100.0, 0.0, 100000.0, 10.0));
        Forwarder2018.setSpinnerMaximumFractionDigits(this.txtVerkaufRundholz_m3iR);
        this.txtVerkaufRundholz_m3iR.setEnabled(false);
        this.txtBhdMit_cm.setModel(new SpinnerNumberModel(30, 0, 100, 1));
        this.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtBhdMit_cm);
        Object[] objectArray = ArbeitsobjektForwarder2018.Rueckeentfernung.values();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            value = objectArray[n2];
            this.cmbRueckeentfernung.addItem((ArbeitsobjektForwarder2018.Rueckeentfernung)((Object)value));
            ++n2;
        }
        this.addDefaultActionListener(this.cmbRueckeentfernung);
        objectArray = ArbeitsobjektForwarder2018.Hangneigung.values();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            value = objectArray[n2];
            this.cmbHangneigung.addItem((ArbeitsobjektForwarder2018.Hangneigung)((Object)value));
            ++n2;
        }
        this.addDefaultActionListener(this.cmbHangneigung);
        objectArray = ArbeitsobjektForwarder2018.AnzahlSortimente.values();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            value = objectArray[n2];
            this.cmbAnzahlSortimente.addItem((ArbeitsobjektForwarder2018.AnzahlSortimente)((Object)value));
            ++n2;
        }
        this.addDefaultActionListener(this.cmbAnzahlSortimente);
        objectArray = ArbeitsobjektForwarder2018.Erschwernisse.values();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            value = objectArray[n2];
            this.cmbErschwernisse.addItem((ArbeitsobjektForwarder2018.Erschwernisse)((Object)value));
            ++n2;
        }
        this.addDefaultActionListener(this.cmbErschwernisse);
        objectArray = ArbeitsobjektForwarder2018.AbstandRueckegasse.values();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            value = objectArray[n2];
            this.cmbAbstandRueckegasse.addItem((ArbeitsobjektForwarder2018.AbstandRueckegasse)((Object)value));
            ++n2;
        }
        this.addDefaultActionListener(this.cmbAbstandRueckegasse);
        this.txtZopfdurchmesser_cm.setModel(new SpinnerNumberModel(10, 0, 100, 1));
        this.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtZopfdurchmesser_cm);
        objectArray = this.model.getArbeitsobjekt().getAllEnergieholzanfall();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object energieholzanfall = objectArray[n2];
            this.cmbEnergieholzanfall_m3iRproHa.addItem((ArbeitsobjektForwarder2018.Energieholzanfall)energieholzanfall);
            ++n2;
        }
        this.addDefaultActionListener(this.cmbEnergieholzanfall_m3iRproHa);
        objectArray = ArbeitssystemForwarder2018.Forwardertyp.values();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            value = objectArray[n2];
            this.cmbForwardertyp.addItem((ArbeitssystemForwarder2018.Forwardertyp)((Object)value));
            ++n2;
        }
        this.addDefaultActionListener(this.cmbForwardertyp);
        objectArray = CalculatorForwarder2018.ErgebnisAnzeige.values();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            value = objectArray[n2];
            this.cmbErgebnisanzeige.addItem((CalculatorForwarder2018.ErgebnisAnzeige)((Object)value));
            ++n2;
        }
        this.addDefaultActionListener(this.cmbErgebnisanzeige);
        this.cmbErgebnisanzeige.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((CalculatorForwarder2018.ErgebnisAnzeige)((Object)Forwarder2018.this.cmbErgebnisanzeige.getSelectedItem()) == CalculatorForwarder2018.ErgebnisAnzeige.Rundholz) {
                    ((ErgebnisPanel)Forwarder2018.this.ergebnisPanel).setTitle(GuiStrings.getString("Forwarder2018.ErgebnistitelRundholz"));
                    ((ErgebnisPanel)Forwarder2018.this.ergebnisPanel).setLabelProduktivitaet(GuiStrings.getString("HeProMoWindow2014.Produktivitaet_m3_iR_pro_PMH15"));
                    ((ErgebnisPanel)Forwarder2018.this.ergebnisPanel).setLabelKostenProM3(GuiStrings.getString("HeProMoWindow2014.ProM3oR"));
                } else if ((CalculatorForwarder2018.ErgebnisAnzeige)((Object)Forwarder2018.this.cmbErgebnisanzeige.getSelectedItem()) == CalculatorForwarder2018.ErgebnisAnzeige.Energieholz) {
                    ((ErgebnisPanel)Forwarder2018.this.ergebnisPanel).setTitle(GuiStrings.getString("Forwarder2018.ErgebnistitelEnergieholz"));
                    ((ErgebnisPanel)Forwarder2018.this.ergebnisPanel).setLabelProduktivitaet(GuiStrings.getString("Forwarder2018.Produktivitaet_m3iRproPmh15"));
                    ((ErgebnisPanel)Forwarder2018.this.ergebnisPanel).setLabelKostenProM3(GuiStrings.getString("Forwarder2018.proM3iR"));
                }
            }
        });
        this.initHoverActions();
    }

    private void initHoverActions() {
        MouseAdapter mouseAdapterSchaftholz = this.createMouseAdapter(ImgCode.SCHAFTHOLZ);
        Forwarder2018.addMouseListenerToLabelAndSpinner(this.lblSchaftholz_m3iR, this.txtSchaftholz_m3iR, mouseAdapterSchaftholz);
        MouseAdapter mouseAdapterEnergieholz = this.createMouseAdapter(ImgCode.ENERGIEHOLZ);
        Forwarder2018.addMouseListenerToLabelAndSpinner(this.lblEnergieholzmenge_m3iR, this.txtEnergieholzmenge_m3iR, mouseAdapterEnergieholz);
        MouseAdapter mouseAdapterSchaftholzEnergie = this.createMouseAdapter(ImgCode.ENERGIEHOLZ_AUS_SCHAFTHOLZ);
        Forwarder2018.addMouseListenerToLabelAndSpinner(this.lblEnergieholzAusSchaftholz_m3iR, this.txtEnergieholzAusSchaftholz_m3iR, mouseAdapterSchaftholzEnergie);
        MouseAdapter mouseAdapterAstderbholzReisig = this.createMouseAdapter(ImgCode.ASTDERBHOLZREISIG);
        Forwarder2018.addMouseListenerToLabelAndSpinner(this.lblEnergieholzAusAstderbholzUndReisig_m3iR, this.txtEnergieholzAusAstderbholzUndReisig_m3iR, mouseAdapterAstderbholzReisig);
        MouseAdapter mouseAdapterRundholz = this.createMouseAdapter(ImgCode.RUNDHOLZ);
        Forwarder2018.addMouseListenerToLabelAndSpinner(this.lblVerkaufRundholz_m3iR, this.txtVerkaufRundholz_m3iR, mouseAdapterRundholz);
        MouseAdapter mouseAdapterZopfdurchmesser = this.createMouseAdapter(ImgCode.ZOPFDURCHMESSER);
        Forwarder2018.addMouseListenerToLabelAndSpinner(this.lblZopfdurchmesser_cm, this.txtZopfdurchmesser_cm, mouseAdapterZopfdurchmesser);
    }

    private MouseAdapter createMouseAdapter(final ImgCode imgCode) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Forwarder2018.this.lblSkizzeBaumteile.setIcon(Forwarder2018.getScaledImageIcon(imgCode));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!Forwarder2018.this.isMouseWithinSensitiveArea()) {
                    Forwarder2018.this.lblSkizzeBaumteile.setIcon(Forwarder2018.getScaledImageIcon(ImgCode.ALLES));
                }
            }
        };
        return mouseAdapter;
    }

    public boolean isMouseWithinSensitiveArea() {
        Point mousePos = MouseInfo.getPointerInfo().getLocation();
        Rectangle bounds = this.lblMouseSensitiveArea.getBounds();
        bounds.setLocation(this.lblMouseSensitiveArea.getLocationOnScreen());
        return bounds.contains(mousePos);
    }

    private static void addMouseListenerToLabelAndSpinner(JLabel label, JSpinner spinner, MouseListener listener) {
        label.addMouseListener(listener);
        Component[] componentArray = spinner.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.addMouseListener(listener);
            ++n2;
        }
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().addMouseListener(listener);
    }

    private static void setSpinnerMaximumFractionDigits(JSpinner spinner) {
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)spinner.getEditor();
        DecimalFormat decimalFormat = editor.getFormat();
        decimalFormat.setMaximumFractionDigits(2);
    }

    private void onHolzmengenChange() {
        if (super.isReactOnInputChange()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Forwarder2018.this.holzmengenUnveraendertSeitBerechnungEnergieholzmengen) {
                        Forwarder2018.this.holzmengenUnveraendertSeitBerechnungEnergieholzmengen = false;
                        Forwarder2018.this.highlightMengenFields(true);
                    }
                    Forwarder2018.this.showWarnmeldungHolzmengeIfNotYetShown();
                }
            });
        }
    }

    protected void showWarnmeldungHolzmengeIfNotYetShown() {
        if (this.hinweisAenderungenBeimNachestenChangeZeigen) {
            this.hinweisAenderungenBeimNachestenChangeZeigen = false;
            String msg = Forwarder2018.wrap(GuiStrings.getString("Forwarder2018.WarnmeldungHolzmenge"), 60);
            JOptionPane.showMessageDialog(this, msg, GuiStrings.getString("Forwarder2018.Achtung"), 2);
        }
    }

    protected void highlightMengenFields(boolean flag) {
        Forwarder2018.highlightSpinner(this.txtSchaftholz_m3iR, flag);
        Forwarder2018.highlightSpinner(this.txtEnergieholzmenge_m3iR, flag);
        Forwarder2018.highlightSpinner(this.txtEnergieholzAusSchaftholz_m3iR, flag);
        Forwarder2018.highlightSpinner(this.txtEnergieholzAusAstderbholzUndReisig_m3iR, flag);
        Forwarder2018.highlightSpinner(this.txtVerkaufRundholz_m3iR, flag);
    }

    private static void highlightSpinner(JSpinner spinner, boolean flag) {
        Color bgColor = flag ? HIGHLIGHT_COLOR : (spinner.isEnabled() ? Color.WHITE : null);
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setBackground(bgColor);
    }

    protected void setEnergieholzErgebnis(BiomasseCalculatorKompartimente2018.ErgebnisEnergieholz energieholzErgebnis) {
        this.holzmengenUnveraendertSeitBerechnungEnergieholzmengen = false;
        this.hinweisAenderungenBeimNachestenChangeZeigen = false;
        this.txtEnergieholzmenge_m3iR.setValue(energieholzErgebnis.getVolumenEnergieholz_m3iR());
        double energieHolzSchaft_m3iR = energieholzErgebnis.getVolumenEnergieholzAmSchaftOberhalbZopf_m3iR() + energieholzErgebnis.getVolumenEnergierundholzUnterhalbZopf_m3iR();
        this.txtEnergieholzAusSchaftholz_m3iR.setValue(energieHolzSchaft_m3iR);
        double energieHolzAstderbReisig_m3iR = energieholzErgebnis.getVolumenAstderbholz_m3iR() + energieholzErgebnis.getVolumenReisig_m3iR();
        this.txtEnergieholzAusAstderbholzUndReisig_m3iR.setValue(energieHolzAstderbReisig_m3iR);
        this.updateVerkaufRundholz();
        this.displayErgebnis();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Forwarder2018.this.holzmengenUnveraendertSeitBerechnungEnergieholzmengen = true;
                Forwarder2018.this.hinweisAenderungenBeimNachestenChangeZeigen = true;
                Forwarder2018.this.highlightMengenFields(false);
            }
        });
    }

    protected void setZopf_cm(int value) {
        this.txtZopfdurchmesser_cm.setValue(value);
    }

    protected void updateVerkaufRundholz() {
        double schaftholz_m3iR = (Double)this.txtSchaftholz_m3iR.getValue();
        double energieHolzSchaft_m3iR = (Double)this.txtEnergieholzAusSchaftholz_m3iR.getValue();
        double verkaufsmenge_m3iR = schaftholz_m3iR - energieHolzSchaft_m3iR;
        this.txtVerkaufRundholz_m3iR.setValue(verkaufsmenge_m3iR);
        double rindenAbzugFaktor = this.getModel().getArbeitsobjekt().getRindenAbzugFaktor();
        this.verkaufsmenge_m3oR = verkaufsmenge_m3iR * rindenAbzugFaktor;
        this.updateLabelVerkaufRundholz_m3oR_Info();
    }

    protected final void updateLabelVerkaufRundholz_m3oR_Info() {
        this.lblVerkaufRundholz_m3oR_Info.setText("<html>(" + this.df.format(this.verkaufsmenge_m3oR) + " m<sup>3</sup> " + GuiStrings.getString("Forwarder2018.oR") + ")</html>");
    }

    @Override
    protected void onInputChangedBeforeCalculation(Object eventSource) {
        ArbeitsobjektForwarder2018.Energieholzanfall energieholzanfall;
        this.updateVerkaufRundholz();
        if (this.cmbForwardertyp.equals(eventSource)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String message = GuiStrings.getString("Forwarder2018.WarnungKostensatz");
                    JOptionPane.showMessageDialog(Forwarder2018.this, message, GuiStrings.getString("Forwarder2018.Achtung"), 2);
                }
            });
        }
        if (this.cmbEnergieholzanfall_m3iRproHa.equals(eventSource) && (energieholzanfall = (ArbeitsobjektForwarder2018.Energieholzanfall)this.cmbEnergieholzanfall_m3iRproHa.getSelectedItem()).isBenutzerdefiniert()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String result;
                    String message = GuiStrings.getString("Forwarder2018.EnergieholzanfallEingeben");
                    while ((result = JOptionPane.showInputDialog(Forwarder2018.this, message, energieholzanfall.getEnergieholzanfall_m3ProHa())) != null) {
                        try {
                            int wertNeu = (int)Double.parseDouble(result);
                            if (wertNeu < 0 || wertNeu > 2000) {
                                throw new IllegalArgumentException();
                            }
                            energieholzanfall.setEnergieholzanfall_m3ProHa(wertNeu);
                            break;
                        }
                        catch (NumberFormatException e) {
                            JOptionPane.showMessageDialog(Forwarder2018.this, GuiStrings.getString("Forwarder2018.GueltigenWertEingeben"), GuiStrings.getString("Forwarder2018.Fehler"), 0);
                        }
                        catch (IllegalArgumentException e) {
                            JOptionPane.showMessageDialog(Forwarder2018.this, GuiStrings.getString("Forwarder2018.GueltigenWertEingeben"), GuiStrings.getString("Forwarder2018.Fehler"), 0);
                        }
                    }
                    Forwarder2018.this.displayErgebnis();
                }
            });
        }
    }

    @Override
    public void loadGUIToModel() {
        super.loadGUIToModel();
        CalculatorForwarder2018.ErgebnisAnzeige ergebnisAnzeige = (CalculatorForwarder2018.ErgebnisAnzeige)((Object)this.cmbErgebnisanzeige.getSelectedItem());
        this.model.getCalculator().setErgebnisAnzeige(ergebnisAnzeige);
        this.updateVerkaufRundholz();
        this.model.getArbeitsobjekt().setHolzmenge_m3((Double)this.txtSchaftholz_m3iR.getValue());
        this.model.getArbeitsobjekt().setEnergieholzmenge_m3iR((Double)this.txtEnergieholzmenge_m3iR.getValue());
        this.model.getArbeitsobjekt().setEnergieholzAusSchaftholz_m3iR((Double)this.txtEnergieholzAusSchaftholz_m3iR.getValue());
        this.model.getArbeitsobjekt().setEnergieholzAusAstderbholzUndReisig_m3iR((Double)this.txtEnergieholzAusAstderbholzUndReisig_m3iR.getValue());
        this.model.getArbeitsobjekt().setVerkaufRundholz_m3oR(this.verkaufsmenge_m3oR);
        this.model.getArbeitsobjekt().setHolzmengenUnveraendertSeitBerechnungEnergieholzmengen(this.holzmengenUnveraendertSeitBerechnungEnergieholzmengen);
        this.model.getArbeitsobjekt().setBhdMit_cm((Integer)this.txtBhdMit_cm.getValue());
        this.model.getArbeitsobjekt().setRueckeentfernung((ArbeitsobjektForwarder2018.Rueckeentfernung)((Object)this.cmbRueckeentfernung.getSelectedItem()));
        this.model.getArbeitsobjekt().setHangneigung((ArbeitsobjektForwarder2018.Hangneigung)((Object)this.cmbHangneigung.getSelectedItem()));
        this.model.getArbeitsobjekt().setAnzahlSortimente((ArbeitsobjektForwarder2018.AnzahlSortimente)((Object)this.cmbAnzahlSortimente.getSelectedItem()));
        this.model.getArbeitsobjekt().setErschwernisse((ArbeitsobjektForwarder2018.Erschwernisse)((Object)this.cmbErschwernisse.getSelectedItem()));
        this.model.getArbeitsobjekt().setAbstandRueckegasse((ArbeitsobjektForwarder2018.AbstandRueckegasse)((Object)this.cmbAbstandRueckegasse.getSelectedItem()));
        this.model.getArbeitsobjekt().setZopfdurchmesser_cm((Integer)this.txtZopfdurchmesser_cm.getValue());
        this.model.getArbeitsobjekt().setEnergieholzanfall_m3iRproHa((ArbeitsobjektForwarder2018.Energieholzanfall)this.cmbEnergieholzanfall_m3iRproHa.getSelectedItem());
        this.model.getArbeitsobjekt().setAllEnergieholzanfall(this.getAllEnergieholzanfallFromCombobox());
        this.model.getArbeitssystem().setForwardertyp((ArbeitssystemForwarder2018.Forwardertyp)((Object)this.cmbForwardertyp.getSelectedItem()));
    }

    @Override
    public AbstractModel getModel() {
        return this.model;
    }

    @Override
    public void loadModelToGUI(HeProMoInputData data) {
        super.setReactOnInputChange(false);
        super.loadModelToGUI(data);
        if (data instanceof ModelForwarder2018) {
            ModelForwarder2018 modelFwd = (ModelForwarder2018)data;
            this.cmbErgebnisanzeige.setSelectedItem((Object)modelFwd.getCalculator().getErgebnisAnzeige());
        } else {
            this.cmbErgebnisanzeige.setSelectedItem((Object)CalculatorForwarder2018.ErgebnisAnzeige.Rundholz);
        }
        this.cmbEnergieholzanfall_m3iRproHa.removeAllItems();
        ArbeitsobjektForwarder2018.Energieholzanfall[] energieholzanfallArray = ((ArbeitsobjektForwarder2018)data.getArbeitsobjekt()).getAllEnergieholzanfall();
        int n = energieholzanfallArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArbeitsobjektForwarder2018.Energieholzanfall energieholzanfall = energieholzanfallArray[n2];
            this.cmbEnergieholzanfall_m3iRproHa.addItem(energieholzanfall);
            ++n2;
        }
        this.txtSchaftholz_m3iR.setValue(data.getArbeitsobjekt().getHolzmenge_m3());
        this.txtEnergieholzmenge_m3iR.setValue(((ArbeitsobjektForwarder2018)data.getArbeitsobjekt()).getEnergieholzmenge_m3iR());
        this.txtEnergieholzAusSchaftholz_m3iR.setValue(((ArbeitsobjektForwarder2018)data.getArbeitsobjekt()).getEnergieholzAusSchaftholz_m3iR());
        this.txtEnergieholzAusAstderbholzUndReisig_m3iR.setValue(((ArbeitsobjektForwarder2018)data.getArbeitsobjekt()).getEnergieholzAusAstderbholzUndReisig_m3iR());
        this.verkaufsmenge_m3oR = ((ArbeitsobjektForwarder2018)data.getArbeitsobjekt()).getVerkaufRundholz_m3oR();
        this.txtBhdMit_cm.setValue(((ArbeitsobjektForwarder2018)data.getArbeitsobjekt()).getBhdMit_cm());
        this.holzmengenUnveraendertSeitBerechnungEnergieholzmengen = ((ArbeitsobjektForwarder2018)data.getArbeitsobjekt()).isHolzmengenUnveraendertSeitBerechnungEnergieholzmengen();
        this.cmbRueckeentfernung.setSelectedItem((Object)((ArbeitsobjektForwarder2018)data.getArbeitsobjekt()).getRueckeentfernung());
        this.cmbHangneigung.setSelectedItem((Object)((ArbeitsobjektForwarder2018)data.getArbeitsobjekt()).getHangneigung());
        this.cmbAnzahlSortimente.setSelectedItem((Object)((ArbeitsobjektForwarder2018)data.getArbeitsobjekt()).getAnzahlSortimente());
        this.cmbErschwernisse.setSelectedItem((Object)((ArbeitsobjektForwarder2018)data.getArbeitsobjekt()).getErschwernisse());
        this.cmbAbstandRueckegasse.setSelectedItem((Object)((ArbeitsobjektForwarder2018)data.getArbeitsobjekt()).getAbstandRueckegasse());
        this.txtZopfdurchmesser_cm.setValue(((ArbeitsobjektForwarder2018)data.getArbeitsobjekt()).getZopfdurchmesser_cm());
        this.cmbEnergieholzanfall_m3iRproHa.setSelectedItem(((ArbeitsobjektForwarder2018)data.getArbeitsobjekt()).getEnergieholzanfall_m3iRproHa());
        this.cmbForwardertyp.setSelectedItem((Object)((ArbeitssystemForwarder2018)data.getArbeitssystem()).getForwardertyp());
        this.updateVerkaufRundholz();
        super.setReactOnInputChange(true);
    }

    @Override
    protected void onSuccessfullyLoaded() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean isEnergieholzBerechnet;
                Forwarder2018.this.highlightMengenFields(false);
                boolean bl = isEnergieholzBerechnet = (Double)Forwarder2018.this.txtEnergieholzAusSchaftholz_m3iR.getValue() > 0.0 || (Double)Forwarder2018.this.txtEnergieholzAusAstderbholzUndReisig_m3iR.getValue() > 0.0;
                if (isEnergieholzBerechnet) {
                    Forwarder2018.this.hinweisAenderungenBeimNachestenChangeZeigen = true;
                    if (!Forwarder2018.this.holzmengenUnveraendertSeitBerechnungEnergieholzmengen) {
                        Forwarder2018.this.highlightMengenFields(true);
                        Forwarder2018.this.showWarnmeldungHolzmengeIfNotYetShown();
                    }
                } else {
                    Forwarder2018.this.hinweisAenderungenBeimNachestenChangeZeigen = false;
                }
            }
        });
    }

    private ArbeitsobjektForwarder2018.Energieholzanfall[] getAllEnergieholzanfallFromCombobox() {
        ArbeitsobjektForwarder2018.Energieholzanfall[] result = new ArbeitsobjektForwarder2018.Energieholzanfall[this.cmbEnergieholzanfall_m3iRproHa.getItemCount()];
        int i = 0;
        while (i < this.cmbEnergieholzanfall_m3iRproHa.getItemCount()) {
            result[i] = this.cmbEnergieholzanfall_m3iRproHa.getItemAt(i);
            ++i;
        }
        return result;
    }

    private static enum ImgCode {
        ALLES("Alles"),
        SCHAFTHOLZ("Schaftholz"),
        ENERGIEHOLZ("Energieholz"),
        ENERGIEHOLZ_AUS_SCHAFTHOLZ("SchaftholzEnergie"),
        ASTDERBHOLZREISIG("AstderbholzReisig"),
        RUNDHOLZ("Rundholz"),
        ZOPFDURCHMESSER("Zopfdurchmesser");

        private final String fileSuffix;

        private ImgCode(String fileSuffix) {
            this.fileSuffix = fileSuffix;
        }
    }
}

