/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui;

import ch.wsl.fps.hepromo.gui.AbstractErgebnisPanel;
import ch.wsl.fps.hepromo.gui.DocumentationBroker;
import ch.wsl.fps.hepromo.gui.ErgebnisPanel;
import ch.wsl.fps.hepromo.gui.FaktorenPanel;
import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoExceptionHandler;
import ch.wsl.fps.hepromo.gui.MainWindow;
import ch.wsl.fps.hepromo.gui.TitledBorderFactory;
import ch.wsl.fps.hepromo.model.Ergebnis;
import ch.wsl.fps.hepromo.model.Faktoren;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.PersistentInputData;
import ch.wsl.fps.hepromo.model.modelle.AbstractModel;
import ch.wsl.fps.hepromo.util.CsvCreator;
import ch.wsl.fps.hepromo.util.DatenblattCreator;
import ch.wsl.fps.hepromo.util.ExportMethodResult;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public abstract class HeProMoWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JLabel lblArbeitsort;
    private JTextField txtArbeitsort;
    private JPanel pnlArbeitsObjekt = new JPanel();
    private JPanel pnlArbeitsSystem = new JPanel();
    private FaktorenPanel pnlFaktoren;
    protected AbstractErgebnisPanel ergebnisPanel;
    private JSpinner txtAnzahlNachkommastellen;
    private JButton btnDatenblatt;
    private JButton btnCsv;
    protected Faktoren faktoren = new Faktoren();
    private boolean reactOnInputChange = false;
    private final String defaultDir = HeProMoWindow.isStartedFromJar() ? "." : "./data";
    public volatile boolean isLoadingModelFromFile = false;
    private final ChangeListener defaultChangeListner = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            HeProMoWindow.this.onInputChanged(e.getSource());
        }
    };
    private final ActionListener defaultActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object selectedItem = ((JComboBox)e.getSource()).getSelectedItem();
            if (selectedItem != null) {
                HeProMoWindow.this.onInputChanged(e.getSource());
            }
        }
    };
    private final ItemListener defaultItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            HeProMoWindow.this.onInputChanged(e.getSource());
        }
    };
    private final DocumentListener defaultDocumentListener = new DocumentListener(){

        @Override
        public void removeUpdate(DocumentEvent e) {
            HeProMoWindow.this.onInputChanged(e.getDocument());
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            HeProMoWindow.this.onInputChanged(e.getDocument());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            HeProMoWindow.this.onInputChanged(e.getDocument());
        }
    };

    private static boolean isStartedFromJar() {
        return MainWindow.class.getResource("MainWindow.class").toString().startsWith("rsrc");
    }

    public HeProMoWindow() {
        this.setSize(550, 590);
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(2);
        this.setIconImage(MainWindow.getWslLogo().getImage());
    }

    protected final void setReactOnInputChange(boolean flag) {
        this.reactOnInputChange = flag;
        if (flag) {
            this.displayErgebnis();
        }
    }

    protected final boolean isReactOnInputChange() {
        return this.reactOnInputChange;
    }

    protected void onInputChangedBeforeCalculation(Object eventSource) {
    }

    private void onInputChanged(Object eventSource) {
        if (this.reactOnInputChange) {
            this.reactOnInputChange = false;
            this.onInputChangedBeforeCalculation(eventSource);
            this.reactOnInputChange = true;
            this.displayErgebnis();
        }
    }

    protected final void initalize() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    HeProMoWindow.this.pnlFaktoren = new FaktorenPanel(HeProMoWindow.this);
                    HeProMoWindow.this.initContent();
                    HeProMoWindow.this.initPanelArbeitsobjekt(HeProMoWindow.this.pnlArbeitsObjekt);
                    HeProMoWindow.this.initPanelArbeitssystem(HeProMoWindow.this.pnlArbeitsSystem);
                    HeProMoWindow.this.initData();
                    HeProMoWindow.this.loadModelToGUI(HeProMoWindow.this.getModel());
                    HeProMoWindow.this.setVisible(true);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private final void initContent() {
        this.getContentPane().removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.insets = new Insets(5, 10, 0, 10);
        this.lblArbeitsort = new JLabel(GuiStrings.getString("HeProMoWindow.ArbeitsortHolzschlag"));
        this.getContentPane().add((Component)this.lblArbeitsort, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(5, 10, 0, 0);
        this.txtArbeitsort = new JTextField(){
            private static final long serialVersionUID = 1L;
            private int limit = 80;

            @Override
            protected Document createDefaultModel() {
                return new PlainDocument(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
                        if (str == null) {
                            return;
                        }
                        if (this.getLength() + str.length() <= limit) {
                            super.insertString(offset, str, attr);
                        } else {
                            int maxLength = limit - this.getLength();
                            super.insertString(offset, str.substring(0, maxLength), attr);
                        }
                    }
                };
            }
        };
        this.addDefaultDocumentListener(this.txtArbeitsort);
        this.getContentPane().add((Component)this.txtArbeitsort, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.insets = new Insets(7, 5, 0, 12);
        JLabel lblArbeitsort_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("HeProMoWindow.InfoButtonArbeitsort"));
        this.getContentPane().add((Component)lblArbeitsort_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.fill = 1;
        c.weightx = 100.0;
        c.weighty = 100.0;
        c.insets = new Insets(10, 5, 5, 5);
        JPanel pnlInput = this.initPanelInput();
        this.getContentPane().add((Component)pnlInput, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(15, 5, 5, 5);
        this.ergebnisPanel = this.initErgebnisPanel();
        this.getContentPane().add((Component)this.ergebnisPanel, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 3;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(5, 5, 5, 5);
        JPanel pnlButtons = this.initPanelButtons();
        this.getContentPane().add((Component)pnlButtons, c);
    }

    private final JPanel initPanelInput() {
        JPanel pnlInput = new JPanel();
        pnlInput.setBorder(TitledBorderFactory.createTitledBorderBold(GuiStrings.getString("HeProMoWindow.TitleEingaben")));
        pnlInput.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 100.0;
        c.weighty = 100.0;
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(GuiStrings.getString("HeProMoWindow.TabTitleArbeitsobjekt"), this.pnlArbeitsObjekt);
        tabbedPane.addTab(GuiStrings.getString("HeProMoWindow.TabTitleArbeitssystem"), this.pnlArbeitsSystem);
        tabbedPane.addTab(GuiStrings.getString("HeProMoWindow.TabTitleFaktoren"), this.pnlFaktoren);
        pnlInput.add((Component)tabbedPane, c);
        return pnlInput;
    }

    private final JPanel initPanelButtons() {
        JPanel pnlButtons = new JPanel();
        pnlButtons.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 0, 0);
        JLabel lblAnzahlNachkommastellen = new JLabel(GuiStrings.getString("HeProMoWindow.Nachkommastellen"));
        lblAnzahlNachkommastellen.setToolTipText(GuiStrings.getString("HeProMoWindow.TooltipNachkommastellen"));
        pnlButtons.add((Component)lblAnzahlNachkommastellen, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(5, 2, 0, 5);
        this.txtAnzahlNachkommastellen = new JSpinner(new SpinnerNumberModel(2, 0, 5, 1));
        this.txtAnzahlNachkommastellen.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                HeProMoWindow.this.ergebnisPanel.setDecimalFormat(HeProMoWindow.this.createDecimalFormat());
                HeProMoWindow.this.displayErgebnis();
            }
        });
        pnlButtons.add((Component)this.txtAnzahlNachkommastellen, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        JPanel pnlPlaceholder = new JPanel();
        pnlButtons.add((Component)pnlPlaceholder, c);
        if (DocumentationBroker.exists(this.getModel())) {
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = 0;
            c.insets = new Insets(5, 0, 0, 0);
            final JButton btnDokumentation = new JButton(GuiStrings.getString("HeProMoWindow.btnGrundlagen"));
            btnDokumentation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DocumentationBroker.showDocumentation(HeProMoWindow.this.getModel(), (Component)HeProMoWindow.this, btnDokumentation);
                }
            });
            pnlButtons.add((Component)btnDokumentation, c);
        }
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 0;
        c.insets = new Insets(5, 0, 0, 0);
        this.btnDatenblatt = new JButton(GuiStrings.getString("HeProMoWindow.btnDatenblatt"));
        this.btnDatenblatt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatenblattCreator.preInitializeInSeparateThread();
                final File pdfFile = HeProMoWindow.this.getExportFile(".pdf");
                if (pdfFile == null) {
                    return;
                }
                HeProMoWindow.this.btnDatenblatt.setEnabled(false);
                HeProMoWindow.this.btnDatenblatt.setText(GuiStrings.getString("HeProMoWindow.btnBitteWarten"));
                HeProMoWindow.this.loadGUIToModel();
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        HeProMoWindow.this.createAndOpenDatenblattPdf(pdfFile);
                        return null;
                    }

                    @Override
                    protected void done() {
                        HeProMoWindow.this.btnDatenblatt.setEnabled(true);
                        HeProMoWindow.this.btnDatenblatt.setText(GuiStrings.getString("HeProMoWindow.btnDatenblatt"));
                    }
                };
                worker.execute();
            }
        });
        pnlButtons.add((Component)this.btnDatenblatt, c);
        c = new GridBagConstraints();
        c.gridx = 5;
        c.gridy = 0;
        c.insets = new Insets(5, 0, 0, 0);
        this.btnCsv = new JButton("CSV");
        this.btnCsv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final File csvFile = HeProMoWindow.this.getExportFile(".csv");
                if (csvFile == null) {
                    return;
                }
                HeProMoWindow.this.btnCsv.setEnabled(false);
                HeProMoWindow.this.btnCsv.setText(GuiStrings.getString("HeProMoWindow.btnBitteWarten"));
                HeProMoWindow.this.loadGUIToModel();
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        HeProMoWindow.this.createAndOpenExportCsv(csvFile);
                        return null;
                    }

                    @Override
                    protected void done() {
                        HeProMoWindow.this.btnCsv.setEnabled(true);
                        HeProMoWindow.this.btnCsv.setText("CSV");
                    }
                };
                worker.execute();
            }
        });
        pnlButtons.add((Component)this.btnCsv, c);
        c = new GridBagConstraints();
        c.gridx = 6;
        c.gridy = 0;
        c.insets = new Insets(5, 0, 0, 0);
        JButton btnLoad = new JButton(GuiStrings.getString("HeProMoWindow.btnLaden"));
        btnLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeProMoWindow.this.load();
            }
        });
        pnlButtons.add((Component)btnLoad, c);
        c = new GridBagConstraints();
        c.gridx = 7;
        c.gridy = 0;
        c.insets = new Insets(5, 0, 0, 0);
        JButton btnSave = new JButton(GuiStrings.getString("HeProMoWindow.btnSpeichern"));
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeProMoWindow.this.save();
            }
        });
        pnlButtons.add((Component)btnSave, c);
        c = new GridBagConstraints();
        c.gridx = 8;
        c.gridy = 0;
        c.insets = new Insets(5, 0, 0, 5);
        JButton btnClose = new JButton(GuiStrings.getString("HeProMoWindow.btnBeenden"));
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeProMoWindow.this.dispose();
            }
        });
        pnlButtons.add((Component)btnClose, c);
        return pnlButtons;
    }

    private DecimalFormat createDecimalFormat() {
        int anzahlNachkommastellen = (Integer)this.txtAnzahlNachkommastellen.getValue();
        StringBuilder sb = new StringBuilder(",##0");
        if (anzahlNachkommastellen > 0) {
            sb.append(".");
        }
        int i = 0;
        while (i < anzahlNachkommastellen) {
            sb.append("0");
            ++i;
        }
        DecimalFormat decimalFormat = new DecimalFormat(sb.toString());
        return decimalFormat;
    }

    protected abstract void initPanelArbeitsobjekt(JPanel var1);

    protected abstract void initPanelArbeitssystem(JPanel var1);

    protected AbstractErgebnisPanel initErgebnisPanel() {
        return new ErgebnisPanel();
    }

    protected abstract void initData();

    private File getExportFile(final String fileSuffix) {
        String defaultfileName;
        if (fileSuffix.endsWith("pdf")) {
            defaultfileName = GuiStrings.getString("HeProMoWindow.DefaultDatenblattFilename");
        } else if (fileSuffix.endsWith("csv")) {
            defaultfileName = GuiStrings.getString("HeProMoWindow.DefaultCsvFilename");
        } else {
            throw new IllegalArgumentException(fileSuffix);
        }
        JFileChooser fileChooser = new JFileChooser(this.defaultDir){
            private static final long serialVersionUID = 1L;

            @Override
            public void approveSelection() {
                File file = this.getSelectedFile();
                if (!file.getName().toLowerCase().endsWith(fileSuffix)) {
                    file = new File(String.valueOf(file.getPath()) + fileSuffix);
                    this.setSelectedFile(file);
                }
                if (file.exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(this, GuiStrings.getString("HeProMoWindow.WarnungDateiUeberschreiben"), GuiStrings.getString("HeProMoWindow.DialogTitleSpeichern"), 1);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case 1: {
                            return;
                        }
                        case -1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        fileChooser.setSelectedFile(new File(defaultfileName));
        if (fileChooser.showSaveDialog(this) != 0) {
            return null;
        }
        return fileChooser.getSelectedFile();
    }

    private void createAndOpenDatenblattPdf(File pdfFile) {
        DatenblattCreator pdfCreator = new DatenblattCreator();
        ExportMethodResult result = pdfCreator.create(this.getModel(), pdfFile, this.createDecimalFormat());
        if (result.success) {
            try {
                Desktop.getDesktop().open(pdfFile);
            }
            catch (IOException e) {
                HeProMoExceptionHandler.handle(e);
            }
        } else if (!result.errorMsgShown) {
            String msg = GuiStrings.getString("HeProMoWindow.FehlerBeimErstellenDerDatei");
            JOptionPane.showMessageDialog(null, msg, GuiStrings.getString("HeProMoWindow.DialogTitleFehler"), 0);
        }
    }

    private void createAndOpenExportCsv(File csvFile) {
        CsvCreator csvCreator = new CsvCreator();
        ExportMethodResult result = csvCreator.create(this.getModel(), csvFile, this.createDecimalFormat());
        if (result.success) {
            try {
                Desktop.getDesktop().open(csvFile);
            }
            catch (IOException e) {
                HeProMoExceptionHandler.handle(e);
            }
        } else if (!result.errorMsgShown) {
            String msg = GuiStrings.getString("HeProMoWindow.FehlerBeimErstellenDerDatei");
            JOptionPane.showMessageDialog(null, msg, GuiStrings.getString("HeProMoWindow.DialogTitleFehler"), 0);
        }
    }

    private void save() {
        String defaultfileName = "data.hpm";
        JFileChooser fileChooser = new JFileChooser(this.defaultDir){
            private static final long serialVersionUID = 1L;

            @Override
            public void approveSelection() {
                File file = this.getSelectedFile();
                if (!file.getName().toLowerCase().endsWith(".hpm")) {
                    file = new File(String.valueOf(file.getPath()) + ".hpm");
                    this.setSelectedFile(file);
                }
                if (file.exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(this, GuiStrings.getString("HeProMoWindow.WarnungDateiUeberschreiben"), GuiStrings.getString("HeProMoWindow.DialogTitleSpeichern"), 1);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case 1: {
                            return;
                        }
                        case -1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        fileChooser.setSelectedFile(new File(defaultfileName));
        if (fileChooser.showSaveDialog(this) != 0) {
            return;
        }
        this.loadGUIToModel();
        PersistentInputData data = new PersistentInputData(this.getModel());
        try {
            FileOutputStream fout = new FileOutputStream(fileChooser.getSelectedFile());
            ObjectOutputStream oos = new ObjectOutputStream(fout);
            oos.writeObject(data);
            oos.close();
            System.out.println(GuiStrings.getString("HeProMoWindow.BestaetigungDatenGespeichert"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void load() {
        String defaultfileName = "data.hpm";
        JFileChooser fileChooser = new JFileChooser(this.defaultDir);
        fileChooser.setSelectedFile(new File(defaultfileName));
        if (fileChooser.showOpenDialog(this) != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        PersistentInputData data = null;
        try {
            FileInputStream fin = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fin);
            data = (PersistentInputData)ois.readObject();
            ois.close();
        }
        catch (InvalidClassException e) {
            JOptionPane.showMessageDialog(this, GuiStrings.getString("HeProMoWindow.FehlerBeimLesenDerDateiFalscheVersion"), GuiStrings.getString("HeProMoWindow.DialogTitleFehler"), 0);
            return;
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), GuiStrings.getString("HeProMoWindow.DialogTitleFehler"), 0);
            return;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, GuiStrings.getString("HeProMoWindow.FehlerBeimLesenDerDatei"), GuiStrings.getString("HeProMoWindow.DialogTitleFehler"), 0);
            return;
        }
        Class<? extends AbstractModel> loadedModelClass = data.getModelClass();
        if (loadedModelClass != this.getModel().getClass()) {
            JOptionPane.showMessageDialog(this, String.valueOf(GuiStrings.getString("HeProMoWindow.FehlerDateiMitDatenAnderemModellZeile1")) + GuiStrings.getString("HeProMoWindow.FehlerDateiMitDatenAnderemModellZeile2") + loadedModelClass.getSimpleName(), GuiStrings.getString("HeProMoWindow.DialogTitleFehler"), 0);
            return;
        }
        this.isLoadingModelFromFile = true;
        this.loadModelToGUI(data);
        this.isLoadingModelFromFile = false;
        this.onSuccessfullyLoaded();
        System.out.println(GuiStrings.getString("HeProMoWindow.BestaetigungDatenGeladen"));
    }

    protected void onSuccessfullyLoaded() {
    }

    public static final void adjustJSpinnerFormatter(final JSpinner spinner, final boolean isPercentageField) {
        final JFormattedTextField textField = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
        DefaultFormatter formatter = (DefaultFormatter)textField.getFormatter();
        formatter.setCommitsOnValidEdit(true);
        textField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("editValid".equals(evt.getPropertyName())) {
                    if (Boolean.FALSE.equals(evt.getNewValue())) {
                        DecimalFormat df = isPercentageField ? new DecimalFormat("#.##%") : new DecimalFormat("#.##");
                        SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
                        textField.setBackground(Color.YELLOW);
                        textField.setToolTipText(String.valueOf(GuiStrings.getString("HeProMoWindow.ToolTipUngueltigeEingabeA")) + df.format(model.getMinimum()) + GuiStrings.getString("HeProMoWindow.ToolTipUngueltigeEingabeB") + df.format(model.getMaximum()) + GuiStrings.getString("HeProMoWindow.ToolTipUngueltigeEingabeC"));
                    } else {
                        textField.setBackground(Color.WHITE);
                        textField.setToolTipText(null);
                    }
                }
            }
        });
    }

    public void addDefaultChangeListenerAndAdjustJSpinnerFormatter(JSpinner spinner, boolean isPercentageField) {
        HeProMoWindow.adjustJSpinnerFormatter(spinner, isPercentageField);
        spinner.removeChangeListener(this.defaultChangeListner);
        spinner.addChangeListener(this.defaultChangeListner);
    }

    public void addDefaultChangeListenerAndAdjustJSpinnerFormatter(JSpinner spinner) {
        this.addDefaultChangeListenerAndAdjustJSpinnerFormatter(spinner, false);
    }

    public void addDefaultActionListener(JComboBox<?> combobox) {
        combobox.removeActionListener(this.defaultActionListener);
        combobox.addActionListener(this.defaultActionListener);
    }

    public void addDefaultItemListener(JToggleButton toggleButton) {
        toggleButton.removeItemListener(this.defaultItemListener);
        toggleButton.addItemListener(this.defaultItemListener);
    }

    public void addDefaultDocumentListener(JTextField textfield) {
        textfield.getDocument().removeDocumentListener(this.defaultDocumentListener);
        textfield.getDocument().addDocumentListener(this.defaultDocumentListener);
    }

    public void loadGUIToModel() {
        this.getModel().setArbeitsort(this.txtArbeitsort.getText());
        this.pnlFaktoren.loadGUIToModel(this.getModel());
    }

    public abstract AbstractModel getModel();

    protected void displayErgebnis() {
        this.loadGUIToModel();
        this.pnlFaktoren.updateFaktorenPanel(this.getModel());
        this.updateWaehrungskuerzel(this.getModel().getFaktoren().getWaehrungskuerzel());
        Ergebnis ergebnis = this.getModel().getErgebnis();
        this.ergebnisPanel.setErgebnis(ergebnis);
        this.validate();
    }

    protected void updateWaehrungskuerzel(String newValue) {
        this.ergebnisPanel.updateWaehrung(newValue);
    }

    public abstract void loadModelToGUI(HeProMoInputData var1);

    protected final void loadFaktoren(HeProMoInputData data) {
        this.txtArbeitsort.setText(data.getArbeitsort());
        this.pnlFaktoren.loadFaktoren(data);
    }

    protected FaktorenPanel getFaktorenPanel() {
        return this.pnlFaktoren;
    }

    public static String wrap(String text, int charsPerLine) {
        if (text.startsWith("<html>") || text.length() < charsPerLine) {
            return text;
        }
        String BREAK = "<br>";
        int startPos = 0;
        int latestCutPosition = startPos + charsPerLine;
        while (text.lastIndexOf("<br>", latestCutPosition) > startPos) {
            startPos = text.lastIndexOf("<br>", latestCutPosition) + "<br>".length();
            latestCutPosition = startPos + charsPerLine;
        }
        while (latestCutPosition < text.length()) {
            int indexOfLastSpace = text.lastIndexOf(" ", latestCutPosition);
            if (indexOfLastSpace == -1) {
                text = String.valueOf(text.substring(0, latestCutPosition)) + "-" + "<br>" + text.substring(latestCutPosition);
                startPos = latestCutPosition + 1 + "<br>".length();
                latestCutPosition = startPos + charsPerLine;
            } else {
                text = String.valueOf(text.substring(0, indexOfLastSpace)) + "<br>" + text.substring(indexOfLastSpace + 1);
                startPos = indexOfLastSpace + "<br>".length();
                latestCutPosition = startPos + charsPerLine;
            }
            while (text.lastIndexOf("<br>", latestCutPosition) > startPos) {
                startPos = text.lastIndexOf("<br>", latestCutPosition) + "<br>".length();
                latestCutPosition = startPos + charsPerLine;
            }
        }
        text = "<html>" + text + "</html>";
        return text;
    }
}

