/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JOptionPane;

public class HeProMoExceptionHandler {
    private static final boolean PRINT = true;
    private static volatile boolean DIALOG = false;
    private static volatile boolean STACKTRACE = false;

    public static void handle(Throwable e) {
        HeProMoExceptionHandler.handle(e, null);
    }

    public static void handle(Throwable e, String msgPrefix) {
        if (DIALOG && STACKTRACE) {
            JOptionPane.showMessageDialog(null, HeProMoExceptionHandler.getErrorMsgWithStackTrace(e, msgPrefix));
        } else if (DIALOG) {
            JOptionPane.showMessageDialog(null, String.valueOf(msgPrefix != null ? msgPrefix : "") + e);
        }
        if (msgPrefix != null) {
            System.err.print(msgPrefix);
        }
        e.printStackTrace();
        HeProMoExceptionHandler.appendToErrorLogFile(e, msgPrefix);
    }

    public static void setLogDialog(boolean flag) {
        DIALOG = flag;
    }

    public static void setLogStackTrace(boolean flag) {
        STACKTRACE = flag;
    }

    private static void appendToErrorLogFile(Throwable e, String msgPrefix) {
        File file = new File("hepromo-error.log");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));){
                String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
                printWriter.append(String.valueOf(timeStamp) + "\n");
                String errorMsg = HeProMoExceptionHandler.getErrorMsgWithStackTrace(e, msgPrefix);
                printWriter.append(String.valueOf(errorMsg) + "\n");
                printWriter.flush();
                printWriter.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private static String getErrorMsgWithStackTrace(Throwable e, String msgPrefix) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String errorMsg = String.valueOf(msgPrefix == null ? "" : msgPrefix) + sw.toString();
        return errorMsg;
    }
}

