/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui;

import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoWindow;
import ch.wsl.fps.hepromo.gui.TitledBorderFactory;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.PersistentInputData;
import ch.wsl.fps.hepromo.model.aobj.Arbeitsobjekt;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel;
import ch.wsl.fps.hepromo.model.modelle.AbstractModel;
import ch.wsl.fps.hepromo.model.modelle.AbstractModel2014;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;

public class FaktorenPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final HeProMoWindow parent;
    private JToggleButton btnExpand;
    private JLabel lblRisikoVerwaltungGewinn;
    private JSpinner txtRisikoVerwaltungGewinn;
    private JLabel lblRisiko;
    private JSpinner txtRisiko;
    private JLabel lblVerwaltung;
    private JSpinner txtVerwaltung;
    private JLabel lblGewinn;
    private JSpinner txtGewinn;
    private JSpinner txtMehrwertsteuer;
    private JTextField txtWaehrungskuerzel;
    private JCheckBox chkRindenabzugAutomatisch;
    private JSpinner txtRindenabzug = new JSpinner(new SpinnerNumberModel(0.6, 0.5, 1.0, 0.01));
    private JPanel pnlWeitereFaktoren;
    private JSpinner txtKorrekturfaktor;
    private JLabel lblKorrekturfaktor_Info;
    private JLabel lblFaktorStoerungen;
    private JLabel lblFaktorVerlusteBis15Min;
    private JLabel lblFaktorIndirekteArbeitszeit;
    private JTextField txtFaktorStoerungen;
    private JTextField txtFaktorVerlusteBis15Min;
    private JTextField txtFaktorIndirekteArbeitszeit;
    private JTextField txtFaktorWegzeitenUndPausen;
    private JLabel lblFaktorWegzeitenUndPausen_Info;
    private String infoTextKF = "<html>" + GuiStrings.getString("FaktorenPanel.InfoTextKorrekturFaktorZeile1") + "<br>" + GuiStrings.getString("FaktorenPanel.InfoTextKorrekturFaktorZeile2") + "<br>" + GuiStrings.getString("FaktorenPanel.InfoTextKorrekturFaktorZeile3") + "<br>" + GuiStrings.getString("FaktorenPanel.InfoTextKorrekturFaktorZeile4") + "<br>" + GuiStrings.getString("FaktorenPanel.InfoTextKorrekturFaktorZeile5") + "<br>" + GuiStrings.getString("FaktorenPanel.InfoTextKorrekturFaktorZeile6") + "</html>";

    public FaktorenPanel(HeProMoWindow parent) {
        this.parent = parent;
        this.initContent();
    }

    private void initContent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(10, 10, 0, 5);
        JPanel row1 = new JPanel();
        row1.setLayout(new BoxLayout(row1, 0));
        this.add((Component)row1, c);
        this.btnExpand = new JToggleButton("+");
        this.btnExpand.setMargin(new Insets(1, 5, 1, 5));
        this.btnExpand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FaktorenPanel.this.changeExpandRisikoVerwaltungGewinn();
            }
        });
        this.parent.addDefaultItemListener(this.btnExpand);
        row1.add(this.btnExpand);
        row1.add(Box.createHorizontalStrut(5));
        this.lblRisikoVerwaltungGewinn = new JLabel(GuiStrings.getString("FaktorenPanel.RisikoVerwaltungGewinn"));
        row1.add(this.lblRisikoVerwaltungGewinn);
        row1.add(Box.createHorizontalStrut(5));
        this.txtRisikoVerwaltungGewinn = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 200.0, 0.1));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtRisikoVerwaltungGewinn);
        this.txtRisikoVerwaltungGewinn.setMaximumSize(new Dimension(60, 20));
        row1.add(this.txtRisikoVerwaltungGewinn);
        row1.add(Box.createHorizontalStrut(15));
        this.lblRisiko = new JLabel(GuiStrings.getString("FaktorenPanel.Risiko"));
        row1.add(this.lblRisiko);
        row1.add(Box.createHorizontalStrut(5));
        this.txtRisiko = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 200.0, 0.1));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtRisiko);
        this.txtRisiko.setMaximumSize(new Dimension(60, 20));
        row1.add(this.txtRisiko);
        row1.add(Box.createHorizontalStrut(15));
        this.lblVerwaltung = new JLabel(GuiStrings.getString("FaktorenPanel.Verwaltung"));
        row1.add(this.lblVerwaltung);
        row1.add(Box.createHorizontalStrut(5));
        this.txtVerwaltung = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 200.0, 0.1));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtVerwaltung);
        this.txtVerwaltung.setMaximumSize(new Dimension(60, 20));
        row1.add(this.txtVerwaltung);
        row1.add(Box.createHorizontalStrut(15));
        this.lblGewinn = new JLabel(GuiStrings.getString("FaktorenPanel.Gewinn"));
        row1.add(this.lblGewinn);
        row1.add(Box.createHorizontalStrut(5));
        this.txtGewinn = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 200.0, 0.1));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtGewinn);
        this.txtGewinn.setMaximumSize(new Dimension(60, 20));
        row1.add(this.txtGewinn);
        row1.add(Box.createHorizontalStrut(15));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(10, 10, 0, 5);
        JPanel row2 = new JPanel();
        row2.setLayout(new BoxLayout(row2, 0));
        this.add((Component)row2, c);
        JLabel lblMehrwertsteuer = new JLabel(GuiStrings.getString("FaktorenPanel.Mehrwertsteuer"));
        row2.add(lblMehrwertsteuer);
        row2.add(Box.createHorizontalStrut(5));
        this.txtMehrwertsteuer = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 200.0, 0.1));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtMehrwertsteuer);
        this.txtMehrwertsteuer.setMaximumSize(new Dimension(60, 20));
        row2.add(this.txtMehrwertsteuer);
        row2.add(Box.createHorizontalStrut(15));
        JLabel lblWaehrungsKuerzel = new JLabel(GuiStrings.getString("FaktorenPanel.Waehrungskuerzel"));
        row2.add(lblWaehrungsKuerzel);
        row2.add(Box.createHorizontalStrut(5));
        this.txtWaehrungskuerzel = new JTextField();
        this.txtWaehrungskuerzel.setMaximumSize(new Dimension(60, 20));
        this.parent.addDefaultDocumentListener(this.txtWaehrungskuerzel);
        row2.add(this.txtWaehrungskuerzel);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(10, 5, 0, 5);
        JPanel row3 = new JPanel();
        row3.setLayout(new BoxLayout(row3, 0));
        this.add((Component)row3, c);
        this.chkRindenabzugAutomatisch = new JCheckBox(GuiStrings.getString("FaktorenPanel.Umrechnungsfaktor_iR_oR_automatisch"));
        this.parent.addDefaultItemListener(this.chkRindenabzugAutomatisch);
        this.chkRindenabzugAutomatisch.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FaktorenPanel.this.txtRindenabzug.setEnabled(!((JCheckBox)e.getSource()).isSelected());
            }
        });
        this.chkRindenabzugAutomatisch.setSelected(true);
        row3.add(this.chkRindenabzugAutomatisch);
        row3.add(Box.createHorizontalStrut(5));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtRindenabzug);
        this.txtRindenabzug.setMaximumSize(new Dimension(60, 20));
        this.txtRindenabzug.setEnabled(false);
        row3.add(this.txtRindenabzug);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(20, 0, 0, 0);
        this.pnlWeitereFaktoren = this.initPanelWeitereFaktoren();
        this.add((Component)this.pnlWeitereFaktoren, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.fill = 1;
        c.weightx = 100.0;
        c.weighty = 100.0;
        this.add((Component)new JPanel(), c);
    }

    private JPanel initPanelWeitereFaktoren() {
        JPanel pnlWeitereFaktoren = new JPanel();
        pnlWeitereFaktoren.setBorder(TitledBorderFactory.createTitledBorder(GuiStrings.getString("FaktorenPanel.TitleWeitereFaktoren")));
        pnlWeitereFaktoren.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(10, 5, 20, 5);
        JLabel lblKorrekturfaktor = new JLabel(GuiStrings.getString("FaktorenPanel.BetriebsspezifischerKorrekturfaktor"));
        pnlWeitereFaktoren.add((Component)lblKorrekturfaktor, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtKorrekturfaktor = new JSpinner(new SpinnerNumberModel(1.0, 0.1, 10.0, 0.01));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtKorrekturfaktor);
        pnlWeitereFaktoren.add((Component)this.txtKorrekturfaktor, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 5, 0, 5);
        this.lblKorrekturfaktor_Info = GuiStrings.getInfoButtonBlue(this.infoTextKF);
        pnlWeitereFaktoren.add((Component)this.lblKorrekturfaktor_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.lblFaktorStoerungen = new JLabel(GuiStrings.getString("FaktorenPanel.Stoerungen"));
        pnlWeitereFaktoren.add((Component)this.lblFaktorStoerungen, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtFaktorStoerungen = new JTextField("--");
        this.txtFaktorStoerungen.setEditable(false);
        pnlWeitereFaktoren.add((Component)this.txtFaktorStoerungen, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.lblFaktorVerlusteBis15Min = new JLabel(GuiStrings.getString("FaktorenPanel.VerlusteBis15min"));
        pnlWeitereFaktoren.add((Component)this.lblFaktorVerlusteBis15Min, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtFaktorVerlusteBis15Min = new JTextField("--");
        this.txtFaktorVerlusteBis15Min.setEditable(false);
        pnlWeitereFaktoren.add((Component)this.txtFaktorVerlusteBis15Min, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.lblFaktorIndirekteArbeitszeit = new JLabel(GuiStrings.getString("FaktorenPanel.IndirekteArbeitszeit"));
        pnlWeitereFaktoren.add((Component)this.lblFaktorIndirekteArbeitszeit, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtFaktorIndirekteArbeitszeit = new JTextField("--");
        this.txtFaktorIndirekteArbeitszeit.setEditable(false);
        pnlWeitereFaktoren.add((Component)this.txtFaktorIndirekteArbeitszeit, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(0, 5, 0, 5);
        JLabel lblFaktorWegzeitenUndPausen = new JLabel(GuiStrings.getString("FaktorenPanel.WegzeitenUndPausen"));
        pnlWeitereFaktoren.add((Component)lblFaktorWegzeitenUndPausen, c);
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtFaktorWegzeitenUndPausen = new JTextField("--");
        this.txtFaktorWegzeitenUndPausen.setEditable(false);
        pnlWeitereFaktoren.add((Component)this.txtFaktorWegzeitenUndPausen, c);
        c = new GridBagConstraints();
        c.gridx = 5;
        c.gridy = 1;
        c.insets = new Insets(0, 5, 0, 5);
        this.lblFaktorWegzeitenUndPausen_Info = GuiStrings.getInfoButtonBlue("<html>" + GuiStrings.getString("FaktorenPanel.InfoTextWegzeitenUndPausenZeile1") + "<br>" + GuiStrings.getString("FaktorenPanel.InfoTextWegzeitenUndPausenZeile2") + "<br>" + GuiStrings.getString("FaktorenPanel.InfoTextWegzeitenUndPausenZeile3") + "</html>");
        pnlWeitereFaktoren.add((Component)this.lblFaktorWegzeitenUndPausen_Info, c);
        return pnlWeitereFaktoren;
    }

    public void loadFaktoren(HeProMoInputData data) {
        this.btnExpand.setSelected(!data.getFaktoren().isRisikoVerwaltungGewinnMerged());
        this.txtRisikoVerwaltungGewinn.setValue(data.getFaktoren().getMargin());
        this.txtRisiko.setValue(data.getFaktoren().getRisiko());
        this.txtVerwaltung.setValue(data.getFaktoren().getVerwaltung());
        this.txtGewinn.setValue(data.getFaktoren().getGewinn());
        this.txtMehrwertsteuer.setValue(data.getFaktoren().getMehrwertsteuer());
        this.txtWaehrungskuerzel.setText(data.getFaktoren().getWaehrungskuerzel());
        this.txtKorrekturfaktor.setValue(data.getFaktoren().getKorrekturFaktor());
        this.changeExpandRisikoVerwaltungGewinn();
        if (data instanceof AbstractModel2014 || data instanceof PersistentInputData && AbstractModel2014.class.isAssignableFrom(((PersistentInputData)data).getModelClass())) {
            Arbeitsobjekt ao = data.getArbeitsobjekt();
            this.chkRindenabzugAutomatisch.setSelected(!ao.isRindenabzugsfaktorManuellGesetzt());
            this.txtRindenabzug.setValue(ao.getRindenAbzugFaktor());
            this.showRindenabzugFields(true);
        } else {
            this.showRindenabzugFields(false);
        }
    }

    public void updateFaktorenPanel(AbstractModel model) {
        if (model.getCalculator() instanceof AbstractCalculatorSingleModel) {
            AbstractCalculatorSingleModel calculator = (AbstractCalculatorSingleModel)model.getCalculator();
            this.txtFaktorStoerungen.setText(FaktorenPanel.formatDouble(calculator.getFaktorStoerungen()));
            this.txtFaktorVerlusteBis15Min.setText(FaktorenPanel.formatDouble(calculator.getFaktorVerlusteBis15min()));
            this.txtFaktorIndirekteArbeitszeit.setText(FaktorenPanel.formatDouble(calculator.getFaktorIndirekteArbeitszeit()));
            this.lblFaktorStoerungen.setVisible(true);
            this.lblFaktorVerlusteBis15Min.setVisible(true);
            this.lblFaktorIndirekteArbeitszeit.setVisible(true);
            this.txtFaktorStoerungen.setVisible(true);
            this.txtFaktorVerlusteBis15Min.setVisible(true);
            this.txtFaktorIndirekteArbeitszeit.setVisible(true);
        } else {
            this.lblFaktorStoerungen.setVisible(false);
            this.lblFaktorVerlusteBis15Min.setVisible(false);
            this.lblFaktorIndirekteArbeitszeit.setVisible(false);
            this.txtFaktorStoerungen.setVisible(false);
            this.txtFaktorVerlusteBis15Min.setVisible(false);
            this.txtFaktorIndirekteArbeitszeit.setVisible(false);
        }
        this.txtFaktorWegzeitenUndPausen.setText(FaktorenPanel.formatDouble(model.getArbeitssystem().getFaktorWegzeitenUndPausen()));
        if (model instanceof AbstractModel2014) {
            this.lblFaktorVerlusteBis15Min.setVisible(false);
            this.txtFaktorVerlusteBis15Min.setVisible(false);
            if (this.chkRindenabzugAutomatisch.isSelected()) {
                this.txtRindenabzug.setValue(model.getArbeitsobjekt().getRindenAbzugFaktor());
            }
        }
    }

    private static String formatDouble(double value) {
        DecimalFormat df = new DecimalFormat("0.0##");
        String result = df.format(value);
        return result;
    }

    public void loadGUIToModel(AbstractModel model) {
        model.getFaktoren().setRisikoVerwaltungGewinnMerged(!this.btnExpand.isSelected());
        model.getFaktoren().setMargin((Double)this.txtRisikoVerwaltungGewinn.getValue());
        model.getFaktoren().setRisiko((Double)this.txtRisiko.getValue());
        model.getFaktoren().setVerwaltung((Double)this.txtVerwaltung.getValue());
        model.getFaktoren().setGewinn((Double)this.txtGewinn.getValue());
        model.getFaktoren().setMehrwertsteuer((Double)this.txtMehrwertsteuer.getValue());
        model.getFaktoren().setWaehrungskuerzel(this.txtWaehrungskuerzel.getText());
        model.getFaktoren().setKorrekturFaktor((Double)this.txtKorrekturfaktor.getValue());
        if (model instanceof AbstractModel2014) {
            Arbeitsobjekt ao = model.getArbeitsobjekt();
            ao.setRindenabzugsfaktorManuellGesetzt(!this.chkRindenabzugAutomatisch.isSelected());
            if (!this.chkRindenabzugAutomatisch.isSelected()) {
                ao.setRindenabzugsfaktorManuell((Double)this.txtRindenabzug.getValue());
            }
        }
    }

    public void showRindenabzugFields(boolean flag) {
        this.chkRindenabzugAutomatisch.setVisible(flag);
        this.txtRindenabzug.setVisible(flag);
    }

    public void showInfoButtonWegzeitenUndPausen(boolean flag) {
        this.lblFaktorWegzeitenUndPausen_Info.setVisible(flag);
    }

    private void changeExpandRisikoVerwaltungGewinn() {
        boolean isExpanded = this.btnExpand.isSelected();
        this.lblRisikoVerwaltungGewinn.setVisible(!isExpanded);
        this.txtRisikoVerwaltungGewinn.setVisible(!isExpanded);
        this.lblRisiko.setVisible(isExpanded);
        this.txtRisiko.setVisible(isExpanded);
        this.lblVerwaltung.setVisible(isExpanded);
        this.txtVerwaltung.setVisible(isExpanded);
        this.lblGewinn.setVisible(isExpanded);
        this.txtGewinn.setVisible(isExpanded);
    }
}

