/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.util;

import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoExceptionHandler;
import ch.wsl.fps.hepromo.model.modelle.AbstractModel;
import ch.wsl.fps.hepromo.util.ExportMethodResult;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;

public class DatenblattCreator {
    private static final Object classLevelLock = new Object();
    private static volatile boolean isAlreadyPreinitialized = false;
    private static final String CHARSET = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preInitializeInSeparateThread() {
        Object object = classLevelLock;
        synchronized (object) {
            if (!isAlreadyPreinitialized) {
                Thread t = new Thread(() -> {
                    DatenblattCreator instance = new DatenblattCreator();
                    String emptyXMLString = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><kalkulation></kalkulation>";
                    instance.generatePdf(emptyXMLString, null);
                    isAlreadyPreinitialized = true;
                });
                t.start();
            }
        }
    }

    public ExportMethodResult create(AbstractModel model, File pdfFile, DecimalFormat decimalFormat) {
        String finalXMLString = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<kalkulation>\n" + model.getModelAsXmlString(decimalFormat) + "</kalkulation>";
        ExportMethodResult exportMethodResult = this.generatePdf(finalXMLString, pdfFile);
        return exportMethodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExportMethodResult generatePdf(String xmlString, File pdfFile) {
        Object object = classLevelLock;
        synchronized (object) {
            Logger fopLogger = Logger.getLogger("org.apache.fop");
            fopLogger.setLevel(Level.OFF);
            FopFactory fopFactory = FopFactory.newInstance((URI)new File(".").toURI());
            try {
                Throwable throwable = null;
                Object var7_10 = null;
                try (OutputStream out = this.getOutputStream(pdfFile);){
                    Fop fop = fopFactory.newFop("application/pdf", out);
                    String xsltFilePath = "data/kalkulation2fo.xsl";
                    TransformerFactory factory = TransformerFactory.newInstance();
                    Transformer transformer = factory.newTransformer(new StreamSource(this.openFile(xsltFilePath)));
                    StreamSource src = new StreamSource(new ByteArrayInputStream(xmlString.getBytes(CHARSET)));
                    SAXResult res = new SAXResult(fop.getDefaultHandler());
                    transformer.transform(src, res);
                    if (pdfFile != null) {
                        System.out.println("Datenblatt erfolgreich erstellt");
                        return new ExportMethodResult(true, false);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                String msg = String.valueOf(GuiStrings.getString("HeProMoWindow.FehlerBeimErstellenDerDatei")) + "\n" + e.getLocalizedMessage();
                JOptionPane.showMessageDialog(null, msg, GuiStrings.getString("HeProMoWindow.DialogTitleFehler"), 0);
                return new ExportMethodResult(false, true);
            }
            catch (IOException | TransformerException | TransformerFactoryConfigurationError | FOPException e) {
                HeProMoExceptionHandler.handle(e);
            }
        }
        return new ExportMethodResult(false, false);
    }

    private OutputStream getOutputStream(File pdfFile) throws FileNotFoundException {
        if (pdfFile == null) {
            return new NullOutputStream();
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(pdfFile));
        return out;
    }

    private BufferedReader openFile(String filePath) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(filePath);
        if (is != null) {
            try {
                return new BufferedReader(new InputStreamReader(is, CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return new BufferedReader(new InputStreamReader(is));
            }
        }
        File file = new File(filePath);
        try {
            try {
                return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            }
        }
        catch (FileNotFoundException e) {
            HeProMoExceptionHandler.handle(e);
            return null;
        }
    }

    private class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

